/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverTestBase;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ZKMetadataDriverBase.class, ZooKeeperClient.class, ZKMetadataClientDriver.class})
public class ZKMetadataClientDriverTest
extends ZKMetadataDriverTestBase {
    private ZKMetadataClientDriver driver;
    private ClientConfiguration conf;

    @Before
    public void setup() throws Exception {
        this.conf = new ClientConfiguration();
        super.setup((AbstractConfiguration<?>)this.conf);
        this.driver = new ZKMetadataClientDriver();
    }

    @Test
    public void testGetRegClient() throws Exception {
        ScheduledExecutorService mockExecutor = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.driver.initialize(this.conf, mockExecutor, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
        Assert.assertSame((Object)this.conf, (Object)this.driver.clientConf);
        Assert.assertSame((Object)mockExecutor, (Object)this.driver.scheduler);
        Assert.assertNull((Object)this.driver.regClient);
        ZKRegistrationClient mockRegClient = (ZKRegistrationClient)PowerMockito.mock(ZKRegistrationClient.class);
        PowerMockito.whenNew(ZKRegistrationClient.class).withParameterTypes(ZooKeeper.class, new Class[]{String.class, ScheduledExecutorService.class}).withArguments(ArgumentMatchers.any(ZooKeeper.class), new Object[]{ArgumentMatchers.anyString(), ArgumentMatchers.any(ScheduledExecutorService.class)}).thenReturn((Object)mockRegClient);
        RegistrationClient client = this.driver.getRegistrationClient();
        Assert.assertSame((Object)mockRegClient, (Object)client);
        Assert.assertSame((Object)mockRegClient, (Object)this.driver.regClient);
        PowerMockito.verifyNew(ZKRegistrationClient.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.eq((Object)this.mockZkc), new Object[]{ArgumentMatchers.eq((Object)this.ledgersRootPath), ArgumentMatchers.eq((Object)mockExecutor)});
        this.driver.close();
        ((ZKRegistrationClient)Mockito.verify((Object)mockRegClient, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertNull((Object)this.driver.regClient);
    }
}

