/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metastore;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.bookkeeper.metastore.InMemoryMetaStore;
import org.apache.bookkeeper.metastore.InMemoryMetastoreTable;
import org.apache.bookkeeper.metastore.MSException;
import org.apache.bookkeeper.metastore.MetaStore;
import org.apache.bookkeeper.metastore.MetastoreCursor;
import org.apache.bookkeeper.metastore.MetastoreFactory;
import org.apache.bookkeeper.metastore.MetastoreScannableTable;
import org.apache.bookkeeper.metastore.MetastoreScannableTableAsyncToSyncConverter;
import org.apache.bookkeeper.metastore.MetastoreTable;
import org.apache.bookkeeper.metastore.MetastoreTableItem;
import org.apache.bookkeeper.metastore.Value;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMetaStore {
    private static final Logger logger = LoggerFactory.getLogger(TestMetaStore.class);
    protected static final String TABLE = "myTable";
    protected static final String RECORDID = "test";
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_COUNTER = "counter";
    protected MetaStore metastore;
    protected MetastoreScannableTable myActualTable;
    protected MetastoreScannableTableAsyncToSyncConverter myTable;

    protected String getFieldFromValue(Value value, String field) {
        byte[] v = value.getField(field);
        return v == null ? null : new String(v);
    }

    protected static Value makeValue(String name, Integer counter) {
        Value data = new Value();
        if (name != null) {
            data.setField(FIELD_NAME, name.getBytes());
        }
        if (counter != null) {
            data.setField(FIELD_COUNTER, counter.toString().getBytes());
        }
        return data;
    }

    protected String getMetaStoreName() {
        return InMemoryMetaStore.class.getName();
    }

    protected Configuration getConfiguration() {
        return new CompositeConfiguration();
    }

    protected Version newBadVersion() {
        return new InMemoryMetastoreTable.MetadataVersion(-1);
    }

    protected Version nextVersion(Version version) {
        if (Version.NEW == version) {
            return new InMemoryMetastoreTable.MetadataVersion(0);
        }
        if (Version.ANY == version) {
            return Version.ANY;
        }
        Assert.assertTrue((boolean)(version instanceof InMemoryMetastoreTable.MetadataVersion));
        return new InMemoryMetastoreTable.MetadataVersion(((InMemoryMetastoreTable.MetadataVersion)version).incrementVersion());
    }

    private void checkVersion(Version v) {
        Assert.assertNotNull((Object)v);
        if (v != Version.NEW && v != Version.ANY) {
            Assert.assertTrue((boolean)(v instanceof InMemoryMetastoreTable.MetadataVersion));
        }
    }

    protected boolean isEqualVersion(Version v1, Version v2) {
        this.checkVersion(v1);
        this.checkVersion(v2);
        return v1.compare(v2) == Version.Occurred.CONCURRENTLY;
    }

    @Before
    public void setUp() throws Exception {
        this.metastore = MetastoreFactory.createMetaStore((String)this.getMetaStoreName());
        Configuration config = this.getConfiguration();
        this.metastore.init(config, this.metastore.getVersion());
        this.myActualTable = this.metastore.createScannableTable(TABLE);
        this.myTable = new MetastoreScannableTableAsyncToSyncConverter(this.myActualTable);
        this.clearTable();
    }

    @After
    public void tearDown() throws Exception {
        this.clearTable();
        this.myActualTable.close();
        this.metastore.close();
    }

    void checkExpectedValue(Versioned<Value> vv, String expectedName, Integer expectedCounter, Version expectedVersion) {
        Record expected = new Record(expectedName, expectedCounter, expectedVersion);
        expected.checkEqual(vv);
    }

    protected Integer getRandom() {
        return (int)(Math.random() * 65536.0);
    }

    protected Versioned<Value> getRecord(String recordId) throws Exception {
        try {
            return this.myTable.get(recordId);
        }
        catch (MSException.NoKeyException nke) {
            return null;
        }
    }

    protected Versioned<Value> getExistRecordFields(String recordId, Set<String> fields) throws Exception {
        Versioned<Value> retValue = this.myTable.get(recordId, fields);
        return retValue;
    }

    protected void putAndCheck(String recordId, String name, Integer counter, Version version, Record expected, MSException.Code expectedCode) throws Exception {
        Version retVersion = null;
        MSException.Code code = MSException.Code.OperationFailure;
        try {
            retVersion = this.myTable.put(recordId, TestMetaStore.makeValue(name, counter), version);
            code = MSException.Code.OK;
        }
        catch (MSException.BadVersionException bve) {
            code = MSException.Code.BadVersion;
        }
        catch (MSException.NoKeyException nke) {
            code = MSException.Code.NoKey;
        }
        catch (MSException.KeyExistsException kee) {
            code = MSException.Code.KeyExists;
        }
        Assert.assertEquals((Object)expectedCode, (Object)code);
        if (MSException.Code.OK == code) {
            Assert.assertTrue((boolean)this.isEqualVersion(retVersion, this.nextVersion(version)));
            expected.merge(name, counter, retVersion);
        }
        Versioned<Value> existedVV = this.getRecord(recordId);
        if (null == expected) {
            Assert.assertNull(existedVV);
        } else {
            expected.checkEqual(existedVV);
        }
    }

    protected void clearTable() throws Exception {
        MetastoreCursor cursor = this.myTable.openCursor();
        if (!cursor.hasMoreEntries()) {
            return;
        }
        while (cursor.hasMoreEntries()) {
            Iterator iter = cursor.readEntries(99);
            while (iter.hasNext()) {
                MetastoreTableItem item = (MetastoreTableItem)iter.next();
                String key = item.getKey();
                this.myTable.remove(key, Version.ANY);
            }
        }
        cursor.close();
    }

    @Test
    public void testNonExistent() throws Exception {
        try {
            this.myTable.get(RECORDID);
            Assert.fail((String)"Should fail to get a non-existent key");
        }
        catch (MSException.NoKeyException noKeyException) {
            // empty catch block
        }
        HashSet<String> fields = new HashSet<String>(Collections.singletonList(FIELD_COUNTER));
        try {
            this.myTable.get(RECORDID, fields);
            Assert.fail((String)"Should fail to get a non-existent key with specified fields");
        }
        catch (MSException.NoKeyException noKeyException) {
            // empty catch block
        }
        try {
            this.myTable.remove(RECORDID, Version.ANY);
            Assert.fail((String)"Should fail to delete a non-existent key");
        }
        catch (MSException.NoKeyException noKeyException) {
            // empty catch block
        }
    }

    @Test
    public void testGet() throws Exception {
        HashSet<String> fields = new HashSet<String>(Collections.singletonList(FIELD_NAME));
        String name = "get";
        Integer counter = this.getRandom();
        Version version = this.myTable.put(RECORDID, TestMetaStore.makeValue("get", counter), Version.NEW);
        Assert.assertNotNull((Object)version);
        Versioned<Value> vv = this.getExistRecordFields(RECORDID, MetastoreTable.ALL_FIELDS);
        this.checkExpectedValue(vv, "get", counter, version);
        vv = this.getExistRecordFields(RECORDID, fields);
        this.checkExpectedValue(vv, "get", null, version);
        vv = this.getExistRecordFields(RECORDID, MetastoreTable.NON_FIELDS);
        this.checkExpectedValue(vv, null, null, version);
        try {
            this.getExistRecordFields(null, MetastoreTable.NON_FIELDS);
            Assert.fail((String)"Should fail to get null key with NON fields");
        }
        catch (MSException.IllegalOpException illegalOpException) {
            // empty catch block
        }
        try {
            this.getExistRecordFields(null, MetastoreTable.ALL_FIELDS);
            Assert.fail((String)"Should fail to get null key with ALL fields.");
        }
        catch (MSException.IllegalOpException illegalOpException) {
            // empty catch block
        }
        try {
            this.getExistRecordFields(null, fields);
            Assert.fail((String)("Should fail to get null key with fields " + fields));
        }
        catch (MSException.IllegalOpException illegalOpException) {
            // empty catch block
        }
    }

    @Test
    public void testPut() throws Exception {
        Integer counter = this.getRandom();
        String name = "put";
        Version version = this.myTable.put(RECORDID, TestMetaStore.makeValue("put", counter), Version.NEW);
        Assert.assertNotNull((Object)version);
        Record expected = new Record("put", counter, version);
        this.putAndCheck(RECORDID, "name1", null, expected.getVersion(), expected, MSException.Code.OK);
        this.putAndCheck(RECORDID, null, counter + 1, expected.getVersion(), expected, MSException.Code.OK);
        this.putAndCheck(RECORDID, "name2", counter + 2, expected.getVersion(), expected, MSException.Code.OK);
        this.checkPartialPut("put exist entry with Version.ANY", Version.ANY, expected, MSException.Code.OK);
        this.badVersionedPut(Version.NEW, MSException.Code.KeyExists);
        this.badVersionedPut(this.newBadVersion(), MSException.Code.BadVersion);
        this.myTable.remove(RECORDID, Version.ANY);
        this.badVersionedPut(this.newBadVersion(), MSException.Code.NoKey);
        this.badVersionedPut(Version.ANY, MSException.Code.NoKey);
        this.illegalPut(null, Version.NEW);
        this.illegalPut(TestMetaStore.makeValue("illegal value", this.getRandom()), null);
        this.illegalPut(null, null);
    }

    protected void badVersionedPut(Version badVersion, MSException.Code expectedCode) throws Exception {
        Versioned<Value> vv = this.getRecord(RECORDID);
        Record expected = null;
        if (expectedCode != MSException.Code.NoKey) {
            Assert.assertNotNull(vv);
            expected = new Record(vv);
        }
        this.checkPartialPut("badVersionedPut", badVersion, expected, expectedCode);
    }

    protected void checkPartialPut(String name, Version version, Record expected, MSException.Code expectedCode) throws Exception {
        Integer counter = this.getRandom();
        this.putAndCheck(RECORDID, name + counter, counter, version, expected, expectedCode);
        counter = this.getRandom();
        this.putAndCheck(RECORDID, name + counter, null, version, expected, expectedCode);
        this.putAndCheck(RECORDID, null, counter, version, expected, expectedCode);
    }

    protected void illegalPut(Value value, Version version) throws MSException {
        try {
            this.myTable.put(RECORDID, value, version);
            Assert.fail((String)"Should fail to do versioned put with illegal arguments");
        }
        catch (MSException.IllegalOpException illegalOpException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() throws Exception {
        Integer counter = this.getRandom();
        String name = "remove";
        Version version = this.myTable.put(RECORDID, TestMetaStore.makeValue("remove", counter), Version.NEW);
        Assert.assertNotNull((Object)version);
        this.myTable.remove(RECORDID, Version.ANY);
        version = this.myTable.put(RECORDID, TestMetaStore.makeValue("remove", counter), Version.NEW);
        Assert.assertNotNull((Object)version);
        try {
            this.myTable.remove(RECORDID, Version.NEW);
            Assert.fail((String)"Should fail to remove a given key with bad version");
        }
        catch (MSException.BadVersionException badVersionException) {
            // empty catch block
        }
        try {
            this.myTable.remove(RECORDID, this.newBadVersion());
            Assert.fail((String)"Should fail to remove a given key with bad version");
        }
        catch (MSException.BadVersionException badVersionException) {
            // empty catch block
        }
        this.myTable.remove(RECORDID, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openCursorTest(MetastoreCursor cursor, Map<String, Value> expectedValues, int numEntriesPerScan) throws Exception {
        try {
            HashMap entries = Maps.newHashMap();
            while (cursor.hasMoreEntries()) {
                Iterator iter = cursor.readEntries(numEntriesPerScan);
                while (iter.hasNext()) {
                    MetastoreTableItem item = (MetastoreTableItem)iter.next();
                    entries.put(item.getKey(), item.getValue().getValue());
                }
            }
            MapDifference diff = Maps.difference(expectedValues, (Map)entries);
            Assert.assertTrue((boolean)diff.areEqual());
        }
        finally {
            cursor.close();
        }
    }

    void openRangeCursorTest(String firstKey, boolean firstInclusive, String lastKey, boolean lastInclusive, MetastoreScannableTable.Order order, Set<String> fields, Iterator<Map.Entry<String, Value>> expectedValues, int numEntriesPerScan) throws Exception {
        try (MetastoreCursor cursor = this.myTable.openCursor(firstKey, firstInclusive, lastKey, lastInclusive, order, fields);){
            while (cursor.hasMoreEntries()) {
                Iterator iter = cursor.readEntries(numEntriesPerScan);
                while (iter.hasNext()) {
                    Assert.assertTrue((boolean)expectedValues.hasNext());
                    MetastoreTableItem item = (MetastoreTableItem)iter.next();
                    Map.Entry<String, Value> expectedItem = expectedValues.next();
                    Assert.assertEquals((Object)expectedItem.getKey(), (Object)item.getKey());
                    Assert.assertEquals((Object)expectedItem.getValue(), (Object)item.getValue().getValue());
                }
            }
            Assert.assertFalse((boolean)expectedValues.hasNext());
        }
    }

    @Test
    public void testOpenCursor() throws Exception {
        TreeMap allValues = Maps.newTreeMap();
        TreeMap partialValues = Maps.newTreeMap();
        TreeMap nonValues = Maps.newTreeMap();
        HashSet counterFields = Sets.newHashSet((Object[])new String[]{FIELD_COUNTER});
        for (int i = 5; i < 24; ++i) {
            char c = (char)(97 + i);
            String key = String.valueOf(c);
            Value v = TestMetaStore.makeValue("value" + i, i);
            Value cv = v.project((Set)counterFields);
            Value nv = v.project(MetastoreTable.NON_FIELDS);
            this.myTable.put(key, new Value(v), Version.NEW);
            allValues.put(key, v);
            partialValues.put(key, cv);
            nonValues.put(key, nv);
        }
        MetastoreCursor cursor = this.myTable.openCursor(MetastoreTable.ALL_FIELDS);
        this.openCursorTest(cursor, allValues, 7);
        cursor = this.myTable.openCursor(counterFields);
        this.openCursorTest(cursor, partialValues, 7);
        cursor = this.myTable.openCursor(MetastoreTable.NON_FIELDS);
        this.openCursorTest(cursor, nonValues, 7);
        Iterator<Map.Entry<String, Object>> expectedIterator = allValues.subMap("l", true, "u", true).entrySet().iterator();
        this.openRangeCursorTest("l", true, "u", true, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.descendingMap().subMap("u", true, "l", true).entrySet().iterator();
        this.openRangeCursorTest("u", true, "l", true, MetastoreScannableTable.Order.DESC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.subMap("l", false, "u", false).entrySet().iterator();
        this.openRangeCursorTest("l", false, "u", false, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.descendingMap().subMap("u", false, "l", false).entrySet().iterator();
        this.openRangeCursorTest("u", false, "l", false, MetastoreScannableTable.Order.DESC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.subMap("l", true, "u", false).entrySet().iterator();
        this.openRangeCursorTest("l", true, "u", false, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.descendingMap().subMap("u", true, "l", false).entrySet().iterator();
        this.openRangeCursorTest("u", true, "l", false, MetastoreScannableTable.Order.DESC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.subMap("l", false, "u", true).entrySet().iterator();
        this.openRangeCursorTest("l", false, "u", true, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.descendingMap().subMap("u", false, "l", true).entrySet().iterator();
        this.openRangeCursorTest("u", false, "l", true, MetastoreScannableTable.Order.DESC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        String firstKey = "f";
        String lastKey = "x";
        expectedIterator = allValues.subMap(firstKey, true, lastKey, true).entrySet().iterator();
        this.openRangeCursorTest("a", true, "z", true, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.subMap("l", true, lastKey, true).entrySet().iterator();
        this.openRangeCursorTest("l", true, "z", true, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.subMap(firstKey, true, "u", true).entrySet().iterator();
        this.openRangeCursorTest("a", true, "u", true, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.subMap(firstKey, true, "u", true).entrySet().iterator();
        this.openRangeCursorTest(MetastoreScannableTable.EMPTY_START_KEY, true, "u", true, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        expectedIterator = allValues.descendingMap().subMap(lastKey, true, "l", true).entrySet().iterator();
        this.openRangeCursorTest(MetastoreScannableTable.EMPTY_END_KEY, true, "l", true, MetastoreScannableTable.Order.DESC, MetastoreTable.ALL_FIELDS, expectedIterator, 7);
        try {
            this.myTable.openCursor("a", true, "z", true, MetastoreScannableTable.Order.DESC, MetastoreTable.ALL_FIELDS);
            Assert.fail((String)"Should fail with wrong range");
        }
        catch (MSException.IllegalOpException illegalOpException) {
            // empty catch block
        }
        try {
            this.myTable.openCursor("z", true, "a", true, MetastoreScannableTable.Order.ASC, MetastoreTable.ALL_FIELDS);
            Assert.fail((String)"Should fail with wrong range");
        }
        catch (MSException.IllegalOpException illegalOpException) {
            // empty catch block
        }
        try {
            this.myTable.openCursor("a", true, "z", true, null, MetastoreTable.ALL_FIELDS);
            Assert.fail((String)"Should fail with null order");
        }
        catch (MSException.IllegalOpException illegalOpException) {
            // empty catch block
        }
    }

    protected class Record {
        String name;
        Integer counter;
        Version version;

        public Record() {
        }

        public Record(String name, Integer counter, Version version) {
            this.name = name;
            this.counter = counter;
            this.version = version;
        }

        public Record(Versioned<Value> vv) {
            this.version = vv.getVersion();
            Value value = (Value)vv.getValue();
            if (value == null) {
                return;
            }
            this.name = TestMetaStore.this.getFieldFromValue(value, TestMetaStore.FIELD_NAME);
            String c = TestMetaStore.this.getFieldFromValue(value, TestMetaStore.FIELD_COUNTER);
            if (c != null) {
                this.counter = Integer.parseInt(c);
            }
        }

        public Version getVersion() {
            return this.version;
        }

        public Value getValue() {
            return TestMetaStore.makeValue(this.name, this.counter);
        }

        public Versioned<Value> getVersionedValue() {
            return new Versioned((Object)this.getValue(), this.version);
        }

        public void merge(String name, Integer counter, Version version) {
            if (name != null) {
                this.name = name;
            }
            if (counter != null) {
                this.counter = counter;
            }
            if (version != null) {
                this.version = version;
            }
        }

        public void merge(Record record) {
            this.merge(record.name, record.counter, record.version);
        }

        public void checkEqual(Versioned<Value> vv) {
            Version v = vv.getVersion();
            Value value = (Value)vv.getValue();
            Assert.assertEquals((Object)this.name, (Object)TestMetaStore.this.getFieldFromValue(value, TestMetaStore.FIELD_NAME));
            String c = TestMetaStore.this.getFieldFromValue(value, TestMetaStore.FIELD_COUNTER);
            if (this.counter == null) {
                Assert.assertNull((Object)c);
            } else {
                Assert.assertEquals((Object)this.counter.toString(), (Object)c);
            }
            Assert.assertTrue((boolean)TestMetaStore.this.isEqualVersion(this.version, v));
        }
    }
}

