/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.ReadEntryProcessor;
import org.apache.bookkeeper.proto.RequestStats;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class ReadEntryProcessorTest {
    private Channel channel;
    private BookieRequestProcessor requestProcessor;
    private Bookie bookie;

    @Before
    public void setup() throws IOException, BookieException {
        this.channel = (Channel)Mockito.mock(Channel.class);
        this.bookie = (Bookie)Mockito.mock(Bookie.class);
        this.requestProcessor = (BookieRequestProcessor)Mockito.mock(BookieRequestProcessor.class);
        Mockito.when((Object)this.requestProcessor.getBookie()).thenReturn((Object)this.bookie);
        Mockito.when((Object)this.requestProcessor.getWaitTimeoutOnBackpressureMillis()).thenReturn((Object)-1L);
        Mockito.when((Object)this.requestProcessor.getRequestStats()).thenReturn((Object)new RequestStats((StatsLogger)NullStatsLogger.INSTANCE));
        Mockito.when((Object)this.channel.voidPromise()).thenReturn(Mockito.mock(ChannelPromise.class));
        Mockito.when((Object)this.channel.writeAndFlush(ArgumentMatchers.any())).thenReturn(Mockito.mock(ChannelPromise.class));
    }

    @Test
    public void testSuccessfulAsynchronousFenceRequest() throws Exception {
        this.testAsynchronousRequest(true, 0);
    }

    @Test
    public void testFailedAsynchronousFenceRequest() throws Exception {
        this.testAsynchronousRequest(false, 101);
    }

    private void testAsynchronousRequest(boolean result, int errorCode) throws Exception {
        SettableFuture fenceResult = SettableFuture.create();
        Mockito.when((Object)this.bookie.fenceLedger(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any())).thenReturn((Object)fenceResult);
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> ReadEntryProcessorTest.lambda$testAsynchronousRequest$0(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class), (ChannelPromise)ArgumentMatchers.any());
        ExecutorService service = Executors.newCachedThreadPool();
        long ledgerId = System.currentTimeMillis();
        BookieProtocol.ReadRequest request = new BookieProtocol.ReadRequest(2, ledgerId, 1L, 1, new byte[0]);
        ReadEntryProcessor processor = ReadEntryProcessor.create((BookieProtocol.ReadRequest)request, (Channel)this.channel, (BookieRequestProcessor)this.requestProcessor, (ExecutorService)service);
        processor.run();
        fenceResult.set((Object)result);
        latch.await();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class), (ChannelPromise)ArgumentMatchers.any());
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)1L, (long)response.getEntryId());
        Assert.assertEquals((long)ledgerId, (long)response.getLedgerId());
        Assert.assertEquals((long)2L, (long)response.getOpCode());
        Assert.assertEquals((long)errorCode, (long)response.getErrorCode());
    }

    @Test
    public void testSuccessfulSynchronousFenceRequest() throws Exception {
        this.testSynchronousRequest(true, 0);
    }

    @Test
    public void testFailedSynchronousFenceRequest() throws Exception {
        this.testSynchronousRequest(false, 101);
    }

    private void testSynchronousRequest(boolean result, int errorCode) throws Exception {
        SettableFuture fenceResult = SettableFuture.create();
        Mockito.when((Object)this.bookie.fenceLedger(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any())).thenReturn((Object)fenceResult);
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> ReadEntryProcessorTest.lambda$testSynchronousRequest$1(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class), (ChannelPromise)ArgumentMatchers.any());
        long ledgerId = System.currentTimeMillis();
        BookieProtocol.ReadRequest request = new BookieProtocol.ReadRequest(2, ledgerId, 1L, 1, new byte[0]);
        ReadEntryProcessor processor = ReadEntryProcessor.create((BookieProtocol.ReadRequest)request, (Channel)this.channel, (BookieRequestProcessor)this.requestProcessor, null);
        fenceResult.set((Object)result);
        processor.run();
        latch.await();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class), (ChannelPromise)ArgumentMatchers.any());
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)1L, (long)response.getEntryId());
        Assert.assertEquals((long)ledgerId, (long)response.getLedgerId());
        Assert.assertEquals((long)2L, (long)response.getOpCode());
        Assert.assertEquals((long)errorCode, (long)response.getErrorCode());
    }

    @Test
    public void testNonFenceRequest() throws Exception {
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        AtomicReference writtenObject = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        ((Channel)Mockito.doAnswer(arg_0 -> ReadEntryProcessorTest.lambda$testNonFenceRequest$2(writtenObject, latch, (ChannelPromise)promise, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class), (ChannelPromise)ArgumentMatchers.any());
        long ledgerId = System.currentTimeMillis();
        BookieProtocol.ReadRequest request = new BookieProtocol.ReadRequest(2, ledgerId, 1L, 0, new byte[0]);
        ReadEntryProcessor processor = ReadEntryProcessor.create((BookieProtocol.ReadRequest)request, (Channel)this.channel, (BookieRequestProcessor)this.requestProcessor, null);
        processor.run();
        latch.await();
        ((Channel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).writeAndFlush(ArgumentMatchers.any(BookieProtocol.Response.class), (ChannelPromise)ArgumentMatchers.any());
        Assert.assertTrue((boolean)(writtenObject.get() instanceof BookieProtocol.Response));
        BookieProtocol.Response response = (BookieProtocol.Response)writtenObject.get();
        Assert.assertEquals((long)1L, (long)response.getEntryId());
        Assert.assertEquals((long)ledgerId, (long)response.getLedgerId());
        Assert.assertEquals((long)2L, (long)response.getOpCode());
        Assert.assertEquals((long)0L, (long)response.getErrorCode());
    }

    private static /* synthetic */ Object lambda$testNonFenceRequest$2(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }

    private static /* synthetic */ Object lambda$testSynchronousRequest$1(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }

    private static /* synthetic */ Object lambda$testAsynchronousRequest$0(AtomicReference writtenObject, CountDownLatch latch, ChannelPromise promise, InvocationOnMock invocationOnMock) throws Throwable {
        writtenObject.set(invocationOnMock.getArgument(0));
        latch.countDown();
        return promise;
    }
}

