/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ZoneawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AuditorPeriodicCheckTest;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuditorPlacementPolicyCheckTest
extends BookKeeperClusterTestCase {
    private MetadataBookieDriver driver;

    public AuditorPlacementPolicyCheckTest() {
        super(1);
        this.baseConf.setPageLimit(1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        StaticDNSResolver.reset();
        this.driver = MetadataDrivers.getBookieDriver((URI)URI.create(((ServerConfiguration)this.bsConfs.get(0)).getMetadataServiceUri()));
        this.driver.initialize((ServerConfiguration)this.bsConfs.get(0), () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (null != this.driver) {
            this.driver.close();
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlacementPolicyCheckWithBookiesFromDifferentRacks() throws Exception {
        int numOfBookies = 5;
        ArrayList<BookieSocketAddress> bookieAddresses = new ArrayList<BookieSocketAddress>();
        RegistrationManager regManager = this.driver.getRegistrationManager();
        for (int i = 0; i < numOfBookies; ++i) {
            BookieSocketAddress bookieAddress = new BookieSocketAddress("98.98.98." + i, 2181);
            StaticDNSResolver.addNodeToRack(bookieAddress.getHostName(), "/rack" + i);
            bookieAddresses.add(bookieAddress);
            regManager.registerBookie(bookieAddress.toString(), false);
        }
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        int ensembleSize = 5;
        int writeQuorumSize = 4;
        int ackQuorumSize = 2;
        int minNumRacksPerWriteQuorumConfValue = 4;
        Collections.shuffle(bookieAddresses);
        LedgerMetadata initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(1L, initMeta).get();
        Collections.shuffle(bookieAddresses);
        ensembleSize = 4;
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses.subList(0, 4)).newEnsembleEntry(20L, bookieAddresses.subList(1, 5)).newEnsembleEntry(60L, bookieAddresses.subList(0, 4)).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(2L, initMeta).get();
        Collections.shuffle(bookieAddresses);
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses.subList(0, 4)).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(3L, initMeta).get();
        Collections.shuffle(bookieAddresses);
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses.subList(0, 4)).newEnsembleEntry(20L, bookieAddresses.subList(1, 5)).newEnsembleEntry(60L, bookieAddresses.subList(0, 4)).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(4L, initMeta).get();
        ServerConfiguration servConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        servConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorumConfValue);
        this.setServerConfigPropertiesForRackPlacement(servConf);
        MutableObject auditorRef = new MutableObject();
        try {
            TestStatsProvider.TestStatsLogger statsLogger = this.startAuditorAndWaitForPlacementPolicyCheck(servConf, (MutableObject<Auditor>)auditorRef);
            Gauge ledgersNotAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY");
            Gauge ledgersSoftlyAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)0, (Object)ledgersNotAdheringToPlacementPolicyGuage.getSample());
            Assert.assertEquals((String)"NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)0, (Object)ledgersSoftlyAdheringToPlacementPolicyGuage.getSample());
        }
        finally {
            Auditor auditor = (Auditor)auditorRef.getValue();
            if (auditor != null) {
                auditor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlacementPolicyCheckWithLedgersNotAdheringToPlacementPolicy() throws Exception {
        int numOfBookies = 5;
        int numOfLedgersNotAdheringToPlacementPolicy = 0;
        ArrayList<BookieSocketAddress> bookieAddresses = new ArrayList<BookieSocketAddress>();
        RegistrationManager regManager = this.driver.getRegistrationManager();
        for (int i = 0; i < numOfBookies; ++i) {
            BookieSocketAddress bookieAddress = new BookieSocketAddress("98.98.98." + i, 2181);
            bookieAddresses.add(bookieAddress);
            regManager.registerBookie(bookieAddress.toString(), false);
        }
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(0)).getHostName(), "/rack1");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(1)).getHostName(), "/rack2");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(2)).getHostName(), "/rack3");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(3)).getHostName(), "/rack1");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(4)).getHostName(), "/rack2");
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        int ensembleSize = 5;
        int writeQuorumSize = 3;
        int ackQuorumSize = 2;
        int minNumRacksPerWriteQuorumConfValue = 3;
        LedgerMetadata initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(1L, initMeta).get();
        ++numOfLedgersNotAdheringToPlacementPolicy;
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(2L, initMeta).get();
        ServerConfiguration servConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        servConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorumConfValue);
        this.setServerConfigPropertiesForRackPlacement(servConf);
        MutableObject auditorRef = new MutableObject();
        try {
            TestStatsProvider.TestStatsLogger statsLogger = this.startAuditorAndWaitForPlacementPolicyCheck(servConf, (MutableObject<Auditor>)auditorRef);
            Gauge ledgersNotAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)numOfLedgersNotAdheringToPlacementPolicy, (Object)ledgersNotAdheringToPlacementPolicyGuage.getSample());
            Gauge ledgersSoftlyAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)0, (Object)ledgersSoftlyAdheringToPlacementPolicyGuage.getSample());
        }
        finally {
            Auditor auditor = (Auditor)auditorRef.getValue();
            if (auditor != null) {
                auditor.close();
            }
        }
    }

    @Test
    public void testPlacementPolicyCheckForURLedgersElapsedRecoveryGracePeriod() throws Exception {
        this.testPlacementPolicyCheckWithURLedgers(true);
    }

    @Test
    public void testPlacementPolicyCheckForURLedgersNotElapsedRecoveryGracePeriod() throws Exception {
        this.testPlacementPolicyCheckWithURLedgers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPlacementPolicyCheckWithURLedgers(boolean timeElapsed) throws Exception {
        int numOfBookies = 4;
        int underreplicatedLedgerRecoveryGracePeriod = timeElapsed ? 1 : 1000;
        int numOfURLedgersElapsedRecoveryGracePeriod = 0;
        ArrayList<BookieSocketAddress> bookieAddresses = new ArrayList<BookieSocketAddress>();
        RegistrationManager regManager = this.driver.getRegistrationManager();
        for (int i = 0; i < numOfBookies; ++i) {
            BookieSocketAddress bookieAddress = new BookieSocketAddress("98.98.98." + i, 2181);
            bookieAddresses.add(bookieAddress);
            regManager.registerBookie(bookieAddress.toString(), false);
        }
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();
        int ensembleSize = 4;
        int writeQuorumSize = 3;
        int ackQuorumSize = 2;
        long ledgerId1 = 1L;
        LedgerMetadata initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(ledgerId1, initMeta).get();
        underreplicationManager.markLedgerUnderreplicated(ledgerId1, ((BookieSocketAddress)bookieAddresses.get(0)).toString());
        if (timeElapsed) {
            ++numOfURLedgersElapsedRecoveryGracePeriod;
        }
        ensembleSize = 3;
        long ledgerId2 = 21234561L;
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, Arrays.asList((BookieSocketAddress)bookieAddresses.get(0), (BookieSocketAddress)bookieAddresses.get(1), (BookieSocketAddress)bookieAddresses.get(2))).newEnsembleEntry(100L, Arrays.asList((BookieSocketAddress)bookieAddresses.get(3), (BookieSocketAddress)bookieAddresses.get(1), (BookieSocketAddress)bookieAddresses.get(2))).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(ledgerId2, initMeta).get();
        underreplicationManager.markLedgerUnderreplicated(ledgerId2, ((BookieSocketAddress)bookieAddresses.get(0)).toString());
        if (timeElapsed) {
            ++numOfURLedgersElapsedRecoveryGracePeriod;
        }
        long ledgerId3 = 31234561L;
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, Arrays.asList((BookieSocketAddress)bookieAddresses.get(1), (BookieSocketAddress)bookieAddresses.get(2), (BookieSocketAddress)bookieAddresses.get(3))).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(ledgerId3, initMeta).get();
        if (timeElapsed) {
            Thread.sleep((underreplicatedLedgerRecoveryGracePeriod + 1) * 1000);
        } else {
            Thread.sleep(5000L);
        }
        ServerConfiguration servConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        servConf.setUnderreplicatedLedgerRecoveryGracePeriod((long)underreplicatedLedgerRecoveryGracePeriod);
        this.setServerConfigPropertiesForRackPlacement(servConf);
        MutableObject auditorRef = new MutableObject();
        try {
            TestStatsProvider.TestStatsLogger statsLogger = this.startAuditorAndWaitForPlacementPolicyCheck(servConf, (MutableObject<Auditor>)auditorRef);
            Gauge underreplicatedLedgersElapsedRecoveryGracePeriodGuage = statsLogger.getGauge("NUM_UNDERREPLICATED_LEDGERS_ELAPSED_RECOVERY_GRACE_PERIOD");
            Assert.assertEquals((String)"NUM_UNDERREPLICATED_LEDGERS_ELAPSED_RECOVERY_GRACE_PERIOD guage value", (Object)numOfURLedgersElapsedRecoveryGracePeriod, (Object)underreplicatedLedgersElapsedRecoveryGracePeriodGuage.getSample());
        }
        finally {
            Auditor auditor = (Auditor)auditorRef.getValue();
            if (auditor != null) {
                auditor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPlacementPolicyCheckWithLedgersNotAdheringToPolicyWithMultipleSegments() throws Exception {
        int numOfBookies = 7;
        int numOfLedgersNotAdheringToPlacementPolicy = 0;
        ArrayList<BookieSocketAddress> bookieAddresses = new ArrayList<BookieSocketAddress>();
        RegistrationManager regManager = this.driver.getRegistrationManager();
        for (int i = 0; i < numOfBookies; ++i) {
            BookieSocketAddress bookieAddress = new BookieSocketAddress("98.98.98." + i, 2181);
            bookieAddresses.add(bookieAddress);
            regManager.registerBookie(bookieAddress.toString(), false);
        }
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(0)).getHostName(), "/rack1");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(1)).getHostName(), "/rack2");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(2)).getHostName(), "/rack3");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(3)).getHostName(), "/rack4");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(4)).getHostName(), "/rack1");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(5)).getHostName(), "/rack2");
        StaticDNSResolver.addNodeToRack(((BookieSocketAddress)bookieAddresses.get(6)).getHostName(), "/rack3");
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        int ensembleSize = 5;
        int writeQuorumSize = 5;
        int ackQuorumSize = 2;
        int minNumRacksPerWriteQuorumConfValue = 4;
        LedgerMetadata initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses.subList(0, 5)).newEnsembleEntry(20L, bookieAddresses.subList(1, 6)).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(1L, initMeta).get();
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).newEnsembleEntry(0L, bookieAddresses.subList(0, 5)).newEnsembleEntry(20L, Arrays.asList((BookieSocketAddress)bookieAddresses.get(0), (BookieSocketAddress)bookieAddresses.get(1), (BookieSocketAddress)bookieAddresses.get(2), (BookieSocketAddress)bookieAddresses.get(4), (BookieSocketAddress)bookieAddresses.get(5))).newEnsembleEntry(40L, Arrays.asList((BookieSocketAddress)bookieAddresses.get(0), (BookieSocketAddress)bookieAddresses.get(1), (BookieSocketAddress)bookieAddresses.get(2), (BookieSocketAddress)bookieAddresses.get(4), (BookieSocketAddress)bookieAddresses.get(6))).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(2L, initMeta).get();
        ++numOfLedgersNotAdheringToPlacementPolicy;
        ServerConfiguration servConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        servConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorumConfValue);
        this.setServerConfigPropertiesForRackPlacement(servConf);
        MutableObject auditorRef = new MutableObject();
        try {
            TestStatsProvider.TestStatsLogger statsLogger = this.startAuditorAndWaitForPlacementPolicyCheck(servConf, (MutableObject<Auditor>)auditorRef);
            Gauge ledgersNotAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY gauge value", (Object)numOfLedgersNotAdheringToPlacementPolicy, (Object)ledgersNotAdheringToPlacementPolicyGuage.getSample());
            Gauge ledgersSoftlyAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY gauge value", (Object)0, (Object)ledgersSoftlyAdheringToPlacementPolicyGuage.getSample());
        }
        finally {
            Auditor auditor = (Auditor)auditorRef.getValue();
            if (auditor != null) {
                auditor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZoneawarePlacementPolicyCheck() throws Exception {
        int numOfBookies = 6;
        int numOfLedgersNotAdheringToPlacementPolicy = 0;
        int numOfLedgersSoftlyAdheringToPlacementPolicy = 0;
        ArrayList<BookieSocketAddress> bookieAddresses = new ArrayList<BookieSocketAddress>();
        RegistrationManager regManager = this.driver.getRegistrationManager();
        for (int i = 0; i < numOfBookies; ++i) {
            BookieSocketAddress bookieAddress = new BookieSocketAddress("98.98.98." + i, 2181);
            bookieAddresses.add(bookieAddress);
            regManager.registerBookie(bookieAddress.toString(), false);
            String zone = "/zone" + i % 3;
            String upgradeDomain = "/ud" + i % 2;
            String networkLocation = zone + upgradeDomain;
            StaticDNSResolver.addNodeToRack(bookieAddress.getHostName(), networkLocation);
        }
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        ServerConfiguration servConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        servConf.setDesiredNumZonesPerWriteQuorum(3);
        servConf.setMinNumZonesPerWriteQuorum(2);
        this.setServerConfigPropertiesForZonePlacement(servConf);
        LedgerMetadata initMeta = LedgerMetadataBuilder.create().withEnsembleSize(6).withWriteQuorumSize(6).withAckQuorumSize(2).newEnsembleEntry(0L, bookieAddresses).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(1L, initMeta).get();
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(6).withWriteQuorumSize(5).withAckQuorumSize(2).newEnsembleEntry(0L, bookieAddresses).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(2L, initMeta).get();
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(6).withWriteQuorumSize(5).withAckQuorumSize(2).newEnsembleEntry(0L, bookieAddresses).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(3L, initMeta).get();
        ++numOfLedgersNotAdheringToPlacementPolicy;
        ArrayList newEnsemble = new ArrayList();
        newEnsemble.add(bookieAddresses.get(0));
        newEnsemble.add(bookieAddresses.get(1));
        newEnsemble.add(bookieAddresses.get(3));
        newEnsemble.add(bookieAddresses.get(4));
        initMeta = LedgerMetadataBuilder.create().withEnsembleSize(4).withWriteQuorumSize(4).withAckQuorumSize(2).newEnsembleEntry(0L, newEnsemble).withClosedState().withLastEntryId(100L).withLength(10000L).withDigestType(DigestType.DUMMY).withPassword(new byte[0]).build();
        lm.createLedgerMetadata(4L, initMeta).get();
        ++numOfLedgersSoftlyAdheringToPlacementPolicy;
        MutableObject auditorRef = new MutableObject();
        try {
            TestStatsProvider.TestStatsLogger statsLogger = this.startAuditorAndWaitForPlacementPolicyCheck(servConf, (MutableObject<Auditor>)auditorRef);
            Gauge ledgersNotAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_NOT_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)numOfLedgersNotAdheringToPlacementPolicy, (Object)ledgersNotAdheringToPlacementPolicyGuage.getSample());
            Gauge ledgersSoftlyAdheringToPlacementPolicyGuage = statsLogger.getGauge("NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY");
            Assert.assertEquals((String)"NUM_LEDGERS_SOFTLY_ADHERING_TO_PLACEMENT_POLICY guage value", (Object)numOfLedgersSoftlyAdheringToPlacementPolicy, (Object)ledgersSoftlyAdheringToPlacementPolicyGuage.getSample());
        }
        finally {
            Auditor auditor = (Auditor)auditorRef.getValue();
            if (auditor != null) {
                auditor.close();
            }
        }
    }

    private void setServerConfigPropertiesForRackPlacement(ServerConfiguration servConf) {
        this.setServerConfigProperties(servConf, RackawareEnsemblePlacementPolicy.class.getName());
    }

    private void setServerConfigPropertiesForZonePlacement(ServerConfiguration servConf) {
        this.setServerConfigProperties(servConf, ZoneawareEnsemblePlacementPolicy.class.getName());
    }

    private void setServerConfigProperties(ServerConfiguration servConf, String ensemblePlacementPolicyClass) {
        servConf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        servConf.setProperty("ensemblePlacementPolicy", (Object)ensemblePlacementPolicyClass);
        servConf.setAuditorPeriodicCheckInterval(0L);
        servConf.setAuditorPeriodicBookieCheckInterval(0L);
        servConf.setAuditorPeriodicReplicasCheckInterval(0L);
        servConf.setAuditorPeriodicPlacementPolicyCheckInterval(1000L);
    }

    private TestStatsProvider.TestStatsLogger startAuditorAndWaitForPlacementPolicyCheck(ServerConfiguration servConf, MutableObject<Auditor> auditorRef) throws MetadataException, ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException, UnknownHostException {
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerUnderreplicationManager urm = mFactory.newLedgerUnderreplicationManager();
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("auditor");
        TestStatsProvider.TestOpStatsLogger placementPolicyCheckStatsLogger = (TestStatsProvider.TestOpStatsLogger)statsLogger.getOpStatsLogger("PLACEMENT_POLICY_CHECK_TIME");
        AuditorPeriodicCheckTest.TestAuditor auditor = new AuditorPeriodicCheckTest.TestAuditor(Bookie.getBookieAddress((ServerConfiguration)servConf).toString(), servConf, (StatsLogger)statsLogger);
        auditorRef.setValue((Object)auditor);
        CountDownLatch latch = auditor.getLatch();
        Assert.assertEquals((String)"PLACEMENT_POLICY_CHECK_TIME SuccessCount", (long)0L, (long)placementPolicyCheckStatsLogger.getSuccessCount());
        urm.setPlacementPolicyCheckCTime(-1L);
        auditor.start();
        Assert.assertTrue((String)"placementPolicyCheck should have executed", (boolean)latch.await(20L, TimeUnit.SECONDS));
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(100L);
            if (placementPolicyCheckStatsLogger.getSuccessCount() >= 1L) break;
        }
        Assert.assertEquals((String)"PLACEMENT_POLICY_CHECK_TIME SuccessCount", (long)1L, (long)placementPolicyCheckStatsLogger.getSuccessCount());
        return statsLogger;
    }
}

