/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AuditorPeriodicCheckTest;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuditorReplicasCheckTest
extends BookKeeperClusterTestCase {
    private MetadataBookieDriver driver;

    public AuditorReplicasCheckTest() {
        super(1);
        this.baseConf.setPageLimit(1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        StaticDNSResolver.reset();
        this.driver = MetadataDrivers.getBookieDriver((URI)URI.create(((ServerConfiguration)this.bsConfs.get(0)).getMetadataServiceUri()));
        this.driver.initialize((ServerConfiguration)this.bsConfs.get(0), () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (null != this.driver) {
            this.driver.close();
        }
        super.tearDown();
    }

    private TestStatsProvider.TestStatsLogger startAuditorAndWaitForReplicasCheck(ServerConfiguration servConf, MutableObject<Auditor> auditorRef, MultiKeyMap<String, AvailabilityOfEntriesOfLedger> expectedReturnAvailabilityOfEntriesOfLedger, MultiKeyMap<String, Integer> errorReturnValueForGetAvailabilityOfEntriesOfLedger) throws MetadataException, ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException, UnknownHostException {
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerUnderreplicationManager urm = mFactory.newLedgerUnderreplicationManager();
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("auditor");
        TestStatsProvider.TestOpStatsLogger replicasCheckStatsLogger = (TestStatsProvider.TestOpStatsLogger)statsLogger.getOpStatsLogger("REPLICAS_CHECK_TIME");
        AuditorPeriodicCheckTest.TestAuditor auditor = new AuditorPeriodicCheckTest.TestAuditor(Bookie.getBookieAddress((ServerConfiguration)servConf).toString(), servConf, this.bkc, true, new TestBookKeeperAdmin(this.bkc, (StatsLogger)statsLogger, expectedReturnAvailabilityOfEntriesOfLedger, errorReturnValueForGetAvailabilityOfEntriesOfLedger), true, (StatsLogger)statsLogger);
        auditorRef.setValue((Object)auditor);
        CountDownLatch latch = auditor.getLatch();
        Assert.assertEquals((String)"REPLICAS_CHECK_TIME SuccessCount", (long)0L, (long)replicasCheckStatsLogger.getSuccessCount());
        urm.setReplicasCheckCTime(-1L);
        auditor.start();
        Assert.assertTrue((String)"replicasCheck should have executed", (boolean)latch.await(20L, TimeUnit.SECONDS));
        for (int i = 0; i < 200; ++i) {
            Thread.sleep(100L);
            if (replicasCheckStatsLogger.getSuccessCount() >= 1L) break;
        }
        Assert.assertEquals((String)"REPLICAS_CHECK_TIME SuccessCount", (long)1L, (long)replicasCheckStatsLogger.getSuccessCount());
        return statsLogger;
    }

    private void setServerConfigProperties(ServerConfiguration servConf) {
        servConf.setAuditorPeriodicCheckInterval(0L);
        servConf.setAuditorPeriodicBookieCheckInterval(0L);
        servConf.setAuditorPeriodicPlacementPolicyCheckInterval(0L);
        servConf.setAuditorPeriodicReplicasCheckInterval(1000L);
    }

    List<BookieSocketAddress> addAndRegisterBookies(RegistrationManager regManager, int numOfBookies) throws BookieException {
        ArrayList<BookieSocketAddress> bookieAddresses = new ArrayList<BookieSocketAddress>();
        for (int i = 0; i < numOfBookies; ++i) {
            BookieSocketAddress bookieAddress = new BookieSocketAddress("98.98.98." + i, 2181);
            bookieAddresses.add(bookieAddress);
            regManager.registerBookie(bookieAddress.toString(), false);
        }
        return bookieAddresses;
    }

    private void createClosedLedgerMetadata(LedgerManager lm, long ledgerId, int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<Long, List<BookieSocketAddress>> segmentEnsembles, long lastEntryId, int length, DigestType digestType, byte[] password) throws InterruptedException, ExecutionException {
        LedgerMetadataBuilder ledgerMetadataBuilder = LedgerMetadataBuilder.create();
        ledgerMetadataBuilder.withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).withClosedState().withLastEntryId(lastEntryId).withLength((long)length).withDigestType(digestType).withPassword(password);
        for (Map.Entry<Long, List<BookieSocketAddress>> mapEntry : segmentEnsembles.entrySet()) {
            ledgerMetadataBuilder.newEnsembleEntry(mapEntry.getKey().longValue(), mapEntry.getValue());
        }
        LedgerMetadata initMeta = ledgerMetadataBuilder.build();
        lm.createLedgerMetadata(ledgerId, initMeta).get();
    }

    private void createNonClosedLedgerMetadata(LedgerManager lm, long ledgerId, int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<Long, List<BookieSocketAddress>> segmentEnsembles, DigestType digestType, byte[] password) throws InterruptedException, ExecutionException {
        LedgerMetadataBuilder ledgerMetadataBuilder = LedgerMetadataBuilder.create();
        ledgerMetadataBuilder.withEnsembleSize(ensembleSize).withWriteQuorumSize(writeQuorumSize).withAckQuorumSize(ackQuorumSize).withDigestType(digestType).withPassword(password);
        for (Map.Entry<Long, List<BookieSocketAddress>> mapEntry : segmentEnsembles.entrySet()) {
            ledgerMetadataBuilder.newEnsembleEntry(mapEntry.getKey().longValue(), mapEntry.getValue());
        }
        LedgerMetadata initMeta = ledgerMetadataBuilder.build();
        lm.createLedgerMetadata(ledgerId, initMeta).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestScenario(MultiKeyMap<String, AvailabilityOfEntriesOfLedger> returnAvailabilityOfEntriesOfLedger, MultiKeyMap<String, Integer> errorReturnValueForGetAvailabilityOfEntriesOfLedger, int expectedNumLedgersFoundHavingNoReplicaOfAnEntry, int expectedNumLedgersHavingLessThanAQReplicasOfAnEntry, int expectedNumLedgersHavingLessThanWQReplicasOfAnEntry) throws ReplicationException.CompatibilityException, ReplicationException.UnavailableException, UnknownHostException, MetadataException, KeeperException, InterruptedException {
        ServerConfiguration servConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        this.setServerConfigProperties(servConf);
        MutableObject auditorRef = new MutableObject();
        try {
            TestStatsProvider.TestStatsLogger statsLogger = this.startAuditorAndWaitForReplicasCheck(servConf, (MutableObject<Auditor>)auditorRef, returnAvailabilityOfEntriesOfLedger, errorReturnValueForGetAvailabilityOfEntriesOfLedger);
            this.checkReplicasCheckStats(statsLogger, expectedNumLedgersFoundHavingNoReplicaOfAnEntry, expectedNumLedgersHavingLessThanAQReplicasOfAnEntry, expectedNumLedgersHavingLessThanWQReplicasOfAnEntry);
        }
        finally {
            Auditor auditor = (Auditor)auditorRef.getValue();
            if (auditor != null) {
                auditor.close();
            }
        }
    }

    private void checkReplicasCheckStats(TestStatsProvider.TestStatsLogger statsLogger, int expectedNumLedgersFoundHavingNoReplicaOfAnEntry, int expectedNumLedgersHavingLessThanAQReplicasOfAnEntry, int expectedNumLedgersHavingLessThanWQReplicasOfAnEntry) {
        Gauge numLedgersFoundHavingNoReplicaOfAnEntryGuage = statsLogger.getGauge("NUM_LEDGERS_HAVING_NO_REPLICA_OF_AN_ENTRY");
        Gauge numLedgersHavingLessThanAQReplicasOfAnEntryGuage = statsLogger.getGauge("NUM_LEDGERS_HAVING_LESS_THAN_AQ_REPLICAS_OF_AN_ENTRY");
        Gauge numLedgersHavingLessThanWQReplicasOfAnEntryGuage = statsLogger.getGauge("NUM_LEDGERS_HAVING_LESS_THAN_WQ_REPLICAS_OF_AN_ENTRY");
        Assert.assertEquals((String)"NUM_LEDGERS_HAVING_NO_REPLICA_OF_AN_ENTRY guage value", (Object)expectedNumLedgersFoundHavingNoReplicaOfAnEntry, (Object)numLedgersFoundHavingNoReplicaOfAnEntryGuage.getSample());
        Assert.assertEquals((String)"NUM_LEDGERS_HAVING_LESS_THAN_AQ_REPLICAS_OF_AN_ENTRY guage value", (Object)expectedNumLedgersHavingLessThanAQReplicasOfAnEntry, (Object)numLedgersHavingLessThanAQReplicasOfAnEntryGuage.getSample());
        Assert.assertEquals((String)"NUM_LEDGERS_HAVING_LESS_THAN_WQ_REPLICAS_OF_AN_ENTRY guage value", (Object)expectedNumLedgersHavingLessThanWQReplicasOfAnEntry, (Object)numLedgersHavingLessThanWQReplicasOfAnEntryGuage.getSample());
    }

    @Test
    public void testReplicasCheckForBookieHandleNotAvailable() throws Exception {
        int numOfBookies = 5;
        RegistrationManager regManager = this.driver.getRegistrationManager();
        MultiKeyMap returnAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        MultiKeyMap errorReturnValueForGetAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        List<BookieSocketAddress> bookieAddresses = this.addAndRegisterBookies(regManager, numOfBookies);
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        int ensembleSize = 5;
        int writeQuorumSize = 4;
        int ackQuorumSize = 2;
        long lastEntryId = 100L;
        int length = 10000;
        DigestType digestType = DigestType.DUMMY;
        byte[] password = new byte[]{};
        Collections.shuffle(bookieAddresses);
        HashMap<Long, List<BookieSocketAddress>> segmentEnsembles = new HashMap<Long, List<BookieSocketAddress>>();
        segmentEnsembles.put(0L, bookieAddresses);
        long ledgerId = 1L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)-8);
        }
        ensembleSize = 4;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(20L, bookieAddresses.subList(1, 5));
        segmentEnsembles.put(60L, bookieAddresses.subList(0, 4));
        ledgerId = 2L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)-8);
        }
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        ledgerId = 3L;
        this.createNonClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)-8);
        }
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(20L, bookieAddresses.subList(1, 5));
        segmentEnsembles.put(60L, bookieAddresses.subList(0, 4));
        ledgerId = 4L;
        this.createNonClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)-8);
        }
        this.runTestScenario((MultiKeyMap<String, AvailabilityOfEntriesOfLedger>)returnAvailabilityOfEntriesOfLedger, (MultiKeyMap<String, Integer>)errorReturnValueForGetAvailabilityOfEntriesOfLedger, 0, 0, 0);
    }

    @Test
    public void testReplicasCheckForLedgersFoundHavingNoReplica() throws Exception {
        int numOfBookies = 5;
        RegistrationManager regManager = this.driver.getRegistrationManager();
        MultiKeyMap returnAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        MultiKeyMap errorReturnValueForGetAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        List<BookieSocketAddress> bookieAddresses = this.addAndRegisterBookies(regManager, numOfBookies);
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        int ensembleSize = 5;
        int writeQuorumSize = 4;
        int ackQuorumSize = 2;
        long lastEntryId = 100L;
        int length = 10000;
        DigestType digestType = DigestType.DUMMY;
        byte[] password = new byte[]{};
        Collections.shuffle(bookieAddresses);
        int numLedgersFoundHavingNoReplicaOfAnEntry = 0;
        HashMap<Long, List<BookieSocketAddress>> segmentEnsembles = new HashMap<Long, List<BookieSocketAddress>>();
        segmentEnsembles.put(0L, bookieAddresses);
        long ledgerId = 1L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            returnAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)AvailabilityOfEntriesOfLedger.EMPTY_AVAILABILITYOFENTRIESOFLEDGER);
        }
        ++numLedgersFoundHavingNoReplicaOfAnEntry;
        ensembleSize = 4;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(20L, bookieAddresses.subList(1, 5));
        segmentEnsembles.put(60L, bookieAddresses.subList(0, 4));
        ledgerId = 2L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)-7);
        }
        ++numLedgersFoundHavingNoReplicaOfAnEntry;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        ledgerId = 3L;
        this.createNonClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            returnAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)AvailabilityOfEntriesOfLedger.EMPTY_AVAILABILITYOFENTRIESOFLEDGER);
        }
        ensembleSize = 3;
        writeQuorumSize = 3;
        ackQuorumSize = 2;
        lastEntryId = 1L;
        length = 1000;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 3));
        ledgerId = 4L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        for (BookieSocketAddress bookieSocketAddress : bookieAddresses) {
            returnAvailabilityOfEntriesOfLedger.put((Object)bookieSocketAddress.toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L}));
        }
        ++numLedgersFoundHavingNoReplicaOfAnEntry;
        ensembleSize = 4;
        writeQuorumSize = 3;
        ackQuorumSize = 2;
        lastEntryId = 3L;
        length = 10000;
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        ledgerId = 5L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{2L, 3L}));
        this.runTestScenario((MultiKeyMap<String, AvailabilityOfEntriesOfLedger>)returnAvailabilityOfEntriesOfLedger, (MultiKeyMap<String, Integer>)errorReturnValueForGetAvailabilityOfEntriesOfLedger, ++numLedgersFoundHavingNoReplicaOfAnEntry, 0, 0);
    }

    @Test
    public void testReplicasCheckForLedgersFoundHavingLessThanAQReplicasOfAnEntry() throws Exception {
        int numOfBookies = 5;
        RegistrationManager regManager = this.driver.getRegistrationManager();
        MultiKeyMap returnAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        MultiKeyMap errorReturnValueForGetAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        List<BookieSocketAddress> bookieAddresses = this.addAndRegisterBookies(regManager, numOfBookies);
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        DigestType digestType = DigestType.DUMMY;
        byte[] password = new byte[]{};
        Collections.shuffle(bookieAddresses);
        int numLedgersFoundHavingLessThanAQReplicasOfAnEntry = 0;
        HashMap<Long, List<BookieSocketAddress>> segmentEnsembles = new HashMap<Long, List<BookieSocketAddress>>();
        int ensembleSize = 4;
        int writeQuorumSize = 3;
        int ackQuorumSize = 2;
        long lastEntryId = 3L;
        int length = 10000;
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        long ledgerId = 1L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L, 2L, 3L}));
        ++numLedgersFoundHavingLessThanAQReplicasOfAnEntry;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(2L, bookieAddresses.subList(1, 5));
        ledgerId = 2L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[0]));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 2L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(4).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{3L}));
        ++numLedgersFoundHavingLessThanAQReplicasOfAnEntry;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(2L, bookieAddresses.subList(1, 5));
        ledgerId = 3L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{2L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 2L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(4).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{3L}));
        ++numLedgersFoundHavingLessThanAQReplicasOfAnEntry;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(2L, bookieAddresses.subList(1, 5));
        ledgerId = 4L;
        this.createNonClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[0]));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 2L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(4).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{3L}));
        ensembleSize = 3;
        writeQuorumSize = 3;
        ackQuorumSize = 2;
        lastEntryId = 1L;
        length = 1000;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 3));
        ledgerId = 5L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)AvailabilityOfEntriesOfLedger.EMPTY_AVAILABILITYOFENTRIESOFLEDGER);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)AvailabilityOfEntriesOfLedger.EMPTY_AVAILABILITYOFENTRIESOFLEDGER);
        errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)-8);
        this.runTestScenario((MultiKeyMap<String, AvailabilityOfEntriesOfLedger>)returnAvailabilityOfEntriesOfLedger, (MultiKeyMap<String, Integer>)errorReturnValueForGetAvailabilityOfEntriesOfLedger, 0, ++numLedgersFoundHavingLessThanAQReplicasOfAnEntry, 0);
    }

    @Test
    public void testReplicasCheckForLedgersFoundHavingLessThanWQReplicasOfAnEntry() throws Exception {
        int numOfBookies = 5;
        RegistrationManager regManager = this.driver.getRegistrationManager();
        MultiKeyMap returnAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        MultiKeyMap errorReturnValueForGetAvailabilityOfEntriesOfLedger = new MultiKeyMap();
        List<BookieSocketAddress> bookieAddresses = this.addAndRegisterBookies(regManager, numOfBookies);
        LedgerManagerFactory mFactory = this.driver.getLedgerManagerFactory();
        LedgerManager lm = mFactory.newLedgerManager();
        DigestType digestType = DigestType.DUMMY;
        byte[] password = new byte[]{};
        Collections.shuffle(bookieAddresses);
        int numLedgersFoundHavingLessThanWQReplicasOfAnEntry = 0;
        HashMap<Long, List<BookieSocketAddress>> segmentEnsembles = new HashMap<Long, List<BookieSocketAddress>>();
        int ensembleSize = 4;
        int writeQuorumSize = 3;
        int ackQuorumSize = 2;
        long lastEntryId = 3L;
        int length = 10000;
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        long ledgerId = 1L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 2L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L, 2L, 3L}));
        ++numLedgersFoundHavingLessThanWQReplicasOfAnEntry;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(2L, bookieAddresses.subList(1, 5));
        ledgerId = 2L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[0]));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 2L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(4).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{2L, 3L}));
        ++numLedgersFoundHavingLessThanWQReplicasOfAnEntry;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        segmentEnsembles.put(2L, bookieAddresses.subList(1, 5));
        ledgerId = 3L;
        this.createNonClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, digestType, password);
        errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)-7);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 2L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(4).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{2L, 3L}));
        ensembleSize = 4;
        writeQuorumSize = 3;
        ackQuorumSize = 2;
        lastEntryId = 1L;
        length = 1000;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 4));
        ledgerId = 4L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L, 2L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{1L, 3L}));
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(3).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L}));
        ++numLedgersFoundHavingLessThanWQReplicasOfAnEntry;
        ensembleSize = 3;
        writeQuorumSize = 3;
        ackQuorumSize = 2;
        lastEntryId = 1L;
        length = 1000;
        segmentEnsembles.clear();
        segmentEnsembles.put(0L, bookieAddresses.subList(0, 3));
        ledgerId = 5L;
        this.createClosedLedgerMetadata(lm, ledgerId, ensembleSize, writeQuorumSize, ackQuorumSize, segmentEnsembles, lastEntryId, length, digestType, password);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(0).toString(), (Object)Long.toString(ledgerId), (Object)AvailabilityOfEntriesOfLedger.EMPTY_AVAILABILITYOFENTRIESOFLEDGER);
        returnAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(1).toString(), (Object)Long.toString(ledgerId), (Object)new AvailabilityOfEntriesOfLedger(new long[]{0L, 1L}));
        errorReturnValueForGetAvailabilityOfEntriesOfLedger.put((Object)bookieAddresses.get(2).toString(), (Object)Long.toString(ledgerId), (Object)-8);
        this.runTestScenario((MultiKeyMap<String, AvailabilityOfEntriesOfLedger>)returnAvailabilityOfEntriesOfLedger, (MultiKeyMap<String, Integer>)errorReturnValueForGetAvailabilityOfEntriesOfLedger, 0, 0, ++numLedgersFoundHavingLessThanWQReplicasOfAnEntry);
    }

    private class TestBookKeeperAdmin
    extends BookKeeperAdmin {
        private final MultiKeyMap<String, AvailabilityOfEntriesOfLedger> returnAvailabilityOfEntriesOfLedger;
        private final MultiKeyMap<String, Integer> errorReturnValueForGetAvailabilityOfEntriesOfLedger;

        public TestBookKeeperAdmin(BookKeeper bkc, StatsLogger statsLogger, MultiKeyMap<String, AvailabilityOfEntriesOfLedger> returnAvailabilityOfEntriesOfLedger, MultiKeyMap<String, Integer> errorReturnValueForGetAvailabilityOfEntriesOfLedger) {
            super(bkc, statsLogger);
            this.returnAvailabilityOfEntriesOfLedger = returnAvailabilityOfEntriesOfLedger;
            this.errorReturnValueForGetAvailabilityOfEntriesOfLedger = errorReturnValueForGetAvailabilityOfEntriesOfLedger;
        }

        public CompletableFuture<AvailabilityOfEntriesOfLedger> asyncGetListOfEntriesOfLedger(BookieSocketAddress address, long ledgerId) {
            CompletableFuture<AvailabilityOfEntriesOfLedger> futureResult = new CompletableFuture<AvailabilityOfEntriesOfLedger>();
            Integer errorReturnValue = (Integer)this.errorReturnValueForGetAvailabilityOfEntriesOfLedger.get((Object)address.toString(), (Object)Long.toString(ledgerId));
            if (errorReturnValue != null) {
                futureResult.completeExceptionally(BKException.create((int)errorReturnValue).fillInStackTrace());
            } else {
                AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = (AvailabilityOfEntriesOfLedger)this.returnAvailabilityOfEntriesOfLedger.get((Object)address.toString(), (Object)Long.toString(ledgerId));
                futureResult.complete(availabilityOfEntriesOfLedger);
            }
            return futureResult;
        }
    }
}

