/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataClientDriver;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Test;

public class AutoRecoveryMainTest
extends BookKeeperClusterTestCase {
    public AutoRecoveryMainTest() {
        super(3);
    }

    @Test
    public void testStartup() throws Exception {
        AutoRecoveryMain main = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(0));
        try {
            main.start();
            Thread.sleep(500L);
            Assert.assertTrue((String)"AuditorElector should be running", (boolean)main.auditorElector.isRunning());
            Assert.assertTrue((String)"Replication worker should be running", (boolean)main.replicationWorker.isRunning());
        }
        finally {
            main.shutdown();
        }
    }

    @Test
    public void testShutdown() throws Exception {
        AutoRecoveryMain main = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(0));
        main.start();
        Thread.sleep(500L);
        Assert.assertTrue((String)"AuditorElector should be running", (boolean)main.auditorElector.isRunning());
        Assert.assertTrue((String)"Replication worker should be running", (boolean)main.replicationWorker.isRunning());
        main.shutdown();
        Assert.assertFalse((String)"AuditorElector should not be running", (boolean)main.auditorElector.isRunning());
        Assert.assertFalse((String)"Replication worker should not be running", (boolean)main.replicationWorker.isRunning());
    }

    @Test
    public void testAutoRecoverySessionLoss() throws Exception {
        AutoRecoveryMain main1 = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(0));
        AutoRecoveryMain main2 = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(1));
        AutoRecoveryMain main3 = new AutoRecoveryMain((ServerConfiguration)this.bsConfs.get(2));
        ZKMetadataClientDriver zkMetadataClientDriver1 = this.startAutoRecoveryMain(main1);
        ZooKeeper zk1 = zkMetadataClientDriver1.getZk();
        Auditor auditor1 = main1.auditorElector.getAuditor();
        BookieSocketAddress currentAuditor = AuditorElector.getCurrentAuditor((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(0)), (ZooKeeper)zk1);
        Assert.assertTrue((String)"Current Auditor should be AR1", (boolean)currentAuditor.equals((Object)Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(0)))));
        Assert.assertTrue((String)"Auditor of AR1 should be running", (boolean)auditor1.isRunning());
        ZKMetadataClientDriver zkMetadataClientDriver2 = this.startAutoRecoveryMain(main2);
        ZooKeeper zk2 = zkMetadataClientDriver2.getZk();
        ZKMetadataClientDriver zkMetadataClientDriver3 = this.startAutoRecoveryMain(main3);
        ZooKeeper zk3 = zkMetadataClientDriver3.getZk();
        Assert.assertTrue((String)"Current Auditor should still be AR1", (boolean)currentAuditor.equals((Object)Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(0)))));
        Auditor auditor2 = main2.auditorElector.getAuditor();
        Auditor auditor3 = main3.auditorElector.getAuditor();
        Assert.assertTrue((String)"AR2's Auditor should not be running", (auditor2 == null || !auditor2.isRunning() ? 1 : 0) != 0);
        Assert.assertTrue((String)"AR3's Auditor should not be running", (auditor3 == null || !auditor3.isRunning() ? 1 : 0) != 0);
        this.zkUtil.expireSession(zk2);
        this.zkUtil.expireSession(zk1);
        for (int i = 0; i < 10 && (main1.auditorElector.isRunning() || main1.replicationWorker.isRunning() || main1.isAutoRecoveryRunning() || main2.auditorElector.isRunning() || main2.replicationWorker.isRunning() || main2.isAutoRecoveryRunning()); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"AR1's vote node should not be existing", (zk3.exists(main1.auditorElector.getMyVote(), false) == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"AR2's vote node should not be existing", (zk3.exists(main2.auditorElector.getMyVote(), false) == null ? 1 : 0) != 0);
        currentAuditor = AuditorElector.getCurrentAuditor((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(2)), (ZooKeeper)zk3);
        Assert.assertTrue((String)"Current Auditor should be AR3", (boolean)currentAuditor.equals((Object)Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(2)))));
        auditor3 = main3.auditorElector.getAuditor();
        Assert.assertTrue((String)"Auditor of AR3 should be running", (boolean)auditor3.isRunning());
        Assert.assertFalse((String)"AR1's auditor should not be running", (boolean)auditor1.isRunning());
        Assert.assertFalse((String)"Elector1 should have shutdown", (boolean)main1.auditorElector.isRunning());
        Assert.assertFalse((String)"RW1 should have shutdown", (boolean)main1.replicationWorker.isRunning());
        Assert.assertFalse((String)"AR1 should have shutdown", (boolean)main1.isAutoRecoveryRunning());
        Assert.assertFalse((String)"Elector2 should have shutdown", (boolean)main2.auditorElector.isRunning());
        Assert.assertFalse((String)"RW2 should have shutdown", (boolean)main2.replicationWorker.isRunning());
        Assert.assertFalse((String)"AR2 should have shutdown", (boolean)main2.isAutoRecoveryRunning());
    }

    ZKMetadataClientDriver startAutoRecoveryMain(AutoRecoveryMain autoRecoveryMain) throws InterruptedException, KeeperException, ReplicationException.UnavailableException {
        String myVote;
        autoRecoveryMain.start();
        ZKMetadataClientDriver metadataClientDriver = (ZKMetadataClientDriver)autoRecoveryMain.bkc.getMetadataClientDriver();
        ZooKeeper zk = metadataClientDriver.getZk();
        for (int i = 0; !(i >= 10 || autoRecoveryMain.auditorElector.isRunning() && autoRecoveryMain.replicationWorker.isRunning() && autoRecoveryMain.isAutoRecoveryRunning() && (myVote = autoRecoveryMain.auditorElector.getMyVote()) != null && null != zk.exists(myVote, false)); ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"autoRecoveryMain components should be running", (autoRecoveryMain.auditorElector.isRunning() && autoRecoveryMain.replicationWorker.isRunning() && autoRecoveryMain.isAutoRecoveryRunning() ? 1 : 0) != 0);
        Assert.assertTrue((String)"autoRecoveryMain's vote node should be existing", (zk.exists(autoRecoveryMain.auditorElector.getMyVote(), false) != null ? 1 : 0) != 0);
        return metadataClientDriver;
    }
}

