/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentLedgerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentLedgerTest.class);
    Bookie bookie;
    File txnDir;
    File ledgerDir;
    int recvTimeout = 10000;
    Semaphore throttle;
    ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
    final List<File> tempDirs = new ArrayList<File>();
    byte[] zeros = new byte[16];
    int iterations = 51;
    int iterationStep;

    public ConcurrentLedgerTest() {
        String iterationsString = System.getProperty("iterations");
        if (iterationsString != null) {
            this.iterations = Integer.parseInt(iterationsString);
        }
        this.iterationStep = 25;
        iterationsString = System.getProperty("iterationStep");
        if (iterationsString != null) {
            this.iterationStep = Integer.parseInt(iterationsString);
        }
    }

    private File createTempDir(String prefix, String suffix, File parent) throws IOException {
        File dir = File.createTempFile(prefix, suffix, parent);
        dir.delete();
        this.tempDirs.add(dir);
        return dir;
    }

    @Before
    public void setUp() throws Exception {
        String ledgerDirName;
        String txnDirName = System.getProperty("txnDir");
        if (txnDirName != null) {
            this.txnDir = new File(txnDirName);
        }
        if ((ledgerDirName = System.getProperty("ledgerDir")) != null) {
            this.ledgerDir = new File(ledgerDirName);
        }
        File tmpFile = this.createTempDir("book", ".txn", this.txnDir);
        this.txnDir = new File(tmpFile.getParent(), tmpFile.getName() + ".dir");
        this.txnDir.mkdirs();
        tmpFile = this.createTempDir("book", ".ledger", this.ledgerDir);
        this.ledgerDir = new File(tmpFile.getParent(), tmpFile.getName() + ".dir");
        this.ledgerDir.mkdirs();
        this.conf.setBookiePort(5000);
        this.conf.setMetadataServiceUri(null);
        this.conf.setJournalDirName(this.txnDir.getPath());
        this.conf.setLedgerDirNames(new String[]{this.ledgerDir.getPath()});
        this.bookie = new Bookie(this.conf);
        this.bookie.start();
    }

    static void recursiveDelete(File f) {
        if (f.isFile()) {
            f.delete();
        } else {
            for (File i : f.listFiles()) {
                ConcurrentLedgerTest.recursiveDelete(i);
            }
            f.delete();
        }
    }

    @After
    public void tearDown() {
        this.bookie.shutdown();
        ConcurrentLedgerTest.recursiveDelete(this.txnDir);
        ConcurrentLedgerTest.recursiveDelete(this.ledgerDir);
    }

    @Test
    public void testConcurrentWrite() throws IOException, InterruptedException, BookieException {
        long duration;
        int ledgers;
        int size = 1024;
        int totalwrites = 128;
        if (System.getProperty("totalwrites") != null) {
            totalwrites = Integer.parseInt(System.getProperty("totalwrites"));
        }
        LOG.info("Running up to " + this.iterations + " iterations");
        LOG.info("Total writes = " + totalwrites);
        for (ledgers = 1; ledgers <= this.iterations; ledgers += this.iterationStep) {
            duration = this.doWrites(ledgers, size, totalwrites);
            LOG.info(totalwrites + " on " + ledgers + " took " + duration + " ms");
        }
        LOG.info("ledgers " + ledgers);
        for (ledgers = 1; ledgers <= this.iterations; ledgers += this.iterationStep) {
            duration = this.doReads(ledgers, size, totalwrites);
            LOG.info(ledgers + " read " + duration + " ms");
        }
    }

    private long doReads(int ledgers, int size, int totalwrites) throws IOException, InterruptedException, BookieException {
        long start = System.currentTimeMillis();
        for (int i = 1; i <= totalwrites / ledgers; ++i) {
            for (int j = 1; j <= ledgers; ++j) {
                ByteBuf entry = this.bookie.readEntry((long)j, (long)i);
                entry.readLong();
                entry.readLong();
                Assert.assertEquals((String)(j + "@" + i), (long)(j + 2), (long)entry.readLong());
                Assert.assertEquals((String)(j + "@" + i), (long)(i + 3), (long)entry.readLong());
            }
        }
        long finish = System.currentTimeMillis();
        return finish - start;
    }

    private long doWrites(int ledgers, int size, int totalwrites) throws IOException, InterruptedException, BookieException {
        this.throttle = new Semaphore(10000);
        BookkeeperInternalCallbacks.WriteCallback cb = new BookkeeperInternalCallbacks.WriteCallback(){

            public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
                AtomicInteger counter = (AtomicInteger)ctx;
                counter.getAndIncrement();
                ConcurrentLedgerTest.this.throttle.release();
            }
        };
        AtomicInteger counter = new AtomicInteger();
        long start = System.currentTimeMillis();
        for (int i = 1; i <= totalwrites / ledgers; ++i) {
            for (int j = 1; j <= ledgers; ++j) {
                ByteBuffer bytes = ByteBuffer.allocate(size);
                bytes.putLong(j);
                bytes.putLong(i);
                bytes.putLong(j + 2);
                bytes.putLong(i + 3);
                bytes.put(("This is ledger " + j + " entry " + i).getBytes());
                bytes.position(0);
                bytes.limit(bytes.capacity());
                this.throttle.acquire();
                this.bookie.addEntry(Unpooled.wrappedBuffer((ByteBuffer)bytes), false, cb, (Object)counter, this.zeros);
            }
        }
        long finish = System.currentTimeMillis();
        return finish - start;
    }
}

