/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.LedgerMetadataUtils;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.DataFormats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadataSerDe {
    private static final Logger log = LoggerFactory.getLogger(LedgerMetadataSerDe.class);
    public static final int METADATA_FORMAT_VERSION_1 = 1;
    public static final int METADATA_FORMAT_VERSION_2 = 2;
    public static final int METADATA_FORMAT_VERSION_3 = 3;
    public static final int MAXIMUM_METADATA_FORMAT_VERSION = 3;
    public static final int CURRENT_METADATA_FORMAT_VERSION = 3;
    private static final int LOWEST_COMPAT_METADATA_FORMAT_VERSION = 1;
    private static final int MAX_VERSION_DIGITS = 10;
    private static final byte[] VERSION_KEY_BYTES = "BookieMetadataFormatVersion\t".getBytes(Charsets.UTF_8);
    private static final String LINE_SPLITTER = "\n";
    private static final byte[] LINE_SPLITTER_BYTES = "\n".getBytes(Charsets.UTF_8);
    private static final String FIELD_SPLITTER = "\t";
    private static final String V1_CLOSED_TAG = "CLOSED";
    private static final int V1_IN_RECOVERY_ENTRY_ID = -102;

    private static void writeHeader(OutputStream os, int version) throws IOException {
        os.write(VERSION_KEY_BYTES);
        os.write(String.valueOf(version).getBytes(Charsets.UTF_8));
        os.write(LINE_SPLITTER_BYTES);
    }

    private static int readHeader(InputStream is) throws IOException {
        Preconditions.checkState((LINE_SPLITTER_BYTES.length == 1 ? 1 : 0) != 0, (Object)"LINE_SPLITTER must be single byte");
        for (int i = 0; i < VERSION_KEY_BYTES.length; ++i) {
            int b = is.read();
            if (b >= 0 && (byte)b == VERSION_KEY_BYTES[i]) continue;
            throw new IOException("Ledger metadata header corrupt at index " + i);
        }
        byte[] versionBuf = new byte[10];
        int i = 0;
        while (i < 10) {
            int b = is.read();
            if (b == LINE_SPLITTER_BYTES[0]) {
                String versionStr = new String(versionBuf, 0, i, Charsets.UTF_8);
                try {
                    return Integer.parseInt(versionStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Unable to parse version number from " + versionStr);
                }
            }
            if (b < 0) break;
            versionBuf[i++] = (byte)b;
        }
        throw new IOException("Unable to find end of version number, metadata appears corrupt");
    }

    public byte[] serialize(LedgerMetadata metadata) throws IOException {
        byte[] serialized;
        int formatVersion = metadata.getMetadataFormatVersion();
        switch (formatVersion) {
            case 3: {
                serialized = LedgerMetadataSerDe.serializeVersion3(metadata);
                break;
            }
            case 2: {
                serialized = LedgerMetadataSerDe.serializeVersion2(metadata);
                break;
            }
            case 1: {
                serialized = LedgerMetadataSerDe.serializeVersion1(metadata);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format version " + formatVersion);
            }
        }
        if (log.isDebugEnabled()) {
            String serializedStr = formatVersion > 2 ? Base64.getEncoder().encodeToString(serialized) : new String(serialized, Charsets.UTF_8);
            log.debug("Serialized with format {}: {}", (Object)formatVersion, (Object)serializedStr);
        }
        return serialized;
    }

    private static byte[] serializeVersion3(LedgerMetadata metadata) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            LedgerMetadataSerDe.writeHeader(os, 3);
            DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
            builder.setQuorumSize(metadata.getWriteQuorumSize()).setAckQuorumSize(metadata.getAckQuorumSize()).setEnsembleSize(metadata.getEnsembleSize()).setLength(metadata.getLength()).setLastEntryId(metadata.getLastEntryId());
            switch (metadata.getState()) {
                case CLOSED: {
                    builder.setState(DataFormats.LedgerMetadataFormat.State.CLOSED);
                    break;
                }
                case IN_RECOVERY: {
                    builder.setState(DataFormats.LedgerMetadataFormat.State.IN_RECOVERY);
                    break;
                }
                case OPEN: {
                    builder.setState(DataFormats.LedgerMetadataFormat.State.OPEN);
                    break;
                }
                default: {
                    Preconditions.checkArgument((boolean)false, (Object)String.format("Unknown state %s for protobuf serialization", new Object[]{metadata.getState()}));
                }
            }
            if (LedgerMetadataUtils.shouldStoreCtime(metadata)) {
                builder.setCtime(metadata.getCtime());
            }
            builder.setDigestType(LedgerMetadataSerDe.apiToProtoDigestType(metadata.getDigestType()));
            LedgerMetadataSerDe.serializePassword(metadata.getPassword(), builder);
            Map<String, byte[]> customMetadata = metadata.getCustomMetadata();
            if (customMetadata.size() > 0) {
                DataFormats.LedgerMetadataFormat.cMetadataMapEntry.Builder cMetadataBuilder = DataFormats.LedgerMetadataFormat.cMetadataMapEntry.newBuilder();
                for (Map.Entry<String, byte[]> entry : customMetadata.entrySet()) {
                    cMetadataBuilder.setKey(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue()));
                    builder.addCustomMetadata(cMetadataBuilder.build());
                }
            }
            for (Map.Entry entry : metadata.getAllEnsembles().entrySet()) {
                DataFormats.LedgerMetadataFormat.Segment.Builder segmentBuilder = DataFormats.LedgerMetadataFormat.Segment.newBuilder();
                segmentBuilder.setFirstEntryId(((Long)entry.getKey()).longValue());
                for (BookieSocketAddress addr : (List)entry.getValue()) {
                    segmentBuilder.addEnsembleMember(addr.toString());
                }
                builder.addSegment(segmentBuilder.build());
            }
            builder.setCToken(metadata.getCToken());
            builder.build().writeDelimitedTo((OutputStream)os);
            Object object = os.toByteArray();
            return object;
        }
    }

    private static byte[] serializeVersion2(LedgerMetadata metadata) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            LedgerMetadataSerDe.writeHeader(os, 2);
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, Charsets.UTF_8.name()));){
                DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
                builder.setQuorumSize(metadata.getWriteQuorumSize()).setAckQuorumSize(metadata.getAckQuorumSize()).setEnsembleSize(metadata.getEnsembleSize()).setLength(metadata.getLength()).setLastEntryId(metadata.getLastEntryId());
                switch (metadata.getState()) {
                    case CLOSED: {
                        builder.setState(DataFormats.LedgerMetadataFormat.State.CLOSED);
                        break;
                    }
                    case IN_RECOVERY: {
                        builder.setState(DataFormats.LedgerMetadataFormat.State.IN_RECOVERY);
                        break;
                    }
                    case OPEN: {
                        builder.setState(DataFormats.LedgerMetadataFormat.State.OPEN);
                        break;
                    }
                    default: {
                        Preconditions.checkArgument((boolean)false, (Object)String.format("Unknown state %s for protobuf serialization", new Object[]{metadata.getState()}));
                    }
                }
                if (LedgerMetadataUtils.shouldStoreCtime(metadata)) {
                    builder.setCtime(metadata.getCtime());
                }
                builder.setDigestType(LedgerMetadataSerDe.apiToProtoDigestType(metadata.getDigestType()));
                LedgerMetadataSerDe.serializePassword(metadata.getPassword(), builder);
                Map<String, byte[]> customMetadata = metadata.getCustomMetadata();
                if (customMetadata.size() > 0) {
                    DataFormats.LedgerMetadataFormat.cMetadataMapEntry.Builder cMetadataBuilder = DataFormats.LedgerMetadataFormat.cMetadataMapEntry.newBuilder();
                    for (Map.Entry<String, byte[]> entry : customMetadata.entrySet()) {
                        cMetadataBuilder.setKey(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue()));
                        builder.addCustomMetadata(cMetadataBuilder.build());
                    }
                }
                for (Map.Entry entry : metadata.getAllEnsembles().entrySet()) {
                    DataFormats.LedgerMetadataFormat.Segment.Builder segmentBuilder = DataFormats.LedgerMetadataFormat.Segment.newBuilder();
                    segmentBuilder.setFirstEntryId(((Long)entry.getKey()).longValue());
                    for (BookieSocketAddress addr : (List)entry.getValue()) {
                        segmentBuilder.addEnsembleMember(addr.toString());
                    }
                    builder.addSegment(segmentBuilder.build());
                }
                TextFormat.print((MessageOrBuilder)builder.build(), (Appendable)writer);
                writer.flush();
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    private static byte[] serializeVersion1(LedgerMetadata metadata) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            LedgerMetadataSerDe.writeHeader(os, 1);
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, Charsets.UTF_8.name()));){
                writer.append(String.valueOf(metadata.getWriteQuorumSize())).append(LINE_SPLITTER);
                writer.append(String.valueOf(metadata.getEnsembleSize())).append(LINE_SPLITTER);
                writer.append(String.valueOf(metadata.getLength())).append(LINE_SPLITTER);
                for (Map.Entry entry : metadata.getAllEnsembles().entrySet()) {
                    writer.append(String.valueOf(entry.getKey()));
                    for (BookieSocketAddress addr : (List)entry.getValue()) {
                        writer.append(FIELD_SPLITTER).append(addr.toString());
                    }
                    writer.append(LINE_SPLITTER);
                }
                if (metadata.getState() == LedgerMetadata.State.IN_RECOVERY) {
                    writer.append(String.valueOf(-102)).append(FIELD_SPLITTER).append(V1_CLOSED_TAG);
                } else if (metadata.getState() == LedgerMetadata.State.CLOSED) {
                    writer.append(String.valueOf(metadata.getLastEntryId())).append(FIELD_SPLITTER).append(V1_CLOSED_TAG);
                } else {
                    Preconditions.checkArgument((metadata.getState() == LedgerMetadata.State.OPEN ? 1 : 0) != 0, (Object)String.format("Unknown state %s for V1 serialization", new Object[]{metadata.getState()}));
                }
                writer.flush();
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF_8 should be supported everywhere");
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    private static void serializePassword(byte[] password, DataFormats.LedgerMetadataFormat.Builder builder) {
        if (password == null || password.length == 0) {
            builder.setPassword(ByteString.EMPTY);
        } else {
            builder.setPassword(ByteString.copyFrom((byte[])password));
        }
    }

    public LedgerMetadata parseConfig(byte[] bytes, Optional<Long> metadataStoreCtime) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Deserializing {}", (Object)Base64.getEncoder().encodeToString(bytes));
        }
        Throwable throwable = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            int metadataFormatVersion = LedgerMetadataSerDe.readHeader(is);
            if (log.isDebugEnabled()) {
                String contentStr = "";
                if (metadataFormatVersion <= 2) {
                    contentStr = ", content: " + new String(bytes, Charsets.UTF_8);
                }
                log.debug("Format version {} detected{}", (Object)metadataFormatVersion, (Object)contentStr);
            }
            switch (metadataFormatVersion) {
                case 3: {
                    LedgerMetadata ledgerMetadata = LedgerMetadataSerDe.parseVersion3Config(is, metadataStoreCtime);
                    return ledgerMetadata;
                }
                case 2: {
                    LedgerMetadata ledgerMetadata = LedgerMetadataSerDe.parseVersion2Config(is, metadataStoreCtime);
                    return ledgerMetadata;
                }
                case 1: {
                    LedgerMetadata ledgerMetadata = LedgerMetadataSerDe.parseVersion1Config(is);
                    return ledgerMetadata;
                }
            }
            try {
                throw new IOException(String.format("Metadata version not compatible. Expected between %d and %d, but got %d", 1, 3, metadataFormatVersion));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static LedgerMetadata parseVersion3Config(InputStream is, Optional<Long> metadataStoreCtime) throws IOException {
        LedgerMetadataBuilder builder = LedgerMetadataBuilder.create().withMetadataFormatVersion(3);
        DataFormats.LedgerMetadataFormat.Builder formatBuilder = DataFormats.LedgerMetadataFormat.newBuilder();
        formatBuilder.mergeDelimitedFrom(is);
        DataFormats.LedgerMetadataFormat data = formatBuilder.build();
        LedgerMetadataSerDe.decodeFormat(data, builder);
        if (data.hasCtime()) {
            builder.storingCreationTime(true);
        } else if (metadataStoreCtime.isPresent()) {
            builder.withCreationTime(metadataStoreCtime.get()).storingCreationTime(false);
        }
        return builder.build();
    }

    private static LedgerMetadata parseVersion2Config(InputStream is, Optional<Long> metadataStoreCtime) throws IOException {
        LedgerMetadataBuilder builder = LedgerMetadataBuilder.create().withMetadataFormatVersion(2);
        DataFormats.LedgerMetadataFormat.Builder formatBuilder = DataFormats.LedgerMetadataFormat.newBuilder();
        try (InputStreamReader reader = new InputStreamReader(is, Charsets.UTF_8.name());){
            TextFormat.merge((Readable)reader, (Message.Builder)formatBuilder);
        }
        DataFormats.LedgerMetadataFormat data = formatBuilder.build();
        LedgerMetadataSerDe.decodeFormat(data, builder);
        if (data.hasCtime()) {
            builder.storingCreationTime(true);
        } else if (metadataStoreCtime.isPresent()) {
            builder.withCreationTime(metadataStoreCtime.get()).storingCreationTime(false);
        }
        return builder.build();
    }

    private static void decodeFormat(DataFormats.LedgerMetadataFormat data, LedgerMetadataBuilder builder) throws IOException {
        builder.withEnsembleSize(data.getEnsembleSize());
        builder.withWriteQuorumSize(data.getQuorumSize());
        if (data.hasAckQuorumSize()) {
            builder.withAckQuorumSize(data.getAckQuorumSize());
        } else {
            builder.withAckQuorumSize(data.getQuorumSize());
        }
        if (data.hasCtime()) {
            builder.withCreationTime(data.getCtime());
        }
        if (data.getState() == DataFormats.LedgerMetadataFormat.State.IN_RECOVERY) {
            builder.withInRecoveryState();
        } else if (data.getState() == DataFormats.LedgerMetadataFormat.State.CLOSED) {
            builder.withClosedState().withLastEntryId(data.getLastEntryId()).withLength(data.getLength());
        }
        if (data.hasPassword()) {
            builder.withPassword(data.getPassword().toByteArray()).withDigestType(LedgerMetadataSerDe.protoToApiDigestType(data.getDigestType()));
        }
        for (DataFormats.LedgerMetadataFormat.Segment s : data.getSegmentList()) {
            ArrayList<BookieSocketAddress> addrs = new ArrayList<BookieSocketAddress>();
            for (String addr : s.getEnsembleMemberList()) {
                addrs.add(new BookieSocketAddress(addr));
            }
            builder.newEnsembleEntry(s.getFirstEntryId(), addrs);
        }
        if (data.getCustomMetadataCount() > 0) {
            builder.withCustomMetadata(data.getCustomMetadataList().stream().collect(Collectors.toMap(e -> e.getKey(), e -> e.getValue().toByteArray())));
        }
        if (data.hasCToken()) {
            builder.withCToken(data.getCToken());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LedgerMetadata parseVersion1Config(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8.name()));){
            LedgerMetadataBuilder builder = LedgerMetadataBuilder.create().withMetadataFormatVersion(1);
            int quorumSize = Integer.parseInt(reader.readLine());
            int ensembleSize = Integer.parseInt(reader.readLine());
            long length = Long.parseLong(reader.readLine());
            builder.withEnsembleSize(ensembleSize).withWriteQuorumSize(quorumSize).withAckQuorumSize(quorumSize);
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(FIELD_SPLITTER);
                if (parts[1].equals(V1_CLOSED_TAG)) {
                    Long l = Long.parseLong(parts[0]);
                    if (l == -102L) {
                        builder.withInRecoveryState();
                        break;
                    }
                    builder.withClosedState().withLastEntryId(l).withLength(length);
                    break;
                }
                ArrayList<BookieSocketAddress> addrs = new ArrayList<BookieSocketAddress>();
                for (int j = 1; j < parts.length; ++j) {
                    addrs.add(new BookieSocketAddress(parts[j]));
                }
                builder.newEnsembleEntry(Long.parseLong(parts[0]), addrs);
                line = reader.readLine();
            }
            LedgerMetadata ledgerMetadata = builder.build();
            return ledgerMetadata;
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private static DataFormats.LedgerMetadataFormat.DigestType apiToProtoDigestType(DigestType digestType) {
        switch (digestType) {
            case MAC: {
                return DataFormats.LedgerMetadataFormat.DigestType.HMAC;
            }
            case CRC32: {
                return DataFormats.LedgerMetadataFormat.DigestType.CRC32;
            }
            case CRC32C: {
                return DataFormats.LedgerMetadataFormat.DigestType.CRC32C;
            }
            case DUMMY: {
                return DataFormats.LedgerMetadataFormat.DigestType.DUMMY;
            }
        }
        throw new IllegalArgumentException("Unable to convert digest type " + (Object)((Object)digestType));
    }

    private static DigestType protoToApiDigestType(DataFormats.LedgerMetadataFormat.DigestType digestType) {
        switch (digestType) {
            case HMAC: {
                return DigestType.MAC;
            }
            case CRC32: {
                return DigestType.CRC32;
            }
            case CRC32C: {
                return DigestType.CRC32C;
            }
            case DUMMY: {
                return DigestType.DUMMY;
            }
        }
        throw new IllegalArgumentException("Unable to convert digest type " + digestType);
    }
}

