/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieJournalTest;
import org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.bookkeeper.bookie.BookieStatus;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerDirsMonitor;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.bookkeeper.common.component.Lifecycle;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.server.service.AutoRecoveryService;
import org.apache.bookkeeper.server.service.BookieService;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.LoggerOutput;
import org.apache.bookkeeper.util.PortManager;
import org.apache.bookkeeper.util.TestUtils;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieInitializationTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookieInitializationTest.class);
    private static ObjectMapper om = new ObjectMapper();
    @Rule
    public final TestName runtime = new TestName();
    @Rule
    public LoggerOutput loggerOutput = new LoggerOutput();
    ZKMetadataBookieDriver driver;

    public BookieInitializationTest() {
        super(0);
    }

    @Override
    public void setUp() throws Exception {
        String ledgersPath = "/ledgers" + this.runtime.getMethodName();
        super.setUp(ledgersPath);
        this.zkUtil.createBKEnsemble(ledgersPath);
        this.driver = new ZKMetadataBookieDriver();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.driver != null) {
            this.driver.close();
        }
        super.tearDown();
    }

    @Test
    public void testOneJournalReplayForBookieRestartInReadOnlyMode() throws Exception {
        this.testJournalReplayForBookieRestartInReadOnlyMode(1);
    }

    @Test
    public void testMultipleJournalReplayForBookieRestartInReadOnlyMode() throws Exception {
        this.testJournalReplayForBookieRestartInReadOnlyMode(4);
    }

    private void testJournalReplayForBookieRestartInReadOnlyMode(int numOfJournalDirs) throws Exception {
        Journal journal;
        int i;
        File tmpLedgerDir = this.createTempDir("DiskCheck", "test");
        File tmpJournalDir = this.createTempDir("DiskCheck", "test");
        String[] journalDirs = new String[numOfJournalDirs];
        for (int i2 = 0; i2 < numOfJournalDirs; ++i2) {
            journalDirs[i2] = tmpJournalDir.getAbsolutePath() + "/journal-" + i2;
        }
        ServerConfiguration conf = (ServerConfiguration)this.newServerConfiguration().setJournalDirsName(journalDirs).setLedgerDirNames(new String[]{tmpLedgerDir.getPath()}).setDiskCheckInterval(1000).setLedgerStorageClass(SortedLedgerStorage.class.getName()).setAutoRecoveryDaemonEnabled(false).setZkTimeout(5000);
        MockBookieServer server = new MockBookieServer(conf);
        server.start();
        ArrayList<Journal.LastLogMark> lastLogMarkList = new ArrayList<Journal.LastLogMark>(journalDirs.length);
        for (int i3 = 0; i3 < journalDirs.length; ++i3) {
            Journal journal2 = (Journal)server.getBookie().journals.get(i3);
            journal2.getLastLogMark().readLog();
            lastLogMarkList.add(journal2.getLastLogMark().markLog());
            Assert.assertEquals((long)0L, (long)((Journal.LastLogMark)lastLogMarkList.get(i3)).getCurMark().compare(new LogMark(0L, 0L)));
        }
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setMetadataServiceUri(this.metadataServiceUri);
        BookKeeper bkClient = new BookKeeper(clientConf);
        for (i = 0; i < journalDirs.length; ++i) {
            LedgerHandle lh = bkClient.createLedger(1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes());
            long entryId = -1L;
            long numOfEntries = new Random().nextInt(10) + 3;
            int j = 0;
            while ((long)j < numOfEntries) {
                entryId = lh.addEntry("data".getBytes());
                ++j;
            }
            Assert.assertEquals((long)entryId, (long)(numOfEntries - 1L));
            lh.close();
        }
        for (i = 0; i < journalDirs.length; ++i) {
            journal = (Journal)server.getBookie().journals.get(i);
            Assert.assertTrue((journal.getLastLogMark().getCurMark().compare(((Journal.LastLogMark)lastLogMarkList.get(i)).getCurMark()) > 0 ? 1 : 0) != 0);
            lastLogMarkList.set(i, journal.getLastLogMark().markLog());
        }
        server.shutdown();
        conf.setDiskUsageThreshold(0.001f).setDiskUsageWarnThreshold(0.0f).setReadOnlyModeEnabled(true).setIsForceGCAllowWhenNoSpace(true).setMinUsableSizeForIndexFileCreation(5120L);
        server = new BookieServer(conf);
        for (i = 0; i < journalDirs.length; ++i) {
            journal = (Journal)server.getBookie().journals.get(i);
            Assert.assertEquals((long)0L, (long)journal.getLastLogMark().getCurMark().compare(new LogMark(0L, 0L)));
        }
        int numOfRestarts = 3;
        for (int i4 = 0; i4 < numOfRestarts; ++i4) {
            int txnBefore = TestUtils.countNumOfFiles(conf.getJournalDirs(), "txn");
            int logBefore = TestUtils.countNumOfFiles(conf.getLedgerDirs(), "log");
            int idxBefore = TestUtils.countNumOfFiles(conf.getLedgerDirs(), "idx");
            server.start();
            for (int j = 0; j < journalDirs.length; ++j) {
                Journal journal3 = (Journal)server.getBookie().journals.get(j);
                Assert.assertTrue((journal3.getLastLogMark().getCurMark().compare(((Journal.LastLogMark)lastLogMarkList.get(j)).getCurMark()) > 0 ? 1 : 0) != 0);
                lastLogMarkList.set(j, journal3.getLastLogMark().markLog());
            }
            server.shutdown();
            Assert.assertEquals((long)journalDirs.length, (long)(TestUtils.countNumOfFiles(conf.getJournalDirs(), "txn") - txnBefore));
            if (i4 == 0) {
                Assert.assertTrue((TestUtils.countNumOfFiles(conf.getLedgerDirs(), "log") - logBefore > 0 ? 1 : 0) != 0);
                Assert.assertTrue((TestUtils.countNumOfFiles(conf.getLedgerDirs(), "idx") - idxBefore > 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((TestUtils.countNumOfFiles(conf.getLedgerDirs(), "log") - logBefore <= 0 ? 1 : 0) != 0);
                Assert.assertTrue((TestUtils.countNumOfFiles(conf.getLedgerDirs(), "idx") - idxBefore <= 0 ? 1 : 0) != 0);
            }
            server = new BookieServer(conf);
        }
        bkClient.close();
    }

    @Test
    public void testExitCodeZK_REG_FAIL() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setMetadataServiceUri(this.metadataServiceUri);
        final RegistrationManager rm = (RegistrationManager)Mockito.mock(RegistrationManager.class);
        ((RegistrationManager)Mockito.doThrow((Throwable[])new Throwable[]{new BookieException.MetadataStoreException("mocked exception")}).when((Object)rm)).registerBookie(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (BookieServiceInfo)ArgumentMatchers.any(BookieServiceInfo.class));
        BookieServer bkServer = new BookieServer(conf){

            protected Bookie newBookie(ServerConfiguration conf, ByteBufAllocator allocator, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException, KeeperException, InterruptedException, BookieException {
                Bookie bookie = new Bookie(conf);
                MetadataBookieDriver driver = (MetadataBookieDriver)Whitebox.getInternalState((Object)bookie, (String)"metadataDriver");
                ((ZKMetadataBookieDriver)driver).setRegManager(rm);
                return bookie;
            }
        };
        bkServer.start();
        bkServer.join();
        Assert.assertEquals((String)"Failed to return ExitCode.ZK_REG_FAIL", (long)4L, (long)bkServer.getExitCode());
    }

    @Test
    public void testBookieRegistrationWithSameZooKeeperClient() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        ((ServerConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setListeningInterface(null);
        String bookieId = Bookie.getBookieAddress((ServerConfiguration)conf).toString();
        this.driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        try (BookieStateManager manager = new BookieStateManager(conf, (MetadataBookieDriver)this.driver);){
            manager.registerBookie(true).get();
            Assert.assertTrue((String)"Bookie registration node doesn't exists!", (boolean)this.driver.getRegistrationManager().isBookieRegistered(bookieId));
            manager.registerBookie(true).get();
            Assert.assertTrue((String)"Bookie registration node doesn't exists!", (boolean)this.driver.getRegistrationManager().isBookieRegistered(bookieId));
        }
    }

    @Test
    public void testBookieRegistration() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        ((ServerConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setListeningInterface(null);
        String bookieId = Bookie.getBookieAddress((ServerConfiguration)conf).toString();
        String bkRegPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf) + "/" + "available" + "/" + bookieId;
        this.driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        try (BookieStateManager manager = new BookieStateManager(conf, (MetadataBookieDriver)this.driver);){
            manager.registerBookie(true).get();
        }
        Stat bkRegNode1 = this.zkc.exists(bkRegPath, false);
        Assert.assertNotNull((String)"Bookie registration has been failed", (Object)bkRegNode1);
        try (ZKMetadataBookieDriver newDriver = new ZKMetadataBookieDriver();){
            newDriver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
            try (ZooKeeperClient newZk = this.createNewZKClient();){
                new Thread(() -> {
                    try {
                        Thread.sleep(conf.getZkTimeout() / 3);
                        this.zkc.delete(bkRegPath, -1);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete the znode :" + bkRegPath, (Throwable)e);
                    }
                }).start();
                try (BookieStateManager newMgr = new BookieStateManager(conf, (MetadataBookieDriver)newDriver);){
                    newMgr.registerBookie(true).get();
                }
                catch (IOException e) {
                    Throwable t = e.getCause();
                    if (t instanceof KeeperException) {
                        KeeperException ke = (KeeperException)t;
                        Assert.assertTrue((String)("ErrorCode:" + ke.code() + ", Registration node exists"), (ke.code() != KeeperException.Code.NODEEXISTS ? 1 : 0) != 0);
                    }
                    throw e;
                }
                Stat bkRegNode2 = newZk.exists(bkRegPath, false);
                Assert.assertNotNull((String)"Bookie registration has been failed", (Object)bkRegNode2);
                Assert.assertTrue((String)("Bookie is referring to old registration znode:" + bkRegNode1 + ", New ZNode:" + bkRegNode2), (bkRegNode1.getEphemeralOwner() != bkRegNode2.getEphemeralOwner() ? 1 : 0) != 0);
            }
        }
    }

    @Test(timeout=20000L)
    public void testBookieRegistrationWithFQDNHostNameAsBookieID() throws Exception {
        ServerConfiguration conf = ((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.metadataServiceUri)).setUseHostNameAsBookieID(true).setListeningInterface(null);
        String bookieId = InetAddress.getLocalHost().getCanonicalHostName() + ":" + conf.getBookiePort();
        this.driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        try (BookieStateManager manager = new BookieStateManager(conf, (MetadataBookieDriver)this.driver);){
            manager.registerBookie(true).get();
            Assert.assertTrue((String)"Bookie registration node doesn't exists!", (boolean)this.driver.getRegistrationManager().isBookieRegistered(bookieId));
        }
    }

    @Test(timeout=20000L)
    public void testBookieRegistrationWithShortHostNameAsBookieID() throws Exception {
        ServerConfiguration conf = ((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.metadataServiceUri)).setUseHostNameAsBookieID(true).setUseShortHostName(true).setListeningInterface(null);
        String bookieId = InetAddress.getLocalHost().getCanonicalHostName().split("\\.", 2)[0] + ":" + conf.getBookiePort();
        this.driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        try (BookieStateManager manager = new BookieStateManager(conf, (MetadataBookieDriver)this.driver);){
            manager.registerBookie(true).get();
            Assert.assertTrue((String)"Bookie registration node doesn't exists!", (boolean)this.driver.getRegistrationManager().isBookieRegistered(bookieId));
        }
    }

    @Test
    public void testRegNodeExistsAfterSessionTimeOut() throws Exception {
        ServerConfiguration conf = ((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.metadataServiceUri)).setListeningInterface(null);
        String bookieId = InetAddress.getLocalHost().getHostAddress() + ":" + conf.getBookiePort();
        String bkRegPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf) + "/" + "available" + "/" + bookieId;
        this.driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        try (BookieStateManager manager = new BookieStateManager(conf, (MetadataBookieDriver)this.driver);){
            manager.registerBookie(true).get();
            Assert.assertTrue((String)"Bookie registration node doesn't exists!", (boolean)this.driver.getRegistrationManager().isBookieRegistered(bookieId));
        }
        Stat bkRegNode1 = this.zkc.exists(bkRegPath, false);
        Assert.assertNotNull((String)"Bookie registration has been failed", (Object)bkRegNode1);
        Throwable throwable = null;
        try (ZKMetadataBookieDriver newDriver = new ZKMetadataBookieDriver();){
            newDriver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
            try (BookieStateManager newMgr = new BookieStateManager(conf, (MetadataBookieDriver)newDriver);){
                newMgr.registerBookie(true).get();
                Assert.fail((String)"Should throw NodeExistsException as the znode is not getting expired");
            }
            catch (ExecutionException ee) {
                Throwable e = ee.getCause();
                Throwable t1 = e.getCause();
                Throwable t2 = t1.getCause();
                Throwable t3 = t2.getCause();
                if (t3 instanceof KeeperException) {
                    KeeperException ke = (KeeperException)t3;
                    Assert.assertTrue((String)("ErrorCode:" + ke.code() + ", Registration node doesn't exists"), (ke.code() == KeeperException.Code.NODEEXISTS ? 1 : 0) != 0);
                    Stat bkRegNode2 = this.zkc.exists(bkRegPath, false);
                    Assert.assertNotNull((String)"Bookie registration has been failed", (Object)bkRegNode2);
                    Assert.assertTrue((String)("Bookie wrongly registered. Old registration znode:" + bkRegNode1 + ", New znode:" + bkRegNode2), (bkRegNode1.getEphemeralOwner() == bkRegNode2.getEphemeralOwner() ? 1 : 0) != 0);
                    if (newDriver != null) {
                        if (throwable != null) {
                            try {
                                newDriver.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            newDriver.close();
                        }
                    }
                    return;
                }
                try {
                    throw ee;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    @Test(timeout=20000L)
    public void testBookieRegistrationBookieServiceInfo() throws Exception {
        ServerConfiguration conf = ((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.metadataServiceUri)).setUseHostNameAsBookieID(true).setUseShortHostName(true).setListeningInterface(null);
        String bookieId = InetAddress.getLocalHost().getCanonicalHostName().split("\\.", 2)[0] + ":" + conf.getBookiePort();
        String bkRegPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)conf) + "/" + "available" + "/" + bookieId;
        this.driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        BookieServiceInfo.Endpoint endpoint = new BookieServiceInfo.Endpoint("test", 1281, "localhost", "bookie-rpc", Collections.emptyList(), Collections.emptyList());
        BookieServiceInfo bsi = new BookieServiceInfo(Collections.emptyMap(), Arrays.asList(endpoint));
        Supplier<BookieServiceInfo> supplier = () -> bsi;
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        try (BookieStateManager manager = new BookieStateManager(conf, (StatsLogger)NullStatsLogger.INSTANCE, (MetadataBookieDriver)this.driver, ledgerDirsManager, supplier);){
            manager.registerBookie(true).get();
            Assert.assertTrue((String)"Bookie registration node doesn't exists!", (boolean)this.driver.getRegistrationManager().isBookieRegistered(bookieId));
        }
        Stat bkRegNode = this.zkc.exists(bkRegPath, false);
        Assert.assertNotNull((String)"Bookie registration has been failed", (Object)bkRegNode);
        byte[] bkRegNodeData = this.zkc.getData(bkRegPath, null, null);
        Assert.assertFalse((String)"Bookie service info not written", (bkRegNodeData == null || bkRegNodeData.length == 0 ? 1 : 0) != 0);
        DataFormats.BookieServiceInfoFormat serializedBookieServiceInfo = DataFormats.BookieServiceInfoFormat.parseFrom((byte[])bkRegNodeData);
        DataFormats.BookieServiceInfoFormat.Endpoint serializedEndpoint = serializedBookieServiceInfo.getEndpoints(0);
        Assert.assertNotNull((String)"Serialized Bookie endpoint not found", (Object)serializedEndpoint);
        Assert.assertEquals((Object)endpoint.getId(), (Object)serializedEndpoint.getId());
        Assert.assertEquals((Object)endpoint.getHost(), (Object)serializedEndpoint.getHost());
        Assert.assertEquals((long)endpoint.getPort(), (long)serializedEndpoint.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserNotPermittedToStart() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        int port = PortManager.nextFreePort();
        ((ServerConfiguration)conf.setMetadataServiceUri(null)).setBookiePort(port).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()});
        String userString = "larry, curly,moe,,";
        conf.setPermittedStartupUsers(userString);
        BookieServer bs1 = null;
        boolean sawException = false;
        try {
            bs1 = new BookieServer(conf);
            Assert.fail((String)"Bookkeeper should not have started since current user isn't in permittedStartupUsers");
        }
        catch (AccessControlException buae) {
            sawException = true;
        }
        finally {
            if (bs1 != null && bs1.isRunning()) {
                bs1.shutdown();
            }
        }
        Assert.assertTrue((String)"Should have thrown exception", (boolean)sawException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserPermittedToStart() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        int port = PortManager.nextFreePort();
        ((ServerConfiguration)conf.setMetadataServiceUri(null)).setBookiePort(port).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()});
        BookieServer bs1 = null;
        String userString = "larry,,,curly ," + System.getProperty("user.name") + " ,moe";
        conf.setPermittedStartupUsers(userString);
        try {
            bs1 = new BookieServer(conf);
            bs1.start();
        }
        catch (AccessControlException buae) {
            Assert.fail((String)"Bookkeeper should have started since current user is in permittedStartupUsers");
        }
        finally {
            if (bs1 != null && bs1.isRunning()) {
                bs1.shutdown();
            }
        }
        userString = "larry ,curly, moe," + System.getProperty("user.name") + ",";
        conf.setPermittedStartupUsers(userString);
        try {
            bs1 = new BookieServer(conf);
            bs1.start();
        }
        catch (AccessControlException buae) {
            Assert.fail((String)"Bookkeeper should have started since current user is in permittedStartupUsers");
        }
        finally {
            if (bs1 != null && bs1.isRunning()) {
                bs1.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserPermittedToStartWithMissingProperty() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        LOG.info("{}", (Object)conf);
        int port = PortManager.nextFreePort();
        ((ServerConfiguration)conf.setMetadataServiceUri(null)).setBookiePort(port).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()});
        BookieServer bs1 = null;
        try {
            bs1 = new BookieServer(conf);
            bs1.start();
        }
        catch (AccessControlException buae) {
            Assert.fail((String)"Bookkeeper should have started since permittedStartupUser is not specified");
        }
        finally {
            if (bs1 != null && bs1.isRunning()) {
                bs1.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateBookieServerStartup() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        int port = PortManager.nextFreePort();
        conf.setBookiePort(port).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setMetadataServiceUri(this.metadataServiceUri);
        BookieServer bs1 = new BookieServer(conf);
        bs1.start();
        BookieServer bs2 = null;
        try {
            bs2 = new BookieServer(conf);
            bs2.start();
            Assert.fail((String)"Should throw BindException, as the bk server is already running!");
        }
        catch (BindException bindException) {
        }
        catch (IOException e) {
            Assert.assertTrue((String)"BKServer allowed duplicate Startups!", (boolean)e.getMessage().contains("bind"));
        }
        finally {
            bs1.shutdown();
            if (bs2 != null) {
                bs2.shutdown();
            }
        }
    }

    @Test
    public void testBookieServiceExceptionHandler() throws Exception {
        File tmpDir = this.createTempDir("bookie", "exception-handler");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        int port = PortManager.nextFreePort();
        conf.setBookiePort(port).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setMetadataServiceUri(this.metadataServiceUri);
        BookieConfiguration bkConf = new BookieConfiguration(conf);
        BookieService service = new BookieService(bkConf, (StatsLogger)NullStatsLogger.INSTANCE, BookieServiceInfo.NO_INFO);
        CompletableFuture startFuture = ComponentStarter.startComponent((LifecycleComponent)service);
        service.getServer().getBookie().shutdown();
        startFuture.get();
    }

    @Test
    public void testBookieStartException() throws Exception {
        File journalDir = this.createTempDir("bookie", "journal");
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)journalDir));
        File ledgerDir = this.createTempDir("bookie", "ledger");
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)ledgerDir));
        int numOfEntries = 100;
        BookieJournalTest.writeV5Journal(Bookie.getCurrentDirectory((File)journalDir), numOfEntries, "testV5Journal".getBytes());
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        int port = PortManager.nextFreePort();
        ((ServerConfiguration)conf.setBookiePort(port).setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setMetadataServiceUri(this.metadataServiceUri)).setLedgerStorageClass(MockInterleavedLedgerStorage.class.getName());
        BookieConfiguration bkConf = new BookieConfiguration(conf);
        this.driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
        Cookie.Builder cookieBuilder = Cookie.generateCookie((ServerConfiguration)conf);
        Cookie cookie = cookieBuilder.build();
        cookie.writeToDirectory(new File(journalDir, "current"));
        cookie.writeToDirectory(new File(ledgerDir, "current"));
        Versioned newCookie = new Versioned((Object)cookie.toString().getBytes(StandardCharsets.UTF_8), Version.NEW);
        this.driver.getRegistrationManager().writeCookie(Bookie.getBookieAddress((ServerConfiguration)conf).toString(), newCookie);
        LifecycleComponentStack server = Main.buildBookieServer((BookieConfiguration)bkConf);
        CompletableFuture startFuture = ComponentStarter.startComponent((LifecycleComponent)server);
        startFuture.get();
        this.loggerOutput.expect(logEvents -> Assert.assertThat((Object)logEvents, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.containsString((String)"Triggered exceptionHandler of Component:")))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegativeLengthEntryBookieShutdown() throws Exception {
        File journalDir = this.createTempDir("bookie", "journal");
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)journalDir));
        File ledgerDir = this.createTempDir("bookie", "ledger");
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)ledgerDir));
        BookieJournalTest.writeV5Journal(Bookie.getCurrentDirectory((File)journalDir), 5, "testV5Journal".getBytes(), true);
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setMetadataServiceUri(null);
        Bookie b = null;
        try {
            b = new Bookie(conf);
            b.start();
            Assert.assertFalse((String)"Bookie should shutdown normally after catching IOException due to corrupt entry with negative length", (boolean)b.isRunning());
        }
        finally {
            if (b != null) {
                b.shutdown();
            }
        }
    }

    @Test
    public void testAutoRecoveryServiceExceptionHandler() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setMetadataServiceUri(this.metadataServiceUri);
        BookieConfiguration bkConf = new BookieConfiguration(conf);
        AutoRecoveryService service = new AutoRecoveryService(bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
        CompletableFuture startFuture = ComponentStarter.startComponent((LifecycleComponent)service);
        service.getAutoRecoveryServer().shutdown();
        startFuture.get();
    }

    @Test
    public void testBookieServerStartupOnEphemeralPorts() throws Exception {
        File tmpDir1 = this.createTempDir("bookie", "test1");
        File tmpDir2 = this.createTempDir("bookie", "test2");
        ServerConfiguration conf1 = TestBKConfiguration.newServerConfiguration();
        conf1.setBookiePort(0).setJournalDirName(tmpDir1.getPath()).setLedgerDirNames(new String[]{tmpDir1.getPath()}).setMetadataServiceUri(null);
        Assert.assertEquals((long)0L, (long)conf1.getBookiePort());
        BookieServer bs1 = new BookieServer(conf1);
        bs1.start();
        Assert.assertFalse((0 == conf1.getBookiePort() ? 1 : 0) != 0);
        ServerConfiguration conf2 = TestBKConfiguration.newServerConfiguration();
        conf2.setBookiePort(0).setJournalDirName(tmpDir2.getPath()).setLedgerDirNames(new String[]{tmpDir2.getPath()}).setMetadataServiceUri(null);
        BookieServer bs2 = new BookieServer(conf2);
        bs2.start();
        Assert.assertFalse((0 == conf2.getBookiePort() ? 1 : 0) != 0);
        Assert.assertFalse((conf1.getBookiePort() == conf2.getBookiePort() ? 1 : 0) != 0);
    }

    @Test
    public void testStartBookieWithoutZKServer() throws Exception {
        this.zkUtil.killCluster();
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration().setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()});
        ((ServerConfiguration)conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setZkTimeout(5000);
        try {
            new Bookie(conf);
            Assert.fail((String)"Should throw ConnectionLossException as ZKServer is not running!");
        }
        catch (BookieException.MetadataStoreException metadataStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testStartBookieWithoutZKInitialized() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        String zkRoot = "/ledgers2";
        ServerConfiguration conf = (ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri("/ledgers2"))).setZkTimeout(5000);
        try {
            new Bookie(conf);
            Assert.fail((String)"Should throw NoNodeException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerConfiguration adminConf = new ServerConfiguration();
        adminConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri("/ledgers2"));
        BookKeeperAdmin.format((ServerConfiguration)adminConf, (boolean)false, (boolean)false);
        Bookie b = new Bookie(conf);
        b.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithDiskFullReadOnlyDisabledOrForceGCAllowDisabled() throws Exception {
        File tmpDir = this.createTempDir("DiskCheck", "test");
        long usableSpace = tmpDir.getUsableSpace();
        long totalSpace = tmpDir.getTotalSpace();
        ServerConfiguration conf = (ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setLedgerStorageClass(InterleavedLedgerStorage.class.getName()).setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setDiskCheckInterval(1000).setDiskUsageThreshold((1.0f - (float)usableSpace / (float)totalSpace) * 0.999f).setDiskUsageWarnThreshold(0.0f).setMetadataServiceUri(this.metadataServiceUri)).setZkTimeout(5000);
        conf.setMinUsableSizeForEntryLogCreation(Long.MAX_VALUE).setReadOnlyModeEnabled(false);
        try {
            new Bookie(conf);
            Assert.fail((String)"NoWritableLedgerDirException expected");
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException noWritableLedgerDirException) {
            // empty catch block
        }
        conf.setMinUsableSizeForEntryLogCreation(Long.MIN_VALUE).setReadOnlyModeEnabled(false);
        try {
            new Bookie(conf);
            Assert.fail((String)"NoWritableLedgerDirException expected");
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException noWritableLedgerDirException) {
            // empty catch block
        }
        conf.setMinUsableSizeForEntryLogCreation(Long.MAX_VALUE).setReadOnlyModeEnabled(true);
        Bookie bookie = null;
        try {
            bookie = new Bookie(conf);
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            Assert.fail((String)"NoWritableLedgerDirException unexpected");
        }
        finally {
            if (null != bookie) {
                bookie.shutdown();
            }
        }
    }

    @Test
    public void testWithDiskFullReadOnlyEnabledAndForceGCAllowAllowed() throws Exception {
        File tmpDir = this.createTempDir("DiskCheck", "test");
        long usableSpace = tmpDir.getUsableSpace();
        long totalSpace = tmpDir.getTotalSpace();
        ServerConfiguration conf = (ServerConfiguration)((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setDiskCheckInterval(1000).setDiskUsageThreshold((1.0f - (float)usableSpace / (float)totalSpace) * 0.999f).setDiskUsageWarnThreshold(0.0f).setMetadataServiceUri(this.metadataServiceUri)).setZkTimeout(5000);
        conf.setReadOnlyModeEnabled(true).setIsForceGCAllowWhenNoSpace(true);
        Bookie bk = new Bookie(conf);
        bk.start();
        Thread.sleep(conf.getDiskCheckInterval() * 2 + 100);
        Assert.assertTrue((boolean)bk.isReadOnly());
        bk.shutdown();
    }

    @Test
    public void testWithDiskFullAndAbilityToCreateNewIndexFile() throws Exception {
        File tmpDir = this.createTempDir("DiskCheck", "test");
        ServerConfiguration conf = (ServerConfiguration)this.newServerConfiguration().setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setDiskCheckInterval(1000).setLedgerStorageClass(SortedLedgerStorage.class.getName()).setAutoRecoveryDaemonEnabled(false).setZkTimeout(5000);
        MockBookieServer server = new MockBookieServer(conf);
        server.start();
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setMetadataServiceUri(this.metadataServiceUri);
        BookKeeper bkClient = new BookKeeper(clientConf);
        LedgerHandle lh = bkClient.createLedger(1, 1, 1, BookKeeper.DigestType.CRC32, "passwd".getBytes());
        long entryId = -1L;
        long numOfEntries = 5L;
        int i = 0;
        while ((long)i < numOfEntries) {
            entryId = lh.addEntry("data".getBytes());
            ++i;
        }
        Assert.assertTrue((String)"EntryId of the recently added entry should be 0", (entryId == numOfEntries - 1L ? 1 : 0) != 0);
        server.shutdown();
        conf.setDiskUsageThreshold(0.001f).setDiskUsageWarnThreshold(0.0f).setReadOnlyModeEnabled(true).setIsForceGCAllowWhenNoSpace(true).setMinUsableSizeForIndexFileCreation(Long.MAX_VALUE);
        server = new BookieServer(conf);
        server.start();
        Assert.assertFalse((String)"Bookie should be Shutdown", (boolean)server.getBookie().isRunning());
        server.shutdown();
        conf.setMinUsableSizeForIndexFileCreation(5120L);
        server = new BookieServer(conf);
        server.start();
        Thread.sleep(conf.getDiskCheckInterval() * 2 + 100);
        Assert.assertTrue((String)"Bookie should be up and running", (boolean)server.getBookie().isRunning());
        Assert.assertTrue((boolean)server.getBookie().isReadOnly());
        server.shutdown();
        bkClient.close();
    }

    @Test
    public void testWithDiskError() throws Exception {
        File parent = this.createTempDir("DiskCheck", "test");
        File child = File.createTempFile("DiskCheck", "test", parent);
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration().setJournalDirName(child.getPath()).setLedgerDirNames(new String[]{child.getPath()});
        ((ServerConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setZkTimeout(5000);
        try {
            LedgerDirsManager ldm = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
            LedgerDirsMonitor ledgerMonitor = new LedgerDirsMonitor(conf, new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()), Collections.singletonList(ldm));
            ledgerMonitor.init();
            Assert.fail((String)"should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDiskPartitionDuplicationDisabled() throws Exception {
        File tmpDir1 = this.createTempDir("bookie", "test");
        File tmpDir2 = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        int port = PortManager.nextFreePort();
        ((ServerConfiguration)((ServerConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setZkTimeout(5000)).setBookiePort(port).setJournalDirName(tmpDir1.getPath()).setLedgerDirNames(new String[]{tmpDir1.getPath(), tmpDir2.getPath()}).setIndexDirName(new String[]{tmpDir1.getPath()}).setAllowMultipleDirsUnderSameDiskPartition(false);
        BookieServer bs1 = null;
        try {
            bs1 = new BookieServer(conf);
            Assert.fail((String)"Bookkeeper should not have started since AllowMultipleDirsUnderSameDiskPartition is not enabled");
        }
        catch (BookieException.DiskPartitionDuplicationException diskPartitionDuplicationException) {
        }
        finally {
            if (bs1 != null) {
                bs1.shutdown();
            }
        }
        tmpDir1 = this.createTempDir("bookie", "test");
        tmpDir2 = this.createTempDir("bookie", "test");
        port = PortManager.nextFreePort();
        ((ServerConfiguration)((ServerConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setZkTimeout(5000)).setBookiePort(port).setJournalDirName(tmpDir1.getPath()).setLedgerDirNames(new String[]{tmpDir1.getPath()}).setIndexDirName(new String[]{tmpDir1.getPath(), tmpDir2.getPath()}).setAllowMultipleDirsUnderSameDiskPartition(false);
        bs1 = null;
        try {
            bs1 = new BookieServer(conf);
            Assert.fail((String)"Bookkeeper should not have started since AllowMultipleDirsUnderSameDiskPartition is not enabled");
        }
        catch (BookieException.DiskPartitionDuplicationException diskPartitionDuplicationException) {
        }
        finally {
            if (bs1 != null) {
                bs1.shutdown();
            }
        }
        tmpDir1 = this.createTempDir("bookie", "test");
        tmpDir2 = this.createTempDir("bookie", "test");
        port = PortManager.nextFreePort();
        ((ServerConfiguration)((ServerConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setZkTimeout(5000)).setBookiePort(port).setJournalDirsName(new String[]{tmpDir1.getPath(), tmpDir2.getPath()}).setLedgerDirNames(new String[]{tmpDir1.getPath()}).setIndexDirName(new String[]{tmpDir1.getPath()}).setAllowMultipleDirsUnderSameDiskPartition(false);
        bs1 = null;
        try {
            bs1 = new BookieServer(conf);
            Assert.fail((String)"Bookkeeper should not have started since AllowMultipleDirsUnderSameDiskPartition is not enabled");
        }
        catch (BookieException.DiskPartitionDuplicationException diskPartitionDuplicationException) {
        }
        finally {
            if (bs1 != null) {
                bs1.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDiskPartitionDuplicationAllowed() throws Exception {
        File tmpDir1 = this.createTempDir("bookie", "test");
        File tmpDir2 = this.createTempDir("bookie", "test");
        File tmpDir3 = this.createTempDir("bookie", "test");
        File tmpDir4 = this.createTempDir("bookie", "test");
        File tmpDir5 = this.createTempDir("bookie", "test");
        File tmpDir6 = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        int port = 12555;
        ((ServerConfiguration)((ServerConfiguration)conf.setMetadataServiceUri(this.metadataServiceUri)).setZkTimeout(5000)).setBookiePort(port).setJournalDirsName(new String[]{tmpDir1.getPath(), tmpDir2.getPath()}).setLedgerDirNames(new String[]{tmpDir3.getPath(), tmpDir4.getPath()}).setIndexDirName(new String[]{tmpDir5.getPath(), tmpDir6.getPath()});
        conf.setAllowMultipleDirsUnderSameDiskPartition(true);
        BookieServer bs1 = null;
        try {
            bs1 = new BookieServer(conf);
        }
        catch (BookieException.DiskPartitionDuplicationException dpde) {
            Assert.fail((String)"Bookkeeper should have started since AllowMultipleDirsUnderSameDiskPartition is enabled");
        }
        finally {
            if (bs1 != null) {
                bs1.shutdown();
            }
        }
    }

    private ZooKeeperClient createNewZKClient() throws Exception {
        LOG.debug("Instantiate ZK Client");
        return ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).build();
    }

    @Test(timeout=10000L)
    public void testPersistBookieStatus() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setReadOnlyModeEnabled(true).setPersistBookieStatusEnabled(true).setMetadataServiceUri(this.metadataServiceUri);
        BookieServer bookieServer = new BookieServer(conf);
        bookieServer.start();
        Bookie bookie = bookieServer.getBookie();
        Assert.assertFalse((boolean)bookie.isReadOnly());
        bookie.getStateManager().doTransitionToReadOnlyMode();
        Assert.assertTrue((boolean)bookie.isReadOnly());
        bookieServer.shutdown();
        bookieServer = new BookieServer(conf);
        bookieServer.start();
        bookie = bookieServer.getBookie();
        Assert.assertTrue((boolean)bookie.isReadOnly());
        bookie.getStateManager().doTransitionToWritableMode();
        bookieServer.shutdown();
        bookieServer = new BookieServer(conf);
        bookieServer.start();
        bookie = bookieServer.getBookie();
        Assert.assertFalse((boolean)bookie.isReadOnly());
        bookieServer.shutdown();
    }

    @Test(timeout=10000L)
    public void testReadOnlyBookieShouldIgnoreBookieStatus() throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setReadOnlyModeEnabled(true).setPersistBookieStatusEnabled(true).setMetadataServiceUri(this.metadataServiceUri);
        BookieServer bookieServer = new BookieServer(conf);
        bookieServer.start();
        Bookie bookie = bookieServer.getBookie();
        bookie.getStateManager().doTransitionToReadOnlyMode();
        bookie.getStateManager().doTransitionToWritableMode();
        Assert.assertFalse((boolean)bookie.isReadOnly());
        bookieServer.shutdown();
        ServerConfiguration readOnlyConf = TestBKConfiguration.newServerConfiguration();
        readOnlyConf.loadConf((CompositeConfiguration)conf);
        readOnlyConf.setForceReadOnlyBookie(true);
        bookieServer = new BookieServer(readOnlyConf);
        bookieServer.start();
        bookie = bookieServer.getBookie();
        Assert.assertTrue((boolean)bookie.isReadOnly());
        bookie.getStateManager().doTransitionToWritableMode();
        Assert.assertTrue((boolean)bookie.isReadOnly());
        bookieServer.shutdown();
    }

    @Test(timeout=10000L)
    public void testRetrieveBookieStatusWhenStatusFileIsCorrupted() throws Exception {
        File[] tmpLedgerDirs = new File[3];
        String[] filePath = new String[tmpLedgerDirs.length];
        for (int i = 0; i < tmpLedgerDirs.length; ++i) {
            tmpLedgerDirs[i] = this.createTempDir("bookie", "test" + i);
            filePath[i] = tmpLedgerDirs[i].getPath();
        }
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(filePath[0]).setLedgerDirNames(filePath).setReadOnlyModeEnabled(true).setPersistBookieStatusEnabled(true).setMetadataServiceUri(this.metadataServiceUri);
        BookieServer bookieServer = new BookieServer(conf);
        bookieServer.start();
        Bookie bookie = bookieServer.getBookie();
        Assert.assertFalse((boolean)bookie.isReadOnly());
        bookie.getStateManager().doTransitionToReadOnlyMode();
        Assert.assertTrue((boolean)bookie.isReadOnly());
        List ledgerDirs = bookie.getLedgerDirsManager().getAllLedgerDirs();
        this.corruptFile(new File((File)ledgerDirs.get(0), "BOOKIE_STATUS"));
        this.corruptFile(new File((File)ledgerDirs.get(1), "BOOKIE_STATUS"));
        bookieServer.shutdown();
        bookieServer = new BookieServer(conf);
        bookieServer.start();
        bookie = bookieServer.getBookie();
        Assert.assertTrue((boolean)bookie.isReadOnly());
        bookieServer.shutdown();
    }

    @Test(timeout=10000L)
    public void testReadLatestBookieStatus() throws Exception {
        File[] tmpLedgerDirs = new File[3];
        String[] filePath = new String[tmpLedgerDirs.length];
        for (int i = 0; i < tmpLedgerDirs.length; ++i) {
            tmpLedgerDirs[i] = this.createTempDir("bookie", "test" + i);
            filePath[i] = tmpLedgerDirs[i].getPath();
        }
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(filePath[0]).setLedgerDirNames(filePath).setReadOnlyModeEnabled(true).setPersistBookieStatusEnabled(true).setMetadataServiceUri(this.metadataServiceUri);
        BookieServer bookieServer = new BookieServer(conf);
        bookieServer.start();
        Bookie bookie = bookieServer.getBookie();
        Assert.assertFalse((boolean)bookie.isReadOnly());
        bookie.getStateManager().doTransitionToReadOnlyMode();
        Assert.assertTrue((boolean)bookie.isReadOnly());
        Thread.sleep(1L);
        BookieStatus status = new BookieStatus();
        ArrayList dirs = new ArrayList();
        dirs.add(bookie.getLedgerDirsManager().getAllLedgerDirs().get(0));
        status.writeToDirectories(dirs);
        bookieServer.shutdown();
        bookieServer = new BookieServer(conf);
        bookieServer.start();
        bookie = bookieServer.getBookie();
        Assert.assertFalse((boolean)bookie.isReadOnly());
        bookieServer.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void corruptFile(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
            byte[] bytes = new byte[64];
            new Random().nextBytes(bytes);
            bw.write(new String(bytes));
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            fos.close();
        }
    }

    @Test
    public void testIOVertexHTTPServerEndpointForBookieWithPrometheusProvider() throws Exception {
        String inputLine;
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = ((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setBookiePort(PortManager.nextFreePort()).setMetadataServiceUri(this.metadataServiceUri)).setListeningInterface(null);
        int nextFreePort = PortManager.nextFreePort();
        conf.setStatsProviderClass(PrometheusMetricsProvider.class);
        conf.setHttpServerEnabled(true);
        conf.setProperty("httpServerClass", (Object)"org.apache.bookkeeper.http.vertx.VertxHttpServer");
        conf.setHttpServerPort(nextFreePort);
        LifecycleComponentStack server = Main.buildBookieServer((BookieConfiguration)new BookieConfiguration(conf));
        CompletableFuture stackComponentFuture = ComponentStarter.startComponent((LifecycleComponent)server);
        while (server.lifecycleState() != Lifecycle.State.STARTED) {
            Thread.sleep(100L);
        }
        URL url = new URL("http://localhost:" + nextFreePort + "/metrics");
        URLConnection urlc = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        StringBuilder metricsStringBuilder = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            metricsStringBuilder.append(inputLine);
        }
        in.close();
        String metrics = metricsStringBuilder.toString();
        Assert.assertTrue((String)"Metrics should contain basic counters", (boolean)metrics.contains("BOOKIE_ADD_ENTRY"));
        url = new URL("http://localhost:" + nextFreePort + "/api/v1/config/server_config");
        Map configMap = (Map)om.readValue(url, Map.class);
        if (configMap.isEmpty() || !configMap.containsKey("bookiePort")) {
            Assert.fail((String)"Failed to map configurations to valid JSON entries.");
        }
        stackComponentFuture.cancel(true);
    }

    @Test
    public void testIOVertexHTTPServerEndpointForARWithPrometheusProvider() throws Exception {
        String inputLine;
        ServerConfiguration conf = ((ServerConfiguration)TestBKConfiguration.newServerConfiguration().setMetadataServiceUri(this.metadataServiceUri)).setListeningInterface(null);
        int nextFreePort = PortManager.nextFreePort();
        conf.setStatsProviderClass(PrometheusMetricsProvider.class);
        conf.setHttpServerEnabled(true);
        conf.setProperty("httpServerClass", (Object)"org.apache.bookkeeper.http.vertx.VertxHttpServer");
        conf.setHttpServerPort(nextFreePort);
        LifecycleComponentStack server = AutoRecoveryMain.buildAutoRecoveryServer((BookieConfiguration)new BookieConfiguration(conf));
        CompletableFuture stackComponentFuture = ComponentStarter.startComponent((LifecycleComponent)server);
        while (server.lifecycleState() != Lifecycle.State.STARTED) {
            Thread.sleep(100L);
        }
        URL url = new URL("http://localhost:" + nextFreePort + "/metrics");
        URLConnection urlc = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        StringBuilder metricsStringBuilder = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            metricsStringBuilder.append(inputLine);
        }
        in.close();
        String metrics = metricsStringBuilder.toString();
        Assert.assertTrue((String)"Metrics should contain basic counters", (boolean)metrics.contains("NUM_FULL_OR_PARTIAL_LEDGERS_REPLICATED"));
        Assert.assertTrue((String)"Metrics should contain basic counters from BookKeeper client", (boolean)metrics.contains("LEDGER_CREATE"));
        url = new URL("http://localhost:" + nextFreePort + "/api/v1/config/server_config");
        Map configMap = (Map)om.readValue(url, Map.class);
        if (configMap.isEmpty() || !configMap.containsKey("metadataServiceUri")) {
            Assert.fail((String)"Failed to map configurations to valid JSON entries.");
        }
        stackComponentFuture.cancel(true);
    }

    @Test
    public void testBookieConnectAfterCookieDelete() throws BookieException.UpgradeException {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        try {
            MetadataDrivers.runFunctionWithRegistrationManager((ServerConfiguration)conf, rm -> {
                try {
                    this.bookieConnectAfterCookieDeleteWorker(conf, (RegistrationManager)rm);
                }
                catch (IOException | InterruptedException | BookieException e) {
                    Assert.fail((String)("Test failed to run: " + e.getMessage()));
                }
                return null;
            });
        }
        catch (ExecutionException | MetadataException e) {
            throw new BookieException.UpgradeException(e);
        }
    }

    private void bookieConnectAfterCookieDeleteWorker(ServerConfiguration conf, RegistrationManager rm) throws BookieException, InterruptedException, IOException {
        File tmpLedgerDir = this.createTempDir("BootupTest", "test");
        File tmpJournalDir = this.createTempDir("BootupTest", "test");
        Integer numOfJournalDirs = 2;
        String[] journalDirs = new String[numOfJournalDirs.intValue()];
        for (int i = 0; i < numOfJournalDirs; ++i) {
            journalDirs[i] = tmpJournalDir.getAbsolutePath() + "/journal-" + i;
        }
        conf.setJournalDirsName(journalDirs);
        conf.setLedgerDirNames(new String[]{tmpLedgerDir.getPath()});
        Bookie b = new Bookie(conf);
        BookieSocketAddress bookieAddress = Bookie.getBookieAddress((ServerConfiguration)conf);
        Versioned rmCookie = Cookie.readFromRegistrationManager((RegistrationManager)rm, (BookieSocketAddress)bookieAddress);
        b.shutdown();
        ((Cookie)rmCookie.getValue()).deleteFromRegistrationManager(rm, conf, rmCookie.getVersion());
        try {
            b = new Bookie(conf);
            Assert.fail((String)"Bookie should not have come up. Cookie no present in metadata store.");
        }
        catch (Exception e) {
            LOG.info("As expected Bookie fails to come up without a cookie in metadata store.");
        }
    }

    class MockBookieWithNoopShutdown
    extends Bookie {
        public MockBookieWithNoopShutdown(ServerConfiguration conf, StatsLogger statsLogger) throws IOException, KeeperException, InterruptedException, BookieException {
            super(conf, statsLogger, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, BookieServiceInfo.NO_INFO);
        }

        synchronized int shutdown(int exitCode) {
            return exitCode;
        }
    }

    class MockBookieServer
    extends BookieServer {
        ServerConfiguration conf;

        public MockBookieServer(ServerConfiguration conf) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException, SecurityException {
            super(conf);
            this.conf = conf;
        }

        protected Bookie newBookie(ServerConfiguration conf, ByteBufAllocator allocator, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException, KeeperException, InterruptedException, BookieException {
            return new MockBookieWithNoopShutdown(conf, (StatsLogger)NullStatsLogger.INSTANCE);
        }
    }

    public static class MockInterleavedLedgerStorage
    extends InterleavedLedgerStorage {
        AtomicInteger atmoicInt = new AtomicInteger(0);

        public long addEntry(ByteBuf entry) throws IOException {
            if (this.atmoicInt.incrementAndGet() == 10) {
                throw new OutOfMemoryError("Some Injected Exception");
            }
            return super.addEntry(entry);
        }
    }
}

