/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.net.InetAddresses;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.bookkeeper.common.component.Lifecycle;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.bookkeeper.util.PortManager;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperAdminTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperAdminTest.class);
    private BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static final String PASSWORD = "testPasswd";
    private static final int numOfBookies = 2;
    private final int lostBookieRecoveryDelayInitValue = 1800;

    public BookKeeperAdminTest() {
        super(2, 480);
        this.baseConf.setLostBookieRecoveryDelay(1800);
        this.baseConf.setOpenLedgerRereplicationGracePeriod(String.valueOf(30000));
        this.setAutoRecoveryEnabled(true);
    }

    @Test
    public void testLostBookieRecoveryDelayValue() throws Exception {
        try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());){
            Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)1800L, (long)bkAdmin.getLostBookieRecoveryDelay());
            int newLostBookieRecoveryDelayValue = 2400;
            bkAdmin.setLostBookieRecoveryDelay(newLostBookieRecoveryDelayValue);
            Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)newLostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
            newLostBookieRecoveryDelayValue = 3000;
            bkAdmin.setLostBookieRecoveryDelay(newLostBookieRecoveryDelayValue);
            Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)newLostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
            LOG.info("Test Done");
        }
    }

    @Test
    public void testTriggerAuditWithStoreSystemTimeAsLedgerUnderreplicatedMarkTime() throws Exception {
        this.testTriggerAudit(true);
    }

    @Test
    public void testTriggerAuditWithoutStoreSystemTimeAsLedgerUnderreplicatedMarkTime() throws Exception {
        this.testTriggerAudit(false);
    }

    public void testTriggerAudit(boolean storeSystemTimeAsLedgerUnderreplicatedMarkTime) throws Exception {
        ServerConfiguration thisServerConf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        thisServerConf.setStoreSystemTimeAsLedgerUnderreplicatedMarkTime(storeSystemTimeAsLedgerUnderreplicatedMarkTime);
        this.restartBookies(thisServerConf);
        ClientConfiguration thisClientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        thisClientConf.setStoreSystemTimeAsLedgerUnderreplicatedMarkTime(storeSystemTimeAsLedgerUnderreplicatedMarkTime);
        long testStartSystime = System.currentTimeMillis();
        ZkLedgerUnderreplicationManager urLedgerMgr = new ZkLedgerUnderreplicationManager((AbstractConfiguration)thisClientConf, this.zkc);
        BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        int lostBookieRecoveryDelayValue = bkAdmin.getLostBookieRecoveryDelay();
        urLedgerMgr.disableLedgerReplication();
        try {
            bkAdmin.triggerAudit();
            Assert.fail((String)"Trigger Audit should have failed because LedgerReplication is disabled");
        }
        catch (ReplicationException.UnavailableException unavailableException) {
            // empty catch block
        }
        Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)lostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
        urLedgerMgr.enableLedgerReplication();
        bkAdmin.triggerAudit();
        Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)lostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
        long ledgerId = 1L;
        LedgerHandle ledgerHandle = this.bkc.createLedgerAdv(ledgerId, this.numBookies, this.numBookies, this.numBookies, this.digestType, PASSWORD.getBytes(), null);
        ledgerHandle.addEntry(0L, "data".getBytes());
        ledgerHandle.close();
        BookieServer bookieToKill = (BookieServer)this.bs.get(1);
        this.killBookie(1);
        bkAdmin.triggerAudit();
        Thread.sleep(500L);
        Iterator underreplicatedLedgerItr = urLedgerMgr.listLedgersToRereplicate(null);
        Assert.assertTrue((String)"There are supposed to be underreplicatedledgers", (boolean)underreplicatedLedgerItr.hasNext());
        UnderreplicatedLedger underreplicatedLedger = (UnderreplicatedLedger)underreplicatedLedgerItr.next();
        Assert.assertEquals((String)"Underreplicated ledgerId", (long)ledgerId, (long)underreplicatedLedger.getLedgerId());
        Assert.assertTrue((String)("Missingreplica of Underreplicated ledgerId should contain " + bookieToKill.getLocalAddress()), (boolean)underreplicatedLedger.getReplicaList().contains(bookieToKill.getLocalAddress().toString()));
        if (storeSystemTimeAsLedgerUnderreplicatedMarkTime) {
            long ctimeOfURL = underreplicatedLedger.getCtime();
            Assert.assertTrue((String)"ctime of underreplicated ledger should be greater than test starttime", (ctimeOfURL > testStartSystime && ctimeOfURL < System.currentTimeMillis() ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)"ctime of underreplicated ledger should not be set", (long)-1L, (long)underreplicatedLedger.getCtime());
        }
        bkAdmin.close();
    }

    @Test
    public void testBookieInit() throws Exception {
        File[] ledgerDirs;
        File[] journalDirs;
        int bookieindex = 0;
        ServerConfiguration confOfExistingBookie = (ServerConfiguration)this.bsConfs.get(bookieindex);
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since bookie is still running with that configuration", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        this.killBookie(bookieindex);
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since previous bookie is not formatted yet", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        for (File journalDir : journalDirs = confOfExistingBookie.getJournalDirs()) {
            FileUtils.deleteDirectory((File)journalDir);
        }
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since previous bookie is not formatted yet completely", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        for (File ledgerDir : ledgerDirs = confOfExistingBookie.getLedgerDirs()) {
            FileUtils.deleteDirectory((File)ledgerDir);
        }
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since previous bookie is not formatted yet completely", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        File[] indexDirs = confOfExistingBookie.getIndexDirs();
        if (indexDirs != null) {
            for (File indexDir : indexDirs) {
                FileUtils.deleteDirectory((File)indexDir);
            }
        }
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since cookie in ZK is not deleted yet", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        String bookieId = Bookie.getBookieAddress((ServerConfiguration)confOfExistingBookie).toString();
        String bookieCookiePath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)confOfExistingBookie) + "/" + "cookies" + "/" + bookieId;
        this.zkc.delete(bookieCookiePath, -1);
        Assert.assertTrue((String)"initBookie shouldn't succeeded", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
    }

    @Test
    public void testInitNewCluster() throws Exception {
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        String ledgersRootPath = "/testledgers";
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        Assert.assertTrue((String)"New cluster should be initialized successfully", (boolean)BookKeeperAdmin.initNewCluster((ServerConfiguration)newConfig));
        Assert.assertTrue((String)("Cluster rootpath should have been created successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) != null ? 1 : 0) != 0);
        String availableBookiesPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available";
        Assert.assertTrue((String)("AvailableBookiesPath should have been created successfully " + availableBookiesPath), (this.zkc.exists(availableBookiesPath, false) != null ? 1 : 0) != 0);
        String readonlyBookiesPath = availableBookiesPath + "/" + "readonly";
        Assert.assertTrue((String)("ReadonlyBookiesPath should have been created successfully " + readonlyBookiesPath), (this.zkc.exists(readonlyBookiesPath, false) != null ? 1 : 0) != 0);
        String instanceIdPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID";
        Assert.assertTrue((String)("InstanceId node should have been created successfully" + instanceIdPath), (this.zkc.exists(instanceIdPath, false) != null ? 1 : 0) != 0);
        String ledgersLayout = ledgersRootPath + "/" + "LAYOUT";
        Assert.assertTrue((String)("Layout node should have been created successfully" + ledgersLayout), (this.zkc.exists(ledgersLayout, false) != null ? 1 : 0) != 0);
        int numOfBookies = 3;
        Random rand = new Random();
        for (int i = 0; i < numOfBookies; ++i) {
            String ipString = InetAddresses.fromInteger((int)rand.nextInt()).getHostAddress();
            String regPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available" + "/" + ipString + ":3181";
            this.zkc.create(regPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        BookKeeper bk = new BookKeeper(new ClientConfiguration((AbstractConfiguration)newConfig));
        LedgerHandle lh = bk.createLedger(numOfBookies, numOfBookies, numOfBookies, BookKeeper.DigestType.MAC, new byte[0]);
        bk.deleteLedger(lh.ledgerId);
        bk.close();
    }

    @Test
    public void testNukeExistingClusterWithForceOption() throws Exception {
        String ledgersRootPath = "/testledgers";
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        ArrayList<String> bookiesRegPaths = new ArrayList<String>();
        this.initiateNewClusterAndCreateLedgers(newConfig, bookiesRegPaths);
        for (int i = 0; i < bookiesRegPaths.size(); ++i) {
            this.zkc.delete((String)bookiesRegPaths.get(i), -1);
        }
        Assert.assertTrue((String)"New cluster should be nuked successfully", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, null, (boolean)true));
        Assert.assertTrue((String)("Cluster rootpath should have been deleted successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) == null ? 1 : 0) != 0);
    }

    @Test
    public void testNukeExistingClusterWithInstanceId() throws Exception {
        String ledgersRootPath = "/testledgers";
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        ArrayList<String> bookiesRegPaths = new ArrayList<String>();
        this.initiateNewClusterAndCreateLedgers(newConfig, bookiesRegPaths);
        for (int i = 0; i < bookiesRegPaths.size(); ++i) {
            this.zkc.delete((String)bookiesRegPaths.get(i), -1);
        }
        byte[] data = this.zkc.getData(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID", false, null);
        String readInstanceId = new String(data, StandardCharsets.UTF_8);
        Assert.assertTrue((String)"New cluster should be nuked successfully", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        Assert.assertTrue((String)("Cluster rootpath should have been deleted successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) == null ? 1 : 0) != 0);
    }

    @Test
    public void tryNukingExistingClustersWithInvalidParams() throws Exception {
        String ledgersRootPath = "/testledgers";
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        ArrayList<String> bookiesRegPaths = new ArrayList<String>();
        this.initiateNewClusterAndCreateLedgers(newConfig, bookiesRegPaths);
        BookKeeper bk = new BookKeeper(new ClientConfiguration((AbstractConfiguration)newConfig));
        long ledgerId = 23456789L;
        LedgerHandle lh = bk.createLedgerAdv(ledgerId, 1, 1, 1, BookKeeper.DigestType.MAC, new byte[0], null);
        lh.close();
        byte[] data = this.zkc.getData(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID", false, null);
        String readInstanceId = new String(data, StandardCharsets.UTF_8);
        String ipString = InetAddresses.fromInteger((int)new Random().nextInt()).getHostAddress();
        String roBookieRegPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available" + "/" + "readonly" + "/" + ipString + ":3181";
        this.zkc.create(roBookieRegPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertFalse((String)"Cluster should'nt be nuked since instanceid is not provided and force option is not set", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, null, (boolean)false));
        Assert.assertFalse((String)"Cluster should'nt be nuked since incorrect instanceid is provided", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)"incorrectinstanceid", (boolean)false));
        Assert.assertFalse((String)"Cluster should'nt be nuked since bookies are still registered", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        for (int i = 0; i < bookiesRegPaths.size(); ++i) {
            this.zkc.delete((String)bookiesRegPaths.get(i), -1);
        }
        Assert.assertFalse((String)"Cluster should'nt be nuked since ro bookie is still registered", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        Assert.assertTrue((String)("Cluster rootpath should be existing " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) != null ? 1 : 0) != 0);
        String availableBookiesPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available";
        Assert.assertTrue((String)("AvailableBookiesPath should be existing " + availableBookiesPath), (this.zkc.exists(availableBookiesPath, false) != null ? 1 : 0) != 0);
        String instanceIdPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID";
        Assert.assertTrue((String)("InstanceId node should be existing" + instanceIdPath), (this.zkc.exists(instanceIdPath, false) != null ? 1 : 0) != 0);
        String ledgersLayout = ledgersRootPath + "/" + "LAYOUT";
        Assert.assertTrue((String)("Layout node should be existing" + ledgersLayout), (this.zkc.exists(ledgersLayout, false) != null ? 1 : 0) != 0);
        lh = bk.openLedgerNoRecovery(ledgerId, BookKeeper.DigestType.MAC, new byte[0]);
        lh.close();
        bk.close();
        this.zkc.delete(roBookieRegPath, -1);
        Assert.assertTrue((String)"Cluster should be nuked since no bookie is registered", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        Assert.assertTrue((String)("Cluster rootpath should have been deleted successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) == null ? 1 : 0) != 0);
    }

    void initiateNewClusterAndCreateLedgers(ServerConfiguration newConfig, List<String> bookiesRegPaths) throws Exception {
        Assert.assertTrue((String)"New cluster should be initialized successfully", (boolean)BookKeeperAdmin.initNewCluster((ServerConfiguration)newConfig));
        int numberOfBookies = 3;
        Random rand = new Random();
        for (int i = 0; i < numberOfBookies; ++i) {
            String ipString = InetAddresses.fromInteger((int)rand.nextInt()).getHostAddress();
            bookiesRegPaths.add(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available" + "/" + ipString + ":3181");
            this.zkc.create(bookiesRegPaths.get(i), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        BookKeeper bk = new BookKeeper(new ClientConfiguration((AbstractConfiguration)newConfig));
        int numOfLedgers = 5;
        for (int i = 0; i < numOfLedgers; ++i) {
            LedgerHandle lh = bk.createLedger(numberOfBookies, numberOfBookies, numberOfBookies, BookKeeper.DigestType.MAC, new byte[0]);
            lh.close();
        }
        bk.close();
    }

    @Test
    public void testGetListOfEntriesOfClosedLedger() throws Exception {
        this.testGetListOfEntriesOfLedger(true);
    }

    @Test
    public void testGetListOfEntriesOfNotClosedLedger() throws Exception {
        this.testGetListOfEntriesOfLedger(false);
    }

    @Test
    public void testGetListOfEntriesOfNonExistingLedger() throws Exception {
        long nonExistingLedgerId = 56789L;
        try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());){
            for (int i = 0; i < this.bs.size(); ++i) {
                CompletableFuture futureResult = bkAdmin.asyncGetListOfEntriesOfLedger(((BookieServer)this.bs.get(i)).getLocalAddress(), nonExistingLedgerId);
                try {
                    futureResult.get();
                    Assert.fail((String)"asyncGetListOfEntriesOfLedger is supposed to be failed with NoSuchLedgerExistsException");
                    continue;
                }
                catch (ExecutionException ee) {
                    Assert.assertTrue((boolean)(ee.getCause() instanceof BKException));
                    BKException e = (BKException)ee.getCause();
                    Assert.assertEquals((long)e.getCode(), (long)-7L);
                }
            }
        }
    }

    public void testGetListOfEntriesOfLedger(boolean isLedgerClosed) throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int numOfEntries = 6;
        BookKeeper bkc = new BookKeeper(conf);
        LedgerHandle lh = bkc.createLedger(2, 2, this.digestType, PASSWORD.getBytes());
        long lId = lh.getId();
        for (int i = 0; i < numOfEntries; ++i) {
            lh.addEntry("000".getBytes());
        }
        if (isLedgerClosed) {
            lh.close();
        }
        try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());){
            for (int i = 0; i < this.bs.size(); ++i) {
                CompletableFuture futureResult = bkAdmin.asyncGetListOfEntriesOfLedger(((BookieServer)this.bs.get(i)).getLocalAddress(), lId);
                AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = (AvailabilityOfEntriesOfLedger)futureResult.get();
                Assert.assertEquals((String)"Number of entries", (long)numOfEntries, (long)availabilityOfEntriesOfLedger.getTotalNumOfAvailableEntries());
                for (int j = 0; j < numOfEntries; ++j) {
                    Assert.assertTrue((String)("Entry should be available: " + j), (boolean)availabilityOfEntriesOfLedger.isEntryAvailable((long)j));
                }
                Assert.assertFalse((String)("Entry should not be available: " + numOfEntries), (boolean)availabilityOfEntriesOfLedger.isEntryAvailable((long)numOfEntries));
            }
        }
        bkc.close();
    }

    @Test
    public void testGetListOfEntriesOfLedgerWithJustOneBookieInWriteQuorum() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int numOfEntries = 6;
        BookKeeper bkc = new BookKeeper(conf);
        LedgerHandle lh = bkc.createLedger(2, 1, this.digestType, PASSWORD.getBytes());
        long lId = lh.getId();
        for (int i = 0; i < numOfEntries; ++i) {
            lh.addEntry("000".getBytes());
        }
        try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());){
            for (int i = 0; i < this.bs.size(); ++i) {
                CompletableFuture futureResult = bkAdmin.asyncGetListOfEntriesOfLedger(((BookieServer)this.bs.get(i)).getLocalAddress(), lId);
                AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = (AvailabilityOfEntriesOfLedger)futureResult.get();
                Assert.assertEquals((String)"Number of entries", (long)(numOfEntries / 2), (long)availabilityOfEntriesOfLedger.getTotalNumOfAvailableEntries());
            }
        }
        bkc.close();
    }

    @Test
    public void testGetBookies() throws Exception {
        String ledgersRootPath = "/ledgers";
        Assert.assertTrue((String)("Cluster rootpath should have been created successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) != null ? 1 : 0) != 0);
        String bookieCookiePath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf) + "/" + "cookies";
        Assert.assertTrue((String)("AvailableBookiesPath should have been created successfully " + bookieCookiePath), (this.zkc.exists(bookieCookiePath, false) != null ? 1 : 0) != 0);
        try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());){
            Collection availableBookies = bkAdmin.getAvailableBookies();
            Assert.assertEquals((long)availableBookies.size(), (long)this.bs.size());
            for (int i = 0; i < this.bs.size(); ++i) {
                availableBookies.contains(((BookieServer)this.bs.get(i)).getLocalAddress());
            }
            BookieServer killedBookie = (BookieServer)this.bs.get(1);
            this.killBookieAndWaitForZK(1);
            Collection remainingBookies = bkAdmin.getAvailableBookies();
            Assert.assertFalse((boolean)remainingBookies.contains(killedBookie.getLocalAddress()));
            Collection allBookies = bkAdmin.getAllBookies();
            for (int i = 0; i < this.bs.size(); ++i) {
                remainingBookies.contains(((BookieServer)this.bs.get(i)).getLocalAddress());
                allBookies.contains(((BookieServer)this.bs.get(i)).getLocalAddress());
            }
            Assert.assertEquals((long)remainingBookies.size(), (long)(allBookies.size() - 1));
            Assert.assertTrue((boolean)allBookies.contains(killedBookie.getLocalAddress()));
        }
    }

    @Test
    public void testGetListOfEntriesOfLedgerWithEntriesNotStripedToABookie() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        LedgerHandle lh = bkc.createLedger(2, 1, this.digestType, PASSWORD.getBytes());
        long lId = lh.getId();
        lh.close();
        CountDownLatch callbackCalled = new CountDownLatch(1);
        AtomicBoolean exceptionInCallback = new AtomicBoolean(false);
        AtomicInteger exceptionCode = new AtomicInteger(0);
        BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        bkAdmin.asyncGetListOfEntriesOfLedger(((BookieServer)this.bs.get(0)).getLocalAddress(), lId).whenComplete((availabilityOfEntriesOfLedger, throwable) -> {
            exceptionInCallback.set(throwable != null);
            if (throwable != null) {
                exceptionCode.set(BKException.getExceptionCode((Throwable)throwable));
            }
            callbackCalled.countDown();
        });
        callbackCalled.await();
        Assert.assertTrue((String)"Exception occurred", (boolean)exceptionInCallback.get());
        Assert.assertEquals((String)"Exception code", (long)-7L, (long)exceptionCode.get());
        bkAdmin.close();
        bkc.close();
    }

    @Test
    public void testAreEntriesOfLedgerStoredInTheBookieForLastEmptySegment() throws Exception {
        int lastEntryId = 10;
        long ledgerId = 100L;
        BookieSocketAddress bookie0 = new BookieSocketAddress("bookie0:3181");
        BookieSocketAddress bookie1 = new BookieSocketAddress("bookie1:3181");
        BookieSocketAddress bookie2 = new BookieSocketAddress("bookie2:3181");
        BookieSocketAddress bookie3 = new BookieSocketAddress("bookie3:3181");
        ArrayList<BookieSocketAddress> ensembleOfSegment1 = new ArrayList<BookieSocketAddress>();
        ensembleOfSegment1.add(bookie0);
        ensembleOfSegment1.add(bookie1);
        ensembleOfSegment1.add(bookie2);
        ArrayList<BookieSocketAddress> ensembleOfSegment2 = new ArrayList<BookieSocketAddress>();
        ensembleOfSegment2.add(bookie3);
        ensembleOfSegment2.add(bookie1);
        ensembleOfSegment2.add(bookie2);
        LedgerMetadataBuilder builder = LedgerMetadataBuilder.create();
        builder.withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).withDigestType(this.digestType.toApiDigestType()).withPassword(PASSWORD.getBytes()).newEnsembleEntry(0L, ensembleOfSegment1).newEnsembleEntry((long)(lastEntryId + 1), ensembleOfSegment2).withLastEntryId((long)lastEntryId).withLength(65576L).withClosedState();
        LedgerMetadata meta = builder.build();
        Assert.assertFalse((String)"expected areEntriesOfLedgerStoredInTheBookie to return False for bookie3", (boolean)BookKeeperAdmin.areEntriesOfLedgerStoredInTheBookie((long)ledgerId, (BookieSocketAddress)bookie3, (LedgerMetadata)meta));
        Assert.assertTrue((String)"expected areEntriesOfLedgerStoredInTheBookie to return true for bookie2", (boolean)BookKeeperAdmin.areEntriesOfLedgerStoredInTheBookie((long)ledgerId, (BookieSocketAddress)bookie2, (LedgerMetadata)meta));
    }

    @Test
    public void testBookkeeperAdminFormatResetsLedgerIds() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int numOfLedgers = 2;
        try (BookKeeper bkc = new BookKeeper(conf);){
            Throwable throwable;
            Object lh;
            HashSet<Long> ledgerIds = new HashSet<Long>();
            for (int n = 0; n < numOfLedgers; ++n) {
                lh = bkc.createLedger(2, 2, this.digestType, "L".getBytes());
                throwable = null;
                try {
                    ledgerIds.add(lh.getId());
                    lh.addEntry("000".getBytes());
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lh != null) {
                        if (throwable != null) {
                            try {
                                lh.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            lh.close();
                        }
                    }
                }
            }
            BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
            lh = null;
            try {
                BookKeeperAdmin.format((ServerConfiguration)this.baseConf, (boolean)false, (boolean)true);
            }
            catch (Throwable throwable4) {
                lh = throwable4;
                throw throwable4;
            }
            finally {
                if (bkAdmin != null) {
                    if (lh != null) {
                        try {
                            bkAdmin.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)lh).addSuppressed(throwable5);
                        }
                    } else {
                        bkAdmin.close();
                    }
                }
            }
            for (int n = 0; n < numOfLedgers; ++n) {
                lh = bkc.createLedger(2, 2, this.digestType, "L".getBytes());
                throwable = null;
                try {
                    lh.addEntry("000".getBytes());
                    Assert.assertTrue((boolean)ledgerIds.contains(lh.getId()));
                    continue;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (lh != null) {
                        if (throwable != null) {
                            try {
                                lh.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            lh.close();
                        }
                    }
                }
            }
        }
    }

    private void testBookieServiceInfo(boolean readonly, boolean legacy) throws Exception {
        File tmpDir = this.createTempDir("bookie", "test");
        ServerConfiguration conf = (ServerConfiguration)TestBKConfiguration.newServerConfiguration().setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setBookiePort(PortManager.nextFreePort()).setMetadataServiceUri(this.metadataServiceUri);
        LifecycleComponentStack server = Main.buildBookieServer((BookieConfiguration)new BookieConfiguration(conf));
        CompletableFuture stackComponentFuture = ComponentStarter.startComponent((LifecycleComponent)server);
        while (server.lifecycleState() != Lifecycle.State.STARTED) {
            Thread.sleep(100L);
        }
        ServerConfiguration bkConf = this.newServerConfiguration().setForceReadOnlyBookie(readonly);
        BookieServer bkServer = this.startBookie(bkConf);
        String bookieId = bkServer.getLocalAddress().toString();
        String host = bkServer.getLocalAddress().getHostName();
        int port = bkServer.getLocalAddress().getPort();
        if (legacy) {
            String regPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)bkConf) + "/" + "available";
            regPath = readonly ? regPath + "readonly" + "/" + bookieId : regPath + "/" + bookieId;
            this.zkc.setData(regPath, new byte[0], -1);
        }
        try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());){
            BookieServiceInfo bookieServiceInfo = bkAdmin.getBookieServiceInfo(bookieId);
            Assert.assertThat((Object)bookieServiceInfo.getEndpoints().size(), (Matcher)Matchers.is((Object)1));
            BookieServiceInfo.Endpoint endpoint = bookieServiceInfo.getEndpoints().stream().filter(e -> Objects.equals(e.getId(), bookieId)).findFirst().get();
            Assert.assertNotNull((String)("Endpoint " + bookieId + " not found."), (Object)endpoint);
            Assert.assertThat((Object)endpoint.getHost(), (Matcher)Matchers.is((Object)host));
            Assert.assertThat((Object)endpoint.getPort(), (Matcher)Matchers.is((Object)port));
            Assert.assertThat((Object)endpoint.getProtocol(), (Matcher)Matchers.is((Object)"bookie-rpc"));
        }
        bkServer.shutdown();
        stackComponentFuture.cancel(true);
    }

    @Test
    public void testBookieServiceInfoWritable() throws Exception {
        this.testBookieServiceInfo(false, false);
    }

    @Test
    public void testBookieServiceInfoReadonly() throws Exception {
        this.testBookieServiceInfo(true, false);
    }

    @Test
    public void testLegacyBookieServiceInfo() throws Exception {
        this.testBookieServiceInfo(false, true);
    }
}

