/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBookieHealthCheck
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestBookieHealthCheck.class);

    public TestBookieHealthCheck() {
        super(4);
        this.baseClientConf.setAddEntryTimeout(1);
        this.baseClientConf.enableBookieHealthCheck();
        this.baseClientConf.setBookieHealthCheckInterval(1, TimeUnit.SECONDS);
        this.baseClientConf.setBookieErrorThresholdPerInterval(1L);
        this.baseClientConf.setBookieQuarantineTime(5, TimeUnit.SECONDS);
    }

    @Test
    public void testBkQuarantine() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, 2, BookKeeper.DigestType.CRC32, new byte[0]);
        int numEntries = 10;
        for (int i = 0; i < 10; ++i) {
            byte[] msg = ("msg-" + i).getBytes();
            lh.addEntry(msg);
        }
        BookieSocketAddress bookieToQuarantine = (BookieSocketAddress)lh.getLedgerMetadata().getEnsembleAt(10L).get(0);
        this.sleepBookie(bookieToQuarantine, this.baseClientConf.getAddEntryTimeout() * 2).await();
        byte[] tempMsg = "temp-msg".getBytes();
        lh.asyncAddEntry(tempMsg, new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
            }
        }, null);
        Thread.sleep(this.baseClientConf.getAddEntryTimeout() * 2 * 1000);
        Thread.sleep(this.baseClientConf.getBookieHealthCheckIntervalSeconds() * 2 * 1000);
        Assert.assertTrue((boolean)this.bkc.bookieWatcher.quarantinedBookies.asMap().containsKey(bookieToQuarantine));
        LedgerHandle lh1 = this.bkc.createLedger(2, 2, 2, BookKeeper.DigestType.CRC32, new byte[0]);
        LedgerHandle lh2 = this.bkc.createLedger(3, 3, 3, BookKeeper.DigestType.CRC32, new byte[0]);
        Assert.assertFalse((boolean)lh1.getLedgerMetadata().getEnsembleAt(0L).contains(bookieToQuarantine));
        Assert.assertFalse((boolean)lh2.getLedgerMetadata().getEnsembleAt(0L).contains(bookieToQuarantine));
        LedgerHandle lh3 = this.bkc.createLedger(4, 4, 4, BookKeeper.DigestType.CRC32, new byte[0]);
        Assert.assertTrue((boolean)lh3.getLedgerMetadata().getEnsembleAt(0L).contains(bookieToQuarantine));
        Thread.sleep(this.baseClientConf.getBookieQuarantineTimeSeconds() * 1000);
        Assert.assertFalse((boolean)this.bkc.bookieWatcher.quarantinedBookies.asMap().containsKey(bookieToQuarantine));
    }

    @Test
    public void testNoQuarantineOnBkRestart() throws Exception {
        final LedgerHandle lh = this.bkc.createLedger(2, 2, 2, BookKeeper.DigestType.CRC32, new byte[0]);
        int numEntries = 20;
        BookieSocketAddress bookieToRestart = (BookieSocketAddress)lh.getLedgerMetadata().getEnsembleAt(0L).get(0);
        Thread addEntryThread = new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    byte[] msg = ("msg-" + i).getBytes();
                    try {
                        lh.addEntry(msg);
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Error sending msg");
                    }
                }
            }
        };
        addEntryThread.start();
        this.restartBookie(bookieToRestart);
        Thread.sleep(this.baseClientConf.getBookieHealthCheckIntervalSeconds() * 2 * 1000);
        Assert.assertFalse((boolean)this.bkc.bookieWatcher.quarantinedBookies.asMap().containsKey(bookieToRestart));
    }

    @Test
    public void testNoQuarantineOnExpectedBkErrors() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, 2, BookKeeper.DigestType.CRC32, new byte[0]);
        int numEntries = 10;
        for (int i = 0; i < 10; ++i) {
            byte[] msg = ("msg-" + i).getBytes();
            lh.addEntry(msg);
        }
        BookieSocketAddress bookie1 = (BookieSocketAddress)lh.getLedgerMetadata().getEnsembleAt(0L).get(0);
        BookieSocketAddress bookie2 = (BookieSocketAddress)lh.getLedgerMetadata().getEnsembleAt(0L).get(1);
        try {
            lh.readEntries(10L, 10L);
        }
        catch (BKException bKException) {
            // empty catch block
        }
        Thread.sleep(this.baseClientConf.getBookieHealthCheckIntervalSeconds() * 2 * 1000);
        Assert.assertFalse((boolean)this.bkc.bookieWatcher.quarantinedBookies.asMap().containsKey(bookie1));
        Assert.assertFalse((boolean)this.bkc.bookieWatcher.quarantinedBookies.asMap().containsKey(bookie2));
    }
}

