/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockBookieClient
implements BookieClient {
    static final Logger LOG = LoggerFactory.getLogger(MockBookieClient.class);
    final OrderedExecutor executor;
    final ConcurrentHashMap<BookieSocketAddress, ConcurrentHashMap<Long, LedgerData>> data = new ConcurrentHashMap();
    final Set<BookieSocketAddress> errorBookies = Collections.newSetFromMap(new ConcurrentHashMap());
    private Hook preReadHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);
    private Hook postReadHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);
    private Hook preWriteHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);
    private Hook postWriteHook = (bookie, ledgerId, entryId) -> FutureUtils.value(null);

    public MockBookieClient(OrderedExecutor executor) {
        this.executor = executor;
    }

    public void setPreReadHook(Hook hook) {
        this.preReadHook = hook;
    }

    public void setPostReadHook(Hook hook) {
        this.postReadHook = hook;
    }

    public void setPreWriteHook(Hook hook) {
        this.preWriteHook = hook;
    }

    public void setPostWriteHook(Hook hook) {
        this.postWriteHook = hook;
    }

    public void errorBookies(BookieSocketAddress ... bookies) {
        this.errorBookies.addAll(Arrays.asList(bookies));
    }

    public void removeErrors(BookieSocketAddress ... bookies) {
        for (BookieSocketAddress b : bookies) {
            this.errorBookies.remove(b);
        }
    }

    public void seedEntries(BookieSocketAddress bookie, long ledgerId, long entryId, long lac) throws Exception {
        DigestManager digestManager = DigestManager.instantiate((long)ledgerId, (byte[])new byte[0], (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)false);
        ByteBuf entry = ByteBufList.coalesce((ByteBufList)digestManager.computeDigestAndPackageForSending(entryId, lac, 0L, Unpooled.buffer((int)10)));
        LedgerData ledger = this.getBookieData(bookie).computeIfAbsent(ledgerId, LedgerData::new);
        ledger.addEntry(entryId, entry);
    }

    public List<BookieSocketAddress> getFaultyBookies() {
        return Collections.emptyList();
    }

    public boolean isWritable(BookieSocketAddress address, long ledgerId) {
        return true;
    }

    public long getNumPendingRequests(BookieSocketAddress address, long ledgerId) {
        return 0L;
    }

    public void forceLedger(BookieSocketAddress addr, long ledgerId, BookkeeperInternalCallbacks.ForceLedgerCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.forceLedgerComplete(-100, ledgerId, addr, ctx)));
    }

    public void writeLac(BookieSocketAddress addr, long ledgerId, byte[] masterKey, long lac, ByteBufList toSend, BookkeeperInternalCallbacks.WriteLacCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.writeLacComplete(-100, ledgerId, addr, ctx)));
    }

    public void addEntry(BookieSocketAddress addr, long ledgerId, byte[] masterKey, long entryId, ByteBufList toSend, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, int options, boolean allowFastFail, EnumSet<WriteFlag> writeFlags) {
        toSend.retain();
        ((CompletableFuture)((CompletableFuture)this.preWriteHook.runHook(addr, ledgerId, entryId).thenComposeAsync(ignore -> {
            LOG.info("[{};L{}] write entry {}", new Object[]{addr, ledgerId, entryId});
            if (this.errorBookies.contains(addr)) {
                LOG.warn("[{};L{}] erroring write {}", new Object[]{addr, ledgerId, entryId});
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            LedgerData ledger = this.getBookieData(addr).computeIfAbsent(ledgerId, LedgerData::new);
            ledger.addEntry(entryId, MockBookieClient.copyData(toSend));
            toSend.release();
            return FutureUtils.value(null);
        }, (Executor)this.executor.chooseThread(ledgerId))).thenCompose(res -> this.postWriteHook.runHook(addr, ledgerId, entryId))).whenCompleteAsync((res, ex) -> {
            if (ex != null) {
                cb.writeComplete(BKException.getExceptionCode((Throwable)ex, (int)-12), ledgerId, entryId, addr, ctx);
            } else {
                cb.writeComplete(0, ledgerId, entryId, addr, ctx);
            }
        }, (Executor)this.executor.chooseThread(ledgerId));
    }

    public void readLac(BookieSocketAddress addr, long ledgerId, BookkeeperInternalCallbacks.ReadLacCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.readLacComplete(-100, ledgerId, null, null, ctx)));
    }

    public void readEntry(BookieSocketAddress addr, long ledgerId, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx, int flags, byte[] masterKey, boolean allowFastFail) {
        ((CompletableFuture)((CompletableFuture)this.preReadHook.runHook(addr, ledgerId, entryId).thenComposeAsync(res -> {
            LOG.info("[{};L{}] read entry {}", new Object[]{addr, ledgerId, entryId});
            if (this.errorBookies.contains(addr)) {
                LOG.warn("[{};L{}] erroring read {}", new Object[]{addr, ledgerId, entryId});
                return FutureUtils.exception((Throwable)new BKException.BKReadException());
            }
            LedgerData ledger = this.getBookieData(addr).get(ledgerId);
            if (ledger == null) {
                LOG.warn("[{};L{}] ledger not found", (Object)addr, (Object)ledgerId);
                return FutureUtils.exception((Throwable)new BKException.BKNoSuchLedgerExistsException());
            }
            ByteBuf entry = ledger.getEntry(entryId);
            if (entry == null) {
                LOG.warn("[{};L{}] entry({}) not found", new Object[]{addr, ledgerId, entryId});
                return FutureUtils.exception((Throwable)new BKException.BKNoSuchEntryException());
            }
            return FutureUtils.value((Object)entry);
        }, (Executor)this.executor.chooseThread(ledgerId))).thenCompose(buf -> this.postReadHook.runHook(addr, ledgerId, entryId).thenApply(res -> buf))).whenCompleteAsync((res, ex) -> {
            if (ex != null) {
                cb.readEntryComplete(BKException.getExceptionCode((Throwable)ex, (int)-1), ledgerId, entryId, null, ctx);
            } else {
                cb.readEntryComplete(0, ledgerId, entryId, res.slice(), ctx);
            }
        }, (Executor)this.executor.chooseThread(ledgerId));
    }

    public void readEntryWaitForLACUpdate(BookieSocketAddress addr, long ledgerId, long entryId, long previousLAC, long timeOutInMillis, boolean piggyBackEntry, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        this.executor.executeOrdered(ledgerId, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.readEntryComplete(-100, ledgerId, entryId, null, ctx)));
    }

    public void getBookieInfo(BookieSocketAddress addr, long requested, BookkeeperInternalCallbacks.GetBookieInfoCallback cb, Object ctx) {
        this.executor.executeOrdered((Object)addr, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> cb.getBookieInfoComplete(-100, null, ctx)));
    }

    public CompletableFuture<AvailabilityOfEntriesOfLedger> getListOfEntriesOfLedger(BookieSocketAddress address, long ledgerId) {
        BookkeeperInternalCallbacks.FutureGetListOfEntriesOfLedger futureResult = new BookkeeperInternalCallbacks.FutureGetListOfEntriesOfLedger(ledgerId);
        this.executor.executeOrdered((Object)address, (SafeRunnable)org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> futureResult.completeExceptionally(BKException.create((int)-100).fillInStackTrace())));
        return futureResult;
    }

    public boolean isClosed() {
        return false;
    }

    public void close() {
    }

    private ConcurrentHashMap<Long, LedgerData> getBookieData(BookieSocketAddress addr) {
        return this.data.computeIfAbsent(addr, key -> new ConcurrentHashMap());
    }

    private static ByteBuf copyData(ByteBufList list) {
        ByteBuf buf = Unpooled.buffer((int)list.readableBytes());
        for (int i = 0; i < list.size(); ++i) {
            buf.writeBytes(list.getBuffer(i).slice());
        }
        return buf;
    }

    private static class LedgerData {
        final long ledgerId;
        private TreeMap<Long, ByteBuf> entries = new TreeMap();

        LedgerData(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        void addEntry(long entryId, ByteBuf entry) {
            this.entries.put(entryId, entry);
        }

        ByteBuf getEntry(long entryId) {
            if (entryId == -1L) {
                Map.Entry<Long, ByteBuf> lastEntry = this.entries.lastEntry();
                if (lastEntry != null) {
                    return lastEntry.getValue();
                }
                return null;
            }
            return this.entries.get(entryId);
        }
    }

    public static interface Hook {
        public CompletableFuture<Void> runHook(BookieSocketAddress var1, long var2, long var4);
    }
}

