/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.PortManager;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyBookieTest
extends BookKeeperClusterTestCase {
    public ReadOnlyBookieTest() {
        super(2);
        this.baseConf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.baseConf.setEntryLogFilePreAllocationEnabled(false);
        this.baseConf.setMinUsableSizeForEntryLogCreation(Long.MAX_VALUE);
    }

    @Test
    public void testBookieShouldServeAsReadOnly() throws Exception {
        this.killBookie(0);
        this.baseConf.setReadOnlyModeEnabled(true);
        this.startNewBookie();
        LedgerHandle ledger = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        File[] ledgerDirs = ((ServerConfiguration)this.bsConfs.get(1)).getLedgerDirs();
        Assert.assertEquals((String)"Only one ledger dir should be present", (long)1L, (long)ledgerDirs.length);
        Bookie bookie = ((BookieServer)this.bs.get(1)).getBookie();
        LedgerDirsManager ledgerDirsManager = bookie.getLedgerDirsManager();
        for (int i = 0; i < 10; ++i) {
            ledger.addEntry("data".getBytes());
        }
        ledgerDirsManager.addToFilledDirs(new File(ledgerDirs[0], "current"));
        try {
            ledger.addEntry("data".getBytes());
            Assert.fail((String)"Should fail to add entry since there isn't enough bookies alive.");
        }
        catch (BKException.BKNotEnoughBookiesException i) {
            // empty catch block
        }
        Assert.assertTrue((String)"Bookie should be running and converted to readonly mode", (bookie.isRunning() && bookie.isReadOnly() ? 1 : 0) != 0);
        this.killBookie(0);
        Enumeration readEntries = ledger.readEntries(0L, 9L);
        while (readEntries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)readEntries.nextElement();
            Assert.assertEquals((String)"Entry should contain correct data", (Object)"data", (Object)new String(entry.getEntry()));
        }
    }

    @Test
    public void testBookieShouldTurnWritableFromReadOnly() throws Exception {
        this.killBookie(0);
        this.baseConf.setReadOnlyModeEnabled(true);
        this.startNewBookie();
        LedgerHandle ledger = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        File[] ledgerDirs = ((ServerConfiguration)this.bsConfs.get(1)).getLedgerDirs();
        Assert.assertEquals((String)"Only one ledger dir should be present", (long)1L, (long)ledgerDirs.length);
        Bookie bookie = ((BookieServer)this.bs.get(1)).getBookie();
        LedgerDirsManager ledgerDirsManager = bookie.getLedgerDirsManager();
        for (int i = 0; i < 10; ++i) {
            ledger.addEntry("data".getBytes());
        }
        File testDir = new File(ledgerDirs[0], "current");
        ledgerDirsManager.addToFilledDirs(testDir);
        try {
            ledger.addEntry("data".getBytes());
            Assert.fail((String)"Should fail to add entry since there isn't enough bookies alive.");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        this.bkc.waitForReadOnlyBookie(Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(1)))).get(30L, TimeUnit.SECONDS);
        LOG.info("bookie is running {}, readonly {}.", (Object)bookie.isRunning(), (Object)bookie.isReadOnly());
        Assert.assertTrue((String)"Bookie should be running and converted to readonly mode", (bookie.isRunning() && bookie.isReadOnly() ? 1 : 0) != 0);
        try {
            this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
            Assert.fail((String)"Should fail to create a ledger since there isn't enough bookies alive.");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        ledgerDirsManager.addToWritableDirs(testDir, true);
        this.bkc.waitForWritableBookie(Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(1)))).get(30L, TimeUnit.SECONDS);
        LOG.info("bookie is running {}, readonly {}.", (Object)bookie.isRunning(), (Object)bookie.isReadOnly());
        Assert.assertTrue((String)"Bookie should be running and converted back to writable mode", (bookie.isRunning() && !bookie.isReadOnly() ? 1 : 0) != 0);
        LedgerHandle newLedger = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        for (int i = 0; i < 10; ++i) {
            newLedger.addEntry("data".getBytes());
        }
        Enumeration readEntries = newLedger.readEntries(0L, 9L);
        while (readEntries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)readEntries.nextElement();
            Assert.assertEquals((String)"Entry should contain correct data", (Object)"data", (Object)new String(entry.getEntry()));
        }
    }

    @Test
    public void testBookieShutdownIfReadOnlyModeNotEnabled() throws Exception {
        this.killBookie(1);
        this.baseConf.setReadOnlyModeEnabled(false);
        this.startNewBookie();
        File[] ledgerDirs = ((ServerConfiguration)this.bsConfs.get(1)).getLedgerDirs();
        Assert.assertEquals((String)"Only one ledger dir should be present", (long)1L, (long)ledgerDirs.length);
        Bookie bookie = ((BookieServer)this.bs.get(1)).getBookie();
        LedgerHandle ledger = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        LedgerDirsManager ledgerDirsManager = bookie.getLedgerDirsManager();
        for (int i = 0; i < 10; ++i) {
            ledger.addEntry("data".getBytes());
        }
        ledgerDirsManager.addToFilledDirs(new File(ledgerDirs[0], "current"));
        try {
            ledger.addEntry("data".getBytes());
            Assert.fail((String)"Should fail to add entry since there isn't enough bookies alive.");
        }
        catch (BKException.BKNotEnoughBookiesException i) {
            // empty catch block
        }
        for (int i = 0; i < 10 && bookie.isAlive(); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertFalse((String)"Bookie should shutdown if readOnlyMode not enabled", (boolean)bookie.isAlive());
    }

    @Test
    public void testBookieContinueWritingIfMultipleLedgersPresent() throws Exception {
        int i;
        this.startNewBookieWithMultipleLedgerDirs(2);
        File[] ledgerDirs = ((ServerConfiguration)this.bsConfs.get(1)).getLedgerDirs();
        Assert.assertEquals((String)"Only one ledger dir should be present", (long)2L, (long)ledgerDirs.length);
        Bookie bookie = ((BookieServer)this.bs.get(1)).getBookie();
        LedgerHandle ledger = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        LedgerDirsManager ledgerDirsManager = bookie.getLedgerDirsManager();
        for (i = 0; i < 10; ++i) {
            ledger.addEntry("data".getBytes());
        }
        ledgerDirsManager.addToFilledDirs(new File(ledgerDirs[0], "current"));
        for (i = 0; i < 10; ++i) {
            ledger.addEntry("data".getBytes());
        }
        Assert.assertEquals((String)"writable dirs should have one dir", (long)1L, (long)ledgerDirsManager.getWritableLedgerDirs().size());
        Assert.assertTrue((String)"Bookie should shutdown if readOnlyMode not enabled", (boolean)bookie.isAlive());
    }

    private void startNewBookieWithMultipleLedgerDirs(int numOfLedgerDirs) throws Exception {
        ServerConfiguration conf = (ServerConfiguration)this.bsConfs.get(1);
        this.killBookie(1);
        File[] ledgerDirs = new File[numOfLedgerDirs];
        for (int i = 0; i < numOfLedgerDirs; ++i) {
            File dir = this.createTempDir("bookie", "test");
            this.tmpDirs.add(dir);
            ledgerDirs[i] = dir;
        }
        ServerConfiguration newConf = this.newServerConfiguration(PortManager.nextFreePort(), ledgerDirs[0], ledgerDirs);
        this.bsConfs.add(newConf);
        this.bs.add(this.startBookie(newConf));
    }

    @Test
    public void testLedgerCreationShouldFailWithReadonlyBookie() throws Exception {
        this.killBookie(1);
        this.baseConf.setReadOnlyModeEnabled(true);
        this.startNewBookie();
        ((BookieServer)this.bs.get(1)).getBookie().getStateManager().doTransitionToReadOnlyMode();
        try {
            this.bkc.waitForReadOnlyBookie(Bookie.getBookieAddress((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(1)))).get(30L, TimeUnit.SECONDS);
            this.bkc.createLedger(2, 2, BookKeeper.DigestType.CRC32, "".getBytes());
            Assert.fail((String)"Must throw exception, as there is one readonly bookie");
        }
        catch (BKException bKException) {
            // empty catch block
        }
    }

    public void testReadFromReadOnlyBookieShouldBeSuccess() throws Exception {
        LedgerHandle ledger = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        for (int i = 0; i < 10; ++i) {
            ledger.addEntry("data".getBytes());
        }
        ledger.close();
        ((ServerConfiguration)this.bsConfs.get(1)).setReadOnlyModeEnabled(true);
        ((ServerConfiguration)this.bsConfs.get(1)).setDiskCheckInterval(500);
        this.restartBookies();
        File[] ledgerDirs = ((ServerConfiguration)this.bsConfs.get(1)).getLedgerDirs();
        Assert.assertEquals((String)"Only one ledger dir should be present", (long)1L, (long)ledgerDirs.length);
        Bookie bookie = ((BookieServer)this.bs.get(1)).getBookie();
        LedgerDirsManager ledgerDirsManager = bookie.getLedgerDirsManager();
        ledgerDirsManager.addToFilledDirs(new File(ledgerDirs[0], "current"));
        Thread.sleep(1000L);
        Assert.assertTrue((String)"Bookie should be converted to readonly mode", (bookie.isRunning() && bookie.isReadOnly() ? 1 : 0) != 0);
        this.killBookie(0);
        Enumeration readEntries = ledger.readEntries(0L, 9L);
        while (readEntries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)readEntries.nextElement();
            Assert.assertEquals((String)"Entry should contain correct data", (Object)"data", (Object)new String(entry.getEntry()));
        }
    }
}

