/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.PrimitiveIterator;
import org.apache.bookkeeper.util.AvailabilityOfEntriesOfLedger;
import org.junit.Assert;
import org.junit.Test;

public class AvailabilityOfEntriesOfLedgerTest {
    @Test
    public void testWithItrConstructor() {
        long[][] arrays = new long[][]{{0L, 1L, 2L}, {1L, 2L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {0L, 1L, 5L}, {3L}, {1L, 2L, 4L, 5L, 7L, 8L}, new long[0], {0L}, {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 100L, 1000L, 1001L, 10000L, 20000L, 20001L}};
        for (int i = 0; i < arrays.length; ++i) {
            long[] tempArray = arrays[i];
            PrimitiveIterator.OfLong primitiveIterator = Arrays.stream(tempArray).iterator();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(primitiveIterator);
            Assert.assertEquals((String)"Expected total number of entries", (long)tempArray.length, (long)availabilityOfEntriesOfLedger.getTotalNumOfAvailableEntries());
            for (int j = 0; j < tempArray.length; ++j) {
                Assert.assertTrue((String)(tempArray[j] + " is supposed to be available"), (boolean)availabilityOfEntriesOfLedger.isEntryAvailable(tempArray[j]));
            }
        }
    }

    @Test
    public void testWithItrConstructorWithDuplicates() {
        long[][] arrays = new long[][]{{1L, 2L, 2L, 3L}, {1L, 2L, 3L, 5L, 5L, 6L, 7L, 8L, 8L}, {1L, 1L, 5L, 5L}, {3L, 3L}, {1L, 1L, 2L, 4L, 5L, 8L, 9L, 9L, 9L, 9L, 9L}, new long[0], {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 17L, 100L, 1000L, 1000L, 1001L, 10000L, 10000L, 20000L, 20001L}};
        for (int i = 0; i < arrays.length; ++i) {
            long[] tempArray = arrays[i];
            HashSet<Long> tempSet = new HashSet<Long>();
            for (int k = 0; k < tempArray.length; ++k) {
                tempSet.add(tempArray[k]);
            }
            PrimitiveIterator.OfLong primitiveIterator = Arrays.stream(tempArray).iterator();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(primitiveIterator);
            Assert.assertEquals((String)"Expected total number of entries", (long)tempSet.size(), (long)availabilityOfEntriesOfLedger.getTotalNumOfAvailableEntries());
            for (int j = 0; j < tempArray.length; ++j) {
                Assert.assertTrue((String)(tempArray[j] + " is supposed to be available"), (boolean)availabilityOfEntriesOfLedger.isEntryAvailable(tempArray[j]));
            }
        }
    }

    @Test
    public void testSerializeDeserialize() {
        long[][] arrays = new long[][]{{0L, 1L, 2L}, {1L, 2L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {0L, 1L, 5L}, {3L}, {1L, 2L, 4L, 5L, 7L, 8L}, new long[0], {0L}, {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 100L, 1000L, 1001L, 10000L, 20000L, 20001L}};
        for (int i = 0; i < arrays.length; ++i) {
            long[] tempArray = arrays[i];
            PrimitiveIterator.OfLong primitiveIterator = Arrays.stream(tempArray).iterator();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(primitiveIterator);
            byte[] serializedState = availabilityOfEntriesOfLedger.serializeStateOfEntriesOfLedger();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedgerUsingSer = new AvailabilityOfEntriesOfLedger(serializedState);
            Assert.assertEquals((String)"Expected total number of entries", (long)tempArray.length, (long)availabilityOfEntriesOfLedgerUsingSer.getTotalNumOfAvailableEntries());
            for (int j = 0; j < tempArray.length; ++j) {
                Assert.assertTrue((String)(tempArray[j] + " is supposed to be available"), (boolean)availabilityOfEntriesOfLedgerUsingSer.isEntryAvailable(tempArray[j]));
            }
        }
    }

    @Test
    public void testSerializeDeserializeWithItrConstructorWithDuplicates() {
        long[][] arrays = new long[][]{{1L, 2L, 2L, 3L}, {1L, 2L, 3L, 5L, 5L, 6L, 7L, 8L, 8L}, {1L, 1L, 5L, 5L}, {3L, 3L}, {1L, 1L, 2L, 4L, 5L, 8L, 9L, 9L, 9L, 9L, 9L}, new long[0], {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 17L, 100L, 1000L, 1000L, 1001L, 10000L, 10000L, 20000L, 20001L}};
        for (int i = 0; i < arrays.length; ++i) {
            long[] tempArray = arrays[i];
            HashSet<Long> tempSet = new HashSet<Long>();
            for (int k = 0; k < tempArray.length; ++k) {
                tempSet.add(tempArray[k]);
            }
            PrimitiveIterator.OfLong primitiveIterator = Arrays.stream(tempArray).iterator();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(primitiveIterator);
            byte[] serializedState = availabilityOfEntriesOfLedger.serializeStateOfEntriesOfLedger();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedgerUsingSer = new AvailabilityOfEntriesOfLedger(serializedState);
            Assert.assertEquals((String)"Expected total number of entries", (long)tempSet.size(), (long)availabilityOfEntriesOfLedgerUsingSer.getTotalNumOfAvailableEntries());
            for (int j = 0; j < tempArray.length; ++j) {
                Assert.assertTrue((String)(tempArray[j] + " is supposed to be available"), (boolean)availabilityOfEntriesOfLedgerUsingSer.isEntryAvailable(tempArray[j]));
            }
        }
    }

    @Test
    public void testNonExistingEntries() {
        long[][] arrays = new long[][]{{0L, 1L, 2L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {1L, 5L}, {3L}, {1L, 2L, 4L, 5L, 7L, 8L}, new long[0], {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 100L, 1000L, 1001L, 10000L, 20000L, 20001L}};
        long[][] nonExistingEntries = new long[][]{{3L}, {0L, 4L, 9L, 100L, 101L}, {0L, 2L, 3L, 6L, 9L}, {0L, 1L, 2L, 4L, 5L, 6L}, {0L, 3L, 9L, 10L, 11L, 100L, 1000L}, {0L, 1L, 2L, 3L, 4L, 5L}, {4L, 18L, 1002L, 19999L, 20003L}};
        for (int i = 0; i < arrays.length; ++i) {
            long[] tempArray = arrays[i];
            long[] nonExistingElementsTempArray = nonExistingEntries[i];
            PrimitiveIterator.OfLong primitiveIterator = Arrays.stream(tempArray).iterator();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(primitiveIterator);
            for (int j = 0; j < nonExistingElementsTempArray.length; ++j) {
                Assert.assertFalse((String)(nonExistingElementsTempArray[j] + " is not supposed to be available"), (boolean)availabilityOfEntriesOfLedger.isEntryAvailable(nonExistingElementsTempArray[j]));
            }
        }
    }

    @Test
    public void testGetUnavailableEntries() {
        long[][] availableEntries = new long[][]{{1L, 2L}, {0L, 1L, 2L}, {1L, 2L, 3L, 5L, 6L, 7L, 8L}, {1L, 5L}, {3L}, {1L, 2L, 4L, 5L, 7L, 8L}, new long[0], {1L, 2L, 3L, 5L, 6L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 100L, 1000L, 1001L, 10000L, 20000L, 20001L}};
        long[][] expectedToContainEntries = new long[][]{{1L, 2L}, {0L, 1L, 2L, 3L, 5L}, {1L, 2L, 5L, 7L, 8L}, {2L, 7L}, {3L}, {1L, 5L, 7L, 8L, 9L, 10L}, {0L, 1L, 2L, 3L, 4L, 5L}, {4L, 18L, 1002L, 19999L, 20003L}};
        long[][] unavailableEntries = new long[][]{new long[0], {3L, 5L}, new long[0], {2L, 7L}, new long[0], {9L, 10L}, {0L, 1L, 2L, 3L, 4L, 5L}, {4L, 18L, 1002L, 19999L, 20003L}};
        for (int i = 0; i < availableEntries.length; ++i) {
            long lastEntryId;
            long startEntryId;
            long[] availableEntriesTempArray = availableEntries[i];
            long[] expectedToContainEntriesTempArray = expectedToContainEntries[i];
            long[] unavailableEntriesTempArray = unavailableEntries[i];
            ArrayList<Long> unavailableEntriesTempList = new ArrayList<Long>();
            for (int j = 0; j < unavailableEntriesTempArray.length; ++j) {
                unavailableEntriesTempList.add(unavailableEntriesTempArray[j]);
            }
            PrimitiveIterator.OfLong primitiveIterator = Arrays.stream(availableEntriesTempArray).iterator();
            AvailabilityOfEntriesOfLedger availabilityOfEntriesOfLedger = new AvailabilityOfEntriesOfLedger(primitiveIterator);
            if (expectedToContainEntriesTempArray[0] == 0L) {
                startEntryId = expectedToContainEntriesTempArray[0];
                lastEntryId = expectedToContainEntriesTempArray[expectedToContainEntriesTempArray.length - 1];
            } else {
                startEntryId = expectedToContainEntriesTempArray[0] - 1L;
                lastEntryId = expectedToContainEntriesTempArray[expectedToContainEntriesTempArray.length - 1] + 1L;
            }
            BitSet expectedToContainEntriesBitSet = new BitSet((int)(lastEntryId - startEntryId + 1L));
            for (int ind = 0; ind < expectedToContainEntriesTempArray.length; ++ind) {
                int entryId = (int)expectedToContainEntriesTempArray[ind];
                expectedToContainEntriesBitSet.set(entryId - (int)startEntryId);
            }
            List actualUnavailableEntries = availabilityOfEntriesOfLedger.getUnavailableEntries(startEntryId, lastEntryId, expectedToContainEntriesBitSet);
            Assert.assertEquals((String)"Unavailable Entries", unavailableEntriesTempList, (Object)actualUnavailableEntries);
        }
    }

    @Test
    public void testEmptyAvailabilityOfEntriesOfLedger() {
        AvailabilityOfEntriesOfLedger emptyOne = AvailabilityOfEntriesOfLedger.EMPTY_AVAILABILITYOFENTRIESOFLEDGER;
        Assert.assertEquals((String)"expected totalNumOfAvailableEntries", (long)0L, (long)emptyOne.getTotalNumOfAvailableEntries());
        Assert.assertFalse((String)"empty one is not supposed to contain any entry", (boolean)emptyOne.isEntryAvailable(100L));
        long startEntryId = 100L;
        long lastEntryId = 105L;
        BitSet bitSetOfAvailability = new BitSet((int)(lastEntryId - startEntryId + 1L));
        for (int i = 0; i < bitSetOfAvailability.length(); ++i) {
            if (i % 2 != 0) continue;
            bitSetOfAvailability.set(i);
        }
        List unavailableEntries = emptyOne.getUnavailableEntries(startEntryId, lastEntryId, bitSetOfAvailability);
        Assert.assertEquals((String)"Num of unavailable entries", (long)bitSetOfAvailability.cardinality(), (long)unavailableEntries.size());
        for (int i = 0; i < bitSetOfAvailability.length(); ++i) {
            long entryId = startEntryId + (long)i;
            if (!bitSetOfAvailability.get(i)) continue;
            Assert.assertTrue((String)"Unavailable entry", (boolean)unavailableEntries.contains(entryId));
        }
    }
}

