/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackChangeNotifier;
import org.apache.bookkeeper.net.AbstractDNSToSwitchMapping;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDNSResolver
extends AbstractDNSToSwitchMapping
implements RackChangeNotifier {
    static final Logger LOG = LoggerFactory.getLogger(StaticDNSResolver.class);
    private static final ConcurrentMap<String, String> name2Racks = new ConcurrentHashMap<String, String>();
    private static ITopologyAwareEnsemblePlacementPolicy<BookieNode> rackawarePolicy = null;

    public static void addNodeToRack(String name, String rack) {
        name2Racks.put(name, rack);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add node {} to rack {}.", (Object)name, (Object)rack);
        }
    }

    public static String getRack(String name) {
        String rack = (String)name2Racks.get(name);
        if (null == rack) {
            rack = "/default-region/default-rack";
        }
        return rack;
    }

    public static String getRegion(String name) {
        String[] parts = StaticDNSResolver.getRack(name).split("/");
        if (parts.length <= 1) {
            return "/default-region";
        }
        return parts[1];
    }

    public static void reset() {
        name2Racks.clear();
    }

    public List<String> resolve(List<String> names) {
        ArrayList<String> racks = new ArrayList<String>();
        for (String n : names) {
            String rack = (String)name2Racks.get(n);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolve name {} to rack {}.", (Object)n, (Object)rack);
            }
            racks.add(rack);
        }
        return racks;
    }

    public void reloadCachedMappings() {
    }

    public void registerRackChangeListener(ITopologyAwareEnsemblePlacementPolicy<BookieNode> rackawareEnsemblePolicy) {
        rackawarePolicy = rackawareEnsemblePolicy;
    }

    public static void changeRack(List<BookieSocketAddress> bookieAddressList, List<String> rack) {
        for (int i = 0; i < bookieAddressList.size(); ++i) {
            BookieSocketAddress bkAddress = bookieAddressList.get(i);
            name2Racks.put(bkAddress.getHostName(), rack.get(i));
        }
        rackawarePolicy.onBookieRackChange(bookieAddressList);
    }
}

