/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import org.apache.bookkeeper.client.impl.BookKeeperClientStatsImpl;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

public interface BookKeeperClientStats {
    public static final String CATEGORY_CLIENT = "client";
    public static final String CLIENT_SCOPE = "bookkeeper_client";
    public static final String CREATE_OP = "LEDGER_CREATE";
    public static final String DELETE_OP = "LEDGER_DELETE";
    public static final String OPEN_OP = "LEDGER_OPEN";
    public static final String RECOVER_OP = "LEDGER_RECOVER";
    public static final String LEDGER_RECOVER_READ_ENTRIES = "LEDGER_RECOVER_READ_ENTRIES";
    public static final String LEDGER_RECOVER_ADD_ENTRIES = "LEDGER_RECOVER_ADD_ENTRIES";
    public static final String LEDGER_ENSEMBLE_BOOKIE_DISTRIBUTION = "LEDGER_ENSEMBLE_BOOKIE_DISTRIBUTION";
    public static final String ADD_OP = "ADD_ENTRY";
    public static final String ADD_OP_UR = "ADD_ENTRY_UR";
    public static final String FORCE_OP = "FORCE";
    public static final String READ_OP = "READ_ENTRY";
    public static final String READ_OP_DM = "READ_ENTRY_DM";
    public static final String WRITE_LAC_OP = "WRITE_LAC";
    public static final String READ_LAC_OP = "READ_LAC";
    public static final String READ_LAST_CONFIRMED_AND_ENTRY = "READ_LAST_CONFIRMED_AND_ENTRY";
    public static final String READ_LAST_CONFIRMED_AND_ENTRY_RESPONSE = "READ_LAST_CONFIRMED_AND_ENTRY_RESPONSE";
    public static final String PENDING_ADDS = "NUM_PENDING_ADD";
    public static final String ENSEMBLE_CHANGES = "NUM_ENSEMBLE_CHANGE";
    public static final String LAC_UPDATE_HITS = "LAC_UPDATE_HITS";
    public static final String LAC_UPDATE_MISSES = "LAC_UPDATE_MISSES";
    public static final String GET_BOOKIE_INFO_OP = "GET_BOOKIE_INFO";
    public static final String SPECULATIVE_READ_COUNT = "SPECULATIVE_READ_COUNT";
    public static final String READ_REQUESTS_REORDERED = "READ_REQUESTS_REORDERED";
    public static final String GET_LIST_OF_ENTRIES_OF_LEDGER_OP = "GET_LIST_OF_ENTRIES_OF_LEDGER";
    public static final String CHANNEL_SCOPE = "per_channel_bookie_client";
    public static final String CHANNEL_READ_OP = "READ_ENTRY";
    public static final String CHANNEL_TIMEOUT_READ = "TIMEOUT_READ_ENTRY";
    public static final String CHANNEL_ADD_OP = "ADD_ENTRY";
    public static final String CHANNEL_TIMEOUT_ADD = "TIMEOUT_ADD_ENTRY";
    public static final String CHANNEL_WRITE_LAC_OP = "WRITE_LAC";
    public static final String CHANNEL_FORCE_OP = "FORCE";
    public static final String CHANNEL_TIMEOUT_WRITE_LAC = "TIMEOUT_WRITE_LAC";
    public static final String CHANNEL_TIMEOUT_FORCE = "TIMEOUT_FORCE";
    public static final String CHANNEL_READ_LAC_OP = "READ_LAC";
    public static final String CHANNEL_TIMEOUT_READ_LAC = "TIMEOUT_READ_LAC";
    public static final String TIMEOUT_GET_BOOKIE_INFO = "TIMEOUT_GET_BOOKIE_INFO";
    public static final String CHANNEL_START_TLS_OP = "START_TLS";
    public static final String CHANNEL_TIMEOUT_START_TLS_OP = "TIMEOUT_START_TLS";
    public static final String TIMEOUT_GET_LIST_OF_ENTRIES_OF_LEDGER = "TIMEOUT_GET_LIST_OF_ENTRIES_OF_LEDGER";
    public static final String NETTY_EXCEPTION_CNT = "NETTY_EXCEPTION_CNT";
    public static final String CLIENT_CHANNEL_WRITE_WAIT = "CLIENT_CHANNEL_WRITE_WAIT";
    public static final String CLIENT_CONNECT_TIMER = "CLIENT_CONNECT_TIMER";
    public static final String ADD_OP_OUTSTANDING = "ADD_OP_OUTSTANDING";
    public static final String READ_OP_OUTSTANDING = "READ_OP_OUTSTANDING";
    public static final String NETTY_OPS = "NETTY_OPS";
    public static final String ACTIVE_NON_TLS_CHANNEL_COUNTER = "ACTIVE_NON_TLS_CHANNEL_COUNTER";
    public static final String ACTIVE_TLS_CHANNEL_COUNTER = "ACTIVE_TLS_CHANNEL_COUNTER";
    public static final String FAILED_CONNECTION_COUNTER = "FAILED_CONNECTION_COUNTER";
    public static final String FAILED_TLS_HANDSHAKE_COUNTER = "FAILED_TLS_HANDSHAKE_COUNTER";
    public static final String NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK = "NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK";
    public static final String WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS = "WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS";
    public static final String WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS_LATENCY = "WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS_LATENCY";
    public static final String WRITE_TIMED_OUT_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS = "WRITE_TIME_OUT_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS";
    public static final String NUM_WRITABLE_BOOKIES_IN_DEFAULT_FAULTDOMAIN = "NUM_WRITABLE_BOOKIES_IN_DEFAULT_FAULTDOMAIN";
    public static final String BOOKIE_LABEL = "bookie";

    public OpStatsLogger getCreateOpLogger();

    public OpStatsLogger getOpenOpLogger();

    public OpStatsLogger getDeleteOpLogger();

    public OpStatsLogger getRecoverOpLogger();

    public OpStatsLogger getReadOpLogger();

    public OpStatsLogger getReadLacAndEntryOpLogger();

    public OpStatsLogger getReadLacAndEntryRespLogger();

    public OpStatsLogger getAddOpLogger();

    public OpStatsLogger getForceOpLogger();

    public OpStatsLogger getWriteLacOpLogger();

    public OpStatsLogger getReadLacOpLogger();

    public OpStatsLogger getRecoverAddCountLogger();

    public OpStatsLogger getRecoverReadCountLogger();

    public Counter getReadOpDmCounter();

    public Counter getAddOpUrCounter();

    public Counter getSpeculativeReadCounter();

    public Counter getEnsembleBookieDistributionCounter(String var1);

    public Counter getEnsembleChangeCounter();

    public Counter getLacUpdateHitsCounter();

    public Counter getLacUpdateMissesCounter();

    public OpStatsLogger getClientChannelWriteWaitLogger();

    public OpStatsLogger getWriteDelayedDueToNotEnoughFaultDomainsLatency();

    public Counter getWriteDelayedDueToNotEnoughFaultDomains();

    public Counter getWriteTimedOutDueToNotEnoughFaultDomains();

    public void registerPendingAddsGauge(Gauge<Integer> var1);

    public static BookKeeperClientStats newInstance(StatsLogger stats) {
        return new BookKeeperClientStatsImpl(stats);
    }
}

