/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.PortManager;
import org.junit.Assert;
import org.junit.Test;

public class AdvertisedAddressTest
extends BookKeeperClusterTestCase {
    final int bookiePort = PortManager.nextFreePort();

    public AdvertisedAddressTest() {
        super(0);
    }

    private String newDirectory(boolean createCurDir) throws IOException {
        File d = IOUtils.createTempDir((String)"cookie", (String)"tmpdir");
        if (createCurDir) {
            new File(d, "current").mkdirs();
        }
        this.tmpDirs.add(d);
        return d.getPath();
    }

    @Test
    public void testSetAdvertisedAddress() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(this.newDirectory(false)).setLedgerDirNames(new String[]{this.newDirectory(false)}).setBookiePort(this.bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setAdvertisedAddress("10.0.0.1");
        Assert.assertEquals((Object)"10.0.0.1", (Object)conf.getAdvertisedAddress());
        BookieSocketAddress bkAddress = new BookieSocketAddress("10.0.0.1", this.bookiePort);
        Assert.assertEquals((Object)bkAddress, (Object)Bookie.getBookieAddress((ServerConfiguration)conf));
        Assert.assertEquals((Object)bkAddress.toBookieId(), (Object)Bookie.getBookieId((ServerConfiguration)conf));
        Bookie b = new Bookie(conf);
        b.start();
        BookKeeperAdmin bka = new BookKeeperAdmin(this.baseClientConf);
        Collection bookies = bka.getAvailableBookies();
        Assert.assertEquals((long)1L, (long)bookies.size());
        BookieId address = (BookieId)bookies.iterator().next();
        Assert.assertEquals((Object)bkAddress.toBookieId(), (Object)address);
        b.shutdown();
        bka.close();
    }

    @Test
    public void testBothUseHostnameAndAdvertisedAddress() throws Exception {
        ServerConfiguration conf = new ServerConfiguration().setBookiePort(this.bookiePort);
        conf.setAdvertisedAddress("10.0.0.1");
        conf.setUseHostNameAsBookieID(true);
        Assert.assertEquals((Object)"10.0.0.1", (Object)conf.getAdvertisedAddress());
        BookieSocketAddress bkAddress = new BookieSocketAddress("10.0.0.1", this.bookiePort);
        Assert.assertEquals((Object)bkAddress, (Object)Bookie.getBookieAddress((ServerConfiguration)conf));
        Assert.assertEquals((Object)bkAddress.toBookieId(), (Object)Bookie.getBookieId((ServerConfiguration)conf));
    }

    @Test
    public void testSetBookieId() throws Exception {
        String uuid = UUID.randomUUID().toString();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(this.newDirectory(false)).setLedgerDirNames(new String[]{this.newDirectory(false)}).setBookiePort(this.bookiePort).setBookieId(uuid).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setAdvertisedAddress("10.0.0.1");
        Assert.assertEquals((Object)"10.0.0.1", (Object)conf.getAdvertisedAddress());
        Assert.assertEquals((Object)uuid, (Object)conf.getBookieId());
        BookieSocketAddress bkAddress = new BookieSocketAddress("10.0.0.1", this.bookiePort);
        Assert.assertEquals((Object)bkAddress, (Object)Bookie.getBookieAddress((ServerConfiguration)conf));
        Assert.assertEquals((Object)uuid, (Object)Bookie.getBookieId((ServerConfiguration)conf).getId());
        Bookie b = new Bookie(conf);
        b.start();
        BookKeeperAdmin bka = new BookKeeperAdmin(this.baseClientConf);
        Collection bookies = bka.getAvailableBookies();
        Assert.assertEquals((long)1L, (long)bookies.size());
        BookieId address = (BookieId)bookies.iterator().next();
        Assert.assertEquals((Object)BookieId.parse((String)uuid), (Object)address);
        b.shutdown();
        bka.close();
    }
}

