/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BookieMultipleJournalsTest
extends BookKeeperClusterTestCase {
    public BookieMultipleJournalsTest() {
        super(1);
    }

    @Override
    protected ServerConfiguration newServerConfiguration(int port, File journalDir, File[] ledgerDirs) {
        ServerConfiguration conf = super.newServerConfiguration(port, journalDir, ledgerDirs);
        String[] journalDirs = new String[4];
        for (int i = 0; i < 4; ++i) {
            journalDirs[i] = journalDir.getAbsolutePath() + "/journal-" + i;
        }
        conf.setJournalDirsName(journalDirs);
        return conf;
    }

    @Test
    public void testMultipleWritesAndBookieRestart() throws Exception {
        int i;
        int j;
        int i2;
        int numLedgers = 16;
        int numEntriesPerLedger = 30;
        ArrayList<LedgerHandle> writeHandles = new ArrayList<LedgerHandle>();
        for (i2 = 0; i2 < 16; ++i2) {
            writeHandles.add(this.bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, new byte[0]));
        }
        for (i2 = 0; i2 < 30; ++i2) {
            for (j = 0; j < 16; ++j) {
                ((LedgerHandle)writeHandles.get(j)).addEntry(("entry-" + i2).getBytes());
            }
        }
        this.restartBookies();
        for (i2 = 30; i2 < 60; ++i2) {
            for (j = 0; j < 16; ++j) {
                ((LedgerHandle)writeHandles.get(j)).addEntry(("entry-" + i2).getBytes());
            }
        }
        this.restartBookies();
        ArrayList<LedgerHandle> readHandles = new ArrayList<LedgerHandle>();
        for (i = 0; i < 16; ++i) {
            readHandles.add(this.bkc.openLedger(((LedgerHandle)writeHandles.get(i)).getId(), BookKeeper.DigestType.CRC32, new byte[0]));
        }
        for (i = 0; i < 16; ++i) {
            Enumeration entries = ((LedgerHandle)readHandles.get(i)).readEntries(0L, 29L);
            for (int j2 = 0; j2 < 30; ++j2) {
                LedgerEntry entry = (LedgerEntry)entries.nextElement();
                Assert.assertEquals((Object)("entry-" + j2), (Object)new String(entry.getEntry()));
            }
        }
    }
}

