/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.util.PortManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieTest.class);
    private static final int bookiePort = PortManager.nextFreePort();

    public BookieTest() {
        super(0);
    }

    @Test
    public void testWriteLac() throws Exception {
        String metadataServiceUri = this.zkUtil.getMetadataServiceUri();
        File ledgerDir = this.createTempDir("bkLacTest", ".dir");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        ((ServerConfiguration)conf.setMetadataServiceUri(metadataServiceUri)).setBookiePort(bookiePort).setJournalDirName(ledgerDir.toString()).setLedgerDirNames(new String[]{ledgerDir.getAbsolutePath()});
        Bookie b = new Bookie(conf);
        b.start();
        Bookie spyBookie = (Bookie)Mockito.spy((Object)b);
        long ledgerId = 10L;
        long lac = 23L;
        DigestManager digestManager = DigestManager.instantiate((long)10L, (byte[])"".getBytes(StandardCharsets.UTF_8), (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)BookKeeper.DigestType.CRC32), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)this.baseClientConf.getUseV2WireProtocol());
        ByteBufList toSend = digestManager.computeDigestAndPackageForSendingLac(23L);
        ByteString body = UnsafeByteOperations.unsafeWrap((byte[])toSend.array(), (int)toSend.arrayOffset(), (int)toSend.readableBytes());
        ByteBuf lacToAdd = Unpooled.wrappedBuffer((ByteBuffer)body.asReadOnlyByteBuffer());
        byte[] masterKey = ByteString.copyFrom((byte[])"masterKey".getBytes()).toByteArray();
        ByteBuf explicitLACEntry = b.createExplicitLACEntry(10L, lacToAdd);
        lacToAdd.resetReaderIndex();
        ((Bookie)Mockito.doReturn((Object)explicitLACEntry).when((Object)spyBookie)).createExplicitLACEntry(ArgumentMatchers.eq((long)10L), (ByteBuf)ArgumentMatchers.eq((Object)lacToAdd));
        spyBookie.setExplicitLac(lacToAdd, null, null, masterKey);
        Assert.assertEquals((long)0L, (long)lacToAdd.refCnt());
        Assert.assertEquals((long)0L, (long)explicitLACEntry.refCnt());
        b.shutdown();
    }
}

