/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Bookie.class})
public class BookieWriteToJournalTest {
    private static final Logger log = LoggerFactory.getLogger(BookieWriteToJournalTest.class);
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void testJournalLogAddEntryCalledCorrectly() throws Exception {
        File journalDir = this.tempDir.newFolder();
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)journalDir));
        File ledgerDir = this.tempDir.newFolder();
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)ledgerDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setMetadataServiceUri(null);
        BookieId bookieAddress = Bookie.getBookieId((ServerConfiguration)conf);
        CountDownLatch journalJoinLatch = new CountDownLatch(1);
        Journal journal = (Journal)Mockito.mock(Journal.class);
        MutableBoolean effectiveAckBeforeSync = new MutableBoolean(false);
        ((Journal)Mockito.doAnswer(iom -> {
            ByteBuf entry = (ByteBuf)iom.getArgument(0);
            long ledgerId = entry.getLong(entry.readerIndex() + 0);
            long entryId = entry.getLong(entry.readerIndex() + 8);
            boolean ackBeforeSync = (Boolean)iom.getArgument(1);
            BookkeeperInternalCallbacks.WriteCallback callback = (BookkeeperInternalCallbacks.WriteCallback)iom.getArgument(2);
            Object ctx = iom.getArgument(3);
            effectiveAckBeforeSync.setValue(ackBeforeSync);
            callback.writeComplete(0, ledgerId, entryId, bookieAddress, ctx);
            return null;
        }).when((Object)journal)).logAddEntry((ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.anyBoolean(), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.any());
        ((Journal)Mockito.doAnswer(iom -> {
            journalJoinLatch.await();
            return null;
        }).when((Object)journal)).joinThread();
        PowerMockito.whenNew(Journal.class).withAnyArguments().thenReturn((Object)journal);
        NoOpJournalReplayBookie b = new NoOpJournalReplayBookie(conf);
        b.start();
        long ledgerId = 1L;
        long entryId = 0L;
        String expectedCtx = "foo";
        byte[] masterKey = new byte[64];
        for (boolean ackBeforeSync : new boolean[]{true, false}) {
            CountDownLatch latch = new CountDownLatch(1);
            ByteBuf data = BookieWriteToJournalTest.buildEntry(ledgerId, entryId, -1L);
            long expectedEntryId = entryId++;
            b.addEntry(data, ackBeforeSync, (rc, ledgerId1, entryId1, addr, ctx) -> {
                Assert.assertSame((Object)expectedCtx, (Object)ctx);
                Assert.assertEquals((long)ledgerId, (long)ledgerId1);
                Assert.assertEquals((long)expectedEntryId, (long)entryId1);
                latch.countDown();
            }, expectedCtx, masterKey);
            latch.await(30L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)ackBeforeSync, (Object)effectiveAckBeforeSync.booleanValue());
        }
        journalJoinLatch.countDown();
        b.shutdown();
    }

    @Test
    public void testForceLedger() throws Exception {
        File journalDir = this.tempDir.newFolder();
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)journalDir));
        File ledgerDir = this.tempDir.newFolder();
        Bookie.checkDirectoryStructure((File)Bookie.getCurrentDirectory((File)ledgerDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()});
        Bookie b = new Bookie(conf);
        b.start();
        long ledgerId = 1L;
        long entryId = 0L;
        String expectedCtx = "foo";
        byte[] masterKey = new byte[64];
        CompletableFuture latchForceLedger1 = new CompletableFuture();
        CompletableFuture latchForceLedger2 = new CompletableFuture();
        CompletableFuture latchAddEntry = new CompletableFuture();
        ByteBuf data = BookieWriteToJournalTest.buildEntry(ledgerId, entryId, -1L);
        long expectedEntryId = entryId;
        b.forceLedger(ledgerId, (rc, ledgerId1, entryId1, addr, ctx) -> {
            if (rc != 0) {
                latchForceLedger1.completeExceptionally(BKException.create((int)rc));
                return;
            }
            FutureUtils.complete((CompletableFuture)latchForceLedger1, null);
        }, (Object)expectedCtx);
        FutureUtils.result(latchForceLedger1);
        b.addEntry(data, true, (rc, ledgerId1, entryId1, addr, ctx) -> {
            if (rc != 0) {
                latchAddEntry.completeExceptionally(BKException.create((int)rc));
                return;
            }
            latchAddEntry.complete(entryId);
        }, (Object)expectedCtx, masterKey);
        Assert.assertEquals((long)expectedEntryId, (long)((Long)FutureUtils.result(latchAddEntry)));
        b.forceLedger(ledgerId, (rc, ledgerId1, entryId1, addr, ctx) -> {
            if (rc != 0) {
                latchForceLedger2.completeExceptionally(BKException.create((int)rc));
                return;
            }
            FutureUtils.complete((CompletableFuture)latchForceLedger2, null);
        }, (Object)expectedCtx);
        FutureUtils.result(latchForceLedger2);
        b.shutdown();
    }

    private static ByteBuf buildEntry(long ledgerId, long entryId, long lastAddConfirmed) {
        ByteBuf data = Unpooled.buffer();
        data.writeLong(ledgerId);
        data.writeLong(entryId);
        data.writeLong(lastAddConfirmed);
        return data;
    }

    class NoOpJournalReplayBookie
    extends Bookie {
        public NoOpJournalReplayBookie(ServerConfiguration conf) throws IOException, InterruptedException, BookieException {
            super(conf);
        }

        void readJournal() throws IOException, BookieException {
        }
    }
}

