/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.GarbageCollector;
import org.apache.bookkeeper.bookie.ScanAndCompareGarbageCollector;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerTestCase;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.SnapshotMap;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GcOverreplicatedLedgerTest
extends LedgerManagerTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ledgerManager = this.ledgerManagerFactory.newLedgerManager();
        this.activeLedgers = new SnapshotMap();
    }

    public GcOverreplicatedLedgerTest(Class<? extends LedgerManagerFactory> lmFactoryCls) {
        super(lmFactoryCls, 3);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList(new Object[][]{{HierarchicalLedgerManagerFactory.class}});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGcOverreplicatedLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        this.activeLedgers.put((Object)lh.getId(), (Object)true);
        LedgerMetadata newLedgerMetadata = (LedgerMetadata)((Versioned)this.ledgerManager.readLedgerMetadata(lh.getId()).get()).getValue();
        BookieId bookieNotInEnsemble = this.getBookieNotInEnsemble(newLedgerMetadata);
        ServerConfiguration bkConf = this.getBkConf(bookieNotInEnsemble);
        MetadataBookieDriver metadataDriver = GcOverreplicatedLedgerTest.instantiateMetadataDriver(bkConf);
        try {
            LedgerManagerFactory lmf = metadataDriver.getLedgerManagerFactory();
            try {
                LedgerUnderreplicationManager lum = lmf.newLedgerUnderreplicationManager();
                try {
                    Assert.assertFalse((boolean)lum.isLedgerBeingReplicated(lh.getId()));
                    bkConf.setGcOverreplicatedLedgerWaitTime(10L, TimeUnit.MILLISECONDS);
                    lh.close();
                    final LedgerManagerTestCase.MockLedgerStorage mockLedgerStorage = new LedgerManagerTestCase.MockLedgerStorage(this);
                    ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.ledgerManager, (CompactableLedgerStorage)mockLedgerStorage, bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
                    Thread.sleep(bkConf.getGcOverreplicatedLedgerWaitTimeMillis() + 1L);
                    garbageCollector.gc(new GarbageCollector.GarbageCleaner(){

                        public void clean(long ledgerId) {
                            try {
                                mockLedgerStorage.deleteLedger(ledgerId);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return;
                            }
                        }
                    });
                    Assert.assertFalse((boolean)lum.isLedgerBeingReplicated(lh.getId()));
                    Assert.assertFalse((boolean)this.activeLedgers.containsKey((Object)lh.getId()));
                }
                finally {
                    if (Collections.singletonList(lum).get(0) != null) {
                        lum.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(lmf).get(0) != null) {
                    lmf.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(metadataDriver).get(0) != null) {
                metadataDriver.close();
            }
        }
    }

    private static MetadataBookieDriver instantiateMetadataDriver(ServerConfiguration conf) throws BookieException {
        try {
            String metadataServiceUriStr = conf.getMetadataServiceUri();
            MetadataBookieDriver driver = MetadataDrivers.getBookieDriver((URI)URI.create(metadataServiceUriStr));
            driver.initialize(conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
            return driver;
        }
        catch (MetadataException me) {
            throw new BookieException.MetadataStoreException("Failed to initialize metadata bookie driver", (Throwable)me);
        }
        catch (ConfigurationException e) {
            throw new BookieException.BookieIllegalOpException((Throwable)e);
        }
    }

    @Test
    public void testNoGcOfLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        this.activeLedgers.put((Object)lh.getId(), (Object)true);
        LedgerMetadata newLedgerMetadata = (LedgerMetadata)((Versioned)this.ledgerManager.readLedgerMetadata(lh.getId()).get()).getValue();
        BookieId address = null;
        NavigableMap ensembleMap = newLedgerMetadata.getAllEnsembles();
        for (List ensemble : ensembleMap.values()) {
            address = (BookieId)ensemble.get(0);
        }
        ServerConfiguration bkConf = this.getBkConf(address);
        bkConf.setGcOverreplicatedLedgerWaitTime(10L, TimeUnit.MILLISECONDS);
        lh.close();
        final LedgerManagerTestCase.MockLedgerStorage mockLedgerStorage = new LedgerManagerTestCase.MockLedgerStorage(this);
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.ledgerManager, (CompactableLedgerStorage)mockLedgerStorage, bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
        Thread.sleep(bkConf.getGcOverreplicatedLedgerWaitTimeMillis() + 1L);
        garbageCollector.gc(new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                try {
                    mockLedgerStorage.deleteLedger(ledgerId);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        Assert.assertTrue((boolean)this.activeLedgers.containsKey((Object)lh.getId()));
    }

    @Test
    public void testNoGcIfLedgerBeingReplicated() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        this.activeLedgers.put((Object)lh.getId(), (Object)true);
        LedgerMetadata newLedgerMetadata = (LedgerMetadata)((Versioned)this.ledgerManager.readLedgerMetadata(lh.getId()).get()).getValue();
        BookieId bookieNotInEnsemble = this.getBookieNotInEnsemble(newLedgerMetadata);
        ServerConfiguration bkConf = this.getBkConf(bookieNotInEnsemble);
        bkConf.setGcOverreplicatedLedgerWaitTime(10L, TimeUnit.MILLISECONDS);
        lh.close();
        ZkLedgerUnderreplicationManager.acquireUnderreplicatedLedgerLock((ZooKeeper)this.zkc, (String)ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf), (long)lh.getId(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        final LedgerManagerTestCase.MockLedgerStorage mockLedgerStorage = new LedgerManagerTestCase.MockLedgerStorage(this);
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.ledgerManager, (CompactableLedgerStorage)mockLedgerStorage, bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
        Thread.sleep(bkConf.getGcOverreplicatedLedgerWaitTimeMillis() + 1L);
        garbageCollector.gc(new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                try {
                    mockLedgerStorage.deleteLedger(ledgerId);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        Assert.assertTrue((boolean)this.activeLedgers.containsKey((Object)lh.getId()));
    }

    private BookieId getBookieNotInEnsemble(LedgerMetadata ledgerMetadata) throws UnknownHostException {
        ArrayList allAddresses = Lists.newArrayList();
        for (BookieServer bk : this.bs) {
            allAddresses.add(bk.getBookieId());
        }
        NavigableMap ensembles = ledgerMetadata.getAllEnsembles();
        for (List fragmentEnsembles : ensembles.values()) {
            allAddresses.removeAll(fragmentEnsembles);
        }
        Assert.assertEquals((long)allAddresses.size(), (long)1L);
        return (BookieId)allAddresses.get(0);
    }
}

