/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.Enumeration;
import org.apache.bookkeeper.bookie.SyncThread;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCorruptionTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(IndexCorruptionTest.class);
    BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    int pageSize = 1024;

    public IndexCorruptionTest() {
        super(1);
        this.baseConf.setPageSize(this.pageSize);
    }

    @Test
    public void testNoSuchLedger() throws Exception {
        LOG.debug("Testing NoSuchLedger");
        SyncThread syncThread = ((BookieServer)this.bs.get((int)0)).getBookie().syncThread;
        syncThread.suspendSync();
        LedgerHandle lh = this.bkc.createLedger(1, 1, this.digestType, "".getBytes());
        LedgerHandle newLh = this.bkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        String dummyMsg = "NoSuchLedger";
        int numMsgs = 3;
        LedgerHandle wlh = this.bkc.createLedger(1, 1, this.digestType, "".getBytes());
        for (int i = 0; i < numMsgs; ++i) {
            wlh.addEntry(dummyMsg.getBytes());
        }
        syncThread.resumeSync();
        Thread.sleep(2 * this.baseConf.getFlushInterval());
        this.restartBookies();
        Enumeration seq = wlh.readEntries(0L, (long)(numMsgs - 1));
        Assert.assertTrue((String)"Enumeration of ledger entries has no element", (boolean)seq.hasMoreElements());
        int entryId = 0;
        while (seq.hasMoreElements()) {
            LedgerEntry e = (LedgerEntry)seq.nextElement();
            Assert.assertEquals((long)entryId, (long)e.getEntryId());
            Assert.assertArrayEquals((byte[])dummyMsg.getBytes(), (byte[])e.getEntry());
            ++entryId;
        }
        Assert.assertEquals((long)entryId, (long)numMsgs);
    }

    @Test
    public void testEmptyIndexPage() throws Exception {
        LOG.debug("Testing EmptyIndexPage");
        SyncThread syncThread = ((BookieServer)this.bs.get((int)0)).getBookie().syncThread;
        Assert.assertNotNull((String)"Not found SyncThread.", (Object)syncThread);
        syncThread.suspendSync();
        LedgerHandle lh1 = this.bkc.createLedger(1, 1, this.digestType, "".getBytes());
        String dummyMsg = "NoSuchLedger";
        int numMsgs = 2 * this.pageSize / 8;
        LedgerHandle lh2 = this.bkc.createLedger(1, 1, this.digestType, "".getBytes());
        for (int i = 0; i < numMsgs; ++i) {
            lh2.addEntry(dummyMsg.getBytes());
        }
        syncThread.resumeSync();
        Thread.sleep(2 * this.baseConf.getFlushInterval());
        syncThread.suspendSync();
        LedgerHandle newLh1 = this.bkc.openLedger(lh1.getId(), this.digestType, "".getBytes());
        for (int i = 0; i < 3; ++i) {
            lh2.addEntry(dummyMsg.getBytes());
        }
        syncThread.resumeSync();
        Thread.sleep(2 * this.baseConf.getFlushInterval());
        this.restartBookies();
        Enumeration seq = lh2.readEntries(0L, (long)((numMsgs += 3) - 1));
        Assert.assertTrue((String)"Enumeration of ledger entries has no element", (boolean)seq.hasMoreElements());
        int entryId = 0;
        while (seq.hasMoreElements()) {
            LedgerEntry e = (LedgerEntry)seq.nextElement();
            Assert.assertEquals((long)entryId, (long)e.getEntryId());
            Assert.assertArrayEquals((byte[])dummyMsg.getBytes(), (byte[])e.getEntry());
            ++entryId;
        }
        Assert.assertEquals((long)entryId, (long)numMsgs);
    }
}

