/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.IndexPersistenceMgr;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.ReadOnlyFileInfo;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class LedgerStorageTest
extends BookKeeperClusterTestCase {
    public LedgerStorageTest() {
        super(1);
    }

    @Test
    public void testLedgerDeleteNotification() throws Exception {
        LedgerStorage ledgerStorage = ((BookieServer)this.bs.get((int)0)).getBookie().ledgerStorage;
        long deletedLedgerId = 5L;
        ledgerStorage.setMasterKey(deletedLedgerId, new byte[0]);
        CountDownLatch counter = new CountDownLatch(1);
        ledgerStorage.registerLedgerDeletionListener(ledgerId -> {
            Assert.assertEquals((long)deletedLedgerId, (long)ledgerId);
            counter.countDown();
        });
        ledgerStorage.deleteLedger(deletedLedgerId);
        counter.await();
    }

    @Test
    public void testExplicitLacWriteToJournalWithValidVersions() throws Exception {
        this.testExplicitLacWriteToJournal(6, 1);
    }

    @Test
    public void testExplicitLacWriteToJournalWithOlderVersions() throws Exception {
        this.testExplicitLacWriteToJournal(5, 0);
    }

    public void testExplicitLacWriteToJournal(int journalFormatVersionToWrite, int fileInfoFormatVersionToWrite) throws Exception {
        ServerConfiguration bookieServerConfig = (ServerConfiguration)this.bsConfs.get(0);
        bookieServerConfig.setJournalFormatVersionToWrite(journalFormatVersionToWrite);
        bookieServerConfig.setFileInfoFormatVersionToWrite(fileInfoFormatVersionToWrite);
        this.restartBookies(bookieServerConfig);
        ClientConfiguration confWithExplicitLAC = new ClientConfiguration();
        confWithExplicitLAC.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int explictLacInterval = 100;
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        byte[] passwdBytes = "testPasswd".getBytes();
        confWithExplicitLAC.setExplictLacInterval(explictLacInterval);
        BookKeeper bkcWithExplicitLAC = new BookKeeper(confWithExplicitLAC);
        LedgerHandle wlh = bkcWithExplicitLAC.createLedger(1, 1, 1, digestType, passwdBytes);
        long ledgerId = wlh.getId();
        int numOfEntries = 5;
        for (int i = 0; i < numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        LedgerHandle rlh = bkcWithExplicitLAC.openLedgerNoRecovery(ledgerId, digestType, passwdBytes);
        Assert.assertEquals((String)"LAC of rlh", (long)((long)numOfEntries - 2L), (long)rlh.getLastAddConfirmed());
        Assert.assertEquals((String)"Read explicit LAC of rlh", (long)((long)numOfEntries - 2L), (long)rlh.readExplicitLastConfirmed());
        long readExplicitLastConfirmed = TestUtils.waitUntilExplicitLacUpdated(rlh, numOfEntries - 1);
        Assert.assertEquals((String)"Read explicit LAC of rlh after wait for explicitlacflush", (long)(numOfEntries - 1), (long)readExplicitLastConfirmed);
        ServerConfiguration newBookieConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        newBookieConf.setMetadataServiceUri(null);
        Bookie newbookie = new Bookie(newBookieConf);
        newbookie.readJournal();
        ByteBuf explicitLacBuf = newbookie.getExplicitLac(ledgerId);
        if (journalFormatVersionToWrite >= 6 && fileInfoFormatVersionToWrite >= 1) {
            DigestManager digestManager = DigestManager.instantiate((long)ledgerId, (byte[])passwdBytes, (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)digestType), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)confWithExplicitLAC.getUseV2WireProtocol());
            long explicitLacPersistedInJournal = digestManager.verifyDigestAndReturnLac(explicitLacBuf);
            Assert.assertEquals((String)"explicitLac persisted in journal", (long)(numOfEntries - 1), (long)explicitLacPersistedInJournal);
        } else {
            Assert.assertEquals((String)"explicitLac is not expected to be persisted, so it should be null", null, (Object)explicitLacBuf);
        }
        bkcWithExplicitLAC.close();
    }

    @Test
    public void testExplicitLacWriteToFileInfoWithValidVersions() throws Exception {
        this.testExplicitLacWriteToFileInfo(6, 1);
    }

    @Test
    public void testExplicitLacWriteToFileInfoWithOlderVersions() throws Exception {
        this.testExplicitLacWriteToFileInfo(5, 0);
    }

    public void testExplicitLacWriteToFileInfo(int journalFormatVersionToWrite, int fileInfoFormatVersionToWrite) throws Exception {
        ServerConfiguration bookieServerConfig = (ServerConfiguration)this.bsConfs.get(0);
        bookieServerConfig.setJournalFormatVersionToWrite(journalFormatVersionToWrite);
        bookieServerConfig.setFileInfoFormatVersionToWrite(fileInfoFormatVersionToWrite);
        this.restartBookies(bookieServerConfig);
        ClientConfiguration confWithExplicitLAC = new ClientConfiguration();
        confWithExplicitLAC.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int explictLacInterval = 100;
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        byte[] passwdBytes = "testPasswd".getBytes();
        confWithExplicitLAC.setExplictLacInterval(explictLacInterval);
        BookKeeper bkcWithExplicitLAC = new BookKeeper(confWithExplicitLAC);
        LedgerHandle wlh = bkcWithExplicitLAC.createLedger(1, 1, 1, digestType, passwdBytes);
        long ledgerId = wlh.getId();
        int numOfEntries = 5;
        for (int i = 0; i < numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        LedgerHandle rlh = bkcWithExplicitLAC.openLedgerNoRecovery(ledgerId, digestType, passwdBytes);
        Assert.assertEquals((String)"LAC of rlh", (long)((long)numOfEntries - 2L), (long)rlh.getLastAddConfirmed());
        Assert.assertEquals((String)"Read explicit LAC of rlh", (long)((long)numOfEntries - 2L), (long)rlh.readExplicitLastConfirmed());
        long readExplicitLastConfirmed = TestUtils.waitUntilExplicitLacUpdated(rlh, numOfEntries - 1);
        Assert.assertEquals((String)"Read explicit LAC of rlh after wait for explicitlacflush", (long)(numOfEntries - 1), (long)readExplicitLastConfirmed);
        ((BookieServer)this.bs.get((int)0)).getBookie().ledgerStorage.flush();
        ReadOnlyFileInfo fileInfo = this.getFileInfo(ledgerId, Bookie.getCurrentDirectories((File[])((ServerConfiguration)this.bsConfs.get(0)).getLedgerDirs()));
        fileInfo.readHeader();
        ByteBuf explicitLacBufReadFromFileInfo = fileInfo.getExplicitLac();
        if (journalFormatVersionToWrite >= 6 && fileInfoFormatVersionToWrite >= 1) {
            DigestManager digestManager = DigestManager.instantiate((long)ledgerId, (byte[])passwdBytes, (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)digestType), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)confWithExplicitLAC.getUseV2WireProtocol());
            long explicitLacReadFromFileInfo = digestManager.verifyDigestAndReturnLac(explicitLacBufReadFromFileInfo);
            Assert.assertEquals((String)"explicitLac persisted in FileInfo", (long)(numOfEntries - 1), (long)explicitLacReadFromFileInfo);
        } else {
            Assert.assertEquals((String)"explicitLac is not expected to be persisted, so it should be null", null, (Object)explicitLacBufReadFromFileInfo);
        }
        bkcWithExplicitLAC.close();
    }

    private File getLedgerFile(long ledgerId, File[] indexDirectories) {
        File d;
        String ledgerName = IndexPersistenceMgr.getLedgerName((long)ledgerId);
        File lf = null;
        File[] fileArray = indexDirectories;
        int n = fileArray.length;
        for (int i = 0; i < n && !(lf = new File(d = fileArray[i], ledgerName)).exists(); ++i) {
            lf = null;
        }
        return lf;
    }

    ReadOnlyFileInfo getFileInfo(long ledgerId, File[] indexDirectories) throws IOException {
        File ledgerFile = this.getLedgerFile(ledgerId, indexDirectories);
        if (null == ledgerFile) {
            throw new FileNotFoundException("No index file found for ledger " + ledgerId + ". It may be not flushed yet.");
        }
        ReadOnlyFileInfo fi = new ReadOnlyFileInfo(ledgerFile, null);
        fi.readHeader();
        return fi;
    }

    @Test
    public void testGetListOfEntriesOfLedger() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int numOfBookies = this.bs.size();
        int numOfEntries = 5;
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        BookKeeper bkc = new BookKeeper(conf);
        LedgerHandle lh = bkc.createLedger(numOfBookies, numOfBookies, digestType, "testPasswd".getBytes());
        long lId = lh.getId();
        for (int i = 0; i < numOfEntries; ++i) {
            lh.addEntry("000".getBytes());
        }
        ServerConfiguration newBookieConf = new ServerConfiguration((AbstractConfiguration)this.bsConfs.get(0));
        newBookieConf.setMetadataServiceUri(null);
        Bookie newbookie = new Bookie(newBookieConf);
        newbookie.readJournal();
        PrimitiveIterator.OfLong listOfEntriesItr = newbookie.getListOfEntriesOfLedger(lId);
        ArrayList arrayList = new ArrayList();
        Consumer<Long> addMethod = arrayList::add;
        listOfEntriesItr.forEachRemaining((Consumer<? super Long>)addMethod);
        Assert.assertEquals((String)"Num Of Entries", (long)numOfEntries, (long)arrayList.size());
        Assert.assertTrue((String)"Iterator should be sorted", (boolean)IntStream.range(0, arrayList.size() - 1).allMatch(k -> (Long)arrayList.get(k) <= (Long)arrayList.get(k + 1)));
        bkc.close();
    }
}

