/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.DiskChecker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SortedLedgerStorageTest {
    TestStatsProvider statsProvider = new TestStatsProvider();
    ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
    LedgerDirsManager ledgerDirsManager;
    SortedLedgerStorage sortedLedgerStorage = new SortedLedgerStorage();
    final long numWrites = 2000L;
    final long moreNumOfWrites = 3000L;
    final long entriesPerWrite = 2L;
    final long numOfLedgers = 5L;
    CheckpointSource checkpointSource = new CheckpointSource(){

        public CheckpointSource.Checkpoint newCheckpoint() {
            return CheckpointSource.Checkpoint.MAX;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        }
    };
    Checkpointer checkpointer = new Checkpointer(){

        public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        }

        public void start() {
        }
    };

    @Parameterized.Parameters
    public static Iterable<Boolean> elplSetting() {
        return Arrays.asList(true, false);
    }

    public SortedLedgerStorageTest(boolean elplSetting) {
        this.conf.setEntryLogSizeLimit(2048L);
        this.conf.setEntryLogPerLedgerEnabled(elplSetting);
    }

    @Before
    public void setUp() throws Exception {
        File tmpDir = File.createTempFile("bkTest", ".dir");
        tmpDir.delete();
        tmpDir.mkdir();
        File curDir = Bookie.getCurrentDirectory((File)tmpDir);
        Bookie.checkDirectoryStructure((File)curDir);
        this.conf.setLedgerDirNames(new String[]{tmpDir.toString()});
        this.ledgerDirsManager = new LedgerDirsManager(this.conf, this.conf.getLedgerDirs(), new DiskChecker(this.conf.getDiskUsageThreshold(), this.conf.getDiskUsageWarnThreshold()));
        this.sortedLedgerStorage.initialize(this.conf, null, this.ledgerDirsManager, this.ledgerDirsManager, null, this.checkpointSource, this.checkpointer, (StatsLogger)this.statsProvider.getStatsLogger("bookie"), (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    @Test
    public void testGetListOfEntriesOfLedger() throws Exception {
        long nonExistingLedgerId = 123456L;
        PrimitiveIterator.OfLong entriesItr = this.sortedLedgerStorage.getListOfEntriesOfLedger(nonExistingLedgerId);
        Assert.assertFalse((String)"There shouldn't be any entries for this ledger", (boolean)entriesItr.hasNext());
        for (long entryId = 0L; entryId < 2000L; ++entryId) {
            for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
                if (entryId == 0L) {
                    this.sortedLedgerStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
                    this.sortedLedgerStorage.setFenced(ledgerId);
                }
                ByteBuf entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId * 2L);
                entry.writeBytes(("entry-" + entryId).getBytes());
                this.sortedLedgerStorage.addEntry(entry);
            }
        }
        for (long ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
            PrimitiveIterator.OfLong entriesOfLedger = this.sortedLedgerStorage.getListOfEntriesOfLedger(ledgerId);
            ArrayList arrayList = new ArrayList();
            Consumer<Long> addMethod = arrayList::add;
            entriesOfLedger.forEachRemaining((Consumer<? super Long>)addMethod);
            Assert.assertEquals((String)"Number of entries", (long)2000L, (long)arrayList.size());
            Assert.assertTrue((String)"Entries of Ledger", (boolean)IntStream.range(0, arrayList.size()).allMatch(i -> (Long)arrayList.get(i) == (long)i * 2L));
        }
        nonExistingLedgerId = 456789L;
        entriesItr = this.sortedLedgerStorage.getListOfEntriesOfLedger(nonExistingLedgerId);
        Assert.assertFalse((String)"There shouldn't be any entry", (boolean)entriesItr.hasNext());
    }

    @Test
    public void testGetListOfEntriesOfLedgerAfterFlush() throws IOException {
        ByteBuf entry;
        long ledgerId;
        long entryId;
        for (entryId = 0L; entryId < 2000L; ++entryId) {
            for (ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
                if (entryId == 0L) {
                    this.sortedLedgerStorage.setMasterKey(ledgerId, ("ledger-" + ledgerId).getBytes());
                    this.sortedLedgerStorage.setFenced(ledgerId);
                }
                entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId * 2L);
                entry.writeBytes(("entry-" + entryId).getBytes());
                this.sortedLedgerStorage.addEntry(entry);
            }
        }
        this.sortedLedgerStorage.flush();
        for (entryId = 2000L; entryId < 3000L; ++entryId) {
            for (ledgerId = 0L; ledgerId < 5L; ++ledgerId) {
                entry = Unpooled.buffer((int)128);
                entry.writeLong(ledgerId);
                entry.writeLong(entryId * 2L);
                entry.writeBytes(("entry-" + entryId).getBytes());
                this.sortedLedgerStorage.addEntry(entry);
            }
        }
        for (long ledgerId2 = 0L; ledgerId2 < 5L; ++ledgerId2) {
            PrimitiveIterator.OfLong entriesOfLedger = this.sortedLedgerStorage.getListOfEntriesOfLedger(ledgerId2);
            ArrayList arrayList = new ArrayList();
            Consumer<Long> addMethod = arrayList::add;
            entriesOfLedger.forEachRemaining((Consumer<? super Long>)addMethod);
            Assert.assertEquals((String)"Number of entries", (long)3000L, (long)arrayList.size());
            Assert.assertTrue((String)"Entries of Ledger", (boolean)IntStream.range(0, arrayList.size()).allMatch(i -> (Long)arrayList.get(i) == (long)i * 2L));
        }
    }
}

