/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.bookie.FileInfo;
import org.apache.bookkeeper.bookie.FileSystemUpgrade;
import org.apache.bookkeeper.bookie.IndexPersistenceMgr;
import org.apache.bookkeeper.bookie.JournalChannel;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.PortManager;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    private static final int bookiePort = PortManager.nextFreePort();

    public UpgradeTest() {
        super(0);
    }

    static void writeLedgerDir(File dir, byte[] masterKey) throws Exception {
        long ledgerId = 1L;
        File fn = new File(dir, IndexPersistenceMgr.getLedgerName((long)ledgerId));
        fn.getParentFile().mkdirs();
        FileInfo fi = new FileInfo(fn, masterKey, 1);
        fi.write(new ByteBuffer[]{ByteBuffer.allocate(0)}, 0L);
        fi.close(true);
        long logId = 0L;
        ByteBuffer logfileHeader = ByteBuffer.allocate(1024);
        logfileHeader.put("BKLO".getBytes());
        FileChannel logfile = new RandomAccessFile(new File(dir, Long.toHexString(logId) + ".log"), "rw").getChannel();
        logfile.write((ByteBuffer)logfileHeader.clear());
        logfile.close();
    }

    static JournalChannel writeJournal(File journalDir, int numEntries, byte[] masterKey) throws Exception {
        long logId = System.currentTimeMillis();
        JournalChannel jc = new JournalChannel(journalDir, logId);
        BufferedChannel bc = jc.getBufferedChannel();
        long ledgerId = 1L;
        byte[] data = new byte[1024];
        Arrays.fill(data, (byte)88);
        long lastConfirmed = -1L;
        for (int i = 1; i <= numEntries; ++i) {
            ByteBuf packet = ClientUtil.generatePacket(ledgerId, i, lastConfirmed, i * data.length, data);
            lastConfirmed = i;
            ByteBuffer lenBuff = ByteBuffer.allocate(4);
            lenBuff.putInt(packet.readableBytes());
            lenBuff.flip();
            bc.write(Unpooled.wrappedBuffer((ByteBuffer)lenBuff));
            bc.write(packet);
            packet.release();
        }
        bc.flushAndForceWrite(false);
        return jc;
    }

    static File newV1JournalDirectory() throws Exception {
        File d = IOUtils.createTempDir((String)"bookie", (String)"tmpdir");
        UpgradeTest.writeJournal(d, 100, "foobar".getBytes()).close();
        return d;
    }

    static File newV1LedgerDirectory() throws Exception {
        File d = IOUtils.createTempDir((String)"bookie", (String)"tmpdir");
        UpgradeTest.writeLedgerDir(d, "foobar".getBytes());
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createVersion2File(File dir) throws Exception {
        File versionFile = new File(dir, "VERSION");
        FileOutputStream fos = new FileOutputStream(versionFile);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(fos));
            bw.write(String.valueOf(2));
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            fos.close();
        }
    }

    static File newV2JournalDirectory() throws Exception {
        File d = UpgradeTest.newV1JournalDirectory();
        UpgradeTest.createVersion2File(d);
        return d;
    }

    static File newV2LedgerDirectory() throws Exception {
        File d = UpgradeTest.newV1LedgerDirectory();
        UpgradeTest.createVersion2File(d);
        return d;
    }

    private static void testUpgradeProceedure(String zkServers, String journalDir, String ledgerDir) throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setMetadataServiceUri("zk://" + zkServers + "/ledgers");
        conf.setJournalDirName(journalDir).setLedgerDirNames(new String[]{ledgerDir}).setBookiePort(bookiePort);
        Bookie b = null;
        try {
            b = new Bookie(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException e) {
            Assert.assertTrue((String)"wrong exception", (boolean)e.getMessage().contains("upgrade needed"));
        }
        FileSystemUpgrade.upgrade((ServerConfiguration)conf);
        b = new Bookie(conf);
        b.start();
        b.shutdown();
        b = null;
        FileSystemUpgrade.rollback((ServerConfiguration)conf);
        try {
            b = new Bookie(conf);
            Assert.fail((String)"Shouldn't have been able to start");
        }
        catch (BookieException.InvalidCookieException e) {
            Assert.assertTrue((String)"wrong exception", (boolean)e.getMessage().contains("upgrade needed"));
        }
        FileSystemUpgrade.upgrade((ServerConfiguration)conf);
        FileSystemUpgrade.finalizeUpgrade((ServerConfiguration)conf);
        b = new Bookie(conf);
        b.start();
        b.shutdown();
        b = null;
    }

    @Test
    public void testUpgradeV1toCurrent() throws Exception {
        File journalDir = UpgradeTest.newV1JournalDirectory();
        this.tmpDirs.add(journalDir);
        File ledgerDir = UpgradeTest.newV1LedgerDirectory();
        this.tmpDirs.add(ledgerDir);
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath());
    }

    @Test
    public void testUpgradeV2toCurrent() throws Exception {
        File journalDir = UpgradeTest.newV2JournalDirectory();
        this.tmpDirs.add(journalDir);
        File ledgerDir = UpgradeTest.newV2LedgerDirectory();
        this.tmpDirs.add(ledgerDir);
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath());
    }

    @Test
    public void testUpgradeCurrent() throws Exception {
        File journalDir = UpgradeTest.newV2JournalDirectory();
        this.tmpDirs.add(journalDir);
        File ledgerDir = UpgradeTest.newV2LedgerDirectory();
        this.tmpDirs.add(ledgerDir);
        UpgradeTest.testUpgradeProceedure(this.zkUtil.getZooKeeperConnectString(), journalDir.getPath(), ledgerDir.getPath());
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setJournalDirName(journalDir.getPath()).setLedgerDirNames(new String[]{ledgerDir.getPath()}).setBookiePort(bookiePort).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        FileSystemUpgrade.upgrade((ServerConfiguration)conf);
        Bookie b = new Bookie(conf);
        b.start();
        b.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommandLine() throws Exception {
        PrintStream origerr = System.err;
        PrintStream origout = System.out;
        File output = IOUtils.createTempFileAndDeleteOnExit((String)"bookie", (String)"stdout");
        File erroutput = IOUtils.createTempFileAndDeleteOnExit((String)"bookie", (String)"stderr");
        System.setOut(new PrintStream(output));
        System.setErr(new PrintStream(erroutput));
        try {
            FileSystemUpgrade.main((String[])new String[]{"-h"});
            try {
                FileSystemUpgrade.main((String[])new String[]{"-u"});
                Assert.fail((String)"Should have failed");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertTrue((String)("Wrong exception " + iae.getMessage()), (boolean)iae.getMessage().contains("without configuration"));
            }
            File f = IOUtils.createTempFileAndDeleteOnExit((String)"bookie", (String)"tmpconf");
            try {
                FileSystemUpgrade.main((String[])new String[]{"--conf", f.getPath()});
                Assert.fail((String)"Should have failed");
            }
            catch (IllegalArgumentException iae) {
                Assert.assertTrue((String)("Wrong exception " + iae.getMessage()), (boolean)iae.getMessage().contains("Must specify -upgrade"));
            }
        }
        finally {
            System.setOut(origout);
            System.setErr(origerr);
        }
    }
}

