/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.CheckpointSourceList;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.SingleDirectoryDbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DbLedgerStorageTest {
    private DbLedgerStorage storage;
    private File tmpDir;
    private LedgerDirsManager ledgerDirsManager;

    @Before
    public void setup() throws Exception {
        this.tmpDir = File.createTempFile("bkTest", ".dir");
        this.tmpDir.delete();
        this.tmpDir.mkdir();
        File curDir = Bookie.getCurrentDirectory((File)this.tmpDir);
        Bookie.checkDirectoryStructure((File)curDir);
        int gcWaitTime = 1000;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime((long)gcWaitTime);
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        conf.setLedgerDirNames(new String[]{this.tmpDir.toString()});
        Bookie bookie = new Bookie(conf);
        this.ledgerDirsManager = bookie.getLedgerDirsManager();
        this.storage = (DbLedgerStorage)bookie.getLedgerStorage();
    }

    @After
    public void teardown() throws Exception {
        this.storage.shutdown();
        this.tmpDir.delete();
    }

    @Test
    public void simple() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.storage.ledgerExists(3L));
        try {
            this.storage.isFenced(3L);
            Assert.fail((String)"should have failed");
        }
        catch (Bookie.NoLedgerException noLedgerException) {
            // empty catch block
        }
        Assert.assertEquals((Object)false, (Object)this.storage.ledgerExists(3L));
        try {
            this.storage.setFenced(3L);
            Assert.fail((String)"should have failed");
        }
        catch (Bookie.NoLedgerException noLedgerException) {
            // empty catch block
        }
        this.storage.setMasterKey(3L, "key".getBytes());
        try {
            this.storage.setMasterKey(3L, "other-key".getBytes());
            Assert.fail((String)"should have failed");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe.getCause() instanceof BookieException.BookieIllegalOpException));
        }
        this.storage.setMasterKey(3L, "key".getBytes());
        Assert.assertEquals((Object)true, (Object)this.storage.ledgerExists(3L));
        Assert.assertEquals((Object)true, (Object)this.storage.setFenced(3L));
        Assert.assertEquals((Object)true, (Object)this.storage.isFenced(3L));
        Assert.assertEquals((Object)false, (Object)this.storage.setFenced(3L));
        this.storage.setMasterKey(4L, "key".getBytes());
        Assert.assertEquals((Object)false, (Object)this.storage.isFenced(4L));
        Assert.assertEquals((Object)true, (Object)this.storage.ledgerExists(4L));
        Assert.assertEquals((Object)"key", (Object)new String(this.storage.readMasterKey(4L)));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{4L, 3L}), (Object)Lists.newArrayList((Iterable)this.storage.getActiveLedgersInRange(0L, 100L)));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{4L, 3L}), (Object)Lists.newArrayList((Iterable)this.storage.getActiveLedgersInRange(3L, 100L)));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{3L}), (Object)Lists.newArrayList((Iterable)this.storage.getActiveLedgersInRange(0L, 4L)));
        ByteBuf entry = Unpooled.buffer((int)1024);
        entry.writeLong(4L);
        entry.writeLong(1L);
        entry.writeLong(0L);
        entry.writeBytes("entry-1".getBytes());
        Assert.assertEquals((Object)false, (Object)this.storage.isFlushRequired());
        Assert.assertEquals((long)1L, (long)this.storage.addEntry(entry));
        Assert.assertEquals((Object)true, (Object)this.storage.isFlushRequired());
        ByteBuf res = this.storage.getEntry(4L, 1L);
        Assert.assertEquals((Object)entry, (Object)res);
        this.storage.flush();
        Assert.assertEquals((Object)false, (Object)this.storage.isFlushRequired());
        res = this.storage.getEntry(4L, 1L);
        Assert.assertEquals((Object)entry, (Object)res);
        try {
            this.storage.getEntry(4L, 2L);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (Bookie.NoEntryException noEntryException) {
            // empty catch block
        }
        ByteBuf entry2 = Unpooled.buffer((int)1024);
        entry2.writeLong(4L);
        entry2.writeLong(2L);
        entry2.writeLong(1L);
        entry2.writeBytes("entry-2".getBytes());
        this.storage.addEntry(entry2);
        res = this.storage.getEntry(4L, -1L);
        Assert.assertEquals((Object)entry2, (Object)res);
        Assert.assertEquals((long)1L, (long)this.storage.getLastAddConfirmed(4L));
        ByteBuf entry3 = Unpooled.buffer((int)1024);
        entry3.writeLong(4L);
        entry3.writeLong(3L);
        entry3.writeLong(2L);
        entry3.writeBytes("entry-3".getBytes());
        this.storage.addEntry(entry3);
        ByteBuf entry4 = Unpooled.buffer((int)1024);
        entry4.writeLong(4L);
        entry4.writeLong(4L);
        entry4.writeLong(3L);
        entry4.writeBytes("entry-4".getBytes());
        this.storage.addEntry(entry4);
        res = this.storage.getEntry(4L, 4L);
        Assert.assertEquals((Object)entry4, (Object)res);
        Assert.assertEquals((long)3L, (long)this.storage.getLastAddConfirmed(4L));
        Assert.assertEquals((Object)true, (Object)this.storage.ledgerExists(4L));
        this.storage.deleteLedger(4L);
        Assert.assertEquals((Object)false, (Object)this.storage.ledgerExists(4L));
        this.storage.getEntry(4L, 4L);
        Assert.assertEquals((long)3L, (long)this.storage.getLastAddConfirmed(4L));
        this.storage.addEntry(Unpooled.wrappedBuffer((ByteBuf)entry2));
        res = this.storage.getEntry(4L, -1L);
        Assert.assertEquals((Object)entry4, (Object)res);
        Assert.assertEquals((long)3L, (long)this.storage.getLastAddConfirmed(4L));
        this.storage.flush();
        try {
            this.storage.getEntry(4L, 4L);
            Assert.fail((String)"Should have thrown exception since the ledger was deleted");
        }
        catch (Bookie.NoEntryException noEntryException) {
            // empty catch block
        }
    }

    @Test
    public void testBookieCompaction() throws Exception {
        this.storage.setMasterKey(4L, "key".getBytes());
        ByteBuf entry3 = Unpooled.buffer((int)1024);
        entry3.writeLong(4L);
        entry3.writeLong(3L);
        entry3.writeBytes("entry-3".getBytes());
        this.storage.addEntry(entry3);
        SingleDirectoryDbLedgerStorage singleDirStorage = (SingleDirectoryDbLedgerStorage)this.storage.getLedgerStorageList().get(0);
        EntryLogger entryLogger = singleDirStorage.getEntryLogger();
        ByteBuf newEntry3 = Unpooled.buffer((int)1024);
        newEntry3.writeLong(4L);
        newEntry3.writeLong(3L);
        newEntry3.writeBytes("new-entry-3".getBytes());
        long location = entryLogger.addEntry(4L, newEntry3, false);
        this.storage.flush();
        ArrayList locations = Lists.newArrayList((Object[])new EntryLocation[]{new EntryLocation(4L, 3L, location)});
        singleDirStorage.updateEntriesLocations((Iterable)locations);
        ByteBuf res = this.storage.getEntry(4L, 3L);
        System.out.println("res:       " + ByteBufUtil.hexDump((ByteBuf)res));
        System.out.println("newEntry3: " + ByteBufUtil.hexDump((ByteBuf)newEntry3));
        Assert.assertEquals((Object)newEntry3, (Object)res);
    }

    @Test
    public void doubleDirectory() throws Exception {
        int gcWaitTime = 1000;
        File firstDir = new File(this.tmpDir, "dir1");
        File secondDir = new File(this.tmpDir, "dir2");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime((long)gcWaitTime);
        conf.setProperty("dbStorage_writeCacheMaxSizeMb", (Object)4);
        conf.setProperty("dbStorage_readAheadCacheMaxSizeMb", (Object)4);
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        conf.setLedgerDirNames(new String[]{firstDir.getCanonicalPath(), secondDir.getCanonicalPath()});
        Bookie bookie = new Bookie(conf);
        Assert.assertEquals((long)2L, (long)((DbLedgerStorage)bookie.getLedgerStorage()).getLedgerStorageList().size());
        bookie.shutdown();
    }

    @Test
    public void testRewritingEntries() throws Exception {
        this.storage.setMasterKey(1L, "key".getBytes());
        try {
            this.storage.getEntry(1L, -1L);
            Assert.fail((String)"Should throw exception");
        }
        catch (Bookie.NoEntryException noEntryException) {
            // empty catch block
        }
        ByteBuf entry1 = Unpooled.buffer((int)1024);
        entry1.writeLong(1L);
        entry1.writeLong(1L);
        entry1.writeBytes("entry-1".getBytes());
        this.storage.addEntry(entry1);
        this.storage.flush();
        ByteBuf newEntry1 = Unpooled.buffer((int)1024);
        newEntry1.writeLong(1L);
        newEntry1.writeLong(1L);
        newEntry1.writeBytes("new-entry-1".getBytes());
        this.storage.addEntry(newEntry1);
        this.storage.flush();
        ByteBuf response = this.storage.getEntry(1L, 1L);
        Assert.assertEquals((Object)newEntry1, (Object)response);
    }

    @Test
    public void testEntriesOutOfOrder() throws Exception {
        this.storage.setMasterKey(1L, "key".getBytes());
        ByteBuf entry2 = Unpooled.buffer((int)1024);
        entry2.writeLong(1L);
        entry2.writeLong(2L);
        entry2.writeBytes("entry-2".getBytes());
        this.storage.addEntry(entry2);
        try {
            this.storage.getEntry(1L, 1L);
            Assert.fail((String)"Entry doesn't exist");
        }
        catch (Bookie.NoEntryException noEntryException) {
            // empty catch block
        }
        ByteBuf res = this.storage.getEntry(1L, 2L);
        Assert.assertEquals((Object)entry2, (Object)res);
        ByteBuf entry1 = Unpooled.buffer((int)1024);
        entry1.writeLong(1L);
        entry1.writeLong(1L);
        entry1.writeBytes("entry-1".getBytes());
        this.storage.addEntry(entry1);
        res = this.storage.getEntry(1L, 1L);
        Assert.assertEquals((Object)entry1, (Object)res);
        res = this.storage.getEntry(1L, 2L);
        Assert.assertEquals((Object)entry2, (Object)res);
        this.storage.flush();
        res = this.storage.getEntry(1L, 1L);
        Assert.assertEquals((Object)entry1, (Object)res);
        res = this.storage.getEntry(1L, 2L);
        Assert.assertEquals((Object)entry2, (Object)res);
    }

    @Test
    public void testEntriesOutOfOrderWithFlush() throws Exception {
        this.storage.setMasterKey(1L, "key".getBytes());
        ByteBuf entry2 = Unpooled.buffer((int)1024);
        entry2.writeLong(1L);
        entry2.writeLong(2L);
        entry2.writeBytes("entry-2".getBytes());
        this.storage.addEntry(entry2);
        try {
            this.storage.getEntry(1L, 1L);
            Assert.fail((String)"Entry doesn't exist");
        }
        catch (Bookie.NoEntryException noEntryException) {
            // empty catch block
        }
        ByteBuf res = this.storage.getEntry(1L, 2L);
        Assert.assertEquals((Object)entry2, (Object)res);
        res.release();
        this.storage.flush();
        try {
            this.storage.getEntry(1L, 1L);
            Assert.fail((String)"Entry doesn't exist");
        }
        catch (Bookie.NoEntryException noEntryException) {
            // empty catch block
        }
        res = this.storage.getEntry(1L, 2L);
        Assert.assertEquals((Object)entry2, (Object)res);
        res.release();
        ByteBuf entry1 = Unpooled.buffer((int)1024);
        entry1.writeLong(1L);
        entry1.writeLong(1L);
        entry1.writeBytes("entry-1".getBytes());
        this.storage.addEntry(entry1);
        res = this.storage.getEntry(1L, 1L);
        Assert.assertEquals((Object)entry1, (Object)res);
        res.release();
        res = this.storage.getEntry(1L, 2L);
        Assert.assertEquals((Object)entry2, (Object)res);
        res.release();
        this.storage.flush();
        res = this.storage.getEntry(1L, 1L);
        Assert.assertEquals((Object)entry1, (Object)res);
        res.release();
        res = this.storage.getEntry(1L, 2L);
        Assert.assertEquals((Object)entry2, (Object)res);
        res.release();
    }

    @Test
    public void testAddEntriesAfterDelete() throws Exception {
        this.storage.setMasterKey(1L, "key".getBytes());
        ByteBuf entry0 = Unpooled.buffer((int)1024);
        entry0.writeLong(1L);
        entry0.writeLong(0L);
        entry0.writeBytes("entry-0".getBytes());
        ByteBuf entry1 = Unpooled.buffer((int)1024);
        entry1.writeLong(1L);
        entry1.writeLong(1L);
        entry1.writeBytes("entry-1".getBytes());
        this.storage.addEntry(entry0);
        this.storage.addEntry(entry1);
        this.storage.flush();
        this.storage.deleteLedger(1L);
        this.storage.setMasterKey(1L, "key".getBytes());
        entry0 = Unpooled.buffer((int)1024);
        entry0.writeLong(1L);
        entry0.writeLong(0L);
        entry0.writeBytes("entry-0".getBytes());
        entry1 = Unpooled.buffer((int)1024);
        entry1.writeLong(1L);
        entry1.writeLong(1L);
        entry1.writeBytes("entry-1".getBytes());
        this.storage.addEntry(entry0);
        this.storage.addEntry(entry1);
        Assert.assertEquals((Object)entry0, (Object)this.storage.getEntry(1L, 0L));
        Assert.assertEquals((Object)entry1, (Object)this.storage.getEntry(1L, 1L));
        this.storage.flush();
    }

    @Test
    public void testGetLedgerDirsListeners() throws IOException {
        Assert.assertEquals((long)2L, (long)this.ledgerDirsManager.getListeners().size());
    }

    @Test
    public void testMultiLedgerDirectoryCheckpoint() throws Exception {
        int gcWaitTime = 1000;
        File firstDir = new File(this.tmpDir, "dir1");
        File secondDir = new File(this.tmpDir, "dir2");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime((long)gcWaitTime);
        conf.setProperty("dbStorage_writeCacheMaxSizeMb", (Object)4);
        conf.setProperty("dbStorage_readAheadCacheMaxSizeMb", (Object)4);
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        conf.setLedgerDirNames(new String[]{firstDir.getCanonicalPath(), secondDir.getCanonicalPath()});
        Bookie bookie = new Bookie(conf);
        ByteBuf entry1 = Unpooled.buffer((int)1024);
        entry1.writeLong(1L);
        entry1.writeLong(2L);
        entry1.writeBytes("entry-1".getBytes());
        bookie.getLedgerStorage().addEntry(entry1);
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark().setLogMark(1L, 2L);
        ((SingleDirectoryDbLedgerStorage)((DbLedgerStorage)bookie.getLedgerStorage()).getLedgerStorageList().get(0)).flush();
        File firstDirMark = new File(firstDir + "/current", "lastMark");
        File secondDirMark = new File(secondDir + "/current", "lastMark");
        try {
            this.readLogMark(firstDirMark);
            this.readLogMark(secondDirMark);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ByteBuf entry2 = Unpooled.buffer((int)1024);
        entry2.writeLong(2L);
        entry2.writeLong(1L);
        entry2.writeBytes("entry-2".getBytes());
        bookie.getLedgerStorage().addEntry(entry2);
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark().setLogMark(4L, 5L);
        ((SingleDirectoryDbLedgerStorage)((DbLedgerStorage)bookie.getLedgerStorage()).getLedgerStorageList().get(1)).flush();
        try {
            this.readLogMark(firstDirMark);
            this.readLogMark(secondDirMark);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        bookie.getLedgerStorage().flush();
        try {
            this.readLogMark(firstDirMark);
            this.readLogMark(secondDirMark);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CheckpointSourceList checkpointSource = new CheckpointSourceList(bookie.getJournals());
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark().setLogMark(7L, 8L);
        CheckpointSource.Checkpoint checkpoint = checkpointSource.newCheckpoint();
        checkpointSource.checkpointComplete(checkpoint, false);
        try {
            LogMark firstLogMark = this.readLogMark(firstDirMark);
            LogMark secondLogMark = this.readLogMark(secondDirMark);
            Assert.assertEquals((long)7L, (long)firstLogMark.getLogFileId());
            Assert.assertEquals((long)8L, (long)firstLogMark.getLogFileOffset());
            Assert.assertEquals((long)7L, (long)secondLogMark.getLogFileId());
            Assert.assertEquals((long)8L, (long)secondLogMark.getLogFileOffset());
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().readLog();
        LogMark logMark = ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark();
        Assert.assertEquals((long)7L, (long)logMark.getLogFileId());
        Assert.assertEquals((long)8L, (long)logMark.getLogFileOffset());
    }

    private LogMark readLogMark(File file) throws IOException {
        byte[] buff = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(buff);
        LogMark mark = new LogMark();
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead = fis.read(buff);
            if (bytesRead != 16) {
                throw new IOException("Couldn't read enough bytes from lastMark. Wanted 16, got " + bytesRead);
            }
        }
        bb.clear();
        mark.readLogMark(bb);
        return mark;
    }

    @Test
    public void testSingleLedgerDirectoryCheckpoint() throws Exception {
        int gcWaitTime = 1000;
        File ledgerDir = new File(this.tmpDir, "dir");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime((long)gcWaitTime);
        conf.setProperty("dbStorage_writeCacheMaxSizeMb", (Object)4);
        conf.setProperty("dbStorage_readAheadCacheMaxSizeMb", (Object)4);
        conf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        conf.setLedgerDirNames(new String[]{ledgerDir.getCanonicalPath()});
        Bookie bookie = new Bookie(conf);
        ByteBuf entry1 = Unpooled.buffer((int)1024);
        entry1.writeLong(1L);
        entry1.writeLong(2L);
        entry1.writeBytes("entry-1".getBytes());
        bookie.getLedgerStorage().addEntry(entry1);
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark().setLogMark(1L, 2L);
        ((SingleDirectoryDbLedgerStorage)((DbLedgerStorage)bookie.getLedgerStorage()).getLedgerStorageList().get(0)).flush();
        File ledgerDirMark = new File(ledgerDir + "/current", "lastMark");
        try {
            LogMark logMark = this.readLogMark(ledgerDirMark);
            Assert.assertEquals((long)1L, (long)logMark.getLogFileId());
            Assert.assertEquals((long)2L, (long)logMark.getLogFileOffset());
        }
        catch (Exception e) {
            Assert.fail();
        }
        ByteBuf entry2 = Unpooled.buffer((int)1024);
        entry2.writeLong(2L);
        entry2.writeLong(1L);
        entry2.writeBytes("entry-2".getBytes());
        bookie.getLedgerStorage().addEntry(entry2);
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark().setLogMark(4L, 5L);
        bookie.getLedgerStorage().flush();
        try {
            LogMark logMark = this.readLogMark(ledgerDirMark);
            Assert.assertEquals((long)4L, (long)logMark.getLogFileId());
            Assert.assertEquals((long)5L, (long)logMark.getLogFileOffset());
        }
        catch (Exception e) {
            Assert.fail();
        }
        CheckpointSourceList checkpointSource = new CheckpointSourceList(bookie.getJournals());
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark().setLogMark(7L, 8L);
        CheckpointSource.Checkpoint checkpoint = checkpointSource.newCheckpoint();
        checkpointSource.checkpointComplete(checkpoint, false);
        try {
            LogMark firstLogMark = this.readLogMark(ledgerDirMark);
            Assert.assertEquals((long)7L, (long)firstLogMark.getLogFileId());
            Assert.assertEquals((long)8L, (long)firstLogMark.getLogFileOffset());
        }
        catch (Exception e) {
            Assert.fail();
        }
        ((Journal)bookie.getJournals().get(0)).getLastLogMark().readLog();
        LogMark logMark = ((Journal)bookie.getJournals().get(0)).getLastLogMark().getCurMark();
        Assert.assertEquals((long)7L, (long)logMark.getLogFileId());
        Assert.assertEquals((long)8L, (long)logMark.getLogFileOffset());
    }
}

