/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieDecommissionTest
extends BookKeeperClusterTestCase {
    private static final Logger log = LoggerFactory.getLogger(BookieDecommissionTest.class);
    private static final int NUM_OF_BOOKIES = 6;
    private static BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static final String PASSWORD = "testPasswd";

    public BookieDecommissionTest() {
        super(6, 480);
        this.baseConf.setOpenLedgerRereplicationGracePeriod(String.valueOf(1000));
        this.setAutoRecoveryEnabled(true);
    }

    @Test
    public void testDecommissionBookie() throws Exception {
        int i;
        ZkLedgerUnderreplicationManager urLedgerMgr = new ZkLedgerUnderreplicationManager((AbstractConfiguration)this.baseClientConf, this.zkc);
        BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        LinkedList<Long> ledgerIds = new LinkedList<Long>();
        int numOfLedgers = 12;
        int numOfEntries = 12;
        for (i = 0; i < numOfLedgers; ++i) {
            LedgerHandle lh = this.bkc.createLedger(3, 2, digestType, PASSWORD.getBytes());
            ledgerIds.add(lh.getId());
            for (int j = 0; j < numOfEntries; ++j) {
                lh.addEntry("entry".getBytes());
            }
            lh.close();
        }
        for (i = 0; i < numOfLedgers; ++i) {
            LedgerHandle emptylh = this.bkc.createLedger(3, 2, digestType, PASSWORD.getBytes());
            ledgerIds.add(emptylh.getId());
            emptylh.close();
        }
        try {
            bkAdmin.decommissionBookie(((BookieServer)this.bs.get(0)).getBookieId());
            Assert.fail((String)"Expected BKIllegalOpException because that bookie is not shutdown yet");
        }
        catch (BKException.BKIllegalOpException i2) {
            // empty catch block
        }
        ServerConfiguration killedBookieConf = this.killBookie(1);
        bkAdmin.decommissionBookie(Bookie.getBookieId((ServerConfiguration)killedBookieConf));
        bkAdmin.triggerAudit();
        Thread.sleep(5000L);
        Iterator ledgersToRereplicate = urLedgerMgr.listLedgersToRereplicate(null);
        if (ledgersToRereplicate.hasNext()) {
            while (ledgersToRereplicate.hasNext()) {
                Long ledgerId = ((UnderreplicatedLedger)ledgersToRereplicate.next()).getLedgerId();
                log.error("Ledger: {} is underreplicated which is not expected", (Object)ledgerId);
            }
            Assert.fail((String)"There are not supposed to be any underreplicatedledgers");
        }
        killedBookieConf = this.killBookie(0);
        bkAdmin.decommissionBookie(Bookie.getBookieId((ServerConfiguration)killedBookieConf));
        bkAdmin.triggerAudit();
        Thread.sleep(5000L);
        ledgersToRereplicate = urLedgerMgr.listLedgersToRereplicate(null);
        if (ledgersToRereplicate.hasNext()) {
            while (ledgersToRereplicate.hasNext()) {
                Long ledgerId = ((UnderreplicatedLedger)ledgersToRereplicate.next()).getLedgerId();
                log.error("Ledger: {} is underreplicated which is not expected", (Object)ledgerId);
            }
            Assert.fail((String)"There are not supposed to be any underreplicatedledgers");
        }
        bkAdmin.close();
        for (Long id : ledgerIds) {
            this.verifyNoFragmentsOnBookie(id, Bookie.getBookieId((ServerConfiguration)killedBookieConf));
        }
    }

    @Test
    public void testDecommissionForLedgersWithMultipleSegmentsAndNotWriteClosed() throws Exception {
        ZkLedgerUnderreplicationManager urLedgerMgr = new ZkLedgerUnderreplicationManager((AbstractConfiguration)this.baseClientConf, this.zkc);
        BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        int numOfEntries = 12;
        LedgerHandle lh1 = this.bkc.createLedgerAdv(1L, this.numBookies, 3, 3, digestType, PASSWORD.getBytes(), null);
        LedgerHandle lh2 = this.bkc.createLedgerAdv(2L, this.numBookies, 3, 3, digestType, PASSWORD.getBytes(), null);
        LedgerHandle lh3 = this.bkc.createLedgerAdv(3L, this.numBookies, 3, 3, digestType, PASSWORD.getBytes(), null);
        LedgerHandle lh4 = this.bkc.createLedgerAdv(4L, this.numBookies, 3, 3, digestType, PASSWORD.getBytes(), null);
        for (int j = 0; j < numOfEntries; ++j) {
            lh1.addEntry((long)j, "data".getBytes());
            lh2.addEntry((long)j, "data".getBytes());
            lh3.addEntry((long)j, "data".getBytes());
            lh4.addEntry((long)j, "data".getBytes());
        }
        this.stopReplicationService();
        this.startNewBookie();
        Assert.assertEquals((String)"Number of Available Bookies", (long)7L, (long)bkAdmin.getAvailableBookies().size());
        BookieId killedBookieId = this.getBookie(0);
        log.warn("Killing bookie {}", (Object)killedBookieId);
        this.killBookie(0);
        for (int j = numOfEntries; j < 2 * numOfEntries; ++j) {
            lh1.addEntry((long)j, "data".getBytes());
            lh2.addEntry((long)j, "data".getBytes());
        }
        lh1.close();
        lh2.close();
        this.startReplicationService();
        bkAdmin.decommissionBookie(killedBookieId);
        bkAdmin.triggerAudit();
        Thread.sleep(5000L);
        Iterator ledgersToRereplicate = urLedgerMgr.listLedgersToRereplicate(null);
        if (ledgersToRereplicate.hasNext()) {
            while (ledgersToRereplicate.hasNext()) {
                long ledgerId = ((UnderreplicatedLedger)ledgersToRereplicate.next()).getLedgerId();
                log.error("Ledger: {} is underreplicated which is not expected", (Object)ledgerId);
            }
            Assert.fail((String)"There are not supposed to be any underreplicatedledgers");
        }
        bkAdmin.close();
        this.verifyNoFragmentsOnBookie(1L, killedBookieId);
        this.verifyNoFragmentsOnBookie(2L, killedBookieId);
        this.verifyNoFragmentsOnBookie(3L, killedBookieId);
        this.verifyNoFragmentsOnBookie(4L, killedBookieId);
    }

    @Test
    public void testDecommissionForEmptyLedgers() throws Exception {
        ZkLedgerUnderreplicationManager urLedgerMgr = new ZkLedgerUnderreplicationManager((AbstractConfiguration)this.baseClientConf, this.zkc);
        BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        LedgerHandle lh1 = this.bkc.createLedgerAdv(1L, this.numBookies, this.numBookies - 1, this.numBookies - 1, digestType, PASSWORD.getBytes(), null);
        LedgerHandle lh2 = this.bkc.createLedgerAdv(2L, this.numBookies, this.numBookies - 1, this.numBookies - 1, digestType, PASSWORD.getBytes(), null);
        LedgerHandle lh3 = this.bkc.createLedgerAdv(3L, this.numBookies, this.numBookies - 1, this.numBookies - 1, digestType, PASSWORD.getBytes(), null);
        LedgerHandle lh4 = this.bkc.createLedgerAdv(4L, this.numBookies, this.numBookies - 1, this.numBookies - 1, digestType, PASSWORD.getBytes(), null);
        lh1.close();
        lh2.close();
        this.startNewBookie();
        Assert.assertEquals((String)"Number of Available Bookies", (long)7L, (long)bkAdmin.getAvailableBookies().size());
        BookieId killedBookieId = this.getBookie(0);
        log.warn("Killing bookie {}", (Object)killedBookieId);
        this.killBookie(0);
        Assert.assertEquals((String)"Number of Available Bookies", (long)6L, (long)bkAdmin.getAvailableBookies().size());
        bkAdmin.decommissionBookie(killedBookieId);
        bkAdmin.triggerAudit();
        Thread.sleep(5000L);
        Iterator ledgersToRereplicate = urLedgerMgr.listLedgersToRereplicate(null);
        if (ledgersToRereplicate.hasNext()) {
            while (ledgersToRereplicate.hasNext()) {
                long ledgerId = ((UnderreplicatedLedger)ledgersToRereplicate.next()).getLedgerId();
                log.error("Ledger: {} is underreplicated which is not expected. {}", (Object)ledgerId, (Object)((UnderreplicatedLedger)ledgersToRereplicate.next()).getReplicaList());
            }
            Assert.fail((String)"There are not supposed to be any underreplicatedledgers");
        }
        bkAdmin.close();
        this.verifyNoFragmentsOnBookie(1L, killedBookieId);
        this.verifyNoFragmentsOnBookie(2L, killedBookieId);
        this.verifyNoFragmentsOnBookie(3L, killedBookieId);
        this.verifyNoFragmentsOnBookie(4L, killedBookieId);
        lh3.close();
        lh4.close();
    }

    private void verifyNoFragmentsOnBookie(long ledgerId, BookieId bookieId) throws BKException, InterruptedException {
        LedgerHandle lh = this.bkc.openLedgerNoRecovery(ledgerId, digestType, PASSWORD.getBytes());
        log.error("Ledger {} metadata: {}", (Object)ledgerId, (Object)lh.getLedgerMetadata());
        lh.getLedgerMetadata().getAllEnsembles().forEach((num, bookies) -> bookies.forEach(id -> Assert.assertNotEquals((Object)bookieId, (Object)id)));
        lh.close();
    }
}

