/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentV2RecoveryTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentV2RecoveryTest.class);
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public ConcurrentV2RecoveryTest() {
        super(4);
    }

    @Test
    public void testConcurrentOpen() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        ((ClientConfiguration)((ClientConfiguration)conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setNumChannelsPerBookie(16).setUseV2WireProtocol(true).setZkTimeout(20000)).setAddEntryTimeout(30).setReadEntryTimeout(30).setSpeculativeReadTimeout(0).setThrottleValue(0).setLedgerManagerFactoryClassName(HierarchicalLedgerManagerFactory.class.getName());
        BookKeeper bkc = new BookKeeper(conf);
        for (int j = 0; j < 10; ++j) {
            long ledgerId;
            LedgerHandle lh = bkc.createLedger(BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            lh.addEntry("foobar".getBytes());
            long finalLedgerId = ledgerId = lh.getId();
            ExecutorService executor = Executors.newFixedThreadPool(10);
            ArrayList futures = new ArrayList();
            CountDownLatch latch = new CountDownLatch(1);
            for (int i = 0; i < 5; ++i) {
                CompletableFuture completableFuture = new CompletableFuture();
                executor.submit(() -> {
                    latch.await();
                    bkc.asyncOpenLedger(finalLedgerId, BookKeeper.DigestType.CRC32, "testPasswd".getBytes(), (rc, handle, ctx) -> {
                        if (rc != 0) {
                            future.completeExceptionally(BKException.create((int)rc));
                        } else {
                            future.complete(handle);
                        }
                    }, null);
                    return future;
                });
                futures.add(completableFuture);
            }
            latch.countDown();
            for (Future future : futures) {
                try {
                    future.get(10L, TimeUnit.SECONDS);
                }
                catch (ExecutionException ee) {
                    Assert.assertEquals(ee.getCause().getClass(), BKException.BKLedgerRecoveryException.class);
                }
            }
        }
        bkc.close();
    }
}

