/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.MockBookieClient;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadLastConfirmedOpTest {
    private static final Logger log = LoggerFactory.getLogger(ReadLastConfirmedOpTest.class);
    private final BookieId bookie1 = new BookieSocketAddress("bookie1", 3181).toBookieId();
    private final BookieId bookie2 = new BookieSocketAddress("bookie2", 3181).toBookieId();
    OrderedExecutor executor = null;

    @Before
    public void setup() throws Exception {
        this.executor = OrderedExecutor.newBuilder().name("BookKeeperClientWorker").numThreads(1).build();
    }

    @After
    public void teardown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Test
    public void testBookieFailsAfterLedgerMissingOnFirst() throws Exception {
        long ledgerId = 61451L;
        ArrayList ensemble = Lists.newArrayList((Object[])new BookieId[]{this.bookie1, this.bookie2});
        byte[] ledgerKey = new byte[]{};
        MockBookieClient bookieClient = new MockBookieClient(this.executor);
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(2, 2, 2);
        DigestManager digestManager = DigestManager.instantiate((long)ledgerId, (byte[])ledgerKey, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)true);
        CompletableFuture blocker = new CompletableFuture();
        bookieClient.setPreReadHook((bookie, lId, entryId) -> {
            if (bookie.equals((Object)this.bookie1)) {
                return CompletableFuture.completedFuture(null);
            }
            return blocker;
        });
        CompletableFuture promise = new CompletableFuture();
        ReadLastConfirmedOp op = new ReadLastConfirmedOp((BookieClient)bookieClient, (DistributionSchedule)schedule, digestManager, ledgerId, (List)ensemble, ledgerKey, (rc, data) -> {
            if (rc != 0) {
                promise.completeExceptionally(BKException.create((int)rc));
            } else {
                promise.complete(data);
            }
        });
        op.initiateWithFencing();
        while (op.getNumResponsesPending() > 1) {
            Thread.sleep(100L);
        }
        blocker.completeExceptionally(new BKException.BKBookieHandleNotAvailableException());
        promise.get();
    }
}

