/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.AbstractDNSToSwitchMapping;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.ScriptBasedMapping;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRackawareEnsemblePlacementPolicy
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestRackawareEnsemblePlacementPolicy.class);
    RackawareEnsemblePlacementPolicy repp;
    final List<BookieId> ensemble = new ArrayList<BookieId>();
    DistributionSchedule.WriteSet writeSet = DistributionSchedule.NULL_WRITE_SET;
    ClientConfiguration conf = new ClientConfiguration();
    BookieSocketAddress addr1;
    BookieSocketAddress addr2;
    BookieSocketAddress addr3;
    BookieSocketAddress addr4;
    HashedWheelTimer timer;
    final int minNumRacksPerWriteQuorumConfValue = 2;

    protected void setUp() throws Exception {
        super.setUp();
        StaticDNSResolver.reset();
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack("127.0.0.1", "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack("localhost", "/default-region/default-rack");
        LOG.info("Set up static DNS Resolver.");
        this.conf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        this.conf.setMinNumRacksPerWriteQuorum(2);
        this.addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        this.addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        this.addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        this.addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/default-region/rack1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/default-region/rack2");
        this.ensemble.add(this.addr1.toBookieId());
        this.ensemble.add(this.addr2.toBookieId());
        this.ensemble.add(this.addr3.toBookieId());
        this.ensemble.add(this.addr4.toBookieId());
        this.writeSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 1, 2, 3});
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
    }

    protected void tearDown() throws Exception {
        this.repp.uninitalize();
        super.tearDown();
    }

    static BookiesHealthInfo getBookiesHealthInfo() {
        return TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), new HashMap<BookieId, Long>());
    }

    static BookiesHealthInfo getBookiesHealthInfo(final Map<BookieId, Long> bookieFailureHistory, final Map<BookieId, Long> bookiePendingRequests) {
        return new BookiesHealthInfo(){

            public long getBookieFailureHistory(BookieId bookieSocketAddress) {
                return bookieFailureHistory.getOrDefault(bookieSocketAddress, -1L);
            }

            public long getBookiePendingRequests(BookieId bookieSocketAddress) {
                return bookiePendingRequests.getOrDefault(bookieSocketAddress, 0L);
            }
        };
    }

    static void updateMyRack(String rack) throws Exception {
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), rack);
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostName(), rack);
        StaticDNSResolver.addNodeToRack("127.0.0.1", rack);
        StaticDNSResolver.addNodeToRack("localhost", rack);
    }

    @Test
    public void testInitalize() throws Exception {
        String dnsResolverName = this.conf.getString("reppDnsResolverClass", ScriptBasedMapping.class.getName());
        DNSToSwitchMapping dnsResolver = (DNSToSwitchMapping)ReflectionUtils.newInstance((String)dnsResolverName, DNSToSwitchMapping.class);
        AbstractDNSToSwitchMapping tmp = (AbstractDNSToSwitchMapping)dnsResolver;
        TestRackawareEnsemblePlacementPolicy.assertNull((Object)tmp.getBookieAddressResolver());
        dnsResolver.setBookieAddressResolver(this.repp.bookieAddressResolver);
        TestRackawareEnsemblePlacementPolicy.assertNotNull((Object)tmp.getBookieAddressResolver());
    }

    @Test
    public void testNodeDown() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeReadOnly() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        HashSet<BookieId> ro = new HashSet<BookieId>();
        ro.add(this.addr1.toBookieId());
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)reorderSet, (Object)origWriteSet);
    }

    @Test
    public void testNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1.toBookieId(), 0L);
        this.repp.registerSlowBookie(this.addr2.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        bookiePendingMap.put(this.addr2.toBookieId(), 2L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesDown() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        addrs.remove(this.addr2.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndReadOnly() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        addrs.remove(this.addr2.toBookieId());
        HashSet<BookieId> roAddrs = new HashSet<BookieId>();
        roAddrs.add(this.addr2.toBookieId());
        this.repp.onClusterChanged(addrs, roAddrs);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 1, 0});
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        addrs.remove(this.addr2.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 3, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndReadOnlyAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        addrs.remove(this.addr2.toBookieId());
        HashSet<BookieId> ro = new HashSet<BookieId>();
        ro.add(this.addr2.toBookieId());
        this.repp.registerSlowBookie(this.addr3.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr3.toBookieId(), 1L);
        addrs.remove(this.addr2.toBookieId());
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testPendingRequestsReorder() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        ClientConfiguration conf = (ClientConfiguration)this.conf.clone();
        conf.setReorderThresholdPendingRequests(10);
        this.repp.initialize(conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 20L);
        bookiePendingMap.put(this.addr2.toBookieId(), 7L);
        bookiePendingMap.put(this.addr3.toBookieId(), 1L);
        bookiePendingMap.put(this.addr4.toBookieId(), 5L);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{2, 0, 1, 3});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"expect bookie idx 2 first", (Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testPendingRequestsReorderLargeEnsemble() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        ClientConfiguration conf = (ClientConfiguration)this.conf.clone();
        conf.setReorderThresholdPendingRequests(10);
        this.repp.initialize(conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        bookiePendingMap.put(this.addr2.toBookieId(), 20L);
        bookiePendingMap.put(this.addr3.toBookieId(), 0L);
        bookiePendingMap.put(this.addr4.toBookieId(), 12L);
        bookiePendingMap.put(addr5.toBookieId(), 9L);
        bookiePendingMap.put(addr6.toBookieId(), 2L);
        bookiePendingMap.put(addr7.toBookieId(), 10L);
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>();
        ensemble.add(this.addr1.toBookieId());
        ensemble.add(this.addr2.toBookieId());
        ensemble.add(this.addr3.toBookieId());
        ensemble.add(this.addr4.toBookieId());
        ensemble.add(addr5.toBookieId());
        ensemble.add(addr6.toBookieId());
        ensemble.add(addr7.toBookieId());
        DistributionSchedule.WriteSet writeSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 3, 5, 6});
        DistributionSchedule.WriteSet origWriteSet = writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{5, 1, 3, 6});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"expect bookie idx 5 first", (Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testPendingRequestsNoReorder1() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        ClientConfiguration conf = (ClientConfiguration)this.conf.clone();
        conf.setReorderThresholdPendingRequests(10);
        this.repp.initialize(conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 10L);
        bookiePendingMap.put(this.addr2.toBookieId(), 7L);
        bookiePendingMap.put(this.addr3.toBookieId(), 1L);
        bookiePendingMap.put(this.addr4.toBookieId(), 5L);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"writeSet should be in original order", (Object)origWriteSet, (Object)reorderSet);
    }

    @Test
    public void testPendingRequestsNoReorder2() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RackawareEnsemblePlacementPolicy();
        ClientConfiguration conf = (ClientConfiguration)this.conf.clone();
        conf.setReorderThresholdPendingRequests(10);
        this.repp.initialize(conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        bookiePendingMap.put(this.addr2.toBookieId(), 7L);
        bookiePendingMap.put(this.addr3.toBookieId(), 1L);
        bookiePendingMap.put(this.addr4.toBookieId(), 5L);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"writeSet should be in original order", (Object)origWriteSet, (Object)reorderSet);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        EnsemblePlacementPolicy.PlacementResult replaceBookieResponse = this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), new HashSet());
        BookieId replacedBookie = (BookieId)replaceBookieResponse.getResult();
        EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)addr3.toBookieId(), (Object)replacedBookie);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInDifferentRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r4");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        EnsemblePlacementPolicy.PlacementResult replaceBookieResponse = this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs);
        BookieId replacedBookie = (BookieId)replaceBookieResponse.getResult();
        EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)addr1.toBookieId().equals((Object)replacedBookie));
        TestRackawareEnsemblePlacementPolicy.assertTrue((addr3.toBookieId().equals((Object)replacedBookie) || addr4.toBookieId().equals((Object)replacedBookie) ? 1 : 0) != 0);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
    }

    @Test
    public void testReplaceBookieWithNotEnoughBookies() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r4");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        excludedAddrs.add(addr3.toBookieId());
        excludedAddrs.add(addr4.toBookieId());
        try {
            this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRackAsEnsemble() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        ArrayList<BookieId> ensembleBookies = new ArrayList<BookieId>();
        ensembleBookies.add(addr2.toBookieId());
        ensembleBookies.add(addr4.toBookieId());
        EnsemblePlacementPolicy.PlacementResult replaceBookieResponse = this.repp.replaceBookie(1, 1, 1, null, ensembleBookies, addr4.toBookieId(), new HashSet());
        BookieId replacedBookie = (BookieId)replaceBookieResponse.getResult();
        EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)addr1.toBookieId(), (Object)replacedBookie);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
    }

    @Test
    public void testNewEnsembleWithSingleRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.9", 3181);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            List ensemble = (List)ensembleResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)0, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, 2, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)isEnsembleAdheringToPlacementPolicy);
            EnsemblePlacementPolicy.PlacementResult ensembleResponse2 = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
            List ensemble2 = (List)ensembleResponse2.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy2 = ensembleResponse2.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)0, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble2, 2, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)isEnsembleAdheringToPlacementPolicy);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testSingleRackWithEnforceMinNumRacks() throws Exception {
        List ensemble;
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/default-region/default-rack");
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(2);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ensemble = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since there is only one rack.");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        try {
            ensemble = (List)this.repp.newEnsemble(3, 2, 2, new HashSet(), (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE).getResult();
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since there is only one rack.");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testNewEnsembleWithEnforceMinNumRacks() throws Exception {
        String defaultRackForThisTest = "/default-region/default-rack";
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack(defaultRackForThisTest);
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)statsLogger, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack(defaultRackForThisTest);
        Gauge numBookiesInDefaultRackGauge = statsLogger.getGauge("NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK");
        int numOfRacks = 3;
        int numOfBookiesPerRack = 5;
        BookieId[] bookieSocketAddresses = new BookieId[numOfRacks * numOfBookiesPerRack];
        for (int i = 0; i < numOfRacks; ++i) {
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                bookieSocketAddresses[index] = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + index, "/default-region/r" + i);
            }
        }
        int numOfBookiesInDefaultRack = 5;
        BookieId[] bookieSocketAddressesInDefaultRack = new BookieId[numOfBookiesInDefaultRack];
        for (int i = 0; i < numOfBookiesInDefaultRack; ++i) {
            bookieSocketAddressesInDefaultRack[i] = new BookieSocketAddress("128.0.0." + (100 + i), 3181).toBookieId();
            StaticDNSResolver.addNodeToRack("128.0.0." + (100 + i), defaultRackForThisTest);
        }
        List<BookieId> nonDefaultRackBookiesList = Arrays.asList(bookieSocketAddresses);
        List<BookieId> defaultRackBookiesList = Arrays.asList(bookieSocketAddressesInDefaultRack);
        HashSet<BookieId> writableBookies = new HashSet<BookieId>(nonDefaultRackBookiesList);
        writableBookies.addAll(defaultRackBookiesList);
        this.repp.onClusterChanged(writableBookies, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)numOfBookiesInDefaultRack, (Object)numBookiesInDefaultRackGauge.getSample());
        try {
            this.repp.newEnsemble(8, 4, 4, null, new HashSet());
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since there are only 3 non-default racks");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        try {
            this.repp.newEnsemble(8, 4, 4, new HashSet<BookieId>(defaultRackBookiesList), (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since there are only 3 non-default racks and defaultrack bookies are excluded");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        int ensembleSize = numOfRacks * numOfBookiesPerRack;
        int writeQuorumSize = numOfRacks;
        int ackQuorumSize = numOfRacks;
        EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, new HashSet());
        List ensemble = (List)ensembleResponse.getResult();
        EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"Number of writeQuorum sets covered", (int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, clientConf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
        ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, new HashSet<BookieId>(defaultRackBookiesList), (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE);
        ensemble = (List)ensembleResponse.getResult();
        isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"Number of writeQuorum sets covered", (int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, clientConf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
    }

    @Test
    public void testNewEnsembleWithSufficientRacksAndEnforceMinNumRacks() throws Exception {
        this.repp.uninitalize();
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        int writeQuorumSize = 3;
        int ackQuorumSize = 3;
        int effectiveMinNumRacksPerWriteQuorum = Math.min(minNumRacksPerWriteQuorum, writeQuorumSize);
        int numOfRacks = 2 * effectiveMinNumRacksPerWriteQuorum - 1;
        int numOfBookiesPerRack = 20;
        BookieId[] bookieSocketAddresses = new BookieId[numOfRacks * numOfBookiesPerRack];
        for (int i = 0; i < numOfRacks; ++i) {
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                bookieSocketAddresses[index] = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + index, "/default-region/r" + i);
            }
        }
        HashSet addrs = new HashSet();
        this.repp.onClusterChanged(new HashSet<BookieId>(Arrays.asList(bookieSocketAddresses)), new HashSet());
        for (int ensembleSize = effectiveMinNumRacksPerWriteQuorum; ensembleSize < 40; ++ensembleSize) {
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, new HashSet());
            List ensemble = (List)ensembleResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((String)"Number of writeQuorum sets covered", (int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, clientConf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
            ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, new HashSet(), (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE);
            ensemble = (List)ensembleResponse.getResult();
            isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((String)"Number of writeQuorum sets covered", (int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, clientConf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
        }
    }

    @Test
    public void testReplaceBookieWithEnforceMinNumRacks() throws Exception {
        String defaultRackForThisTest = "/default-region/default-rack";
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack(defaultRackForThisTest);
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)statsLogger, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack(defaultRackForThisTest);
        Gauge numBookiesInDefaultRackGauge = statsLogger.getGauge("NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK");
        int numOfRacks = 3;
        int numOfBookiesPerRack = 5;
        HashSet<BookieId> bookieSocketAddresses = new HashSet<BookieId>();
        HashMap<BookieId, String> bookieRackMap = new HashMap<BookieId, String>();
        for (int i = 0; i < numOfRacks; ++i) {
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                BookieId bookieAddress = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                String rack = "/default-region/r" + i;
                StaticDNSResolver.addNodeToRack("128.0.0." + index, rack);
                bookieSocketAddresses.add(bookieAddress);
                bookieRackMap.put(bookieAddress, rack);
            }
        }
        int numOfBookiesInDefaultRack = 5;
        BookieId[] bookieSocketAddressesInDefaultRack = new BookieId[numOfBookiesInDefaultRack];
        for (int i = 0; i < numOfBookiesInDefaultRack; ++i) {
            bookieSocketAddressesInDefaultRack[i] = new BookieSocketAddress("127.0.0." + (i + 100), 3181).toBookieId();
            StaticDNSResolver.addNodeToRack("127.0.0." + (i + 100), defaultRackForThisTest);
        }
        HashSet<BookieId> nonDefaultRackBookiesList = bookieSocketAddresses;
        List<BookieId> defaultRackBookiesList = Arrays.asList(bookieSocketAddressesInDefaultRack);
        HashSet<BookieId> writableBookies = new HashSet<BookieId>(nonDefaultRackBookiesList);
        writableBookies.addAll(defaultRackBookiesList);
        this.repp.onClusterChanged(writableBookies, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)numOfBookiesInDefaultRack, (Object)numBookiesInDefaultRackGauge.getSample());
        int ensembleSize = numOfRacks * numOfBookiesPerRack;
        int writeQuorumSize = numOfRacks;
        int ackQuorumSize = numOfRacks;
        EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, new HashSet());
        List ensemble = (List)ensembleResponse.getResult();
        BookieId bookieInEnsembleToBeReplaced = (BookieId)ensemble.get(7);
        String rackOfOtherBookieInEnsemble = (String)bookieRackMap.get(ensemble.get(8));
        BookieSocketAddress newBookieAddress1 = new BookieSocketAddress("128.0.0.100", 3181);
        StaticDNSResolver.addNodeToRack(newBookieAddress1.getHostName(), rackOfOtherBookieInEnsemble);
        bookieSocketAddresses.add(newBookieAddress1.toBookieId());
        writableBookies.add(newBookieAddress1.toBookieId());
        bookieRackMap.put(newBookieAddress1.toBookieId(), rackOfOtherBookieInEnsemble);
        this.repp.onClusterChanged(writableBookies, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)numOfBookiesInDefaultRack, (Object)numBookiesInDefaultRackGauge.getSample());
        try {
            this.repp.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, null, ensemble, bookieInEnsembleToBeReplaced, new HashSet());
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since there are no more bookies in rackof 'bookieInEnsembleToReplace'and new bookie added belongs to the rack of some other bookie in the ensemble");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        String newRack = "/default-region/r100";
        BookieSocketAddress newBookieAddress2 = new BookieSocketAddress("128.0.0.101", 3181);
        StaticDNSResolver.addNodeToRack(newBookieAddress2.getHostName(), newRack);
        bookieSocketAddresses.add(newBookieAddress2.toBookieId());
        writableBookies.add(newBookieAddress2.toBookieId());
        bookieRackMap.put(newBookieAddress2.toBookieId(), newRack);
        this.repp.onClusterChanged(writableBookies, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)numOfBookiesInDefaultRack, (Object)numBookiesInDefaultRackGauge.getSample());
        EnsemblePlacementPolicy.PlacementResult replaceBookieResponse = this.repp.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, null, ensemble, bookieInEnsembleToBeReplaced, new HashSet());
        BookieId replacedBookieAddress = (BookieId)replaceBookieResponse.getResult();
        EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"It should be newBookieAddress2", (Object)newBookieAddress2.toBookieId(), (Object)replacedBookieAddress);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
        HashSet<BookieId> bookiesToExclude = new HashSet<BookieId>();
        bookiesToExclude.add(newBookieAddress2.toBookieId());
        this.repp.onClusterChanged(writableBookies, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)numOfBookiesInDefaultRack, (Object)numBookiesInDefaultRackGauge.getSample());
        try {
            this.repp.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, null, ensemble, bookieInEnsembleToBeReplaced, bookiesToExclude);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since the only available bookie to replaceis added to excludedBookies list");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        String rackOfBookieToBeReplaced = (String)bookieRackMap.get(bookieInEnsembleToBeReplaced);
        BookieSocketAddress newBookieAddress3 = new BookieSocketAddress("128.0.0.102", 3181);
        StaticDNSResolver.addNodeToRack(newBookieAddress3.getHostName(), rackOfBookieToBeReplaced);
        bookieSocketAddresses.add(newBookieAddress3.toBookieId());
        writableBookies.add(newBookieAddress3.toBookieId());
        bookieRackMap.put(newBookieAddress3.toBookieId(), rackOfBookieToBeReplaced);
        this.repp.onClusterChanged(writableBookies, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)numOfBookiesInDefaultRack, (Object)numBookiesInDefaultRackGauge.getSample());
        replaceBookieResponse = this.repp.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, null, ensemble, bookieInEnsembleToBeReplaced, bookiesToExclude);
        replacedBookieAddress = (BookieId)replaceBookieResponse.getResult();
        isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"It should be newBookieAddress3", (Object)newBookieAddress3.toBookieId(), (Object)replacedBookieAddress);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
    }

    @Test
    public void testSelectBookieFromNetworkLoc() throws Exception {
        this.repp.uninitalize();
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        int numOfRacks = 3;
        int numOfBookiesPerRack = 5;
        String[] rackLocationNames = new String[numOfRacks];
        ArrayList<BookieId> bookieSocketAddresses = new ArrayList<BookieId>();
        HashMap<BookieId, String> bookieRackMap = new HashMap<BookieId, String>();
        for (int i = 0; i < numOfRacks; ++i) {
            rackLocationNames[i] = "/default-region/r" + i;
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                BookieId bookieAddress = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + index, rackLocationNames[i]);
                bookieSocketAddresses.add(bookieAddress);
                bookieRackMap.put(bookieAddress, rackLocationNames[i]);
            }
        }
        String nonExistingRackLocation = "/default-region/r25";
        this.repp.onClusterChanged(new HashSet(bookieSocketAddresses), new HashSet());
        String rack = (String)bookieRackMap.get(bookieSocketAddresses.get(0));
        BookieNode bookieNode = this.repp.selectFromNetworkLocation(rack, new HashSet(), (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
        String recRack = bookieNode.getNetworkLocation();
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"Rack of node", (String)rack, (String)recRack);
        try {
            this.repp.selectFromNetworkLocation(nonExistingRackLocation, new HashSet(), (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since there are no bookies in this rack");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        this.repp.selectFromNetworkLocation(nonExistingRackLocation, new HashSet(), (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, true);
        HashSet excludeBookiesOfRackR0 = new HashSet();
        for (int i = 0; i < numOfBookiesPerRack; ++i) {
            excludeBookiesOfRackR0.add(bookieSocketAddresses.get(i));
        }
        Set excludeBookieNodesOfRackR0 = this.repp.convertBookiesToNodes(excludeBookiesOfRackR0);
        try {
            this.repp.selectFromNetworkLocation((String)bookieRackMap.get(bookieSocketAddresses.get(0)), excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since all the bookies in r0 are added to the exclusion list");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        bookieNode = this.repp.selectFromNetworkLocation((String)bookieRackMap.get(bookieSocketAddresses.get(0)), excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, true);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("BookieNode should not be from Rack /r0" + bookieNode.getNetworkLocation()), (rackLocationNames[1].equals(bookieNode.getNetworkLocation()) || rackLocationNames[2].equals(bookieNode.getNetworkLocation()) ? 1 : 0) != 0);
    }

    @Test
    public void testSelectBookieFromExcludingRacks() throws Exception {
        this.repp.uninitalize();
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        int numOfRacks = 3;
        int numOfBookiesPerRack = 5;
        String[] rackLocationNames = new String[numOfRacks];
        ArrayList<BookieId> bookieSocketAddresses = new ArrayList<BookieId>();
        HashMap<BookieId, String> bookieRackMap = new HashMap<BookieId, String>();
        for (int i = 0; i < numOfRacks; ++i) {
            rackLocationNames[i] = "/default-region/r" + i;
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                BookieId bookieAddress = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + index, rackLocationNames[i]);
                bookieSocketAddresses.add(bookieAddress);
                bookieRackMap.put(bookieAddress, rackLocationNames[i]);
            }
        }
        this.repp.onClusterChanged(new HashSet(bookieSocketAddresses), new HashSet());
        HashSet excludeBookiesOfRackR0 = new HashSet();
        for (int i = 0; i < numOfBookiesPerRack; ++i) {
            excludeBookiesOfRackR0.add(bookieSocketAddresses.get(i));
        }
        Set excludeBookieNodesOfRackR0 = this.repp.convertBookiesToNodes(excludeBookiesOfRackR0);
        HashSet<String> excludeRacksRackR1AndR2 = new HashSet<String>();
        excludeRacksRackR1AndR2.add(rackLocationNames[1]);
        excludeRacksRackR1AndR2.add(rackLocationNames[2]);
        try {
            this.repp.selectFromNetworkLocation(excludeRacksRackR1AndR2, excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception racks R1 and R2 areexcluded and all the bookies in r0 are added to the exclusion list");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        BookieNode bookieNode = this.repp.selectFromNetworkLocation(excludeRacksRackR1AndR2, new HashSet(), (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("BookieNode should be from Rack /r0" + bookieNode.getNetworkLocation()), (boolean)rackLocationNames[0].equals(bookieNode.getNetworkLocation()));
        bookieNode = this.repp.selectFromNetworkLocation(excludeRacksRackR1AndR2, excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, true);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("BookieNode should not be from Rack /r0" + bookieNode.getNetworkLocation()), (rackLocationNames[1].equals(bookieNode.getNetworkLocation()) || rackLocationNames[2].equals(bookieNode.getNetworkLocation()) ? 1 : 0) != 0);
    }

    @Test
    public void testSelectBookieFromNetworkLocAndExcludingRacks() throws Exception {
        this.repp.uninitalize();
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        int numOfRacks = 3;
        int numOfBookiesPerRack = 5;
        String[] rackLocationNames = new String[numOfRacks];
        ArrayList<BookieId> bookieSocketAddresses = new ArrayList<BookieId>();
        HashMap<BookieId, String> bookieRackMap = new HashMap<BookieId, String>();
        for (int i = 0; i < numOfRacks; ++i) {
            rackLocationNames[i] = "/default-region/r" + i;
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                BookieId bookieAddress = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + index, rackLocationNames[i]);
                bookieSocketAddresses.add(bookieAddress);
                bookieRackMap.put(bookieAddress, rackLocationNames[i]);
            }
        }
        String nonExistingRackLocation = "/default-region/r25";
        this.repp.onClusterChanged(new HashSet(bookieSocketAddresses), new HashSet());
        HashSet excludeBookiesOfRackR0 = new HashSet();
        for (int i = 0; i < numOfBookiesPerRack; ++i) {
            excludeBookiesOfRackR0.add(bookieSocketAddresses.get(i));
        }
        Set excludeBookieNodesOfRackR0 = this.repp.convertBookiesToNodes(excludeBookiesOfRackR0);
        HashSet<String> excludeRacksRackR1AndR2 = new HashSet<String>();
        excludeRacksRackR1AndR2.add(rackLocationNames[1]);
        excludeRacksRackR1AndR2.add(rackLocationNames[2]);
        try {
            this.repp.selectFromNetworkLocation(nonExistingRackLocation, excludeRacksRackR1AndR2, excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception racks R1 and R2 are excluded and all the bookies inr0 are added to the exclusion list");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        BookieNode bookieNode = this.repp.selectFromNetworkLocation(rackLocationNames[0], excludeRacksRackR1AndR2, new HashSet(), (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("BookieNode should be from Rack /r0" + bookieNode.getNetworkLocation()), (boolean)rackLocationNames[0].equals(bookieNode.getNetworkLocation()));
        bookieNode = this.repp.selectFromNetworkLocation(rackLocationNames[0], new HashSet(), excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("BookieNode should not be from Rack /r0" + bookieNode.getNetworkLocation()), (rackLocationNames[1].equals(bookieNode.getNetworkLocation()) || rackLocationNames[2].equals(bookieNode.getNetworkLocation()) ? 1 : 0) != 0);
        bookieNode = this.repp.selectFromNetworkLocation(nonExistingRackLocation, excludeRacksRackR1AndR2, excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, true);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("BookieNode should not be from Rack /r0" + bookieNode.getNetworkLocation()), (rackLocationNames[1].equals(bookieNode.getNetworkLocation()) || rackLocationNames[2].equals(bookieNode.getNetworkLocation()) ? 1 : 0) != 0);
    }

    @Test
    public void testSelectBookieByExcludingRacksAndBookies() throws Exception {
        this.repp.uninitalize();
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        this.repp = new RackawareEnsemblePlacementPolicy(true);
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        int numOfRacks = 3;
        int numOfBookiesPerRack = 5;
        String[] rackLocationNames = new String[numOfRacks];
        ArrayList<BookieId> bookieSocketAddresses = new ArrayList<BookieId>();
        HashMap<BookieId, String> bookieRackMap = new HashMap<BookieId, String>();
        for (int i = 0; i < numOfRacks; ++i) {
            rackLocationNames[i] = "/default-region/r" + i;
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                BookieId bookieAddress = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + index, rackLocationNames[i]);
                bookieSocketAddresses.add(bookieAddress);
                bookieRackMap.put(bookieAddress, rackLocationNames[i]);
            }
        }
        this.repp.onClusterChanged(new HashSet(bookieSocketAddresses), new HashSet());
        HashSet excludeBookiesOfRackR0 = new HashSet();
        for (int i = 0; i < numOfBookiesPerRack; ++i) {
            excludeBookiesOfRackR0.add(bookieSocketAddresses.get(i));
        }
        Set excludeBookieNodesOfRackR0 = this.repp.convertBookiesToNodes(excludeBookiesOfRackR0);
        HashSet<String> excludeRackR1 = new HashSet<String>();
        excludeRackR1.add(rackLocationNames[1]);
        BookieNode nodeSelected = this.repp.selectFromNetworkLocation(excludeRackR1, excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"BookieNode should be from Rack2", (String)rackLocationNames[2], (String)nodeSelected.getNetworkLocation());
        try {
            this.repp.selectFromNetworkLocation(excludeRackR1, excludeBookieNodesOfRackR0, (candidate, chosenBookies) -> false, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, false);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since we are using false predicate");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        try {
            this.repp.selectFromNetworkLocation(excludeRackR1, excludeBookieNodesOfRackR0, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)new ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode>(){

                public boolean addNode(BookieNode node) {
                    return false;
                }

                public List<BookieId> toList() {
                    return null;
                }

                public boolean validate() {
                    return false;
                }
            }, false);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception since ensemble rejects all the nodes");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRacks() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r2");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            int ensembleSize = 3;
            int writeQuorumSize = 2;
            int acqQuorumSize = 2;
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, acqQuorumSize, null, new HashSet());
            List ensemble = (List)ensembleResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
            int numCovered = TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver);
            TestRackawareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 && numCovered < 3 ? 1 : 0) != 0);
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)isEnsembleAdheringToPlacementPolicy);
            ensembleSize = 4;
            EnsemblePlacementPolicy.PlacementResult ensembleResponse2 = this.repp.newEnsemble(ensembleSize, writeQuorumSize, acqQuorumSize, null, new HashSet());
            List ensemble2 = (List)ensembleResponse2.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy2 = ensembleResponse2.isAdheringToPolicy();
            numCovered = TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble2, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver);
            TestRackawareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 && numCovered < 3 ? 1 : 0) != 0);
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)isEnsembleAdheringToPlacementPolicy2);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRacksWithCommonRack() throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        clientConf.setMinNumRacksPerWriteQuorum(3);
        this.repp.uninitalize();
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.10", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/default-region/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        addrs.add(addr10.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            int ensembleSize = 10;
            int writeQuorumSize = 10;
            int ackQuorumSize = 2;
            for (int i = 0; i < 50; ++i) {
                HashSet excludeBookies = new HashSet();
                EnsemblePlacementPolicy.PlacementResult placementResult = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, excludeBookies);
            }
        }
        catch (Exception e) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Can not new ensemble selection succeed");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRacksWithCommonRackFailed() throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        clientConf.setMinNumRacksPerWriteQuorum(3);
        this.repp.uninitalize();
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.10", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/default-region/r2");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        addrs.add(addr10.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            int ensembleSize = 10;
            int writeQuorumSize = 10;
            int ackQuorumSize = 2;
            HashSet excludeBookies = new HashSet();
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, excludeBookies);
            TestRackawareEnsemblePlacementPolicy.fail((String)"Can not new ensemble selection succeed");
        }
        catch (Exception e) {
            TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)(e instanceof BKException.BKNotEnoughBookiesException));
        }
    }

    @Test
    public void testNewEnsembleWithPickDifferentRack() throws Exception {
        List ensemble;
        EnsemblePlacementPolicy.PlacementResult ensembleResponse;
        int i;
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        int ensembleSize = 3;
        int writeQuorumSize = 3;
        int ackQuorumSize = 2;
        HashSet excludeBookies = new HashSet();
        for (i = 0; i < 50; ++i) {
            ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, excludeBookies);
            ensemble = (List)ensembleResponse.getResult();
            if (!ensemble.contains(addr1.toBookieId()) || !ensemble.contains(addr2.toBookieId())) continue;
            TestRackawareEnsemblePlacementPolicy.fail((String)"addr1 and addr2 is same rack.");
        }
        addrs.remove(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        for (i = 0; i < 50; ++i) {
            ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, excludeBookies);
            ensemble = (List)ensembleResponse.getResult();
            TestRackawareEnsemblePlacementPolicy.assertTrue((ensemble.contains(addr1.toBookieId()) && ensemble.contains(addr2.toBookieId()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMinNumRacksPerWriteQuorumOfRacks() throws Exception {
        int numOfRacksToCreate = 6;
        int numOfNodesInEachRack = 5;
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        for (int i = 0; i < numOfRacksToCreate; ++i) {
            for (int j = 0; j < numOfNodesInEachRack; ++j) {
                BookieId addr = new BookieSocketAddress("128.0.0." + (i * numOfNodesInEachRack + j), 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + (i * numOfNodesInEachRack + j), "/default-region/r" + i);
                addrs.add(addr);
            }
        }
        try {
            ClientConfiguration newConf = new ClientConfiguration((AbstractConfiguration)this.conf);
            int minNumRacksPerWriteQuorum = 4;
            int ensembleSize = 12;
            int writeQuorumSize = 6;
            this.validateNumOfWriteQuorumsCoveredInEnsembleCreation(addrs, minNumRacksPerWriteQuorum, ensembleSize, writeQuorumSize);
            newConf = new ClientConfiguration((AbstractConfiguration)this.conf);
            minNumRacksPerWriteQuorum = 6;
            ensembleSize = 6;
            writeQuorumSize = 6;
            this.validateNumOfWriteQuorumsCoveredInEnsembleCreation(addrs, minNumRacksPerWriteQuorum, ensembleSize, writeQuorumSize);
            newConf = new ClientConfiguration((AbstractConfiguration)this.conf);
            minNumRacksPerWriteQuorum = 6;
            writeQuorumSize = ensembleSize = 10;
            this.validateNumOfWriteQuorumsCoveredInEnsembleCreation(addrs, minNumRacksPerWriteQuorum, ensembleSize, writeQuorumSize);
            newConf = new ClientConfiguration((AbstractConfiguration)this.conf);
            minNumRacksPerWriteQuorum = 5;
            ensembleSize = 24;
            writeQuorumSize = 12;
            this.validateNumOfWriteQuorumsCoveredInEnsembleCreation(addrs, minNumRacksPerWriteQuorum, ensembleSize, writeQuorumSize);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    void validateNumOfWriteQuorumsCoveredInEnsembleCreation(Set<BookieId> addrs, int minNumRacksPerWriteQuorum, int ensembleSize, int writeQuorumSize) throws Exception {
        ClientConfiguration newConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        newConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(newConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, writeQuorumSize, null, new HashSet());
        List ensemble = (List)ensembleResponse.getResult();
        EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
        int numCovered = TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, minNumRacksPerWriteQuorum, this.repp.bookieAddressResolver);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)("minimum number of racks covered for writequorum ensemble: " + ensemble), (int)ensembleSize, (int)numCovered);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
    }

    @Test
    public void testNewEnsembleWithEnoughRacks() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/default-region/r4");
        int availableNumOfRacks = 4;
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            int ensembleSize = 3;
            int writeQuorumSize = 3;
            int ackQuorumSize = 2;
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, new HashSet());
            List ensemble1 = (List)ensembleResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy1 = ensembleResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble1, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy1);
            ensembleSize = 4;
            writeQuorumSize = 4;
            EnsemblePlacementPolicy.PlacementResult ensembleResponse2 = this.repp.newEnsemble(ensembleSize, writeQuorumSize, 2, null, new HashSet());
            List ensemble2 = (List)ensembleResponse2.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy2 = ensembleResponse2.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble2, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy2);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testRemoveBookieFromCluster() {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(addr1.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
    }

    @Test
    public void testWeightedPlacementAndReplaceBookieWithEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        int multiple = 10;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(-1);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieId, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr1.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr4.toBookieId(), new BookieInfoReader.BookieInfo((long)multiple * 100L, (long)multiple * 100L));
        this.repp.updateBookieInfo(bookieInfoMap);
        HashMap<BookieId, Long> selectionCounts = new HashMap<BookieId, Long>();
        selectionCounts.put(addr3.toBookieId(), 0L);
        selectionCounts.put(addr4.toBookieId(), 0L);
        int numTries = 50000;
        for (int i = 0; i < numTries; ++i) {
            EnsemblePlacementPolicy.PlacementResult replaceBookieResponse = this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), new HashSet());
            BookieId replacedBookie = (BookieId)replaceBookieResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertTrue((String)("replaced : " + replacedBookie), (addr3.toBookieId().equals((Object)replacedBookie) || addr4.toBookieId().equals((Object)replacedBookie) ? 1 : 0) != 0);
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
            selectionCounts.put(replacedBookie, (Long)selectionCounts.get(replacedBookie) + 1L);
        }
        double observedMultiple = (double)((Long)selectionCounts.get(addr4.toBookieId())).longValue() / (double)((Long)selectionCounts.get(addr3.toBookieId())).longValue();
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored " + observedMultiple), (Math.abs(observedMultiple - (double)multiple) < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedPlacementAndReplaceBookieWithoutEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr0 = new BookieSocketAddress("126.0.0.1", 3181);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        StaticDNSResolver.reset();
        StaticDNSResolver.addNodeToRack(addr0.getSocketAddress().getAddress().getHostAddress(), "/default-region/r0");
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r4");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr0.toBookieId());
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        int multiple = 10;
        int maxMultiple = 4;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(maxMultiple);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieId, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr0.toBookieId(), new BookieInfoReader.BookieInfo(50L, 50L));
        bookieInfoMap.put(addr1.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3.toBookieId(), new BookieInfoReader.BookieInfo(200L, 200L));
        bookieInfoMap.put(addr4.toBookieId(), new BookieInfoReader.BookieInfo((long)multiple * 50L, (long)multiple * 50L));
        this.repp.updateBookieInfo(bookieInfoMap);
        HashMap<BookieId, Long> selectionCounts = new HashMap<BookieId, Long>();
        selectionCounts.put(addr0.toBookieId(), 0L);
        selectionCounts.put(addr1.toBookieId(), 0L);
        selectionCounts.put(addr2.toBookieId(), 0L);
        selectionCounts.put(addr3.toBookieId(), 0L);
        selectionCounts.put(addr4.toBookieId(), 0L);
        int numTries = 50000;
        for (int i = 0; i < numTries; ++i) {
            EnsemblePlacementPolicy.PlacementResult replaceBookieResponse = this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), new HashSet());
            BookieId replacedBookie = (BookieId)replaceBookieResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = replaceBookieResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertTrue((addr0.toBookieId().equals((Object)replacedBookie) || addr1.toBookieId().equals((Object)replacedBookie) || addr3.toBookieId().equals((Object)replacedBookie) || addr4.toBookieId().equals((Object)replacedBookie) ? 1 : 0) != 0);
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
            selectionCounts.put(replacedBookie, (Long)selectionCounts.get(replacedBookie) + 1L);
        }
        double medianWeight = 150.0;
        double medianSelectionCounts = medianWeight / (double)((BookieInfoReader.BookieInfo)bookieInfoMap.get(addr1.toBookieId())).getWeight() * (double)((Long)selectionCounts.get(addr1.toBookieId())).longValue();
        double observedMultiple1 = (double)((Long)selectionCounts.get(addr4.toBookieId())).longValue() / medianSelectionCounts;
        double observedMultiple2 = (double)((Long)selectionCounts.get(addr4.toBookieId())).longValue() / (double)((Long)selectionCounts.get(addr3.toBookieId())).longValue();
        LOG.info("oM1 " + observedMultiple1 + " oM2 " + observedMultiple2);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected " + maxMultiple + " observed " + observedMultiple1), (Math.abs(observedMultiple1 - (double)maxMultiple) < 1.0 ? 1 : 0) != 0);
        double expected = medianWeight * (double)maxMultiple / (double)((BookieInfoReader.BookieInfo)bookieInfoMap.get(addr3.toBookieId())).getWeight();
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected " + expected + " observed " + observedMultiple2), (Math.abs(observedMultiple2 - expected) < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedPlacementAndNewEnsembleWithEnoughBookiesInSameRack() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr5.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr6.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr7.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr8.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr9.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        int maxMultiple = 4;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(maxMultiple);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieId, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr1.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr4.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr5.toBookieId(), new BookieInfoReader.BookieInfo(1000L, 1000L));
        bookieInfoMap.put(addr6.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr7.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr8.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr9.toBookieId(), new BookieInfoReader.BookieInfo(1000L, 1000L));
        this.repp.updateBookieInfo(bookieInfoMap);
        HashMap<BookieId, Long> selectionCounts = new HashMap<BookieId, Long>();
        for (BookieId b : addrs) {
            selectionCounts.put(b, 0L);
        }
        int numTries = 10000;
        HashSet excludeList = new HashSet();
        int ensembleSize = 3;
        int writeQuorumSize = 2;
        int acqQuorumSize = 2;
        for (int i = 0; i < numTries; ++i) {
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, acqQuorumSize, null, excludeList);
            List ensemble = (List)ensembleResponse.getResult();
            TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Rackaware selection not happening " + TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver)), (TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, this.conf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver) >= 2 ? 1 : 0) != 0);
            for (BookieId b : ensemble) {
                selectionCounts.put(b, (Long)selectionCounts.get(b) + 1L);
            }
        }
        double observedMultiple1 = (double)((Long)selectionCounts.get(addr5.toBookieId())).longValue() / (double)((Long)selectionCounts.get(addr2.toBookieId())).longValue();
        double observedMultiple2 = (double)((Long)selectionCounts.get(addr9.toBookieId())).longValue() / (double)((Long)selectionCounts.get(addr6.toBookieId())).longValue();
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected 2 observed " + observedMultiple1), (Math.abs(observedMultiple1 - (double)maxMultiple) < 0.5 ? 1 : 0) != 0);
        TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Weights not being honored expected 4 observed " + observedMultiple2), (Math.abs(observedMultiple2 - (double)maxMultiple) < 0.5 ? 1 : 0) != 0);
    }

    @Test
    public void testWeightedPlacementAndNewEnsembleWithoutEnoughBookies() throws Exception {
        List ensemble;
        EnsemblePlacementPolicy.PlacementResult ensembleResponse;
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getSocketAddress().getAddress().getHostAddress(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr3.getSocketAddress().getAddress().getHostAddress(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(addr4.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(addr5.getSocketAddress().getAddress().getHostAddress(), "/default-region/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        int maxMultiple = 4;
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.conf.setBookieMaxWeightMultipleForWeightBasedPlacement(maxMultiple);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, BookieInfoReader.BookieInfo> bookieInfoMap = new HashMap<BookieId, BookieInfoReader.BookieInfo>();
        bookieInfoMap.put(addr1.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr2.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr3.toBookieId(), new BookieInfoReader.BookieInfo(1000L, 1000L));
        bookieInfoMap.put(addr4.toBookieId(), new BookieInfoReader.BookieInfo(100L, 100L));
        bookieInfoMap.put(addr5.toBookieId(), new BookieInfoReader.BookieInfo(1000L, 1000L));
        this.repp.updateBookieInfo(bookieInfoMap);
        HashSet<BookieId> excludeList = new HashSet<BookieId>();
        try {
            excludeList.add(addr1.toBookieId());
            excludeList.add(addr2.toBookieId());
            excludeList.add(addr3.toBookieId());
            excludeList.add(addr4.toBookieId());
            ensembleResponse = this.repp.newEnsemble(3, 2, 2, null, excludeList);
            ensemble = (List)ensembleResponse.getResult();
            TestRackawareEnsemblePlacementPolicy.fail((String)("Should throw BKNotEnoughBookiesException when there is not enough bookies" + ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        try {
            ensembleResponse = this.repp.newEnsemble(1, 1, 1, null, excludeList);
            ensemble = (List)ensembleResponse.getResult();
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            TestRackawareEnsemblePlacementPolicy.fail((String)"Should not throw BKNotEnoughBookiesException when there are enough bookies for the ensemble");
        }
    }

    static int getNumCoveredWriteQuorums(List<BookieId> ensemble, int writeQuorumSize, int minNumRacksPerWriteQuorumConfValue, BookieAddressResolver bookieAddressResolver) throws Exception {
        int ensembleSize = ensemble.size();
        int numCoveredWriteQuorums = 0;
        for (int i = 0; i < ensembleSize; ++i) {
            HashSet<String> racks = new HashSet<String>();
            for (int j = 0; j < writeQuorumSize; ++j) {
                int bookieIdx = (i + j) % ensembleSize;
                BookieId addr = ensemble.get(bookieIdx);
                racks.add(StaticDNSResolver.getRack(bookieAddressResolver.resolve(addr).getHostName()));
            }
            int numOfRacksToCoverTo = Math.max(Math.min(writeQuorumSize, minNumRacksPerWriteQuorumConfValue), 2);
            numCoveredWriteQuorums += racks.size() >= numOfRacksToCoverTo ? 1 : 0;
        }
        return numCoveredWriteQuorums;
    }

    @Test
    public void testNodeWithFailures() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, Long> bookieFailures = new HashMap<BookieId, Long>();
        bookieFailures.put(this.addr1.toBookieId(), 20L);
        bookieFailures.put(this.addr2.toBookieId(), 22L);
        addrs = new HashSet();
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet reoderSet = this.repp.reorderReadSequence(this.ensemble, TestRackawareEnsemblePlacementPolicy.getBookiesHealthInfo(bookieFailures, new HashMap<BookieId, Long>()), this.writeSet);
        LOG.info("reorder set : {}", (Object)reoderSet);
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(2)), (Object)this.addr1.toBookieId());
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(3)), (Object)this.addr2.toBookieId());
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(0)), (Object)this.addr3.toBookieId());
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(1)), (Object)this.addr4.toBookieId());
    }

    @Test
    public void testPlacementOnStabilizeNetworkTopology() throws Exception {
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RackawareEnsemblePlacementPolicy();
        ClientConfiguration confLocal = new ClientConfiguration();
        confLocal.addConfiguration((Configuration)this.conf);
        confLocal.setNetworkTopologyStabilizePeriodSeconds(99999);
        this.repp.initialize(confLocal, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack("/default-region/default-rack");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr4.toBookieId());
        Set deadBookies = this.repp.onClusterChanged(addrs, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)deadBookies.isEmpty());
        for (int i = 0; i < 5; ++i) {
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(3, 2, 2, null, new HashSet());
            List ensemble = (List)ensembleResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)ensemble.contains(this.addr4.toBookieId()));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)isEnsembleAdheringToPlacementPolicy);
        }
        EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(4, 2, 2, null, new HashSet());
        List ensemble = (List)ensembleResponse.getResult();
        EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
        TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL, (Object)isEnsembleAdheringToPlacementPolicy);
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)ensemble.contains(this.addr4.toBookieId()));
    }

    @Test
    public void testShuffleWithMask() {
        DistributionSchedule.WriteSet w;
        int i;
        int mask = 0xE10000;
        int maskBits = 0xFF0000;
        boolean shuffleOccurred = false;
        for (i = 0; i < 100; ++i) {
            w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3 & mask, 4 & mask, 5 & mask, 6});
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask((DistributionSchedule.WriteSet)w, (int)mask, (int)maskBits);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(0), (int)1);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(1), (int)2);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(5), (int)6);
            if (w.get(3) == (3 & mask) || w.get(4) == (3 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(2) != (3 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"3 not found");
            }
            if (w.get(2) == (4 & mask) || w.get(4) == (4 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(3) != (4 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"4 not found");
            }
            if (w.get(2) == (5 & mask) || w.get(3) == (5 & mask)) {
                shuffleOccurred = true;
                continue;
            }
            if (w.get(4) == (5 & mask)) continue;
            TestRackawareEnsemblePlacementPolicy.fail((String)"5 not found");
        }
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)shuffleOccurred);
        shuffleOccurred = false;
        for (i = 0; i < 100; ++i) {
            w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1 & mask, 2 & mask, 3 & mask, 4, 5, 6});
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask((DistributionSchedule.WriteSet)w, (int)mask, (int)maskBits);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(3), (int)4);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(4), (int)5);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(5), (int)6);
            if (w.get(1) == (1 & mask) || w.get(2) == (1 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(0) != (1 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"1 not found");
            }
            if (w.get(0) == (2 & mask) || w.get(2) == (2 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(1) != (2 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"2 not found");
            }
            if (w.get(0) == (3 & mask) || w.get(1) == (3 & mask)) {
                shuffleOccurred = true;
                continue;
            }
            if (w.get(2) == (3 & mask)) continue;
            TestRackawareEnsemblePlacementPolicy.fail((String)"3 not found");
        }
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)shuffleOccurred);
        shuffleOccurred = false;
        for (i = 0; i < 100; ++i) {
            w = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{1, 2, 3, 4 & mask, 5 & mask, 6 & mask});
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask((DistributionSchedule.WriteSet)w, (int)mask, (int)maskBits);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(0), (int)1);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(1), (int)2);
            TestRackawareEnsemblePlacementPolicy.assertEquals((int)w.get(2), (int)3);
            if (w.get(4) == (4 & mask) || w.get(5) == (4 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(3) != (4 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"4 not found");
            }
            if (w.get(3) == (5 & mask) || w.get(5) == (5 & mask)) {
                shuffleOccurred = true;
            } else if (w.get(4) != (5 & mask)) {
                TestRackawareEnsemblePlacementPolicy.fail((String)"5 not found");
            }
            if (w.get(3) == (6 & mask) || w.get(4) == (6 & mask)) {
                shuffleOccurred = true;
                continue;
            }
            if (w.get(5) == (6 & mask)) continue;
            TestRackawareEnsemblePlacementPolicy.fail((String)"6 not found");
        }
        TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)shuffleOccurred);
    }

    @Test
    public void testUpdateTopologyWithRackChange() throws Exception {
        String defaultRackForThisTest = "/default-region/default-rack";
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack(defaultRackForThisTest);
        BookieSocketAddress newAddr1 = new BookieSocketAddress("127.0.0.100", 3181);
        BookieSocketAddress newAddr2 = new BookieSocketAddress("127.0.0.101", 3181);
        BookieSocketAddress newAddr3 = new BookieSocketAddress("127.0.0.102", 3181);
        BookieSocketAddress newAddr4 = new BookieSocketAddress("127.0.0.103", 3181);
        StaticDNSResolver.addNodeToRack(newAddr1.getHostName(), defaultRackForThisTest);
        StaticDNSResolver.addNodeToRack(newAddr2.getHostName(), defaultRackForThisTest);
        StaticDNSResolver.addNodeToRack(newAddr3.getHostName(), defaultRackForThisTest);
        StaticDNSResolver.addNodeToRack(newAddr4.getHostName(), defaultRackForThisTest);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)statsLogger, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack(defaultRackForThisTest);
        Gauge numBookiesInDefaultRackGauge = statsLogger.getGauge("NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK");
        HashSet<BookieId> writeableBookies = new HashSet<BookieId>();
        HashSet readOnlyBookies = new HashSet();
        writeableBookies.add(newAddr1.toBookieId());
        writeableBookies.add(newAddr2.toBookieId());
        writeableBookies.add(newAddr3.toBookieId());
        writeableBookies.add(newAddr4.toBookieId());
        this.repp.onClusterChanged(writeableBookies, readOnlyBookies);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)4, (Object)numBookiesInDefaultRackGauge.getSample());
        StaticDNSResolver.changeRack(Collections.singletonList(newAddr3), Collections.singletonList("/default-region/r4"));
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)3, (Object)numBookiesInDefaultRackGauge.getSample());
        StaticDNSResolver.changeRack(Collections.singletonList(newAddr1), Collections.singletonList(defaultRackForThisTest));
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)3, (Object)numBookiesInDefaultRackGauge.getSample());
    }

    @Test
    public void testNumBookiesInDefaultRackGauge() throws Exception {
        String defaultRackForThisTest = "/default-region/default-rack";
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack(defaultRackForThisTest);
        BookieSocketAddress newAddr1 = new BookieSocketAddress("127.0.0.100", 3181);
        BookieSocketAddress newAddr2 = new BookieSocketAddress("127.0.0.101", 3181);
        BookieSocketAddress newAddr3 = new BookieSocketAddress("127.0.0.102", 3181);
        BookieSocketAddress newAddr4 = new BookieSocketAddress("127.0.0.103", 3181);
        StaticDNSResolver.addNodeToRack(newAddr1.getHostName(), defaultRackForThisTest);
        StaticDNSResolver.addNodeToRack(newAddr2.getHostName(), "/default-region/r2");
        StaticDNSResolver.addNodeToRack(newAddr3.getHostName(), "/default-region/r3");
        StaticDNSResolver.addNodeToRack(newAddr4.getHostName(), defaultRackForThisTest);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)statsLogger, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack(defaultRackForThisTest);
        Gauge numBookiesInDefaultRackGauge = statsLogger.getGauge("NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK");
        HashSet<BookieId> writeableBookies = new HashSet<BookieId>();
        writeableBookies.add(newAddr1.toBookieId());
        writeableBookies.add(newAddr2.toBookieId());
        HashSet<BookieId> readOnlyBookies = new HashSet<BookieId>();
        readOnlyBookies.add(newAddr3.toBookieId());
        readOnlyBookies.add(newAddr4.toBookieId());
        this.repp.onClusterChanged(writeableBookies, readOnlyBookies);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)1, (Object)numBookiesInDefaultRackGauge.getSample());
        readOnlyBookies.remove(newAddr4.toBookieId());
        writeableBookies.add(newAddr4.toBookieId());
        this.repp.onClusterChanged(writeableBookies, readOnlyBookies);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)2, (Object)numBookiesInDefaultRackGauge.getSample());
        StaticDNSResolver.changeRack(Collections.singletonList(newAddr4), Collections.singletonList("/default-region/r4"));
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)1, (Object)numBookiesInDefaultRackGauge.getSample());
        writeableBookies.clear();
        this.repp.onClusterChanged(writeableBookies, readOnlyBookies);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)0, (Object)numBookiesInDefaultRackGauge.getSample());
        StaticDNSResolver.changeRack(Collections.singletonList(newAddr1), Collections.singletonList("/default-region/r2"));
        readOnlyBookies.clear();
        writeableBookies.add(newAddr1.toBookieId());
        writeableBookies.add(newAddr2.toBookieId());
        writeableBookies.add(newAddr3.toBookieId());
        writeableBookies.add(newAddr4.toBookieId());
        this.repp.onClusterChanged(writeableBookies, readOnlyBookies);
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)0, (Object)numBookiesInDefaultRackGauge.getSample());
    }

    @Test
    public void testNewEnsembleExcludesDefaultRackBookiesEnforceMinNumRacks() throws Exception {
        String defaultRackForThisTest = "/default-region/default-rack";
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack(defaultRackForThisTest);
        int minNumRacksPerWriteQuorum = 4;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorum);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)statsLogger, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack(defaultRackForThisTest);
        Gauge numBookiesInDefaultRackGauge = statsLogger.getGauge("NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK");
        int writeQuorumSize = 3;
        int ackQuorumSize = 3;
        int effectiveMinNumRacksPerWriteQuorum = Math.min(minNumRacksPerWriteQuorum, writeQuorumSize);
        int numOfRacks = 2 * effectiveMinNumRacksPerWriteQuorum - 1;
        int numOfBookiesPerRack = 20;
        BookieId[] bookieSocketAddresses = new BookieId[numOfRacks * numOfBookiesPerRack];
        for (int i = 0; i < numOfRacks; ++i) {
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                bookieSocketAddresses[index] = new BookieSocketAddress("128.0.0." + index, 3181).toBookieId();
                StaticDNSResolver.addNodeToRack("128.0.0." + index, "/default-region/r" + i);
            }
        }
        int numOfBookiesInDefaultRack = 10;
        BookieId[] bookieSocketAddressesInDefaultRack = new BookieId[numOfBookiesInDefaultRack];
        for (int i = 0; i < numOfBookiesInDefaultRack; ++i) {
            bookieSocketAddressesInDefaultRack[i] = new BookieSocketAddress("127.0.0." + (i + 100), 3181).toBookieId();
            StaticDNSResolver.addNodeToRack("127.0.0." + (i + 100), defaultRackForThisTest);
        }
        HashSet<BookieId> writableBookies = new HashSet<BookieId>(Arrays.asList(bookieSocketAddresses));
        writableBookies.addAll(Arrays.asList(bookieSocketAddressesInDefaultRack));
        this.repp.onClusterChanged(writableBookies, new HashSet());
        TestRackawareEnsemblePlacementPolicy.assertEquals((String)"NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK guage value", (Object)numOfBookiesInDefaultRack, (Object)numBookiesInDefaultRackGauge.getSample());
        for (int ensembleSize = effectiveMinNumRacksPerWriteQuorum; ensembleSize < 40; ++ensembleSize) {
            EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, new HashSet());
            List ensemble = (List)ensembleResponse.getResult();
            EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((String)"Number of writeQuorum sets covered", (int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, clientConf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
            ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, new HashSet());
            ensemble = (List)ensembleResponse.getResult();
            isEnsembleAdheringToPlacementPolicy = ensembleResponse.isAdheringToPolicy();
            TestRackawareEnsemblePlacementPolicy.assertEquals((String)"Number of writeQuorum sets covered", (int)ensembleSize, (int)TestRackawareEnsemblePlacementPolicy.getNumCoveredWriteQuorums(ensemble, writeQuorumSize, clientConf.getMinNumRacksPerWriteQuorum(), this.repp.bookieAddressResolver));
            TestRackawareEnsemblePlacementPolicy.assertEquals((Object)EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT, (Object)isEnsembleAdheringToPlacementPolicy);
            Collection bookiesOfDefaultRackInEnsemble = CollectionUtils.intersection(Arrays.asList(bookieSocketAddressesInDefaultRack), (Iterable)ensemble);
            TestRackawareEnsemblePlacementPolicy.assertTrue((String)("Ensemble is not supposed to contain bookies from default rack, but ensemble contains - " + bookiesOfDefaultRackInEnsemble), (boolean)bookiesOfDefaultRackInEnsemble.isEmpty());
        }
    }

    private void testAreAckedBookiesAdheringToPlacementPolicyHelper(int minNumRacksPerWriteQuorumConfValue, int ensembleSize, int writeQuorumSize, int ackQuorumSize, int numOfBookiesInDefaultRack, int numOfRacks, int numOfBookiesPerRack) throws Exception {
        int i;
        String defaultRackForThisTest = "/default-region/default-rack";
        this.repp.uninitalize();
        TestRackawareEnsemblePlacementPolicy.updateMyRack(defaultRackForThisTest);
        ClientConfiguration conf = new ClientConfiguration((AbstractConfiguration)this.conf);
        conf.setMinNumRacksPerWriteQuorum(minNumRacksPerWriteQuorumConfValue);
        TestStatsProvider statsProvider = new TestStatsProvider();
        TestStatsProvider.TestStatsLogger statsLogger = statsProvider.getStatsLogger("");
        this.repp = new RackawareEnsemblePlacementPolicy();
        this.repp.initialize(conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)statsLogger, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        this.repp.withDefaultRack(defaultRackForThisTest);
        ArrayList<BookieId> bookieSocketAddressesDefaultRack = new ArrayList<BookieId>();
        ArrayList<BookieId> bookieSocketAddressesNonDefaultRack = new ArrayList<BookieId>();
        HashSet bookiesForEntry = new HashSet();
        for (i = 0; i < numOfRacks; ++i) {
            for (int j = 0; j < numOfBookiesPerRack; ++j) {
                int index = i * numOfBookiesPerRack + j;
                bookieSocketAddressesNonDefaultRack.add(new BookieSocketAddress("128.0.0." + index, 3181).toBookieId());
                StaticDNSResolver.addNodeToRack("128.0.0." + index, "/default-region/r" + i);
            }
        }
        for (i = 0; i < numOfBookiesInDefaultRack; ++i) {
            bookieSocketAddressesDefaultRack.add(new BookieSocketAddress("127.0.0." + (i + 100), 3181).toBookieId());
            StaticDNSResolver.addNodeToRack("127.0.0." + (i + 100), defaultRackForThisTest);
        }
        HashSet<BookieId> writableBookies = new HashSet<BookieId>(bookieSocketAddressesNonDefaultRack);
        writableBookies.addAll(bookieSocketAddressesDefaultRack);
        this.repp.onClusterChanged(writableBookies, new HashSet());
        List ensemble = new ArrayList(bookieSocketAddressesDefaultRack);
        for (int entryId = 0; entryId < 10; ++entryId) {
            RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(writeQuorumSize, ackQuorumSize, ensembleSize);
            DistributionSchedule.WriteSet ws = ds.getWriteSet((long)entryId);
            for (int i2 = 0; i2 < ws.size(); ++i2) {
                bookiesForEntry.add(ensemble.get(ws.get(i2)));
            }
            TestRackawareEnsemblePlacementPolicy.assertFalse((boolean)this.repp.areAckedBookiesAdheringToPlacementPolicy(bookiesForEntry, writeQuorumSize, ackQuorumSize));
        }
        EnsemblePlacementPolicy.PlacementResult ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, new HashSet());
        ensemble = (List)ensembleResponse.getResult();
        for (int entryId = 0; entryId < 10; ++entryId) {
            RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(writeQuorumSize, ackQuorumSize, ensembleSize);
            DistributionSchedule.WriteSet ws = ds.getWriteSet((long)entryId);
            for (int i3 = 0; i3 < ws.size(); ++i3) {
                bookiesForEntry.add(ensemble.get(ws.get(i3)));
            }
            TestRackawareEnsemblePlacementPolicy.assertTrue((boolean)this.repp.areAckedBookiesAdheringToPlacementPolicy(bookiesForEntry, writeQuorumSize, ackQuorumSize));
        }
    }

    @Test
    public void testAreAckedBookiesAdheringToPlacementPolicy() throws Exception {
        this.testAreAckedBookiesAdheringToPlacementPolicyHelper(2, 7, 3, 2, 7, 3, 3);
        this.testAreAckedBookiesAdheringToPlacementPolicyHelper(4, 6, 3, 2, 6, 3, 3);
        this.testAreAckedBookiesAdheringToPlacementPolicyHelper(5, 7, 5, 3, 7, 5, 2);
    }
}

