/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class TestReadLastEntry
extends BookKeeperClusterTestCase {
    final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public TestReadLastEntry() {
        super(1);
    }

    @Test
    public void testTryReadLastEntryAsyncOnEmptyLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(1, 1, 1, this.digestType, "".getBytes());
        lh.close();
        LedgerHandle readLh = this.bkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        final CountDownLatch latch1 = new CountDownLatch(1);
        final AtomicInteger rcStore = new AtomicInteger();
        readLh.asyncReadLastEntry(new AsyncCallback.ReadCallback(){

            public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
                rcStore.set(rc);
                latch1.countDown();
            }
        }, null);
        latch1.await();
        Assert.assertEquals((long)-13L, (long)rcStore.get());
        lh.close();
        readLh.close();
    }

    @Test
    public void testTryReadLastEntryOnEmptyLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(1, 1, 1, this.digestType, "".getBytes());
        lh.close();
        LedgerHandle readLh = this.bkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        try {
            LedgerEntry lastEntry = readLh.readLastEntry();
            Assert.fail((String)"should fail with NoSuchEntryException");
        }
        catch (BKException e) {
            Assert.assertEquals((long)e.getCode(), (long)-13L);
        }
        lh.close();
        readLh.close();
    }

    @Test
    public void testTryReadLastEntryAsync() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(1, 1, 1, this.digestType, "".getBytes());
        byte[] data = new byte[1024];
        Arrays.fill(data, (byte)120);
        for (int j = 0; j < 100; ++j) {
            data[1023] = Integer.valueOf(j).byteValue();
            lh.addEntry(data);
        }
        lh.close();
        LedgerHandle readLh = this.bkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        final CountDownLatch latch1 = new CountDownLatch(1);
        final AtomicInteger rcStore = new AtomicInteger();
        final AtomicInteger lastByteStore = new AtomicInteger();
        readLh.asyncReadLastEntry(new AsyncCallback.ReadCallback(){

            public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
                rcStore.set(rc);
                LedgerEntry entry = seq.nextElement();
                lastByteStore.set(entry.getEntry()[1023]);
                latch1.countDown();
            }
        }, null);
        latch1.await();
        Assert.assertEquals((long)0L, (long)rcStore.get());
        Assert.assertEquals((long)lastByteStore.byteValue(), (long)data[1023]);
        lh.close();
        readLh.close();
    }

    @Test
    public void testTryReadLastEntrySync() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(1, 1, 1, this.digestType, "".getBytes());
        byte[] data = new byte[1024];
        Arrays.fill(data, (byte)120);
        for (int j = 0; j < 100; ++j) {
            data[1023] = Integer.valueOf(j).byteValue();
            lh.addEntry(data);
        }
        lh.close();
        LedgerHandle readLh = this.bkc.openLedger(lh.getId(), this.digestType, "".getBytes());
        LedgerEntry lastEntry = readLh.readLastEntry();
        Assert.assertEquals((long)lastEntry.getEntry()[1023], (long)Integer.valueOf(99).byteValue());
        lh.close();
        readLh.close();
    }
}

