/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import java.util.Set;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.bookkeeper.net.Node;
import org.junit.Assert;
import org.junit.Test;

public class NetworkTopologyImplTest {
    @Test
    public void getLeavesShouldReturnEmptySetForNonExistingScope() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        Set leaves = networkTopology.getLeaves("/non-existing-scope");
        Assert.assertTrue((boolean)leaves.isEmpty());
    }

    @Test
    public void getLeavesShouldReturnNodesInScope() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        String rack0Scope = "/rack-0";
        BookieId bookieIdScopeRack0 = BookieId.parse((String)"bookieIdScopeRack0");
        BookieNode bookieRack0ScopeNode = new BookieNode(bookieIdScopeRack0, rack0Scope);
        String rack1Scope = "/rack-1";
        BookieId bookieIdScopeRack1 = BookieId.parse((String)"bookieIdScopeRack1");
        BookieNode bookieRack1ScopeNode = new BookieNode(bookieIdScopeRack1, rack1Scope);
        networkTopology.add((Node)bookieRack0ScopeNode);
        networkTopology.add((Node)bookieRack1ScopeNode);
        Set leavesScopeRack0 = networkTopology.getLeaves(rack0Scope);
        Set leavesScopeRack1 = networkTopology.getLeaves(rack1Scope);
        Assert.assertTrue((leavesScopeRack0.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)leavesScopeRack0.contains(bookieRack0ScopeNode));
        Assert.assertTrue((leavesScopeRack1.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)leavesScopeRack1.contains(bookieRack1ScopeNode));
    }

    @Test
    public void getLeavesShouldReturnLeavesThatAreNotInExcludedScope() {
        NetworkTopologyImpl networkTopology = new NetworkTopologyImpl();
        String rack0Scope = "/rack-0";
        BookieId bookieIdScopeRack0 = BookieId.parse((String)"bookieIdScopeRack0");
        BookieNode bookieRack0ScopeNode = new BookieNode(bookieIdScopeRack0, rack0Scope);
        String rack1Scope = "/rack-1";
        BookieId bookieIdScopeRack1 = BookieId.parse((String)"bookieIdScopeRack1");
        BookieNode bookieRack1ScopeNode = new BookieNode(bookieIdScopeRack1, rack1Scope);
        String rack2Scope = "/rack-2";
        BookieId bookieIdScopeRack2 = BookieId.parse((String)"bookieIdScopeRack2");
        BookieNode bookieRack2ScopeNode = new BookieNode(bookieIdScopeRack2, rack2Scope);
        networkTopology.add((Node)bookieRack0ScopeNode);
        networkTopology.add((Node)bookieRack1ScopeNode);
        networkTopology.add((Node)bookieRack2ScopeNode);
        String scopeExcludingRack1 = "~/rack-1";
        Set leavesExcludingRack2Scope = networkTopology.getLeaves(scopeExcludingRack1);
        Assert.assertTrue((leavesExcludingRack2Scope.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)leavesExcludingRack2Scope.contains(bookieRack0ScopeNode));
        Assert.assertTrue((boolean)leavesExcludingRack2Scope.contains(bookieRack2ScopeNode));
    }
}

