/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import com.google.common.base.Stopwatch;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.metastore.InMemoryMetaStore;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.replication.ReplicationWorker;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.test.ZooKeeperCluster;
import org.apache.bookkeeper.test.ZooKeeperClusterUtil;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.PortManager;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeperClusterTestCase.class);
    @Rule
    public final TestName runtime = new TestName();
    @Rule
    public final Timeout globalTimeout;
    protected final ZooKeeperCluster zkUtil;
    protected ZooKeeper zkc;
    protected String metadataServiceUri;
    protected final List<File> tmpDirs = new LinkedList<File>();
    protected final List<BookieServer> bs = new LinkedList<BookieServer>();
    protected final List<ServerConfiguration> bsConfs = new LinkedList<ServerConfiguration>();
    private final Map<BookieId, TestStatsProvider> bsLoggers = new HashMap<BookieId, TestStatsProvider>();
    protected int numBookies;
    protected BookKeeperTestClient bkc;
    protected boolean useUUIDasBookieId = true;
    protected final ServerConfiguration baseConf = TestBKConfiguration.newServerConfiguration();
    protected final ClientConfiguration baseClientConf = TestBKConfiguration.newClientConfiguration();
    private final Map<BookieServer, AutoRecoveryMain> autoRecoveryProcesses = new HashMap<BookieServer, AutoRecoveryMain>();
    private boolean isAutoRecoveryEnabled;
    SynchronousQueue<Throwable> asyncExceptions = new SynchronousQueue();

    protected void captureThrowable(Runnable c) {
        try {
            c.run();
        }
        catch (Throwable e) {
            LOG.error("Captured error: {}", e);
            this.asyncExceptions.add(e);
        }
    }

    public BookKeeperClusterTestCase(int numBookies) {
        this(numBookies, 120);
    }

    public BookKeeperClusterTestCase(int numBookies, int testTimeoutSecs) {
        this(numBookies, 1, testTimeoutSecs);
    }

    public BookKeeperClusterTestCase(int numBookies, int numOfZKNodes, int testTimeoutSecs) {
        this.numBookies = numBookies;
        this.globalTimeout = Timeout.seconds((long)testTimeoutSecs);
        if (numOfZKNodes == 1) {
            this.zkUtil = new ZooKeeperUtil();
        } else {
            try {
                this.zkUtil = new ZooKeeperClusterUtil(numOfZKNodes);
            }
            catch (IOException | InterruptedException | KeeperException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.setUp("/ledgers");
    }

    protected void setUp(String ledgersRootPath) throws Exception {
        LOG.info("Setting up test {}", this.getClass());
        InMemoryMetaStore.reset();
        this.setMetastoreImplClass((AbstractConfiguration)this.baseConf);
        this.setMetastoreImplClass((AbstractConfiguration)this.baseClientConf);
        Stopwatch sw = Stopwatch.createStarted();
        try {
            this.startZKCluster();
            this.metadataServiceUri = this.getMetadataServiceUri(ledgersRootPath);
            this.startBKCluster(this.metadataServiceUri);
            LOG.info("Setup testcase {} @ metadata service {} in {} ms.", new Object[]{this.runtime.getMethodName(), this.metadataServiceUri, sw.elapsed(TimeUnit.MILLISECONDS)});
        }
        catch (Exception e) {
            LOG.error("Error setting up", (Throwable)e);
            throw e;
        }
    }

    protected String getMetadataServiceUri(String ledgersRootPath) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath);
    }

    @After
    public void tearDown() throws Exception {
        boolean failed = false;
        for (Throwable e : this.asyncExceptions) {
            LOG.error("Got async exception: {}", e);
            failed = true;
        }
        Assert.assertTrue((String)"Async failure", (!failed ? 1 : 0) != 0);
        Stopwatch sw = Stopwatch.createStarted();
        LOG.info("TearDown");
        Exception tearDownException = null;
        try {
            this.stopBKCluster();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to stop BKCluster", (Throwable)e);
            tearDownException = e;
        }
        try {
            this.stopZKCluster();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to stop ZKCluster", (Throwable)e);
            tearDownException = e;
        }
        try {
            this.cleanupTempDirs();
        }
        catch (Exception e) {
            LOG.error("Got Exception while trying to cleanupTempDirs", (Throwable)e);
            tearDownException = e;
        }
        LOG.info("Tearing down test {} in {} ms.", (Object)this.runtime.getMethodName(), (Object)sw.elapsed(TimeUnit.MILLISECONDS));
        if (tearDownException != null) {
            throw tearDownException;
        }
    }

    protected File createTempDir(String prefix, String suffix) throws IOException {
        File dir = IOUtils.createTempDir((String)prefix, (String)suffix);
        this.tmpDirs.add(dir);
        return dir;
    }

    protected void startZKCluster() throws Exception {
        this.zkUtil.startCluster();
        this.zkc = this.zkUtil.getZooKeeperClient();
    }

    protected void stopZKCluster() throws Exception {
        this.zkUtil.killCluster();
    }

    protected void startBKCluster(String metadataServiceUri) throws Exception {
        this.baseConf.setMetadataServiceUri(metadataServiceUri);
        this.baseClientConf.setMetadataServiceUri(metadataServiceUri);
        this.baseClientConf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        if (this.numBookies > 0) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        for (int i = 0; i < this.numBookies; ++i) {
            this.startNewBookie();
        }
    }

    protected void stopBKCluster() throws Exception {
        if (this.bkc != null) {
            this.bkc.close();
        }
        for (BookieServer server : this.bs) {
            server.shutdown();
            AutoRecoveryMain autoRecovery = this.autoRecoveryProcesses.get(server);
            if (autoRecovery == null || !this.isAutoRecoveryEnabled()) continue;
            autoRecovery.shutdown();
            LOG.debug("Shutdown auto recovery for bookieserver:" + server.getBookieId());
        }
        this.bs.clear();
        this.bsLoggers.clear();
    }

    protected void cleanupTempDirs() throws Exception {
        for (File f : this.tmpDirs) {
            FileUtils.deleteDirectory((File)f);
        }
    }

    protected ServerConfiguration newServerConfiguration() throws Exception {
        File f = this.createTempDir("bookie", "test");
        int port = this.baseConf.isEnableLocalTransport() || !this.baseConf.getAllowEphemeralPorts() ? PortManager.nextFreePort() : 0;
        return this.newServerConfiguration(port, f, new File[]{f});
    }

    protected ClientConfiguration newClientConfiguration() {
        return new ClientConfiguration((AbstractConfiguration)this.baseConf);
    }

    protected ServerConfiguration newServerConfiguration(int port, File journalDir, File[] ledgerDirs) {
        ServerConfiguration conf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        conf.setBookiePort(port);
        conf.setJournalDirName(journalDir.getPath());
        String[] ledgerDirNames = new String[ledgerDirs.length];
        for (int i = 0; i < ledgerDirs.length; ++i) {
            ledgerDirNames[i] = ledgerDirs[i].getPath();
        }
        conf.setLedgerDirNames(ledgerDirNames);
        conf.setEnableTaskExecutionStats(true);
        conf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        return conf;
    }

    protected void stopAllBookies() throws Exception {
        this.stopAllBookies(true);
    }

    protected void stopAllBookies(boolean shutdownClient) throws Exception {
        for (BookieServer server : this.bs) {
            server.shutdown();
        }
        this.bsConfs.clear();
        this.bs.clear();
        if (shutdownClient && this.bkc != null) {
            this.bkc.close();
            this.bkc = null;
        }
    }

    protected void startAllBookies() throws Exception {
        for (ServerConfiguration conf : this.bsConfs) {
            this.bs.add(this.startBookie(conf));
        }
    }

    protected String newMetadataServiceUri(String ledgersRootPath) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath);
    }

    protected String newMetadataServiceUri(String ledgersRootPath, String type) {
        return this.zkUtil.getMetadataServiceUri(ledgersRootPath, type);
    }

    public BookieId getBookie(int index) throws Exception {
        if (this.bs.size() <= index || index < 0) {
            throw new IllegalArgumentException("Invalid index, there are only " + this.bs.size() + " bookies. Asked for " + index);
        }
        return this.bs.get(index).getBookieId();
    }

    public BookieSocketAddress getBookieAddress(int index) throws Exception {
        return this.bkc.getBookieAddressResolver().resolve(this.getBookie(index));
    }

    public ServerConfiguration getBkConf(BookieId addr) throws Exception {
        int bkIndex = 0;
        for (BookieServer server : this.bs) {
            if (server.getBookieId().equals((Object)addr)) break;
            ++bkIndex;
        }
        if (bkIndex < this.bs.size()) {
            return this.bsConfs.get(bkIndex);
        }
        return null;
    }

    public ServerConfiguration killBookie(BookieId addr) throws Exception {
        BookieServer toRemove = null;
        int toRemoveIndex = 0;
        for (BookieServer server : this.bs) {
            if (server.getBookieId().equals((Object)addr)) {
                server.shutdown();
                toRemove = server;
                break;
            }
            ++toRemoveIndex;
        }
        if (toRemove != null) {
            this.stopAutoRecoveryService(toRemove);
            this.bs.remove(toRemove);
            this.bsLoggers.remove(addr);
            return this.bsConfs.remove(toRemoveIndex);
        }
        return null;
    }

    public void setBookieToReadOnly(BookieId addr) throws InterruptedException, UnknownHostException {
        for (BookieServer server : this.bs) {
            if (!server.getBookieId().equals((Object)addr)) continue;
            server.getBookie().getStateManager().doTransitionToReadOnlyMode();
            break;
        }
    }

    public ServerConfiguration killBookie(int index) throws Exception {
        if (index >= this.bs.size()) {
            throw new IOException("Bookie does not exist");
        }
        BookieServer server = this.bs.get(index);
        server.shutdown();
        this.stopAutoRecoveryService(server);
        this.bs.remove(server);
        this.bsLoggers.remove(server.getBookieId());
        return this.bsConfs.remove(index);
    }

    public ServerConfiguration killBookieAndWaitForZK(int index) throws Exception {
        if (index >= this.bs.size()) {
            throw new IOException("Bookie does not exist");
        }
        BookieServer server = this.bs.get(index);
        ServerConfiguration ret = this.killBookie(index);
        while (this.zkc.exists(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf) + "/" + "available" + "/" + server.getBookieId().toString(), false) != null) {
            Thread.sleep(500L);
        }
        return ret;
    }

    public CountDownLatch sleepBookie(BookieId addr, final int seconds) throws Exception {
        for (final BookieServer bookie : this.bs) {
            if (!bookie.getBookieId().equals((Object)addr)) continue;
            final CountDownLatch l = new CountDownLatch(1);
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        bookie.suspendProcessing();
                        LOG.info("bookie {} is asleep", (Object)bookie.getBookieId());
                        l.countDown();
                        Thread.sleep(seconds * 1000);
                        bookie.resumeProcessing();
                        LOG.info("bookie {} is awake", (Object)bookie.getBookieId());
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending bookie", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return l;
        }
        throw new IOException("Bookie not found");
    }

    public void sleepBookie(BookieId addr, CountDownLatch l) throws InterruptedException, IOException {
        CountDownLatch suspendLatch = new CountDownLatch(1);
        this.sleepBookie(addr, l, suspendLatch);
        suspendLatch.await();
    }

    public void sleepBookie(BookieId addr, final CountDownLatch l, final CountDownLatch suspendLatch) throws InterruptedException, IOException {
        for (final BookieServer bookie : this.bs) {
            if (!bookie.getBookieId().equals((Object)addr)) continue;
            LOG.info("Sleep bookie {}.", (Object)addr);
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        bookie.suspendProcessing();
                        if (null != suspendLatch) {
                            suspendLatch.countDown();
                        }
                        l.await();
                        bookie.resumeProcessing();
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending bookie", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return;
        }
        throw new IOException("Bookie not found");
    }

    public void restartBookies() throws Exception {
        this.restartBookies(null);
    }

    public void restartBookie(BookieId addr) throws Exception {
        BookieServer toRemove = null;
        int toRemoveIndex = 0;
        for (BookieServer server : this.bs) {
            if (server.getBookieId().equals((Object)addr)) {
                toRemove = server;
                break;
            }
            ++toRemoveIndex;
        }
        if (toRemove != null) {
            ServerConfiguration newConfig = this.bsConfs.get(toRemoveIndex);
            this.killBookie(toRemoveIndex);
            Thread.sleep(1000L);
            this.bs.add(this.startBookie(newConfig));
            this.bsConfs.add(newConfig);
            return;
        }
        throw new IOException("Bookie not found");
    }

    public void restartBookies(ServerConfiguration newConf) throws Exception {
        for (BookieServer server : this.bs) {
            server.shutdown();
            this.stopAutoRecoveryService(server);
        }
        this.bs.clear();
        this.bsLoggers.clear();
        Thread.sleep(1000L);
        for (ServerConfiguration conf : this.bsConfs) {
            String bookieId = conf.getBookieId();
            int port = conf.getBookiePort();
            if (null != newConf) {
                conf.loadConf((CompositeConfiguration)newConf);
            }
            if (bookieId != null) {
                conf.setBookieId(bookieId);
            } else {
                conf.setBookiePort(port);
            }
            this.bs.add(this.startBookie(conf));
        }
    }

    public int startNewBookie() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        this.bsConfs.add(conf);
        LOG.info("Starting new bookie on port: {}", (Object)conf.getBookiePort());
        BookieServer server = this.startBookie(conf);
        this.bs.add(server);
        return server.getLocalAddress().getPort();
    }

    public BookieId startNewBookieAndReturnBookieId() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        this.bsConfs.add(conf);
        LOG.info("Starting new bookie on port: {}", (Object)conf.getBookiePort());
        BookieServer server = this.startBookie(conf);
        this.bs.add(server);
        return server.getBookieId();
    }

    protected BookieServer startBookie(ServerConfiguration conf) throws Exception {
        TestStatsProvider provider = new TestStatsProvider();
        BookieServer server = new BookieServer(conf, (StatsLogger)provider.getStatsLogger(""), null);
        BookieId address = Bookie.getBookieId((ServerConfiguration)conf);
        this.bsLoggers.put(address, provider);
        if (this.bkc == null) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        Future<?> waitForBookie = conf.isForceReadOnlyBookie() ? this.bkc.waitForReadOnlyBookie(address) : this.bkc.waitForWritableBookie(address);
        server.start();
        waitForBookie.get(30L, TimeUnit.SECONDS);
        LOG.info("New bookie '{}' has been created.", (Object)address);
        try {
            this.startAutoRecovery(server, conf);
        }
        catch (ReplicationException.CompatibilityException ce) {
            LOG.error("Exception while starting AutoRecovery!", (Throwable)ce);
        }
        catch (ReplicationException.UnavailableException ue) {
            LOG.error("Exception while starting AutoRecovery!", (Throwable)ue);
        }
        return server;
    }

    protected BookieServer startBookie(ServerConfiguration conf, final Bookie b) throws Exception {
        TestStatsProvider provider = new TestStatsProvider();
        BookieServer server = new BookieServer(conf, (StatsLogger)provider.getStatsLogger(""), null){

            protected Bookie newBookie(ServerConfiguration conf, ByteBufAllocator allocator, Supplier<BookieServiceInfo> s) {
                return b;
            }
        };
        BookieId address = Bookie.getBookieId((ServerConfiguration)conf);
        if (this.bkc == null) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf, new TestStatsProvider());
        }
        Future<?> waitForBookie = conf.isForceReadOnlyBookie() ? this.bkc.waitForReadOnlyBookie(address) : this.bkc.waitForWritableBookie(address);
        server.start();
        this.bsLoggers.put(server.getBookieId(), provider);
        waitForBookie.get(30L, TimeUnit.SECONDS);
        LOG.info("New bookie '{}' has been created.", (Object)address);
        try {
            this.startAutoRecovery(server, conf);
        }
        catch (ReplicationException.CompatibilityException ce) {
            LOG.error("Exception while starting AutoRecovery!", (Throwable)ce);
        }
        catch (ReplicationException.UnavailableException ue) {
            LOG.error("Exception while starting AutoRecovery!", (Throwable)ue);
        }
        return server;
    }

    public void setMetastoreImplClass(AbstractConfiguration conf) {
        conf.setMetastoreImplClass(InMemoryMetaStore.class.getName());
    }

    public void setAutoRecoveryEnabled(boolean isAutoRecoveryEnabled) {
        this.isAutoRecoveryEnabled = isAutoRecoveryEnabled;
    }

    public boolean isAutoRecoveryEnabled() {
        return this.isAutoRecoveryEnabled;
    }

    private void startAutoRecovery(BookieServer bserver, ServerConfiguration conf) throws Exception {
        if (this.isAutoRecoveryEnabled()) {
            AutoRecoveryMain autoRecoveryProcess = new AutoRecoveryMain(conf);
            autoRecoveryProcess.start();
            this.autoRecoveryProcesses.put(bserver, autoRecoveryProcess);
            LOG.debug("Starting Auditor Recovery for the bookie:" + bserver.getBookieId());
        }
    }

    private void stopAutoRecoveryService(BookieServer toRemove) throws Exception {
        AutoRecoveryMain autoRecoveryMain = this.autoRecoveryProcesses.remove(toRemove);
        if (null != autoRecoveryMain && this.isAutoRecoveryEnabled()) {
            autoRecoveryMain.shutdown();
            LOG.debug("Shutdown auto recovery for bookieserver:" + toRemove.getBookieId());
        }
    }

    public void startReplicationService() throws Exception {
        int index = -1;
        for (BookieServer bserver : this.bs) {
            this.startAutoRecovery(bserver, this.bsConfs.get(++index));
        }
    }

    public void stopReplicationService() throws Exception {
        if (!this.isAutoRecoveryEnabled()) {
            return;
        }
        for (Map.Entry<BookieServer, AutoRecoveryMain> autoRecoveryProcess : this.autoRecoveryProcesses.entrySet()) {
            autoRecoveryProcess.getValue().shutdown();
            LOG.debug("Shutdown Auditor Recovery for the bookie:" + autoRecoveryProcess.getKey().getBookieId());
        }
    }

    public Auditor getAuditor(int timeout, TimeUnit unit) throws Exception {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
        while (System.nanoTime() < timeoutAt) {
            for (AutoRecoveryMain p : this.autoRecoveryProcesses.values()) {
                Auditor a = p.getAuditor();
                ReplicationWorker replicationWorker = p.getReplicationWorker();
                if (a != null && a.isRunning() && replicationWorker != null && replicationWorker.isRunning()) {
                    int deathWatchInterval = this.baseConf.getDeathWatchInterval();
                    Thread.sleep(deathWatchInterval + 1000);
                }
                if (a == null || !a.isRunning() || replicationWorker == null || !replicationWorker.isRunning()) continue;
                return a;
            }
            Thread.sleep(100L);
        }
        throw new Exception("No auditor found");
    }

    public AutoRecoveryMain getAutoRecovery(BookieServer bServer) throws Exception {
        return this.autoRecoveryProcesses.get(bServer);
    }

    public boolean isCreatedFromIp(BookieId bookieId) {
        BookieSocketAddress addr = this.bkc.getBookieAddressResolver().resolve(bookieId);
        return addr.getSocketAddress().toString().startsWith("/");
    }

    public void resetBookieOpLoggers() {
        for (TestStatsProvider provider : this.bsLoggers.values()) {
            provider.clear();
        }
    }

    public TestStatsProvider getStatsProvider(BookieId addr) {
        return this.bsLoggers.get(addr);
    }

    public TestStatsProvider getStatsProvider(int index) throws Exception {
        return this.getStatsProvider(this.bs.get(index).getBookieId());
    }
}

