/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import java.util.Optional;
import org.apache.bookkeeper.util.collections.SynchronizedHashMultiMap;
import org.junit.Assert;
import org.junit.Test;

public class SynchronizedHashMultiMapTest {
    @Test
    public void testGetAnyKey() {
        SynchronizedHashMultiMap map = new SynchronizedHashMultiMap();
        Assert.assertFalse((boolean)map.getAnyKey().isPresent());
        map.put((Object)1, (Object)2);
        Assert.assertEquals(map.getAnyKey().get(), (Object)1);
        map.put((Object)1, (Object)3);
        Assert.assertEquals(map.getAnyKey().get(), (Object)1);
        map.put((Object)2, (Object)4);
        int res = (Integer)map.getAnyKey().get();
        Assert.assertTrue((res == 1 || res == 2 ? 1 : 0) != 0);
        map.removeIf((k, v) -> k == 1);
        Assert.assertEquals(map.getAnyKey().get(), (Object)2);
    }

    @Test
    public void testRemoveAny() {
        SynchronizedHashMultiMap map = new SynchronizedHashMultiMap();
        Assert.assertFalse((boolean)map.removeAny((Object)1).isPresent());
        map.put((Object)1, (Object)2);
        map.put((Object)1, (Object)3);
        map.put((Object)2, (Object)4);
        map.put((Object)2, (Object)4);
        Optional v = map.removeAny((Object)1);
        int firstVal = (Integer)v.get();
        Assert.assertTrue((firstVal == 2 || firstVal == 3 ? 1 : 0) != 0);
        v = map.removeAny((Object)1);
        int secondVal = (Integer)v.get();
        Assert.assertTrue((secondVal == 2 || secondVal == 3 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)secondVal, (long)firstVal);
        v = map.removeAny((Object)2);
        Assert.assertTrue((boolean)v.isPresent());
        Assert.assertEquals(v.get(), (Object)4);
        Assert.assertFalse((boolean)map.removeAny((Object)1).isPresent());
        Assert.assertFalse((boolean)map.removeAny((Object)2).isPresent());
        Assert.assertFalse((boolean)map.removeAny((Object)3).isPresent());
    }

    @Test
    public void testRemoveIf() {
        SynchronizedHashMultiMap map = new SynchronizedHashMultiMap();
        Assert.assertEquals((long)map.removeIf((k, v) -> true), (long)0L);
        map.put((Object)1, (Object)2);
        map.put((Object)1, (Object)3);
        map.put((Object)2, (Object)4);
        map.put((Object)2, (Object)4);
        Assert.assertEquals((long)map.removeIf((k, v) -> v == 4), (long)1L);
        Assert.assertEquals((long)map.removeIf((k, v) -> k == 1), (long)2L);
        map.put((Object)1, (Object)2);
        map.put((Object)1, (Object)3);
        map.put((Object)2, (Object)4);
        Assert.assertEquals((long)map.removeIf((k, v) -> false), (long)0L);
        Assert.assertEquals((long)map.removeIf((k, v) -> true), (long)3L);
    }
}

