/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.zookeeper;

import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.ExponentialBackOffWithDeadlinePolicy;
import org.apache.bookkeeper.zookeeper.ExponentialBackoffRetryPolicy;
import org.junit.Assert;
import org.junit.Test;

public class TestRetryPolicy {
    private static void assertTimeRange(long waitTime, long minTime, long maxTime) {
        Assert.assertTrue((waitTime >= minTime ? 1 : 0) != 0);
        Assert.assertTrue((waitTime <= maxTime ? 1 : 0) != 0);
    }

    @Test
    public void testExponentialBackoffRetryPolicy() throws Exception {
        ExponentialBackoffRetryPolicy policy = new ExponentialBackoffRetryPolicy(1000L, Integer.MAX_VALUE);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(30, 2000L), 1000L, (long)(1000.0 * Math.pow(2.0, 31.0)));
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(31, 2000L), 1000L, (long)(1000.0 * Math.pow(2.0, 32.0)));
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(32, 2000L), 1000L, (long)(1000.0 * Math.pow(2.0, 33.0)));
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(127, 2000L), 1000L, 1000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(128, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(129, 2000L), 1000L, 4000L);
    }

    @Test
    public void testBoundExponentialBackoffRetryPolicy() throws Exception {
        BoundExponentialBackoffRetryPolicy policy = new BoundExponentialBackoffRetryPolicy(1000L, 2000L, Integer.MAX_VALUE);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(30, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(31, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(32, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(127, 2000L), 1000L, 1000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(128, 2000L), 1000L, 2000L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(129, 2000L), 1000L, 2000L);
    }

    @Test
    public void testExponentialBackoffWithDeadlineRetryPolicy() throws Exception {
        ExponentialBackOffWithDeadlinePolicy policy = new ExponentialBackOffWithDeadlinePolicy(100L, 55000L, 20);
        Assert.assertTrue((boolean)policy.allowRetry(1, 5000L));
        Assert.assertTrue((boolean)policy.allowRetry(4, 20000L));
        Assert.assertTrue((boolean)policy.allowRetry(10, 50000L));
        Assert.assertFalse((boolean)policy.allowRetry(0, 60000L));
        Assert.assertFalse((boolean)policy.allowRetry(22, 20000L));
        Assert.assertFalse((boolean)policy.allowRetry(22, 60000L));
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(0, 0L), 0L, 0L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(1, 0L), 100L, 110L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(1, 53000L), 100L, 110L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(2, 0L), 200L, 220L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(3, 0L), 300L, 330L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(3, 53000L), 300L, 330L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(4, 0L), 500L, 550L);
        TestRetryPolicy.assertTimeRange(policy.nextRetryWaitTime(5, 0L), 500L, 550L);
        Assert.assertEquals((long)2000L, (long)policy.nextRetryWaitTime(10, 53000L));
        Assert.assertEquals((long)4000L, (long)policy.nextRetryWaitTime(15, 51000L));
    }
}

