/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.JournalChannel;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.common.util.MemoryLimitController;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JournalChannel.class, Journal.class})
public class BookieJournalMaxMemoryTest {
    private static final Logger log = LoggerFactory.getLogger(BookieJournalMaxMemoryTest.class);
    private static final ByteBuf DATA = Unpooled.wrappedBuffer((byte[])new byte[0x100000]);
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void testAckAfterSyncPageCacheFlush() throws Exception {
        File journalDir = this.tempDir.newFolder();
        BookieImpl.checkDirectoryStructure((File)BookieImpl.getCurrentDirectory((File)journalDir));
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration().setJournalDirName(journalDir.getPath()).setJournalMaxMemorySizeMb(1L);
        JournalChannel jc = (JournalChannel)Mockito.spy((Object)new JournalChannel(journalDir, 1L));
        PowerMockito.whenNew(JournalChannel.class).withAnyArguments().thenReturn((Object)jc);
        LedgerDirsManager ledgerDirsManager = (LedgerDirsManager)Mockito.mock(LedgerDirsManager.class);
        Journal journal = (Journal)Mockito.spy((Object)new Journal(0, journalDir, conf, ledgerDirsManager));
        Whitebox.setInternalState((Object)journal, (String)"memoryLimitController", (Object)Mockito.spy((Object)new MemoryLimitController(1L)));
        MemoryLimitController mlc = (MemoryLimitController)Whitebox.getInternalState((Object)journal, (String)"memoryLimitController");
        journal.start();
        CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            long ledgerId = 1L;
            long entryId = i;
            journal.logAddEntry(ledgerId, entryId, DATA, false, (rc, ledgerId1, entryId1, addr, ctx) -> latch.countDown(), null);
        }
        latch.await();
        ((MemoryLimitController)Mockito.verify((Object)mlc, (VerificationMode)Mockito.times((int)10))).reserveMemory((long)DATA.readableBytes());
        ((MemoryLimitController)Mockito.verify((Object)mlc, (VerificationMode)Mockito.times((int)10))).releaseMemory((long)DATA.readableBytes());
        journal.shutdown();
    }
}

