/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.Enumeration;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BookieJournalNoSyncTest
extends BookKeeperClusterTestCase {
    public BookieJournalNoSyncTest() {
        super(1);
        this.baseConf.setJournalSyncData(false);
    }

    @Test
    public void testWriteToJournal() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, new byte[0]);
        int n = 10;
        long ledgerId = lh.getId();
        for (int i = 0; i < n; ++i) {
            lh.addEntry(("entry-" + i).getBytes());
        }
        this.restartBookies();
        LedgerHandle readLh = this.bkc.openLedger(ledgerId, BookKeeper.DigestType.CRC32, new byte[0]);
        Enumeration entries = readLh.readEntries(0L, (long)(n - 1));
        for (int i = 0; i < n; ++i) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            Assert.assertEquals((Object)("entry-" + i), (Object)new String(entry.getEntry()));
        }
    }
}

