/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.junit.Assert;
import org.junit.Test;

public class BufferedChannelTest {
    private static Random rand = new Random();
    private static final int INTERNAL_BUFFER_WRITE_CAPACITY = 65536;
    private static final int INTERNAL_BUFFER_READ_CAPACITY = 512;

    @Test
    public void testBufferedChannelWithNoBoundOnUnpersistedBytes() throws Exception {
        this.testBufferedChannel(5000, 30, 0, false, false);
    }

    @Test
    public void testBufferedChannelWithBoundOnUnpersistedBytes() throws Exception {
        this.testBufferedChannel(5000, 30, 140000, false, false);
    }

    @Test
    public void testBufferedChannelWithBoundOnUnpersistedBytesAndFlush() throws Exception {
        this.testBufferedChannel(5000, 30, 140000, true, false);
    }

    @Test
    public void testBufferedChannelFlushNoForceWrite() throws Exception {
        this.testBufferedChannel(5000, 30, 0, true, false);
    }

    @Test
    public void testBufferedChannelForceWriteNoFlush() throws Exception {
        this.testBufferedChannel(5000, 30, 0, false, true);
    }

    @Test
    public void testBufferedChannelFlushForceWrite() throws Exception {
        this.testBufferedChannel(5000, 30, 0, true, true);
    }

    public void testBufferedChannel(int byteBufLength, int numOfWrites, int unpersistedBytesBound, boolean flush, boolean shouldForceWrite) throws Exception {
        File newLogFile = File.createTempFile("test", "log");
        newLogFile.deleteOnExit();
        FileChannel fileChannel = new RandomAccessFile(newLogFile, "rw").getChannel();
        BufferedChannel logChannel = new BufferedChannel((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, fileChannel, 65536, 512, (long)unpersistedBytesBound);
        ByteBuf dataBuf = BufferedChannelTest.generateEntry(byteBufLength);
        dataBuf.markReaderIndex();
        dataBuf.markWriterIndex();
        for (int i = 0; i < numOfWrites; ++i) {
            logChannel.write(dataBuf);
            dataBuf.resetReaderIndex();
            dataBuf.resetWriterIndex();
        }
        if (flush && shouldForceWrite) {
            logChannel.flushAndForceWrite(false);
        } else if (flush) {
            logChannel.flush();
        } else if (shouldForceWrite) {
            logChannel.forceWrite(false);
        }
        int expectedNumOfUnpersistedBytes = 0;
        expectedNumOfUnpersistedBytes = flush && shouldForceWrite ? 0 : (!flush && shouldForceWrite ? byteBufLength * numOfWrites % 65536 : byteBufLength * numOfWrites - unpersistedBytesBound);
        if (unpersistedBytesBound > 0) {
            Assert.assertEquals((String)"Unpersisted bytes", (long)expectedNumOfUnpersistedBytes, (long)logChannel.getUnpersistedBytes());
        }
        logChannel.close();
        fileChannel.close();
    }

    private static ByteBuf generateEntry(int length) {
        byte[] data = new byte[length];
        ByteBuf bb = Unpooled.buffer((int)length);
        rand.nextBytes(data);
        bb.writeBytes(data);
        return bb;
    }
}

