/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.AbstractLogCompactor;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.powermock.reflect.Whitebox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectorThreadTest {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollectorThreadTest.class);
    @InjectMocks
    @Spy
    private GarbageCollectorThread mockGCThread;
    @Mock
    private LedgerManager ledgerManager;
    @Mock
    private StatsLogger statsLogger;
    @Mock
    private ScheduledExecutorService gcExecutor;
    private ServerConfiguration conf = (ServerConfiguration)Mockito.spy((Object)new ServerConfiguration().setAllowLoopback(true));
    private CompactableLedgerStorage ledgerStorage = (CompactableLedgerStorage)Mockito.mock(CompactableLedgerStorage.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.ledgerStorage.getEntryLogger()).thenReturn(Mockito.mock(EntryLogger.class));
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void testCompactEntryLogWithException() throws Exception {
        AbstractLogCompactor mockCompactor = (AbstractLogCompactor)Mockito.mock(AbstractLogCompactor.class);
        Mockito.when((Object)mockCompactor.compact((EntryLogMetadata)Mockito.any(EntryLogMetadata.class))).thenThrow(new Throwable[]{new RuntimeException("Unexpected compaction error")});
        Whitebox.setInternalState((Object)this.mockGCThread, (String)"compactor", (Object)mockCompactor);
        AtomicBoolean compacting = (AtomicBoolean)Whitebox.getInternalState((Object)this.mockGCThread, (String)"compacting");
        Assert.assertFalse((boolean)compacting.get());
        this.mockGCThread.compactEntryLog(new EntryLogMetadata(9999L));
        Assert.assertFalse((boolean)compacting.get());
    }

    @Test
    public void testCalculateUsageBucket() {
        int numBuckets = 10;
        int[] usageBuckets = new int[10];
        for (int i = 0; i < 10; ++i) {
            usageBuckets[i] = 0;
        }
        int items = 10000;
        for (int item = 0; item <= items; ++item) {
            double usage = (double)item / (double)items;
            int index = this.mockGCThread.calculateUsageIndex(10, usage);
            Assert.assertFalse((String)"Boundary condition exceeded", (index < 0 || index >= 10 ? 1 : 0) != 0);
            LOG.debug("Mapped {} usage to {}}\n", (Object)usage, (Object)index);
            int n = index;
            usageBuckets[n] = usageBuckets[n] + 1;
        }
        LOG.info("Compaction: entry log usage buckets[10% 20% 30% 40% 50% 60% 70% 80% 90% 100%] = {}", (Object)usageBuckets);
        int sum = 0;
        for (int i = 0; i < 10; ++i) {
            sum += usageBuckets[i];
        }
        Assert.assertEquals((String)"Incorrect number of items", (long)(items + 1), (long)sum);
    }
}

