/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.util.concurrent.RateLimiter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;

public class MockLedgerStorage
implements LedgerStorage {
    private final ConcurrentHashMap<Long, LedgerInfo> ledgers = new ConcurrentHashMap();
    private final EnumSet<LedgerStorage.StorageState> storageStateFlags = EnumSet.noneOf(LedgerStorage.StorageState.class);

    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
    }

    public void setStateManager(StateManager stateManager) {
    }

    public void setCheckpointSource(CheckpointSource checkpointSource) {
    }

    public void setCheckpointer(Checkpointer checkpointer) {
    }

    public void start() {
    }

    public void shutdown() throws InterruptedException {
    }

    public boolean ledgerExists(long ledgerId) throws IOException {
        return this.ledgers.containsKey(ledgerId);
    }

    public boolean entryExists(long ledgerId, long entryId) throws IOException {
        LedgerInfo info = this.ledgers.get(ledgerId);
        if (info == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return info != null && info.entries.containsKey(entryId);
    }

    public boolean setFenced(long ledgerId) throws IOException {
        AtomicBoolean ret = new AtomicBoolean(false);
        LedgerInfo previous = this.ledgers.computeIfPresent(ledgerId, (ledgerId1, current) -> {
            if (!current.fenced) {
                current.fenced = true;
                ret.set(true);
            } else {
                ret.set(false);
            }
            return current;
        });
        if (previous == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return ret.get();
    }

    public boolean isFenced(long ledgerId) throws IOException {
        LedgerInfo info = this.ledgers.get(ledgerId);
        if (info == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return info != null && info.fenced;
    }

    public void setLimboState(long ledgerId) throws IOException {
        LedgerInfo previous = this.ledgers.computeIfPresent(ledgerId, (ledgerId1, current) -> {
            current.limbo = true;
            return current;
        });
        if (previous == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
    }

    public boolean hasLimboState(long ledgerId) throws IOException {
        LedgerInfo info = this.ledgers.get(ledgerId);
        if (info == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return info.limbo;
    }

    public void clearLimboState(long ledgerId) throws IOException {
        LedgerInfo previous = this.ledgers.computeIfPresent(ledgerId, (ledgerId1, current) -> {
            current.limbo = false;
            return current;
        });
        if (previous == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
    }

    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        LedgerInfo previous = this.ledgers.compute(ledgerId, (ledgerId1, current) -> {
            if (current != null) {
                return current;
            }
            return new LedgerInfo(masterKey);
        });
        if (previous != null && !Arrays.equals(masterKey, previous.masterKey)) {
            throw new IOException((Throwable)BookieException.create((int)-100));
        }
    }

    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        LedgerInfo info = this.ledgers.get(ledgerId);
        if (info == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return Arrays.copyOf(info.masterKey, info.masterKey.length);
    }

    public long extractLedgerId(ByteBuf entry) {
        return entry.getLong(entry.readerIndex());
    }

    public long extractEntryId(ByteBuf entry) {
        return entry.getLong(entry.readerIndex() + 8);
    }

    public long extractLac(ByteBuf entry) {
        return entry.getLong(entry.readerIndex() + 16);
    }

    public long addEntry(ByteBuf entry) throws IOException, BookieException {
        ByteBuf copy = entry.retain().duplicate();
        long ledgerId = this.extractLedgerId(copy);
        long entryId = this.extractEntryId(copy);
        long lac = this.extractLac(copy);
        LedgerInfo previous = this.ledgers.computeIfPresent(ledgerId, (ledgerId1, current) -> {
            if (lac > current.lac) {
                current.lac = lac;
            }
            current.entries.put(entryId, copy);
            return current;
        });
        if (previous == null) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return entryId;
    }

    public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public long getLastAddConfirmed(long ledgerId) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public void flush() throws IOException {
    }

    public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public void deleteLedger(long ledgerId) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public ByteBuf getExplicitLac(long ledgerId) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public LedgerStorage getUnderlyingLedgerStorage() {
        return super.getUnderlyingLedgerStorage();
    }

    public void forceGC() {
        super.forceGC();
    }

    public void forceGC(Boolean forceMajor, Boolean forceMinor) {
        super.forceGC(forceMajor, forceMinor);
    }

    public List<LedgerStorage.DetectedInconsistency> localConsistencyCheck(Optional<RateLimiter> rateLimiter) throws IOException {
        return super.localConsistencyCheck(rateLimiter);
    }

    public boolean isInForceGC() {
        return super.isInForceGC();
    }

    public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        return super.getGarbageCollectionStatus();
    }

    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long ledgerId) throws IOException {
        throw new UnsupportedOperationException("Not supported in mock, implement if you need it");
    }

    public EnumSet<LedgerStorage.StorageState> getStorageStateFlags() throws IOException {
        return this.storageStateFlags;
    }

    public void setStorageStateFlag(LedgerStorage.StorageState flag) throws IOException {
        this.storageStateFlags.add(flag);
    }

    public void clearStorageStateFlag(LedgerStorage.StorageState flag) throws IOException {
        this.storageStateFlags.remove(flag);
    }

    private static class LedgerInfo {
        boolean limbo = false;
        boolean fenced = false;
        long lac = -1L;
        final byte[] masterKey;
        ConcurrentHashMap<Long, ByteBuf> entries = new ConcurrentHashMap();

        LedgerInfo(byte[] masterKey) {
            this.masterKey = Arrays.copyOf(masterKey, masterKey.length);
        }
    }
}

