/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.bookkeeper.bookie.ReadOnlyBookie;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.bookie.TestBookieImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataBookieDriver;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class StateManagerTest
extends BookKeeperClusterTestCase {
    @Rule
    public final TestName runtime = new TestName();
    final ServerConfiguration conf;
    MetadataBookieDriver driver;

    public StateManagerTest() {
        super(0);
        String ledgersPath = "/ledgers" + this.runtime.getMethodName();
        this.baseClientConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri(ledgersPath));
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri(ledgersPath));
        this.conf = TestBKConfiguration.newServerConfiguration();
        this.driver = new ZKMetadataBookieDriver();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zkUtil.createBKEnsemble("/" + this.runtime.getMethodName());
        File tmpDir = this.tmpDirs.createNew("stateManger", "test");
        this.conf.setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setJournalDirName(tmpDir.toString()).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    public void testNormalBookieTransitions() throws Exception {
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE);
        try (RegistrationManager rm = this.driver.createRegistrationManager();
             BookieStateManager stateManager = new BookieStateManager(this.conf, rm);){
            rm.addRegistrationListener(() -> {
                stateManager.forceToUnregistered();
                stateManager.registerBookie(false);
            });
            stateManager.initState();
            stateManager.registerBookie(true).get();
            Assert.assertTrue((boolean)stateManager.isRunning());
            Assert.assertTrue((boolean)stateManager.isRegistered());
            stateManager.transitionToReadOnlyMode().get();
            Assert.assertTrue((boolean)stateManager.isReadOnly());
            stateManager.transitionToWritableMode().get();
            Assert.assertTrue((boolean)stateManager.isRunning());
            Assert.assertFalse((boolean)stateManager.isReadOnly());
            stateManager.close();
            Assert.assertFalse((boolean)stateManager.isRunning());
        }
    }

    @Test
    public void testReadOnlyDisableBookieTransitions() throws Exception {
        this.conf.setReadOnlyModeEnabled(false);
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE);
        RegistrationManager rm = this.driver.createRegistrationManager();
        final BookieStateManager stateManager = new BookieStateManager(this.conf, rm);
        stateManager.setShutdownHandler(new StateManager.ShutdownHandler(){

            public void shutdown(int code) {
                try {
                    if (stateManager.isRunning()) {
                        stateManager.forceToShuttingDown();
                        stateManager.forceToReadOnly();
                    }
                }
                finally {
                    stateManager.close();
                }
            }
        });
        rm.addRegistrationListener(() -> {
            stateManager.forceToUnregistered();
            stateManager.registerBookie(false);
        });
        stateManager.initState();
        stateManager.registerBookie(true).get();
        Assert.assertTrue((boolean)stateManager.isRunning());
        stateManager.transitionToReadOnlyMode().get();
        Assert.assertFalse((boolean)stateManager.isRunning());
        Assert.assertTrue((boolean)stateManager.isReadOnly());
    }

    @Test
    public void testReadOnlyBookieTransitions() throws Exception {
        File tmpDir = this.tmpDirs.createNew("stateManger", "test-readonly");
        ServerConfiguration readOnlyConf = TestBKConfiguration.newServerConfiguration();
        ((ServerConfiguration)readOnlyConf.setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()}).setJournalDirName(tmpDir.toString()).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setForceReadOnlyBookie(true);
        this.driver.initialize(readOnlyConf, (StatsLogger)NullStatsLogger.INSTANCE);
        ReadOnlyBookie readOnlyBookie = TestBookieImpl.buildReadOnly(new TestBookieImpl.ResourceBuilder(readOnlyConf).withMetadataDriver(this.driver).build());
        readOnlyBookie.start();
        Assert.assertTrue((boolean)readOnlyBookie.isRunning());
        Assert.assertTrue((boolean)readOnlyBookie.isReadOnly());
        readOnlyBookie.getStateManager().transitionToWritableMode().get();
        Assert.assertTrue((boolean)readOnlyBookie.isRunning());
        Assert.assertTrue((boolean)readOnlyBookie.isReadOnly());
        readOnlyBookie.shutdown();
    }

    @Test
    public void testRegistration() throws Exception {
        this.driver.initialize(this.conf, (StatsLogger)NullStatsLogger.INSTANCE);
        RegistrationManager rm = this.driver.createRegistrationManager();
        final BookieStateManager stateManager = new BookieStateManager(this.conf, rm);
        rm.addRegistrationListener(() -> {
            stateManager.forceToUnregistered();
            stateManager.registerBookie(false);
        });
        stateManager.setShutdownHandler(new StateManager.ShutdownHandler(){

            public void shutdown(int code) {
                try {
                    if (stateManager.isRunning()) {
                        stateManager.forceToShuttingDown();
                        stateManager.forceToReadOnly();
                    }
                }
                finally {
                    stateManager.close();
                }
            }
        });
        stateManager.initState();
        Assert.assertTrue((boolean)stateManager.isRunning());
        Assert.assertFalse((boolean)stateManager.isRegistered());
        stateManager.registerBookie(true).get();
        Assert.assertTrue((boolean)stateManager.isRegistered());
        stateManager.getShutdownHandler().shutdown(0);
        Assert.assertTrue((boolean)stateManager.isReadOnly());
    }
}

