/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.util.DiskChecker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UncleanShutdownDetectionTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void testRegisterStartWithoutRegisterShutdownEqualsUncleanShutdown() throws IOException {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        uncleanShutdownDetection.registerStartUp();
        Assert.assertTrue((boolean)uncleanShutdownDetection.lastShutdownWasUnclean());
    }

    @Test
    public void testRegisterStartWithRegisterShutdownEqualsCleanShutdown() throws IOException {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        uncleanShutdownDetection.registerStartUp();
        uncleanShutdownDetection.registerCleanShutdown();
        Assert.assertFalse((boolean)uncleanShutdownDetection.lastShutdownWasUnclean());
    }

    @Test
    public void testRegisterStartWithoutRegisterShutdownEqualsUncleanShutdownMultipleDirs() throws IOException {
        File ledgerDir1 = this.tempDir.newFolder("l1");
        File ledgerDir2 = this.tempDir.newFolder("l2");
        File ledgerDir3 = this.tempDir.newFolder("l3");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration().setLedgerDirNames(new String[]{ledgerDir1.getAbsolutePath(), ledgerDir2.getAbsolutePath(), ledgerDir3.getAbsolutePath()});
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        uncleanShutdownDetection.registerStartUp();
        Assert.assertTrue((boolean)uncleanShutdownDetection.lastShutdownWasUnclean());
    }

    @Test
    public void testRegisterStartWithRegisterShutdownEqualsCleanShutdownMultipleDirs() throws IOException {
        File ledgerDir1 = this.tempDir.newFolder("l1");
        File ledgerDir2 = this.tempDir.newFolder("l2");
        File ledgerDir3 = this.tempDir.newFolder("l3");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration().setLedgerDirNames(new String[]{ledgerDir1.getAbsolutePath(), ledgerDir2.getAbsolutePath(), ledgerDir3.getAbsolutePath()});
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        uncleanShutdownDetection.registerStartUp();
        uncleanShutdownDetection.registerCleanShutdown();
        Assert.assertFalse((boolean)uncleanShutdownDetection.lastShutdownWasUnclean());
    }

    @Test
    public void testRegisterStartWithPartialRegisterShutdownEqualsUncleanShutdownMultipleDirs() throws IOException {
        File ledgerDir1 = this.tempDir.newFolder("l1");
        File ledgerDir2 = this.tempDir.newFolder("l2");
        File ledgerDir3 = this.tempDir.newFolder("l3");
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration().setLedgerDirNames(new String[]{ledgerDir1.getAbsolutePath(), ledgerDir2.getAbsolutePath(), ledgerDir3.getAbsolutePath()});
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        uncleanShutdownDetection.registerStartUp();
        uncleanShutdownDetection.registerCleanShutdown();
        File dirtyFile = new File((File)ledgerDirsManager.getAllLedgerDirs().get(0), "DIRTY");
        dirtyFile.createNewFile();
        Assert.assertTrue((boolean)uncleanShutdownDetection.lastShutdownWasUnclean());
    }

    @Test(expected=IOException.class)
    public void testRegisterStartFailsToCreateDirtyFilesAndThrowsIOException() throws IOException {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        DiskChecker diskChecker = new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold());
        MockLedgerDirsManager ledgerDirsManager = new MockLedgerDirsManager(conf, conf.getLedgerDirs(), diskChecker);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl((LedgerDirsManager)ledgerDirsManager);
        uncleanShutdownDetection.registerStartUp();
    }

    private class MockLedgerDirsManager
    extends LedgerDirsManager {
        public MockLedgerDirsManager(ServerConfiguration conf, File[] dirs, DiskChecker diskChecker) throws IOException {
            super(conf, dirs, diskChecker);
        }

        public List<File> getAllLedgerDirs() {
            ArrayList<File> dirs = new ArrayList<File>();
            dirs.add(new File("does_not_exist"));
            return dirs;
        }
    }
}

