/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.datainteg;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.bookie.datainteg.WriteSets;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteSetsTest {
    private static final Logger log = LoggerFactory.getLogger(WriteSetsTest.class);

    @Test
    public void testOrderPreserved() throws Exception {
        WriteSets writeSets = new WriteSets((List)ImmutableList.of((Object)0, (Object)3, (Object)2, (Object)4, (Object)1), 5, 2);
        MatcherAssert.assertThat((Object)writeSets.getForEntry(0L), (Matcher)Matchers.contains((Object[])new Integer[]{0, 1}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(1L), (Matcher)Matchers.contains((Object[])new Integer[]{2, 1}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(2L), (Matcher)Matchers.contains((Object[])new Integer[]{3, 2}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(3L), (Matcher)Matchers.contains((Object[])new Integer[]{3, 4}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(4L), (Matcher)Matchers.contains((Object[])new Integer[]{0, 4}));
    }

    @Test
    public void testOrderPreservedWithGapForCurrentBookie() throws Exception {
        WriteSets writeSets = new WriteSets((List)ImmutableList.of((Object)0, (Object)3, (Object)4, (Object)1), 5, 2);
        MatcherAssert.assertThat((Object)writeSets.getForEntry(0L), (Matcher)Matchers.contains((Object[])new Integer[]{0, 1}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(1L), (Matcher)Matchers.contains((Object[])new Integer[]{1}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(2L), (Matcher)Matchers.contains((Object[])new Integer[]{3}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(3L), (Matcher)Matchers.contains((Object[])new Integer[]{3, 4}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(4L), (Matcher)Matchers.contains((Object[])new Integer[]{0, 4}));
    }

    @Test
    public void testEmptyWriteSet() throws Exception {
        WriteSets writeSets = new WriteSets((List)ImmutableList.of((Object)0, (Object)3, (Object)4, (Object)1), 5, 1);
        MatcherAssert.assertThat((Object)writeSets.getForEntry(0L), (Matcher)Matchers.contains((Object[])new Integer[]{0}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(1L), (Matcher)Matchers.contains((Object[])new Integer[]{1}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(2L), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)writeSets.getForEntry(3L), (Matcher)Matchers.contains((Object[])new Integer[]{3}));
        MatcherAssert.assertThat((Object)writeSets.getForEntry(4L), (Matcher)Matchers.contains((Object[])new Integer[]{4}));
    }

    @Test
    public void testE2W2() throws Exception {
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(2, 2, 2);
        WriteSets writeSets = new WriteSets((List)ImmutableList.of((Object)0, (Object)1), 2, 2);
        for (int i = 0; i < 100; ++i) {
            ImmutableList writeSet = writeSets.getForEntry((long)i);
            DistributionSchedule.WriteSet distWriteSet = schedule.getWriteSet((long)i);
            WriteSetsTest.assertContentsMatch((ImmutableList<Integer>)writeSet, distWriteSet);
        }
        WriteSets writeSets2 = new WriteSets((List)ImmutableList.of((Object)1, (Object)0), 2, 2);
        for (int i = 0; i < 100; ++i) {
            ImmutableList writeSet = writeSets2.getForEntry((long)i);
            DistributionSchedule.WriteSet distWriteSet = schedule.getWriteSet((long)i);
            WriteSetsTest.assertContentsMatch((ImmutableList<Integer>)writeSet, distWriteSet);
        }
    }

    @Test
    public void testE10W2() throws Exception {
        RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(2, 2, 10);
        WriteSets writeSets = new WriteSets((List)ImmutableList.of((Object)0, (Object)8, (Object)1, (Object)9, (Object)6, (Object)3, (Object)7, (Object)4, (Object)2, (Object)5), 10, 2);
        for (int i = 0; i < 100; ++i) {
            ImmutableList writeSet = writeSets.getForEntry((long)i);
            DistributionSchedule.WriteSet distWriteSet = schedule.getWriteSet((long)i);
            WriteSetsTest.assertContentsMatch((ImmutableList<Integer>)writeSet, distWriteSet);
        }
        WriteSets writeSets2 = new WriteSets((List)ImmutableList.of((Object)7, (Object)5, (Object)1, (Object)6, (Object)3, (Object)0, (Object)8, (Object)9, (Object)4, (Object)2), 10, 2);
        for (int i = 0; i < 100; ++i) {
            ImmutableList writeSet = writeSets2.getForEntry((long)i);
            DistributionSchedule.WriteSet distWriteSet = schedule.getWriteSet((long)i);
            WriteSetsTest.assertContentsMatch((ImmutableList<Integer>)writeSet, distWriteSet);
        }
        WriteSets writeSets3 = new WriteSets((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9), 10, 2);
        for (int i = 0; i < 100; ++i) {
            ImmutableList writeSet = writeSets3.getForEntry((long)i);
            DistributionSchedule.WriteSet distWriteSet = schedule.getWriteSet((long)i);
            WriteSetsTest.assertContentsMatch((ImmutableList<Integer>)writeSet, distWriteSet);
        }
    }

    @Test
    public void testManyVariants() throws Exception {
        for (int w = 1; w <= 12; ++w) {
            for (int e = w; e <= 12; ++e) {
                RoundRobinDistributionSchedule schedule = new RoundRobinDistributionSchedule(w, w, e);
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < e; ++i) {
                    indices.add(i);
                }
                Collections.shuffle(indices);
                WriteSets writeSets = new WriteSets((List)ImmutableList.copyOf(indices), e, w);
                for (int i = 0; i < 100; ++i) {
                    ImmutableList writeSet = writeSets.getForEntry((long)i);
                    DistributionSchedule.WriteSet distWriteSet = schedule.getWriteSet((long)i);
                    WriteSetsTest.assertContentsMatch((ImmutableList<Integer>)writeSet, distWriteSet);
                }
            }
        }
    }

    private static void assertContentsMatch(ImmutableList<Integer> writeSet, DistributionSchedule.WriteSet distWriteSet) throws Exception {
        log.info("writeSet {} distWriteSet {}", writeSet, (Object)distWriteSet.size());
        MatcherAssert.assertThat((Object)writeSet.size(), (Matcher)Matchers.equalTo((Object)distWriteSet.size()));
        for (Integer i : writeSet) {
            MatcherAssert.assertThat((Object)distWriteSet.contains(i.intValue()), (Matcher)Matchers.equalTo((Object)true));
        }
        for (int i = 0; i < distWriteSet.size(); ++i) {
            MatcherAssert.assertThat((Object)distWriteSet.get(i), (Matcher)Matchers.isIn(writeSet));
        }
    }
}

