/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLedgerStorageBookieTest
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(DbLedgerStorageBookieTest.class);

    public DbLedgerStorageBookieTest() {
        super(1);
        this.baseConf.setLedgerStorageClass(DbLedgerStorage.class.getName());
        this.baseConf.setFlushInterval(60000);
        this.baseConf.setGcWaitTime(60000L);
        this.baseConf.setProperty("dbStorage_writeCacheMaxSizeMb", (Object)"");
        this.baseConf.setProperty("dbStorage_readAheadCacheMaxSizeMb", (Object)16);
    }

    @Test
    public void testRecoveryEmptyLedger() throws Exception {
        LedgerHandle lh1 = this.bkc.createLedger(1, 1, BookKeeper.DigestType.MAC, new byte[0]);
        LedgerHandle lh2 = this.bkc.openLedger(lh1.getId(), BookKeeper.DigestType.MAC, new byte[0]);
        Assert.assertEquals((long)0L, (long)lh2.getLength());
        Assert.assertEquals((long)-1L, (long)lh2.getLastAddConfirmed());
    }

    @Test
    public void testV2ReadWrite() throws Exception {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setUseV2WireProtocol(true);
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper bkc = new BookKeeper(conf);
        LedgerHandle lh1 = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, new byte[0]);
        lh1.addEntry("Foobar".getBytes());
        lh1.close();
        LedgerHandle lh2 = bkc.openLedger(lh1.getId(), BookKeeper.DigestType.CRC32, new byte[0]);
        Assert.assertEquals((long)0L, (long)lh2.getLastAddConfirmed());
        Assert.assertEquals((Object)new String(((LedgerEntry)lh2.readEntries(0L, 0L).nextElement()).getEntry()), (Object)"Foobar");
    }
}

