/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;

public class KeyValueStorageRocksDBTest {
    @Test
    public void testRocksDBInitiateWithBookieConfiguration() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration();
        configuration.setEntryLocationRocksdbConf("entry_location_rocksdb.conf");
        File tmpDir = Files.createTempDirectory("bk-kv-rocksdbtest-conf", new FileAttribute[0]).toFile();
        Files.createDirectory(Paths.get(tmpDir.toString(), "subDir"), new FileAttribute[0]);
        KeyValueStorageRocksDB rocksDB = new KeyValueStorageRocksDB(tmpDir.toString(), "subDir", KeyValueStorageFactory.DbConfigType.EntryLocation, configuration);
        Assert.assertNull((Object)rocksDB.getColumnFamilyDescriptors());
        Options options = (Options)rocksDB.getOptions();
        Assert.assertEquals((long)0x4000000L, (long)options.writeBufferSize());
        Assert.assertEquals((long)4L, (long)options.maxWriteBufferNumber());
        Assert.assertEquals((long)0x10000000L, (long)options.maxBytesForLevelBase());
        rocksDB.close();
    }

    @Test
    public void testRocksDBInitiateWithConfigurationFile() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration();
        URL url = this.getClass().getClassLoader().getResource("test_entry_location_rocksdb.conf");
        configuration.setEntryLocationRocksdbConf(url.getPath());
        File tmpDir = Files.createTempDirectory("bk-kv-rocksdbtest-file", new FileAttribute[0]).toFile();
        Files.createDirectory(Paths.get(tmpDir.toString(), "subDir"), new FileAttribute[0]);
        KeyValueStorageRocksDB rocksDB = new KeyValueStorageRocksDB(tmpDir.toString(), "subDir", KeyValueStorageFactory.DbConfigType.EntryLocation, configuration);
        Assert.assertNotNull((Object)rocksDB.getColumnFamilyDescriptors());
        DBOptions dbOptions = (DBOptions)rocksDB.getOptions();
        Assert.assertTrue((boolean)dbOptions.createIfMissing());
        Assert.assertEquals((long)1L, (long)dbOptions.keepLogFileNum());
        Assert.assertEquals((long)1000L, (long)dbOptions.maxTotalWalSize());
        List columnFamilyDescriptorList = rocksDB.getColumnFamilyDescriptors();
        ColumnFamilyOptions familyOptions = ((ColumnFamilyDescriptor)columnFamilyDescriptorList.get(0)).getOptions();
        Assert.assertEquals((Object)CompressionType.LZ4_COMPRESSION, (Object)familyOptions.compressionType());
        Assert.assertEquals((long)1024L, (long)familyOptions.writeBufferSize());
        Assert.assertEquals((long)1L, (long)familyOptions.maxWriteBufferNumber());
        rocksDB.close();
    }
}

