/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.function.Function;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.versioning.Versioned;

public class ClientUtil {
    public static final DigestType DIGEST_TYPE = DigestType.CRC32C;
    public static final byte[] PASSWD = "foobar".getBytes(StandardCharsets.UTF_8);

    public static ByteBuf generatePacket(long ledgerId, long entryId, long lastAddConfirmed, long length, byte[] data) throws GeneralSecurityException {
        return ClientUtil.generatePacket(ledgerId, entryId, lastAddConfirmed, length, data, 0, data.length);
    }

    public static ByteBuf generatePacket(long ledgerId, long entryId, long lastAddConfirmed, long length, byte[] data, int offset, int len) throws GeneralSecurityException {
        DigestManager dm = DigestManager.instantiate((long)ledgerId, (byte[])new byte[2], (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)true);
        return ByteBufList.coalesce((ByteBufList)dm.computeDigestAndPackageForSending(entryId, lastAddConfirmed, length, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)len)));
    }

    public static boolean isLedgerOpen(LedgerHandle handle) {
        return !handle.getLedgerMetadata().isClosed();
    }

    public static Versioned<LedgerMetadata> setupLedger(ClientContext clientCtx, long ledgerId, LedgerMetadataBuilder builder) throws Exception {
        return ClientUtil.setupLedger(clientCtx.getLedgerManager(), ledgerId, builder);
    }

    public static Versioned<LedgerMetadata> setupLedger(LedgerManager ledgerManager, long ledgerId, LedgerMetadataBuilder builder) throws Exception {
        LedgerMetadata md = builder.withPassword(PASSWD).withDigestType(DIGEST_TYPE).withId(ledgerId).build();
        return (Versioned)ledgerManager.createLedgerMetadata(ledgerId, md).get();
    }

    public static Versioned<LedgerMetadata> transformMetadata(ClientContext clientCtx, long ledgerId, Function<LedgerMetadata, LedgerMetadata> transform) throws Exception {
        return ClientUtil.transformMetadata(clientCtx.getLedgerManager(), ledgerId, transform);
    }

    public static Versioned<LedgerMetadata> transformMetadata(LedgerManager ledgerManager, long ledgerId, Function<LedgerMetadata, LedgerMetadata> transform) throws Exception {
        Versioned current = (Versioned)ledgerManager.readLedgerMetadata(ledgerId).get();
        return (Versioned)ledgerManager.writeLedgerMetadata(ledgerId, transform.apply((LedgerMetadata)current.getValue()), current.getVersion()).get();
    }
}

