/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.MockLedgerHandle;
import org.apache.bookkeeper.client.MockReadHandle;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.OpenBuilder;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.OpenBuilderBase;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockBookKeeper
extends BookKeeper {
    final ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)new DefaultThreadFactory("mock-bookkeeper"));
    final ZooKeeper zkc;
    Map<Long, MockLedgerHandle> ledgers = new ConcurrentHashMap<Long, MockLedgerHandle>();
    AtomicLong sequence = new AtomicLong(3L);
    AtomicBoolean stopped = new AtomicBoolean(false);
    AtomicInteger stepsToFail = new AtomicInteger(-1);
    int failReturnCode = 0;
    int nextFailReturnCode = 0;
    private static final int BkTimeoutOperation = 1000;
    private static final Logger log = LoggerFactory.getLogger(MockBookKeeper.class);

    public ClientConfiguration getConf() {
        return super.getConf();
    }

    public MockBookKeeper(ZooKeeper zkc) throws Exception {
        this.zkc = zkc;
    }

    public LedgerHandle createLedger(BookKeeper.DigestType digestType, byte[] passwd) throws BKException {
        return this.createLedger(3, 2, digestType, passwd);
    }

    public LedgerHandle createLedger(int ensSize, int qSize, BookKeeper.DigestType digestType, byte[] passwd) throws BKException {
        return this.createLedger(ensSize, qSize, qSize, digestType, passwd);
    }

    public void asyncCreateLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, final BookKeeper.DigestType digestType, final byte[] passwd, final AsyncCallback.CreateCallback cb, final Object ctx, Map<String, byte[]> properties) {
        if (this.stopped.get()) {
            cb.createComplete(-12, null, ctx);
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (MockBookKeeper.this.getProgrammedFailStatus()) {
                    if (MockBookKeeper.this.failReturnCode != 1000) {
                        cb.createComplete(MockBookKeeper.this.failReturnCode, null, ctx);
                    }
                    return;
                }
                if (MockBookKeeper.this.stopped.get()) {
                    cb.createComplete(-12, null, ctx);
                    return;
                }
                try {
                    long id = MockBookKeeper.this.sequence.getAndIncrement();
                    log.info("Creating ledger {}", (Object)id);
                    final MockLedgerHandle lh = new MockLedgerHandle(MockBookKeeper.this, id, digestType, passwd);
                    MockBookKeeper.this.ledgers.put(id, lh);
                    lh.executeOrdered((SafeRunnable)new org.apache.bookkeeper.util.SafeRunnable(){

                        public void safeRun() {
                            cb.createComplete(0, (LedgerHandle)lh, ctx);
                        }
                    });
                }
                catch (Throwable t) {
                    log.error("Error", t);
                }
            }
        });
    }

    public LedgerHandle createLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] passwd) throws BKException {
        this.checkProgrammedFail();
        if (this.stopped.get()) {
            throw BKException.create((int)-12);
        }
        try {
            long id = this.sequence.getAndIncrement();
            log.info("Creating ledger {}", (Object)id);
            MockLedgerHandle lh = new MockLedgerHandle(this, id, digestType, passwd);
            this.ledgers.put(id, lh);
            return lh;
        }
        catch (Throwable t) {
            log.error("Exception:", t);
            return null;
        }
    }

    public void asyncCreateLedger(int ensSize, int qSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        this.asyncCreateLedger(ensSize, qSize, qSize, digestType, passwd, cb, ctx, Collections.emptyMap());
    }

    public void asyncOpenLedger(long lId, BookKeeper.DigestType digestType, byte[] passwd, final AsyncCallback.OpenCallback cb, final Object ctx) {
        if (this.getProgrammedFailStatus()) {
            if (this.failReturnCode != 1000) {
                cb.openComplete(this.failReturnCode, null, ctx);
            }
            return;
        }
        if (this.stopped.get()) {
            cb.openComplete(-12, null, ctx);
            return;
        }
        final MockLedgerHandle lh = this.ledgers.get(lId);
        if (lh == null) {
            cb.openComplete(-25, null, ctx);
        } else if (lh.digest != digestType) {
            cb.openComplete(-5, null, ctx);
        } else if (!Arrays.equals(lh.passwd, passwd)) {
            cb.openComplete(-102, null, ctx);
        } else {
            lh.executeOrdered((SafeRunnable)new org.apache.bookkeeper.util.SafeRunnable(){

                public void safeRun() {
                    cb.openComplete(0, (LedgerHandle)lh, ctx);
                }
            });
        }
    }

    public void asyncOpenLedgerNoRecovery(long lId, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.asyncOpenLedger(lId, digestType, passwd, cb, ctx);
    }

    public void asyncDeleteLedger(long lId, AsyncCallback.DeleteCallback cb, Object ctx) {
        if (this.getProgrammedFailStatus()) {
            if (this.failReturnCode != 1000) {
                cb.deleteComplete(this.failReturnCode, ctx);
            }
        } else if (this.stopped.get()) {
            cb.deleteComplete(-12, ctx);
        } else if (this.ledgers.containsKey(lId)) {
            this.ledgers.remove(lId);
            cb.deleteComplete(0, ctx);
        } else {
            cb.deleteComplete(-25, ctx);
        }
    }

    public void deleteLedger(long lId) throws InterruptedException, BKException {
        this.checkProgrammedFail();
        if (this.stopped.get()) {
            throw BKException.create((int)-12);
        }
        if (!this.ledgers.containsKey(lId)) {
            throw BKException.create((int)-25);
        }
        this.ledgers.remove(lId);
    }

    public void close() throws InterruptedException, BKException {
        this.checkProgrammedFail();
        this.shutdown();
    }

    public OpenBuilder newOpenLedgerOp() {
        return new OpenBuilderBase(){

            public CompletableFuture<ReadHandle> execute() {
                CompletableFuture<ReadHandle> promise = new CompletableFuture<ReadHandle>();
                int validateRc = this.validate();
                if (0 != validateRc) {
                    promise.completeExceptionally(BKException.create((int)validateRc));
                    return promise;
                }
                if (MockBookKeeper.this.getProgrammedFailStatus()) {
                    if (MockBookKeeper.this.failReturnCode != 1000) {
                        promise.completeExceptionally(BKException.create((int)MockBookKeeper.this.failReturnCode));
                    }
                    return promise;
                }
                if (MockBookKeeper.this.stopped.get()) {
                    promise.completeExceptionally(new BKException.BKClientClosedException());
                    return promise;
                }
                MockLedgerHandle lh = MockBookKeeper.this.ledgers.get(this.ledgerId);
                if (lh == null) {
                    promise.completeExceptionally((Throwable)new BKException.BKNoSuchLedgerExistsOnMetadataServerException());
                } else if (lh.digest != BookKeeper.DigestType.fromApiDigestType((DigestType)this.digestType)) {
                    promise.completeExceptionally(new BKException.BKDigestMatchException());
                } else if (!Arrays.equals(lh.passwd, this.password)) {
                    promise.completeExceptionally(new BKException.BKUnauthorizedAccessException());
                } else {
                    promise.complete(new MockReadHandle(MockBookKeeper.this, this.ledgerId, lh.getLedgerMetadata(), lh.entries));
                }
                return promise;
            }
        };
    }

    public void shutdown() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopped.set(true);
        for (MockLedgerHandle ledger : this.ledgers.values()) {
            ledger.entries.clear();
        }
        this.ledgers.clear();
        this.executor.shutdownNow();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public Set<Long> getLedgers() {
        return this.ledgers.keySet();
    }

    void checkProgrammedFail() throws BKException {
        int steps = this.stepsToFail.getAndDecrement();
        log.debug("Steps to fail: {}", (Object)steps);
        if (steps <= 0 && this.failReturnCode != 0) {
            int rc = this.failReturnCode;
            this.failReturnCode = this.nextFailReturnCode;
            this.nextFailReturnCode = 0;
            throw BKException.create((int)rc);
        }
    }

    boolean getProgrammedFailStatus() {
        int steps = this.stepsToFail.getAndDecrement();
        log.debug("Steps to fail: {}", (Object)steps);
        return steps == 0;
    }

    public void failNow(int rc) {
        this.failNow(rc, 0);
    }

    public void failNow(int rc, int nextErrorCode) {
        this.failAfter(0, rc);
    }

    public void failAfter(int steps, int rc) {
        this.failAfter(steps, rc, 0);
    }

    public void failAfter(int steps, int rc, int nextErrorCode) {
        this.stepsToFail.set(steps);
        this.failReturnCode = rc;
        this.nextFailReturnCode = nextErrorCode;
    }

    public void timeoutAfter(int steps) {
        this.stepsToFail.set(steps);
        this.failReturnCode = 1000;
    }
}

