/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerChecker;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerFragmentReplicator;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLedgerFragmentReplication
extends BookKeeperClusterTestCase {
    private static final byte[] TEST_PSSWD = "testpasswd".getBytes();
    private static final BookKeeper.DigestType TEST_DIGEST_TYPE = BookKeeper.DigestType.CRC32;
    private static final BiConsumer<Long, Long> NOOP_BICONSUMER = (l, e) -> {};
    private static final Logger LOG = LoggerFactory.getLogger(TestLedgerFragmentReplication.class);

    public TestLedgerFragmentReplication() {
        super(3);
    }

    @Test
    public void testReplicateLFShouldCopyFailedBookieFragmentsToTargetBookie() throws Exception {
        byte[] data = "TestLedgerFragmentReplication".getBytes();
        LedgerHandle lh = this.bkc.createLedger(3, 3, TEST_DIGEST_TYPE, TEST_PSSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        Set<LedgerFragment> result = this.getFragmentsToReplicate(lh);
        BookKeeperAdmin admin = new BookKeeperAdmin(this.baseClientConf);
        lh.close();
        for (LedgerFragment lf : result) {
            admin.replicateLedgerFragment(lh, lf, NOOP_BICONSUMER);
        }
        NavigableMap allBookiesBeforeReplication = lh.getLedgerMetadata().getAllEnsembles();
        for (Map.Entry entry : allBookiesBeforeReplication.entrySet()) {
            List bookies = (List)entry.getValue();
            for (BookieId bookie : bookies) {
                if (newBkAddr.equals((Object)bookie)) continue;
                this.killBookie(bookie);
            }
        }
        this.verifyRecoveredLedgers(lh, 0L, 9L);
    }

    @Test
    public void testReplicateLFFailsOnlyOnLastUnClosedFragments() throws Exception {
        byte[] data = "TestLedgerFragmentReplication".getBytes();
        LedgerHandle lh = this.bkc.createLedger(3, 3, TEST_DIGEST_TYPE, TEST_PSSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        this.startNewBookie();
        LOG.info("Killing Bookie : {}", (Object)replicaToKill);
        this.killBookie(replicaToKill);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        BookieId replicaToKill2 = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(1);
        BookieId newBkAddr = this.startNewBookieAndReturnBookieId();
        LOG.info("New Bookie addr : {}", (Object)newBkAddr);
        LOG.info("Killing Bookie : {}", (Object)replicaToKill2);
        this.killBookie(replicaToKill2);
        Set<LedgerFragment> result = this.getFragmentsToReplicate(lh);
        BookKeeperAdmin admin = new BookKeeperAdmin(this.baseClientConf);
        int unclosedCount = 0;
        for (LedgerFragment lf : result) {
            if (lf.isClosed()) {
                admin.replicateLedgerFragment(lh, lf, NOOP_BICONSUMER);
                continue;
            }
            ++unclosedCount;
            try {
                admin.replicateLedgerFragment(lh, lf, NOOP_BICONSUMER);
                Assert.fail((String)"Shouldn't be able to rereplicate unclosed ledger");
            }
            catch (BKException bKException) {}
        }
        Assert.assertEquals((String)"Should be only one unclosed fragment", (long)1L, (long)unclosedCount);
    }

    @Test
    public void testReplicateLFShouldReturnFalseIfTheReplicationFails() throws Exception {
        byte[] data = "TestLedgerFragmentReplication".getBytes();
        LedgerHandle lh = this.bkc.createLedger(2, 1, TEST_DIGEST_TYPE, TEST_PSSWD);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        BookieId replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        this.killBookie(replicaToKill);
        LOG.info("Killed Bookie =" + replicaToKill);
        for (int i = 0; i < 10; ++i) {
            lh.addEntry(data);
        }
        replicaToKill = (BookieId)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).get(0);
        this.killBookie(replicaToKill);
        LOG.info("Killed Bookie =" + replicaToKill);
        Set<LedgerFragment> fragments = this.getFragmentsToReplicate(lh);
        BookKeeperAdmin admin = new BookKeeperAdmin(this.baseClientConf);
        for (LedgerFragment lf : fragments) {
            try {
                admin.replicateLedgerFragment(lh, lf, NOOP_BICONSUMER);
            }
            catch (BKException.BKLedgerRecoveryException bKLedgerRecoveryException) {}
        }
    }

    @Test
    public void testSplitIntoSubFragmentsWithDifferentFragmentBoundaries() throws Exception {
        ArrayList ensemble = Lists.newArrayList((Object[])new BookieId[]{new BookieSocketAddress("192.0.2.1", 1234).toBookieId(), new BookieSocketAddress("192.0.2.2", 1234).toBookieId(), new BookieSocketAddress("192.0.2.3", 1234).toBookieId()});
        LedgerMetadata metadata = LedgerMetadataBuilder.create().withId(124L).withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).withPassword(TEST_PSSWD).withDigestType(TEST_DIGEST_TYPE.toApiDigestType()).withClosedState().withLastEntryId(-1L).withLength(0L).newEnsembleEntry(0L, (List)ensemble).build();
        LedgerHandle lh = new LedgerHandle(this.bkc.getClientCtx(), 0L, new Versioned((Object)metadata, (Version)new LongVersion(0L)), TEST_DIGEST_TYPE, TEST_PSSWD, WriteFlag.NONE);
        this.testSplitIntoSubFragments(10L, 21L, -1L, 1L, lh);
        this.testSplitIntoSubFragments(10L, 21L, 20L, 1L, lh);
        this.testSplitIntoSubFragments(0L, 0L, 10L, 1L, lh);
        this.testSplitIntoSubFragments(0L, 1L, 1L, 2L, lh);
        this.testSplitIntoSubFragments(20L, 24L, 2L, 3L, lh);
        this.testSplitIntoSubFragments(21L, 32L, 3L, 4L, lh);
        this.testSplitIntoSubFragments(22L, 103L, 11L, 8L, lh);
        this.testSplitIntoSubFragments(49L, 51L, 1L, 3L, lh);
        this.testSplitIntoSubFragments(11L, 101L, 3L, 31L, lh);
    }

    void testSplitIntoSubFragments(final long oriFragmentFirstEntry, final long oriFragmentLastEntry, long entriesPerSubFragment, long expectedSubFragments, LedgerHandle lh) {
        LedgerFragment fr = new LedgerFragment(lh, oriFragmentFirstEntry, oriFragmentLastEntry, Sets.newHashSet((Object[])new Integer[]{0})){

            public long getLastStoredEntryId() {
                return oriFragmentLastEntry;
            }

            public long getFirstStoredEntryId() {
                return oriFragmentFirstEntry;
            }
        };
        Set subFragments = LedgerFragmentReplicator.splitIntoSubFragments((LedgerHandle)lh, (LedgerFragment)fr, (long)entriesPerSubFragment);
        Assert.assertEquals((long)expectedSubFragments, (long)subFragments.size());
        int fullSubFragment = 0;
        int partialSubFragment = 0;
        for (LedgerFragment ledgerFragment : subFragments) {
            if (ledgerFragment.getLastKnownEntryId() - ledgerFragment.getFirstEntryId() + 1L == entriesPerSubFragment) {
                ++fullSubFragment;
                continue;
            }
            long totalEntriesToReplicate = oriFragmentLastEntry - oriFragmentFirstEntry + 1L;
            if (entriesPerSubFragment <= 0L || totalEntriesToReplicate / entriesPerSubFragment == 0L) {
                Assert.assertEquals((String)"FirstEntryId should be same as original fragment's firstEntryId", (long)fr.getFirstEntryId(), (long)ledgerFragment.getFirstEntryId());
                Assert.assertEquals((String)"LastEntryId should be same as original fragment's lastEntryId", (long)fr.getLastKnownEntryId(), (long)ledgerFragment.getLastKnownEntryId());
            } else {
                long partialSplitEntries = totalEntriesToReplicate % entriesPerSubFragment;
                Assert.assertEquals((String)"Partial fragment with wrong entry boundaries", (long)(ledgerFragment.getLastKnownEntryId() - ledgerFragment.getFirstEntryId() + 1L), (long)partialSplitEntries);
            }
            ++partialSubFragment;
        }
        Assert.assertEquals((String)"Unexpected number of sub fargments", (long)(fullSubFragment + partialSubFragment), (long)expectedSubFragments);
        Assert.assertTrue((String)"There should be only one or zero partial sub Fragment", (partialSubFragment == 0 || partialSubFragment == 1 ? 1 : 0) != 0);
    }

    private Set<LedgerFragment> getFragmentsToReplicate(LedgerHandle lh) throws InterruptedException {
        LedgerChecker checker = new LedgerChecker((BookKeeper)this.bkc);
        CheckerCallback cb = new CheckerCallback();
        checker.checkLedger(lh, (BookkeeperInternalCallbacks.GenericCallback)cb);
        Set<LedgerFragment> fragments = cb.waitAndGetResult();
        return fragments;
    }

    private void verifyRecoveredLedgers(LedgerHandle lh, long startEntryId, long endEntryId) throws BKException, InterruptedException {
        LedgerHandle lhs = this.bkc.openLedgerNoRecovery(lh.getId(), TEST_DIGEST_TYPE, TEST_PSSWD);
        Enumeration entries = lhs.readEntries(startEntryId, endEntryId);
        Assert.assertTrue((String)"Should have the elements", (boolean)entries.hasMoreElements());
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            Assert.assertEquals((Object)"TestLedgerFragmentReplication", (Object)new String(entry.getEntry()));
        }
    }

    @Test
    public void testSplitLedgerFragmentState() throws Exception {
        int lastEntryId = 10;
        int rereplicationEntryBatchSize = 10;
        ArrayList<BookieId> ensemble = new ArrayList<BookieId>();
        ensemble.add(BookieId.parse((String)"bookie0:3181"));
        ensemble.add(BookieId.parse((String)"bookie1:3181"));
        ensemble.add(BookieId.parse((String)"bookie2:3181"));
        ensemble.add(BookieId.parse((String)"bookie3:3181"));
        ensemble.add(BookieId.parse((String)"bookie4:3181"));
        ensemble.add(BookieId.parse((String)"bookie5:3181"));
        ensemble.add(BookieId.parse((String)"bookie6:3181"));
        LedgerMetadataBuilder builder = LedgerMetadataBuilder.create();
        builder.withId(124L).withEnsembleSize(7).withWriteQuorumSize(3).withAckQuorumSize(2).withDigestType(TEST_DIGEST_TYPE.toApiDigestType()).withPassword(TEST_PSSWD).newEnsembleEntry(0L, ensemble).withLastEntryId((long)lastEntryId).withLength(512L).withClosedState();
        LedgerMetadata met = builder.build();
        LedgerHandle lh = new LedgerHandle(this.bkc.getClientCtx(), 100L, new Versioned((Object)met, (Version)new LongVersion(0L)), TEST_DIGEST_TYPE, TEST_PSSWD, EnumSet.noneOf(WriteFlag.class));
        HashSet<Integer> bookieIndexes = new HashSet<Integer>();
        bookieIndexes.add(1);
        bookieIndexes.add(5);
        LedgerFragment lfrag = new LedgerFragment(lh, 0L, 10L, bookieIndexes);
        Set partionedFragments = LedgerFragmentReplicator.splitIntoSubFragments((LedgerHandle)lh, (LedgerFragment)lfrag, (long)rereplicationEntryBatchSize);
        Assert.assertEquals((String)"Number of sub-fragments", (long)2L, (long)partionedFragments.size());
        for (LedgerFragment partionedFragment : partionedFragments) {
            if (partionedFragment.getFirstEntryId() == 0L) {
                this.validateEntryIds(partionedFragment, 0L, 0L, 9L, 8L);
                continue;
            }
            this.validateEntryIds(partionedFragment, 10L, 10L, 10L, 10L);
        }
    }

    private void validateEntryIds(LedgerFragment partionedFragment, long expectedFirstEntryId, long expectedFirstStoredEntryId, long expectedLastKnownEntryID, long expectedLastStoredEntryId) {
        Assert.assertEquals((String)"FirstEntryId", (long)expectedFirstEntryId, (long)partionedFragment.getFirstEntryId());
        Assert.assertEquals((String)"FirstStoredEntryId", (long)expectedFirstStoredEntryId, (long)partionedFragment.getFirstStoredEntryId());
        Assert.assertEquals((String)"LastKnownEntryID", (long)expectedLastKnownEntryID, (long)partionedFragment.getLastKnownEntryId());
        Assert.assertEquals((String)"LastStoredEntryId", (long)expectedLastStoredEntryId, (long)partionedFragment.getLastStoredEntryId());
    }

    private static class CheckerCallback
    implements BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> {
        private Set<LedgerFragment> result = null;
        private CountDownLatch latch = new CountDownLatch(1);

        private CheckerCallback() {
        }

        Set<LedgerFragment> waitAndGetResult() throws InterruptedException {
            this.latch.await();
            return this.result;
        }

        public void operationComplete(int rc, Set<LedgerFragment> result) {
            this.result = result;
            this.latch.countDown();
        }
    }
}

