/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReadTimeout
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestReadTimeout.class);
    BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public TestReadTimeout() {
        super(10);
    }

    @Test
    public void testReadTimeout() throws Exception {
        final AtomicBoolean completed = new AtomicBoolean(false);
        LedgerHandle writelh = this.bkc.createLedger(3, 3, this.digestType, "testPasswd".getBytes());
        String tmp = "Foobar";
        int numEntries = 10;
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        HashSet beforeSet = new HashSet();
        beforeSet.addAll(writelh.getLedgerMetadata().getEnsembleAt(10L));
        BookieId bookieToSleep = (BookieId)writelh.getLedgerMetadata().getEnsembleAt(10L).get(0);
        int sleeptime = this.baseClientConf.getReadTimeout() * 3;
        CountDownLatch latch = this.sleepBookie(bookieToSleep, sleeptime);
        latch.await();
        writelh.asyncAddEntry(tmp.getBytes(), new AsyncCallback.AddCallback(){

            public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
                completed.set(true);
            }
        }, null);
        Thread.sleep(this.baseClientConf.getReadTimeout() * 3 * 1000);
        Assert.assertTrue((String)"Write request did not finish", (boolean)completed.get());
        HashSet afterSet = new HashSet();
        afterSet.addAll(writelh.getLedgerMetadata().getEnsembleAt(11L));
        beforeSet.removeAll(afterSet);
        Assert.assertTrue((String)"Bookie set should not match", (beforeSet.size() != 0 ? 1 : 0) != 0);
    }
}

