/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RegionAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.feature.SettableFeature;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.StaticDNSResolver;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegionAwareEnsemblePlacementPolicy
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestRegionAwareEnsemblePlacementPolicy.class);
    RegionAwareEnsemblePlacementPolicy repp;
    final ClientConfiguration conf = new ClientConfiguration();
    final ArrayList<BookieId> ensemble = new ArrayList();
    DistributionSchedule.WriteSet writeSet = DistributionSchedule.NULL_WRITE_SET;
    BookieSocketAddress addr1;
    BookieSocketAddress addr2;
    BookieSocketAddress addr3;
    BookieSocketAddress addr4;
    HashedWheelTimer timer;

    static void updateMyRack(String rack) throws Exception {
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostAddress(), rack);
        StaticDNSResolver.addNodeToRack(InetAddress.getLocalHost().getHostName(), rack);
        BookieSocketAddress bookieAddress = new BookieSocketAddress(InetAddress.getLocalHost().getHostAddress(), 0);
        StaticDNSResolver.addNodeToRack(bookieAddress.getSocketAddress().getHostName(), rack);
        StaticDNSResolver.addNodeToRack(bookieAddress.getSocketAddress().getAddress().getHostAddress(), rack);
        StaticDNSResolver.addNodeToRack("127.0.0.1", rack);
        StaticDNSResolver.addNodeToRack("localhost", rack);
    }

    protected void setUp() throws Exception {
        super.setUp();
        StaticDNSResolver.reset();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        LOG.info("Set up static DNS Resolver.");
        this.conf.setProperty("reppDnsResolverClass", (Object)StaticDNSResolver.class.getName());
        this.addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        this.addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        this.addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        this.addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(this.addr1.getHostName(), "/r1/rack1");
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(this.addr4.getHostName(), "/r1/rack2");
        this.ensemble.add(this.addr1.toBookieId());
        this.ensemble.add(this.addr2.toBookieId());
        this.ensemble.add(this.addr3.toBookieId());
        this.ensemble.add(this.addr4.toBookieId());
        this.writeSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 1, 2, 3});
        this.timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("TestTimer-%d").build(), this.conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, this.conf.getTimeoutTimerNumTicks());
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
    }

    protected void tearDown() throws Exception {
        this.repp.uninitalize();
        super.tearDown();
    }

    static BookiesHealthInfo getBookiesHealthInfo() {
        return TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), new HashMap<BookieId, Long>());
    }

    static BookiesHealthInfo getBookiesHealthInfo(final Map<BookieId, Long> bookieFailureHistory, final Map<BookieId, Long> bookiePendingRequests) {
        return new BookiesHealthInfo(){

            public long getBookieFailureHistory(BookieId bookieSocketAddress) {
                return bookieFailureHistory.getOrDefault(bookieSocketAddress, -1L);
            }

            public long getBookiePendingRequests(BookieId bookieSocketAddress) {
                return bookiePendingRequests.getOrDefault(bookieSocketAddress, 0L);
            }
        };
    }

    @Test
    public void testNotReorderReadIfInDefaultRack() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/default-region/default-rack");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)origWriteSet, (Object)reorderSet);
    }

    @Test
    public void testNodeInSameRegion() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack3");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"r1", (String)this.repp.myRegion);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet.copy());
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 3, 1, 2});
        LOG.info("write set : {}", (Object)this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        LOG.info("expected set : {}", (Object)expectedSet);
        LOG.info("reorder equals {}", (Object)reorderSet.equals(this.writeSet));
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(this.writeSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeNotInSameRegions() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r2/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)origWriteSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDown() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeReadOnly() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        HashSet<BookieId> ro = new HashSet<BookieId>();
        ro.add(this.addr1.toBookieId());
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1.toBookieId(), 0L);
        this.repp.registerSlowBookie(this.addr2.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        bookiePendingMap.put(this.addr2.toBookieId(), 2L);
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 2, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testTwoNodesDown() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        addrs.remove(this.addr2.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 2, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        this.repp.registerSlowBookie(this.addr1.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr1.toBookieId(), 1L);
        addrs.remove(this.addr2.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 2, 0, 1});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testNodeDownAndReadOnlyAndNodeSlow() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r1/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        addrs.remove(this.addr1.toBookieId());
        addrs.remove(this.addr2.toBookieId());
        HashSet<BookieId> ro = new HashSet<BookieId>();
        ro.add(this.addr2.toBookieId());
        this.repp.registerSlowBookie(this.addr3.toBookieId(), 0L);
        HashMap<BookieId, Long> bookiePendingMap = new HashMap<BookieId, Long>();
        bookiePendingMap.put(this.addr3.toBookieId(), 1L);
        this.repp.onClusterChanged(addrs, ro);
        DistributionSchedule.WriteSet origWriteSet = this.writeSet.copy();
        DistributionSchedule.WriteSet reorderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(new HashMap<BookieId, Long>(), bookiePendingMap), this.writeSet);
        DistributionSchedule.WriteSet expectedSet = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{3, 1, 2, 0});
        LOG.info("reorder set : {}", (Object)reorderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)reorderSet.equals(origWriteSet));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)expectedSet, (Object)reorderSet);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInSameRegion() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/default-region/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        BookieId replacedBookie = (BookieId)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)addr3.toBookieId(), (Object)replacedBookie);
    }

    @Test
    public void testReplaceBookieWithEnoughBookiesInDifferentRegion() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        BookieId replacedBookie = (BookieId)this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)addr1.toBookieId().equals((Object)replacedBookie));
        TestRegionAwareEnsemblePlacementPolicy.assertTrue((addr3.toBookieId().equals((Object)replacedBookie) || addr4.toBookieId().equals((Object)replacedBookie) ? 1 : 0) != 0);
    }

    @Test
    public void testNewEnsembleBookieWithNotEnoughBookies() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region3/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region4/r4");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List list = (List)this.repp.newEnsemble(5, 5, 3, null, new HashSet()).getResult();
            LOG.info("Ensemble : {}", (Object)list);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testReplaceBookieWithNotEnoughBookies() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region3/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region4/r4");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr1.toBookieId());
        excludedAddrs.add(addr3.toBookieId());
        excludedAddrs.add(addr4.toBookieId());
        try {
            this.repp.replaceBookie(1, 1, 1, null, new ArrayList(), addr2.toBookieId(), excludedAddrs);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    @Test
    public void testNewEnsembleWithSingleRegion() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region1/r2");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)0, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 2));
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)0, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRegions() throws Exception {
        int numCovered;
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region1/r2");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            numCovered = this.getNumCoveredRegionsInWriteQuorum(ensemble, 2);
            TestRegionAwareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 ? 1 : 0) != 0);
            TestRegionAwareEnsemblePlacementPolicy.assertTrue((numCovered < 3 ? 1 : 0) != 0);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
        try {
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            numCovered = this.getNumCoveredRegionsInWriteQuorum(ensemble2, 2);
            TestRegionAwareEnsemblePlacementPolicy.assertTrue((numCovered >= 1 && numCovered < 3 ? 1 : 0) != 0);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithPickDifferentRack() throws Exception {
        List ensemble;
        EnsemblePlacementPolicy.PlacementResult ensembleResponse;
        int i;
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setMinNumRacksPerWriteQuorum(2);
        clientConf.setEnforceMinNumFaultDomainsForWrite(false);
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region-1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region-1/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region-1/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region-1/r3");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region-2/r1");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        int ensembleSize = 4;
        int writeQuorumSize = 4;
        int ackQuorumSize = 2;
        HashSet excludeBookies = new HashSet();
        for (i = 0; i < 50; ++i) {
            ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, excludeBookies);
            ensemble = (List)ensembleResponse.getResult();
            if (!ensemble.contains(addr1.toBookieId()) || !ensemble.contains(addr2.toBookieId())) continue;
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"addr1 and addr2 is same rack.");
        }
        addrs.remove(addr4.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        for (i = 0; i < 50; ++i) {
            ensembleResponse = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, excludeBookies);
            ensemble = (List)ensembleResponse.getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertTrue((ensemble.contains(addr1.toBookieId()) && ensemble.contains(addr2.toBookieId()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNewEnsembleWithEnoughRegions() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/default-region/default-rack1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/default-region/default-rack2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region2/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble1 = (List)this.repp.newEnsemble(3, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble1, 2));
            List ensemble2 = (List)this.repp.newEnsemble(4, 2, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)4, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble2, 2));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithMultipleRacksWithCommonRack() throws Exception {
        ClientConfiguration clientConf = new ClientConfiguration((AbstractConfiguration)this.conf);
        clientConf.setEnforceMinNumRacksPerWriteQuorum(true);
        clientConf.setMinNumRacksPerWriteQuorum(3);
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(clientConf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.10", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region1/r3");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region2/r1");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region3/r1");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        addrs.add(addr10.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            int ensembleSize = 10;
            int writeQuorumSize = 10;
            int ackQuorumSize = 2;
            for (int i = 0; i < 50; ++i) {
                HashSet excludeBookies = new HashSet();
                EnsemblePlacementPolicy.PlacementResult placementResult = this.repp.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, null, excludeBookies);
            }
        }
        catch (Exception e) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"RegionAwareEnsemblePlacementPolicy should newEnsemble succeed.");
        }
    }

    @Test
    public void testNewEnsembleWithThreeRegions() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region2/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region1/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region2/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region2/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region1/r24");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        addrs.add(addr10.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4.toBookieId()));
            assert (ensemble.contains(addr8.toBookieId()));
            assert (ensemble.size() == 6);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            ensemble = (List)this.repp.newEnsemble(7, 7, 4, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4.toBookieId()));
            assert (ensemble.contains(addr8.toBookieId()));
            assert (ensemble.size() == 7);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            ensemble = (List)this.repp.newEnsemble(8, 8, 5, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4.toBookieId()));
            assert (ensemble.contains(addr8.toBookieId()));
            assert (ensemble.size() == 8);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
            assert (ensemble.contains(addr4.toBookieId()));
            assert (ensemble.contains(addr8.toBookieId()));
            assert (ensemble.size() == 9);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithThreeRegionsWithDisable() throws Exception {
        List ensemble;
        SettableFeatureProvider featureProvider = new SettableFeatureProvider("", 0);
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppDisallowBookiePlacementInRegionFeatureName", (Object)"disallowBookies");
        this.repp.initialize(this.conf, Optional.empty(), this.timer, (FeatureProvider)featureProvider, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region2/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region3/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region1/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region2/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region2/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region1/r24");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        addrs.add(addr10.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            ((SettableFeature)featureProvider.scope("region1").getFeature("disallowBookies")).set(true);
            ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.getNumRegionsInEnsemble(ensemble));
            assert (ensemble.contains(addr1.toBookieId()));
            assert (ensemble.contains(addr3.toBookieId()));
            assert (ensemble.contains(addr4.toBookieId()));
            assert (ensemble.contains(addr7.toBookieId()));
            assert (ensemble.contains(addr8.toBookieId()));
            assert (ensemble.contains(addr9.toBookieId()));
            assert (ensemble.size() == 6);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
        try {
            ((SettableFeature)featureProvider.scope("region2").getFeature("disallowBookies")).set(true);
            this.repp.newEnsemble(6, 6, 4, null, new HashSet());
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should get not enough bookies exception even there is only one region with insufficient bookies.");
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            // empty catch block
        }
        try {
            ((SettableFeature)featureProvider.scope("region2").getFeature("disallowBookies")).set(false);
            ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            assert (ensemble.contains(addr1.toBookieId()));
            assert (ensemble.contains(addr3.toBookieId()));
            assert (ensemble.contains(addr4.toBookieId()));
            assert (ensemble.contains(addr7.toBookieId()));
            assert (ensemble.contains(addr8.toBookieId()));
            assert (ensemble.contains(addr9.toBookieId()));
            assert (ensemble.size() == 6);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleWithFiveRegions() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3;region4;region5");
        this.conf.setProperty("reppMinimumRegionsForDurability", (Object)5);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.1.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.1.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.1.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.1.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.1.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.1.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.1.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.1.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.1.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.1.0.11", 3181);
        BookieSocketAddress addr11 = new BookieSocketAddress("127.1.0.12", 3181);
        BookieSocketAddress addr12 = new BookieSocketAddress("127.1.0.13", 3181);
        BookieSocketAddress addr13 = new BookieSocketAddress("127.1.0.14", 3181);
        BookieSocketAddress addr14 = new BookieSocketAddress("127.1.0.15", 3181);
        BookieSocketAddress addr15 = new BookieSocketAddress("127.1.0.16", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region2/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region2/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region3/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region3/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region4/r24");
        StaticDNSResolver.addNodeToRack(addr11.getHostName(), "/region4/r31");
        StaticDNSResolver.addNodeToRack(addr12.getHostName(), "/region4/r32");
        StaticDNSResolver.addNodeToRack(addr13.getHostName(), "/region5/r33");
        StaticDNSResolver.addNodeToRack(addr14.getHostName(), "/region5/r34");
        StaticDNSResolver.addNodeToRack(addr15.getHostName(), "/region5/r35");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        addrs.add(addr10.toBookieId());
        addrs.add(addr11.toBookieId());
        addrs.add(addr12.toBookieId());
        addrs.add(addr13.toBookieId());
        addrs.add(addr14.toBookieId());
        addrs.add(addr15.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble = (List)this.repp.newEnsemble(10, 10, 10, null, new HashSet()).getResult();
            assert (ensemble.size() == 10);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)5, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            LOG.error("BKNotEnoughBookiesException", (Throwable)bnebe);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
        try {
            HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
            excludedAddrs.add(addr10.toBookieId());
            List ensemble = (List)this.repp.newEnsemble(10, 10, 10, null, excludedAddrs).getResult();
            assert (ensemble.contains(addr11.toBookieId()) && ensemble.contains(addr12.toBookieId()));
            assert (ensemble.size() == 10);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)5, (int)this.getNumRegionsInEnsemble(ensemble));
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testEnsembleWithThreeRegionsReplace() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(3, false, false);
    }

    @Test
    public void testEnsembleWithThreeRegionsReplaceDisableOneRegion() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(2, false, true);
    }

    @Test
    public void testEnsembleWithThreeRegionsReplaceMinDurabilityOne() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(1, false, false);
    }

    @Test
    public void testEnsembleWithThreeRegionsReplaceDisableDurability() throws Exception {
        this.testEnsembleWithThreeRegionsReplaceInternal(1, true, false);
    }

    public void testEnsembleWithThreeRegionsReplaceInternal(int minDurability, boolean disableDurability, boolean disableOneRegion) throws Exception {
        block18: {
            List ensemble;
            this.repp.uninitalize();
            this.repp = new RegionAwareEnsemblePlacementPolicy();
            this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3");
            this.conf.setProperty("reppMinimumRegionsForDurability", (Object)minDurability);
            SettableFeatureProvider featureProvider = new SettableFeatureProvider("", 0);
            if (minDurability <= 1) {
                this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)false);
            } else {
                this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)true);
            }
            this.conf.setProperty("reppDisallowBookiePlacementInRegionFeatureName", (Object)"disallowBookies");
            this.repp.initialize(this.conf, Optional.empty(), this.timer, (FeatureProvider)featureProvider, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
            BookieSocketAddress addr1 = new BookieSocketAddress("127.1.0.2", 3181);
            BookieSocketAddress addr2 = new BookieSocketAddress("127.1.0.3", 3181);
            BookieSocketAddress addr3 = new BookieSocketAddress("127.1.0.4", 3181);
            BookieSocketAddress addr4 = new BookieSocketAddress("127.1.0.5", 3181);
            BookieSocketAddress addr5 = new BookieSocketAddress("127.1.0.6", 3181);
            BookieSocketAddress addr6 = new BookieSocketAddress("127.1.0.7", 3181);
            BookieSocketAddress addr7 = new BookieSocketAddress("127.1.0.8", 3181);
            BookieSocketAddress addr8 = new BookieSocketAddress("127.1.0.9", 3181);
            BookieSocketAddress addr9 = new BookieSocketAddress("127.1.0.10", 3181);
            StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
            StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
            StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
            StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r4");
            StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region2/r11");
            StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region2/r12");
            StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region3/r13");
            StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r14");
            StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region3/r23");
            HashSet<BookieId> addrs = new HashSet<BookieId>();
            addrs.add(addr1.toBookieId());
            addrs.add(addr2.toBookieId());
            addrs.add(addr3.toBookieId());
            addrs.add(addr4.toBookieId());
            addrs.add(addr5.toBookieId());
            addrs.add(addr6.toBookieId());
            addrs.add(addr7.toBookieId());
            addrs.add(addr8.toBookieId());
            addrs.add(addr9.toBookieId());
            this.repp.onClusterChanged(addrs, new HashSet());
            SettableFeature disableDurabilityFeature = (SettableFeature)featureProvider.getFeature("repp_disable_durability_enforcement");
            if (disableDurability) {
                disableDurabilityFeature.set(true);
            }
            int ackQuorum = 4;
            if (minDurability > 2) {
                ackQuorum = 5;
            }
            try {
                ensemble = (List)this.repp.newEnsemble(6, 6, ackQuorum, null, new HashSet()).getResult();
                assert (ensemble.size() == 6);
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
            }
            catch (BKException.BKNotEnoughBookiesException bnebe) {
                LOG.error("BKNotEnoughBookiesException", (Throwable)bnebe);
                TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
                throw bnebe;
            }
            if (disableOneRegion) {
                ((SettableFeature)featureProvider.scope("region2").getFeature("disallowBookies")).set(true);
                HashSet<BookieId> region2Bookies = new HashSet<BookieId>();
                region2Bookies.add(addr4.toBookieId());
                region2Bookies.add(addr5.toBookieId());
                region2Bookies.add(addr6.toBookieId());
                HashSet region1And3Bookies = new HashSet(addrs);
                region1And3Bookies.removeAll(region2Bookies);
                HashSet excludedAddrs = new HashSet();
                for (BookieId addr : region2Bookies) {
                    if (!ensemble.contains(addr)) continue;
                    BookieId replacedBookie = (BookieId)this.repp.replaceBookie(6, 6, ackQuorum, null, ensemble, addr, excludedAddrs).getResult();
                    ensemble.remove(addr);
                    ensemble.add(replacedBookie);
                }
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.getNumRegionsInEnsemble(ensemble));
                TestRegionAwareEnsemblePlacementPolicy.assertTrue((boolean)ensemble.containsAll(region1And3Bookies));
            } else {
                BookieId replacedBookieExpected;
                BookieId bookieToReplace;
                if (ensemble.contains(addr4.toBookieId())) {
                    bookieToReplace = addr4.toBookieId();
                    replacedBookieExpected = ensemble.contains(addr5.toBookieId()) ? addr6.toBookieId() : addr5.toBookieId();
                } else {
                    replacedBookieExpected = addr4.toBookieId();
                    bookieToReplace = addr5.toBookieId();
                }
                HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
                try {
                    BookieId replacedBookie = (BookieId)this.repp.replaceBookie(6, 6, ackQuorum, null, ensemble, bookieToReplace, excludedAddrs).getResult();
                    assert (replacedBookie.equals((Object)replacedBookieExpected));
                    TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.getNumRegionsInEnsemble(ensemble));
                }
                catch (BKException.BKNotEnoughBookiesException bnebe) {
                    TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
                }
                excludedAddrs.add(replacedBookieExpected);
                try {
                    this.repp.replaceBookie(6, 6, ackQuorum, null, ensemble, bookieToReplace, excludedAddrs);
                    if (minDurability > 1 && !disableDurabilityFeature.isAvailable()) {
                        TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
                    }
                }
                catch (BKException.BKNotEnoughBookiesException bnebe) {
                    if (minDurability > 1 && !disableDurabilityFeature.isAvailable()) break block18;
                    TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not throw BKNotEnoughBookiesException when there is not enough bookies");
                }
            }
        }
    }

    @Test
    public void testEnsembleMinDurabilityOne() throws Exception {
        this.testEnsembleDurabilityDisabledInternal(1, false);
    }

    @Test
    public void testEnsembleDisableDurability() throws Exception {
        this.testEnsembleDurabilityDisabledInternal(2, true);
    }

    public void testEnsembleDurabilityDisabledInternal(int minDurability, boolean disableDurability) throws Exception {
        List ensemble;
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3");
        this.conf.setProperty("reppMinimumRegionsForDurability", (Object)minDurability);
        SettableFeatureProvider featureProvider = new SettableFeatureProvider("", 0);
        if (minDurability <= 1) {
            this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)false);
        } else {
            this.conf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)true);
        }
        this.repp.initialize(this.conf, Optional.empty(), this.timer, (FeatureProvider)featureProvider, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.1.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.1.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.1.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.1.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.1.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.1.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.1.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.1.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.1.0.10", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region1/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region1/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region1/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region1/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region1/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region1/r23");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        if (disableDurability) {
            ((SettableFeature)featureProvider.getFeature("repp_disable_durability_enforcement")).set(true);
        }
        try {
            ensemble = (List)this.repp.newEnsemble(6, 6, 4, null, new HashSet()).getResult();
            assert (ensemble.size() == 6);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            LOG.error("BKNotEnoughBookiesException", (Throwable)bnebe);
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
            throw bnebe;
        }
        HashSet excludedAddrs = new HashSet();
        try {
            this.repp.replaceBookie(6, 6, 4, null, ensemble, (BookieId)ensemble.get(2), excludedAddrs);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testNewEnsembleFailWithFiveRegions() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppRegionsToWrite", (Object)"region1;region2;region3;region4;region5");
        this.conf.setProperty("reppMinimumRegionsForDurability", (Object)5);
        this.conf.setProperty("reppEnableValidation", (Object)false);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        BookieSocketAddress addr10 = new BookieSocketAddress("127.0.0.11", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region3/r11");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region3/r12");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region4/r13");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region4/r14");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region5/r23");
        StaticDNSResolver.addNodeToRack(addr10.getHostName(), "/region5/r24");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        addrs.add(addr10.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> excludedAddrs = new HashSet<BookieId>();
        excludedAddrs.add(addr10.toBookieId());
        excludedAddrs.add(addr9.toBookieId());
        try {
            LOG.info("Ensemble : {}", this.repp.newEnsemble(5, 5, 5, null, excludedAddrs).getResult());
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should throw BKNotEnoughBookiesException when there is not enough bookies");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    private void prepareNetworkTopologyForReorderTests(String myRegion) throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/" + myRegion);
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        BookieSocketAddress addr9 = new BookieSocketAddress("127.0.0.10", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region1/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r1");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/region3/r1");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/region3/r2");
        StaticDNSResolver.addNodeToRack(addr9.getHostName(), "/region3/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        addrs.add(addr9.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
    }

    @Test
    public void testBasicReorderReadSequenceWithLocalRegion() throws Exception {
        this.basicReorderReadSequenceWithLocalRegionTest("region2", false);
    }

    @Test
    public void testBasicReorderReadLACSequenceWithLocalRegion() throws Exception {
        this.basicReorderReadSequenceWithLocalRegionTest("region2", true);
    }

    private void basicReorderReadSequenceWithLocalRegionTest(String myRegion, boolean isReadLAC) throws Exception {
        this.prepareNetworkTopologyForReorderTests(myRegion);
        List ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)9, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 9));
        RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(9, 9, 9);
        LOG.info("My region is {}, ensemble : {}", (Object)this.repp.myRegion, (Object)ensemble);
        int ensembleSize = ensemble.size();
        for (int i = 0; i < ensembleSize; ++i) {
            int k;
            DistributionSchedule.WriteSet writeSet = ds.getWriteSet((long)i);
            DistributionSchedule.WriteSet origWriteSet = writeSet.copy();
            DistributionSchedule.WriteSet readSet = isReadLAC ? this.repp.reorderReadLACSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet) : this.repp.reorderReadSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet);
            LOG.info("Reorder {} => {}.", (Object)origWriteSet, (Object)readSet);
            for (k = 0; k < 2; ++k) {
                BookieId address = (BookieId)ensemble.get(readSet.get(k));
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)myRegion, (String)StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(address).getHostName()));
            }
            BookieId remoteAddress = (BookieId)ensemble.get(readSet.get(k));
            TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)myRegion.equals(StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(remoteAddress).getHostName())));
            BookieId localAddress = (BookieId)ensemble.get(readSet.get(++k));
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)myRegion, (String)StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(localAddress).getHostName()));
            ++k;
            while (k < ensembleSize) {
                BookieId address = (BookieId)ensemble.get(readSet.get(k));
                TestRegionAwareEnsemblePlacementPolicy.assertFalse((boolean)myRegion.equals(StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(address).getHostName())));
                ++k;
            }
        }
    }

    @Test
    public void testBasicReorderReadSequenceWithRemoteRegion() throws Exception {
        this.basicReorderReadSequenceWithRemoteRegionTest("region4", false);
    }

    @Test
    public void testBasicReorderReadLACSequenceWithRemoteRegion() throws Exception {
        this.basicReorderReadSequenceWithRemoteRegionTest("region4", true);
    }

    private void basicReorderReadSequenceWithRemoteRegionTest(String myRegion, boolean isReadLAC) throws Exception {
        this.prepareNetworkTopologyForReorderTests(myRegion);
        List ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)9, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 9));
        RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(9, 9, 9);
        LOG.info("My region is {}, ensemble : {}", (Object)this.repp.myRegion, (Object)ensemble);
        int ensembleSize = ensemble.size();
        for (int i = 0; i < ensembleSize; ++i) {
            DistributionSchedule.WriteSet writeSet = ds.getWriteSet((long)i);
            DistributionSchedule.WriteSet readSet = isReadLAC ? this.repp.reorderReadLACSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy()) : this.repp.reorderReadSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy());
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)writeSet, (Object)readSet);
        }
    }

    @Test
    public void testReorderReadSequenceWithUnavailableOrReadOnlyBookies() throws Exception {
        this.reorderReadSequenceWithUnavailableOrReadOnlyBookiesTest(false);
    }

    @Test
    public void testReorderReadLACSequenceWithUnavailableOrReadOnlyBookies() throws Exception {
        this.reorderReadSequenceWithUnavailableOrReadOnlyBookiesTest(true);
    }

    private Set<BookieId> getBookiesForRegion(List<BookieId> ensemble, String region) {
        HashSet<BookieId> regionBookies = new HashSet<BookieId>();
        for (BookieId address : ensemble) {
            String r = StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(address).getHostName());
            if (!r.equals(region)) continue;
            regionBookies.add(address);
        }
        return regionBookies;
    }

    void appendBookieIndexByRegion(List<BookieId> ensemble, DistributionSchedule.WriteSet writeSet, String region, List<Integer> finalSet) {
        for (int i = 0; i < writeSet.size(); ++i) {
            int bi = writeSet.get(i);
            String r = StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(ensemble.get(bi)).getHostName());
            if (!r.equals(region)) continue;
            finalSet.add(bi);
        }
    }

    private void reorderReadSequenceWithUnavailableOrReadOnlyBookiesTest(boolean isReadLAC) throws Exception {
        String myRegion = "region4";
        String unavailableRegion = "region1";
        String writeRegion = "region2";
        String readOnlyRegion = "region3";
        this.prepareNetworkTopologyForReorderTests(myRegion);
        List ensemble = (List)this.repp.newEnsemble(9, 9, 5, null, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)9, (int)this.getNumCoveredRegionsInWriteQuorum(ensemble, 9));
        RoundRobinDistributionSchedule ds = new RoundRobinDistributionSchedule(9, 9, 9);
        LOG.info("My region is {}, ensemble : {}", (Object)this.repp.myRegion, (Object)ensemble);
        Set<BookieId> readOnlyBookies = this.getBookiesForRegion(ensemble, readOnlyRegion);
        Set<BookieId> writeBookies = this.getBookiesForRegion(ensemble, writeRegion);
        this.repp.onClusterChanged(writeBookies, readOnlyBookies);
        LOG.info("Writable Bookies {}, ReadOnly Bookies {}.", this.repp.knownBookies.keySet(), (Object)this.repp.readOnlyBookies);
        int ensembleSize = ensemble.size();
        for (int i = 0; i < ensembleSize; ++i) {
            DistributionSchedule.WriteSet writeSet = ds.getWriteSet((long)i);
            DistributionSchedule.WriteSet readSet = isReadLAC ? this.repp.reorderReadLACSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy()) : this.repp.reorderReadSequence(ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(), writeSet.copy());
            LOG.info("Reorder {} => {}.", (Object)writeSet, (Object)readSet);
            ArrayList<Integer> expectedReadSet = new ArrayList<Integer>();
            this.appendBookieIndexByRegion(ensemble, writeSet, writeRegion, expectedReadSet);
            this.appendBookieIndexByRegion(ensemble, writeSet, readOnlyRegion, expectedReadSet);
            this.appendBookieIndexByRegion(ensemble, writeSet, unavailableRegion, expectedReadSet);
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)expectedReadSet.size(), (int)readSet.size());
            for (int j = 0; j < expectedReadSet.size(); ++j) {
                TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)((Integer)expectedReadSet.get(j)), (int)readSet.get(j));
            }
        }
    }

    private int getNumRegionsInEnsemble(List<BookieId> ensemble) {
        HashSet<String> regions = new HashSet<String>();
        for (BookieId addr : ensemble) {
            regions.add(StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(addr).getHostName()));
        }
        return regions.size();
    }

    private int getNumCoveredRegionsInWriteQuorum(List<BookieId> ensemble, int writeQuorumSize) throws Exception {
        int ensembleSize = ensemble.size();
        int numCoveredWriteQuorums = 0;
        for (int i = 0; i < ensembleSize; ++i) {
            HashSet<String> regions = new HashSet<String>();
            for (int j = 0; j < writeQuorumSize; ++j) {
                int bookieIdx = (i + j) % ensembleSize;
                BookieId addr = ensemble.get(bookieIdx);
                regions.add(StaticDNSResolver.getRegion(this.repp.bookieAddressResolver.resolve(addr).getHostName()));
            }
            numCoveredWriteQuorums += regions.size() > 1 ? 1 : 0;
        }
        return numCoveredWriteQuorums;
    }

    @Test
    public void testRecoveryOnNodeFailure() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region3/r3");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/region3/r3");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashSet<BookieId> bookiesLeftSet = new HashSet<BookieId>();
        bookiesLeftSet.add(addr1.toBookieId());
        this.repp.handleBookiesThatLeft(bookiesLeftSet);
        ArrayList<BookieId> currentEnsemble = new ArrayList<BookieId>();
        currentEnsemble.add(addr1.toBookieId());
        currentEnsemble.add(addr3.toBookieId());
        currentEnsemble.add(addr6.toBookieId());
        EnsemblePlacementPolicy.PlacementResult placementResult = this.repp.replaceBookie(3, 3, 2, null, currentEnsemble, addr1.toBookieId(), new HashSet());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)placementResult.getResult(), (Object)addr2.toBookieId());
    }

    @Test
    public void testNodeWithFailures() throws Exception {
        this.repp.uninitalize();
        TestRegionAwareEnsemblePlacementPolicy.updateMyRack("/r2/rack1");
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        BookieSocketAddress addr6 = new BookieSocketAddress("127.0.0.7", 3181);
        BookieSocketAddress addr7 = new BookieSocketAddress("127.0.0.8", 3181);
        BookieSocketAddress addr8 = new BookieSocketAddress("127.0.0.9", 3181);
        StaticDNSResolver.addNodeToRack(this.addr2.getHostName(), "/r2/rack1");
        StaticDNSResolver.addNodeToRack(this.addr3.getHostName(), "/r2/rack2");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/r1/rack3");
        StaticDNSResolver.addNodeToRack(addr6.getHostName(), "/r2/rack3");
        StaticDNSResolver.addNodeToRack(addr7.getHostName(), "/r2/rack4");
        StaticDNSResolver.addNodeToRack(addr8.getHostName(), "/r1/rack4");
        this.ensemble.add(addr5.toBookieId());
        this.ensemble.add(addr6.toBookieId());
        this.ensemble.add(addr7.toBookieId());
        this.ensemble.add(addr8.toBookieId());
        DistributionSchedule.WriteSet writeSet2 = RoundRobinDistributionSchedule.writeSetFromValues((Integer[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7});
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(this.addr1.toBookieId());
        addrs.add(this.addr2.toBookieId());
        addrs.add(this.addr3.toBookieId());
        addrs.add(this.addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        addrs.add(addr6.toBookieId());
        addrs.add(addr7.toBookieId());
        addrs.add(addr8.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        HashMap<BookieId, Long> bookieFailures = new HashMap<BookieId, Long>();
        bookieFailures.put(this.addr1.toBookieId(), 20L);
        bookieFailures.put(this.addr2.toBookieId(), 22L);
        bookieFailures.put(this.addr3.toBookieId(), 24L);
        bookieFailures.put(this.addr4.toBookieId(), 25L);
        LOG.info("write set : {}", (Object)writeSet2);
        DistributionSchedule.WriteSet reoderSet = this.repp.reorderReadSequence(this.ensemble, TestRegionAwareEnsemblePlacementPolicy.getBookiesHealthInfo(bookieFailures, new HashMap<BookieId, Long>()), writeSet2);
        LOG.info("reorder set : {}", (Object)reoderSet);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(0)), (Object)addr6.toBookieId());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(1)), (Object)addr7.toBookieId());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(2)), (Object)addr5.toBookieId());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(3)), (Object)this.addr2.toBookieId());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(4)), (Object)this.addr3.toBookieId());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(5)), (Object)addr8.toBookieId());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(6)), (Object)this.addr1.toBookieId());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((Object)this.ensemble.get(reoderSet.get(7)), (Object)this.addr4.toBookieId());
    }

    @Test
    public void testNewEnsembleSetWithFiveRegions() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region2/r2");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region3/r3");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region4/r4");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region5/r5");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        try {
            List ensemble1 = (List)this.repp.newEnsemble(3, 3, 2, null, new HashSet()).getResult();
            TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)ensemble1.size(), (int)3);
            List ensemble2 = (List)this.repp.newEnsemble(3, 3, 2, null, new HashSet()).getResult();
            ensemble1.retainAll(ensemble2);
            assert (ensemble1.size() >= 1);
            List ensemble3 = (List)this.repp.newEnsemble(3, 3, 2, null, new HashSet()).getResult();
            ensemble2.removeAll(ensemble3);
            assert (ensemble2.size() >= 1);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            TestRegionAwareEnsemblePlacementPolicy.fail((String)"Should not get not enough bookies exception even there is only one rack.");
        }
    }

    @Test
    public void testRegionsWithDiskWeight() throws Exception {
        this.repp.uninitalize();
        this.repp = new RegionAwareEnsemblePlacementPolicy();
        this.conf.setProperty("reppEnableValidation", (Object)false);
        this.conf.setDiskWeightBasedPlacementEnabled(true);
        this.repp.initialize(this.conf, Optional.empty(), this.timer, SettableFeatureProvider.DISABLE_ALL, (StatsLogger)NullStatsLogger.INSTANCE, BookieSocketAddress.LEGACY_BOOKIEID_RESOLVER);
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.0.2", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.0.3", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.0.4", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.0.5", 3181);
        BookieSocketAddress addr5 = new BookieSocketAddress("127.0.0.6", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/r1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region2/r3");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region3/r11");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region4/r13");
        StaticDNSResolver.addNodeToRack(addr5.getHostName(), "/region5/r23");
        HashSet<BookieId> addrs = new HashSet<BookieId>();
        addrs.add(addr1.toBookieId());
        addrs.add(addr2.toBookieId());
        addrs.add(addr3.toBookieId());
        addrs.add(addr4.toBookieId());
        addrs.add(addr5.toBookieId());
        this.repp.onClusterChanged(addrs, new HashSet());
        List ensemble = (List)this.repp.newEnsemble(3, 3, 2, null, new HashSet()).getResult();
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)ensemble.size());
    }

    @Test
    public void testNotifyRackChangeWithOldRegion() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.1.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.1.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/rack-1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/rack-1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/rack-1");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/rack-1");
        HashSet addrs = Sets.newHashSet((Object[])new BookieId[]{addr1.toBookieId(), addr2.toBookieId(), addr3.toBookieId(), addr4.toBookieId()});
        this.repp.onClusterChanged((Set)addrs, new HashSet());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)4, (int)this.repp.knownBookies.size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.repp.perRegionPlacement.size());
        TopologyAwareEnsemblePlacementPolicy region1Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region1");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)region1Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)region1Placement.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)region1Placement.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TopologyAwareEnsemblePlacementPolicy region2Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region2");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)region2Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)region2Placement.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)region2Placement.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr1.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr2.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region2", (String)((String)this.repp.address2Region.get(addr3.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region2", (String)((String)this.repp.address2Region.get(addr4.toBookieId())));
        ArrayList<BookieSocketAddress> bookieAddressList = new ArrayList<BookieSocketAddress>();
        ArrayList<String> rackList = new ArrayList<String>();
        bookieAddressList.add(addr2);
        rackList.add("/region1/rack-2");
        bookieAddressList.add(addr4);
        rackList.add("/region1/rack-2");
        StaticDNSResolver.changeRack(bookieAddressList, rackList);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)4, (int)this.repp.knownBookies.size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-2", (String)((BookieNode)this.repp.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-2", (String)((BookieNode)this.repp.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.repp.perRegionPlacement.size());
        region1Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region1");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)region1Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)region1Placement.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-2", (String)((BookieNode)region1Placement.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-2", (String)((BookieNode)region1Placement.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        region2Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region2");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)1, (int)region2Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)region2Placement.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr1.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr2.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region2", (String)((String)this.repp.address2Region.get(addr3.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr4.toBookieId())));
    }

    @Test
    public void testNotifyRackChangeWithNewRegion() throws Exception {
        BookieSocketAddress addr1 = new BookieSocketAddress("127.0.1.1", 3181);
        BookieSocketAddress addr2 = new BookieSocketAddress("127.0.1.2", 3181);
        BookieSocketAddress addr3 = new BookieSocketAddress("127.0.1.3", 3181);
        BookieSocketAddress addr4 = new BookieSocketAddress("127.0.1.4", 3181);
        StaticDNSResolver.addNodeToRack(addr1.getHostName(), "/region1/rack-1");
        StaticDNSResolver.addNodeToRack(addr2.getHostName(), "/region1/rack-1");
        StaticDNSResolver.addNodeToRack(addr3.getHostName(), "/region2/rack-1");
        StaticDNSResolver.addNodeToRack(addr4.getHostName(), "/region2/rack-1");
        HashSet addrs = Sets.newHashSet((Object[])new BookieId[]{addr1.toBookieId(), addr2.toBookieId(), addr3.toBookieId(), addr4.toBookieId()});
        this.repp.onClusterChanged((Set)addrs, new HashSet());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)4, (int)this.repp.knownBookies.size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)this.repp.perRegionPlacement.size());
        TopologyAwareEnsemblePlacementPolicy region1Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region1");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)region1Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)region1Placement.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)region1Placement.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TopologyAwareEnsemblePlacementPolicy region2Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region2");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)region2Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)region2Placement.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)region2Placement.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr1.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr2.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region2", (String)((String)this.repp.address2Region.get(addr3.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region2", (String)((String)this.repp.address2Region.get(addr4.toBookieId())));
        ArrayList<BookieSocketAddress> bookieAddressList = new ArrayList<BookieSocketAddress>();
        ArrayList<String> rackList = new ArrayList<String>();
        bookieAddressList.add(addr2);
        rackList.add("/region3/rack-1");
        bookieAddressList.add(addr4);
        rackList.add("/region3/rack-1");
        StaticDNSResolver.changeRack(bookieAddressList, rackList);
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)4, (int)this.repp.knownBookies.size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region3/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region3/rack-1", (String)((BookieNode)this.repp.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)3, (int)this.repp.perRegionPlacement.size());
        region1Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region1");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)1, (int)region1Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region1/rack-1", (String)((BookieNode)region1Placement.knownBookies.get(addr1.toBookieId())).getNetworkLocation());
        region2Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region2");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)1, (int)region2Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region2/rack-1", (String)((BookieNode)region2Placement.knownBookies.get(addr3.toBookieId())).getNetworkLocation());
        TopologyAwareEnsemblePlacementPolicy region3Placement = (TopologyAwareEnsemblePlacementPolicy)this.repp.perRegionPlacement.get("region3");
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((int)2, (int)region3Placement.knownBookies.keySet().size());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region3/rack-1", (String)((BookieNode)region3Placement.knownBookies.get(addr2.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"/region3/rack-1", (String)((BookieNode)region3Placement.knownBookies.get(addr4.toBookieId())).getNetworkLocation());
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region1", (String)((String)this.repp.address2Region.get(addr1.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region3", (String)((String)this.repp.address2Region.get(addr2.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region2", (String)((String)this.repp.address2Region.get(addr3.toBookieId())));
        TestRegionAwareEnsemblePlacementPolicy.assertEquals((String)"region3", (String)((String)this.repp.address2Region.get(addr4.toBookieId())));
    }
}

